/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ObjectTypeRef;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.facade.FacadeResult;
import kd.bos.kflow.api.IFlowDesignService;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.DesignMetaL;
import kd.bos.metadata.PermissionMeta;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.dao.AbstractMetadataSerializer;
import kd.bos.metadata.dao.AbstractMetadataWriter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.dao.MetadataServicePlugInProxy;
import kd.bos.metadata.dao.MsMetadataDaoFacade;
import kd.bos.metadata.dao.PrintMetadataWriter;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.DesignEntityMetaL;
import kd.bos.metadata.entity.RuntimeEntityMeta;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.DesignFormMetaL;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.RuntimeFormMeta;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.xdb.mservice.ShardingMetadataService;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MetadataWriter
extends AbstractMetadataWriter {
    private static final String SUCCESS = "success";
    private static final String BOS_METADATA = "bos-metadata";
    private static final String MESSAGE = "message";
    protected MsMetadataDaoFacade facade = new MsMetadataDaoFacade();

    public MetadataWriter() {
    }

    public MetadataWriter(String modelTypeId) {
        super(modelTypeId);
    }

    @Override
    protected AbstractMetadataSerializer initMetadataSerializer(String modelTypeId) {
        return new MetadataSerializer(modelTypeId);
    }

    public Map<String, Object> save(AbstractMetadata ... metadatas) {
        return this.save(false, metadatas);
    }

    public Map<String, Object> save(Boolean isDraft, AbstractMetadata ... metadatas) {
        FacadeResult beforeResult = this.facade.beforeSave(this, metadatas);
        if (beforeResult != null && beforeResult.isSuccess()) {
            switch (beforeResult.getCode()) {
                case 6: {
                    return beforeResult.getReturnData();
                }
            }
        }
        List<AbstractDesignMeta> designDatas = this.saveMeta(isDraft, metadatas);
        List<ErrorInfo> errors = this.plugIn.getBuildErrors(metadatas);
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.addModifyMsg(designDatas, map);
        if (this.existErrorLevel(errors)) {
            map.put(SUCCESS, false);
            map.put(MESSAGE, ResManager.loadKDString((String)"\u751f\u6210\u8fd0\u884c\u671f\u5143\u6570\u636e\u9519\u8bef\uff0c\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9519\u8bef\u5217\u8868\uff01", (String)"MetadataWriter_1", (String)BOS_METADATA, (Object[])new Object[0]));
            map.put("errors", errors);
            return map;
        }
        map.put(SUCCESS, true);
        map.put(MESSAGE, ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"MetadataWriter_7", (String)BOS_METADATA, (Object[])new Object[0]));
        if (!errors.isEmpty()) {
            map.put("errors", errors);
        }
        return map;
    }

    private boolean existErrorLevel(List<ErrorInfo> buildErrors) {
        if (buildErrors == null || buildErrors.isEmpty()) {
            return false;
        }
        for (ErrorInfo errorInfo : buildErrors) {
            if (errorInfo == null || errorInfo.getLevel() != 2) continue;
            return true;
        }
        return false;
    }

    private void addModifyMsg(List<AbstractDesignMeta> designDatas, Map<String, Object> ret) {
        Optional<AbstractDesignMeta> op = designDatas.stream().filter(designMeta -> designMeta instanceof DesignFormMeta).findFirst();
        if (op.isPresent()) {
            ret.put("modifyDate", ((DesignFormMeta)op.get()).getModifyDate());
            ret.put("modiferId", ((DesignFormMeta)op.get()).getModifierId());
        }
    }

    public static void delFormMetadataLang(DesignMetaL metaL) {
        AbstractMetadataWriter.delFormMetadataLang(metaL);
    }

    public boolean isExistFormRefs(String id) {
        IDataEntityType type = OrmUtils.getDataEntityType(DesignFormMeta.class);
        return this.isInheritPathForm(id, type) || this.isLayoutUsed(id, type);
    }

    public Map<String, Object> delFormMetadata(String id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isExistFormRefs(id)) {
            result.put(SUCCESS, false);
            result.put(MESSAGE, ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u53ef\u80fd\u5df2\u88ab\u6269\u5c55\u6216\u7ee7\u627f\uff0c\u8bf7\u5148\u5220\u9664\u5176\u6269\u5c55\u9875\u9762\u6216\u7ee7\u627f\u9875\u9762\uff0c\u518d\u64cd\u4f5c\u3002", (String)"MetadataWriter_3", (String)BOS_METADATA, (Object[])new Object[0]));
            return result;
        }
        String number = MetadataDao.getNumberById(id);
        List<String> selfScriptId = MetadataWriter.getSelfScriptId(id);
        Set<String> refObjects = this.getRefFormNumbers(number);
        if (!refObjects.isEmpty()) {
            String message = ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u88ab\u5176\u4ed6\u9875\u9762\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002\u5f15\u7528\u9875\u9762\uff1a", (String)"MetadataWriter_5", (String)BOS_METADATA, (Object[])new Object[0]);
            message = message + StringUtils.join((Object[])refObjects.toArray(), (String)",");
            result.put(SUCCESS, false);
            result.put(MESSAGE, message);
            return result;
        }
        if (this.isMainEntityForm(id) && ShardingMetadataService.getInstance().isXDBEnableByEntity(number)) {
            String message = String.format(ResManager.loadKDString((String)"\u8868\u5355%s\u5b58\u5728\u5206\u8868\u914d\u7f6e\uff0c\u8bf7\u5148\u5220\u9664\u5206\u8868\u914d\u7f6e\uff0c\u518d\u64cd\u4f5c\uff01", (String)"MetadataWriter_6", (String)BOS_METADATA, (Object[])new Object[0]), number);
            result.put(SUCCESS, false);
            result.put(MESSAGE, message);
            return result;
        }
        String entityId = this.readEntityId(id);
        String errSql = "";
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            IDataEntityType designFormMetaType = OrmUtils.getDataEntityType(DesignFormMeta.class);
            String modelType = this.readModelType(id, designFormMetaType);
            if (StringUtils.equals((CharSequence)id, (CharSequence)entityId)) {
                if (this.plugIn == null) {
                    this.plugIn = MetadataServicePlugInProxy.create(modelType);
                }
                this.plugIn.delete(id);
                BusinessDataWriter.delete((IDataEntityType)OrmUtils.getDataEntityType(DesignEntityMeta.class), (Object[])new Object[]{id});
                BusinessDataWriter.delete((IDataEntityType)OrmUtils.getDataEntityType(DesignEntityMetaL.class), (Object[])new Object[]{id});
                IDataEntityType refObjectType = OrmUtils.getDataEntityType(ObjectTypeRef.class);
                BusinessDataWriter.delete((IDataEntityType)refObjectType, (Object[])new Object[]{number});
                IDataEntityType runtimeEntityMetaType = OrmUtils.getDataEntityType(RuntimeEntityMeta.class);
                BusinessDataWriter.delete((IDataEntityType)runtimeEntityMetaType, (Object[])new Object[]{entityId});
                try (TXHandle txp = TX.requiresNew();){
                    try {
                        IDataEntityType permMetaType = OrmUtils.getDataEntityType(PermissionMeta.class);
                        BusinessDataWriter.delete((IDataEntityType)permMetaType, (Object[])new Object[]{entityId});
                    }
                    catch (Throwable e) {
                        txp.markRollback();
                        throw e;
                    }
                }
                var15_20 = null;
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        Set<Long> refIds = this.queryReferenceId(id);
                        if (!CollectionUtils.isEmpty(refIds)) {
                            IFlowDesignService flowService = (IFlowDesignService)ServiceFactory.getService(IFlowDesignService.class);
                            flowService.deleteReference(refIds.toArray(new Object[]{refIds.size()}));
                        }
                    }
                    catch (Throwable e) {
                        tx.markRollback();
                        throw e;
                    }
                }
                catch (Throwable throwable2) {
                    var15_20 = throwable2;
                    throw throwable2;
                }
            }
            SqlBuilder delBuilder = new SqlBuilder();
            delBuilder.append("DELETE FROM T_META_BIZOBJLAYOUTREL WHERE ", new Object[0]).appendIn("FFORMID", (Object[])new String[]{id});
            DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)delBuilder);
            if (modelType.equalsIgnoreCase("PrintModel")) {
                PrintMetadataWriter.delete(id);
            }
            BusinessDataWriter.delete((IDataEntityType)designFormMetaType, (Object[])new Object[]{id});
            BusinessDataWriter.delete((IDataEntityType)OrmUtils.getDataEntityType(DesignFormMetaL.class), (Object[])new Object[]{id});
            IDataEntityType runtimeFormMetaType = OrmUtils.getDataEntityType(RuntimeFormMeta.class);
            BusinessDataWriter.delete((IDataEntityType)runtimeFormMetaType, (Object[])new Object[]{id});
            if (!CollectionUtils.isEmpty(selfScriptId)) {
                MainEntityType pluginScriptType = EntityMetadataCache.getDataEntityType((String)"ide_pluginscript");
                BusinessDataWriter.delete((IDataEntityType)pluginScriptType, (Object[])selfScriptId.toArray());
            }
            result.put(SUCCESS, true);
            result.put(MESSAGE, ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"MetadataWriter_8", (String)BOS_METADATA, (Object[])new Object[0]));
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (Throwable e) {
            try {
                h.markRollback();
                String msg = String.format("error:%s;  sql:%s", e.getMessage(), errSql);
                throw new KDException(e, BosErrorCode.sQL, new Object[]{msg});
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
    }

    private static List<String> getSelfScriptId(String formId) {
        BillFormAp billFormAp;
        FormMetadata mobMeta;
        AbstractMetadata abstractMetadata = MetadataDao.readMeta(formId, MetaCategory.Form);
        if (!(abstractMetadata instanceof FormMetadata)) {
            return Collections.emptyList();
        }
        FormMetadata formMetadata = (FormMetadata)abstractMetadata;
        ArrayList<String> selfScriptIds = new ArrayList<String>(8);
        FormAp rootAp = formMetadata.getRootAp();
        List<Plugin> jsPlugins = rootAp.getJsPlugins();
        for (Plugin jsPlugin : jsPlugins) {
            if (jsPlugin.isInherit()) continue;
            selfScriptIds.add(jsPlugin.getFpk());
        }
        if (rootAp instanceof BillFormAp && (mobMeta = (billFormAp = (BillFormAp)rootAp).getMobMeta()) != null) {
            FormAp mobRootAp = mobMeta.getRootAp();
            for (Plugin jsPlugin : mobRootAp.getJsPlugins()) {
                if (jsPlugin.isInherit()) continue;
                selfScriptIds.add(jsPlugin.getFpk());
            }
        }
        return selfScriptIds;
    }

    private Set<Long> queryReferenceId(String formId) {
        HashSet<Long> ids = new HashSet<Long>(10);
        QFilter qFilter = new QFilter("resourceid", "=", (Object)formId);
        ORM orm = ORM.create();
        DynamicObjectCollection cols = orm.query("kf_reference", "id", new QFilter[]{qFilter});
        for (int i = 0; i < cols.size(); ++i) {
            DynamicObject obj = (DynamicObject)cols.get(i);
            ids.add(obj.getLong("id"));
        }
        return ids;
    }

    private Set<String> getRefFormNumbers(String number) {
        if (StringUtils.isBlank((CharSequence)number)) {
            return new HashSet<String>();
        }
        IDataEntityType refObjectType = OrmUtils.getDataEntityType(ObjectTypeRef.class);
        String sql = "select fObjectTypeId,fFieldName from %s where fRefObjectTypeId = ? and fObjectTypeId != fRefObjectTypeId";
        sql = String.format(sql, refObjectType.getAlias());
        Object[] params = new Object[]{number};
        Set formNumbers = (Set)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, rs -> {
            HashSet<Tuple> list = new HashSet<Tuple>();
            try {
                while (rs.next()) {
                    String formNumber = rs.getString("fObjectTypeId");
                    String fieldName = rs.getString("fFieldName");
                    Tuple tuple = new Tuple((Object)formNumber, (Object)fieldName);
                    list.add(tuple);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return list;
        });
        return formNumbers.stream().filter(d -> this.existRefRelation(number, (String)d.item1, (String)d.item2)).map(d -> (String)d.item1).collect(Collectors.toSet());
    }

    private boolean existRefRelation(String bdFormNumber, String formNumber, String fieldName) {
        if (StringUtils.isBlank((CharSequence)formNumber) || StringUtils.isBlank((CharSequence)fieldName)) {
            return false;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formNumber);
        Optional<IDataEntityProperty> prop = type.getAllFields().values().stream().filter(d -> fieldName.equals(d.getAlias())).findFirst();
        if (!prop.isPresent()) {
            return false;
        }
        IDataEntityProperty field = prop.get();
        if (!(field instanceof DynamicComplexProperty)) {
            return false;
        }
        String tRefBdFormNumber = ((DynamicComplexProperty)field).getComplexType().getName();
        return StringUtils.equals((CharSequence)bdFormNumber, (CharSequence)tRefBdFormNumber);
    }

    private boolean isLayoutUsed(String id, IDataEntityType type) {
        String sql = String.format("select t.FID from %s t where FENTITYID = ? and t.FID <> t.FENTITYID and t.FMODELTYPE <> ? ", type.getAlias());
        SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FENTITYID", 12, (Object)id), new SqlParameter(":FMODELTYPE", 12, (Object)"PrintModel")};
        boolean flag = !this.isNullRow(sql, params);
        return flag;
    }

    private String readEntityId(String id) {
        String sql = String.format("select FENTITYID from %s where FID = ? ", "T_META_FORMDESIGN");
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)id)};
        String entityId = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                String sRet = null;
                try {
                    if (rs.next()) {
                        sRet = rs.getString("FENTITYID");
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                }
                return sRet;
            }
        });
        if (StringUtils.isBlank((CharSequence)entityId)) {
            entityId = "";
        }
        return entityId;
    }

    private boolean isMainEntityForm(final String id) {
        String sql = "select FENTITYID, FTYPE from T_META_FORMDESIGN where FID = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)id)};
        return (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                try {
                    if (rs.next() && !"2".equals(rs.getString("FTYPE")) && StringUtils.equals((CharSequence)id, (CharSequence)rs.getString("FENTITYID"))) {
                        return true;
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                }
                return false;
            }
        });
    }

    @Override
    protected AbstractMetadata readBaseMetadata(AbstractMetadata metadata) {
        MetadataReader reader = new MetadataReader();
        boolean isOriForm = !"2".equals(metadata.getDevType());
        reader.setFillExtends(isOriForm);
        AbstractMetadata baseMetadata = reader.readMeta(metadata.getParentId(), metadata.getDesingerMetaType(), false, true);
        return baseMetadata;
    }

    @Override
    protected boolean isBatchSaveDesignMetas() {
        return this.getClass() == MetadataWriter.class;
    }
}

