/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.util.List;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;

class RedisMetadataCache {
    private static final String STR_META_STR = "%s_meta_%s";

    RedisMetadataCache() {
    }

    static String get(DistributeSessionlessCache cache, int metaType, String number, String key) {
        return (String)cache.get(RedisMetadataCache.getCacheType(number), RedisMetadataCache.getCacheKey(key, metaType));
    }

    static void put(DistributeSessionlessCache cache, int metaType, String number, String key, String val) {
        cache.put(RedisMetadataCache.getCacheType(number), RedisMetadataCache.getCacheKey(key, metaType), (Object)val);
    }

    static void put(DistributeSessionlessCache cache, int metaType, String number, String key, String val, int timeOut) {
        cache.put(RedisMetadataCache.getCacheType(number), RedisMetadataCache.getCacheKey(key, metaType), val, timeOut);
    }

    static void remove(DistributeSessionlessCache cache, int metaType, String number, String key) {
        cache.remove(RedisMetadataCache.getCacheType(number), RedisMetadataCache.getCacheKey(key, metaType));
    }

    static void remove(DistributeSessionlessCache cache, String appGroup, int metaType, String number, String key) {
        cache.remove(RedisMetadataCache.getCacheType(appGroup, number), RedisMetadataCache.getCacheKey(key, metaType));
    }

    static void remove(DistributeSessionlessCache cache, String appGroup, List<String> numbers) {
        String[] cacheKeys = new String[numbers.size()];
        for (int i = 0; i < numbers.size(); ++i) {
            cacheKeys[i] = RedisMetadataCache.getCacheType(appGroup, numbers.get(i));
        }
        cache.remove(cacheKeys);
    }

    static void remove(DistributeSessionlessCache cache, String[] numbers) {
        String[] cacheKeys = new String[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            cacheKeys[i] = RedisMetadataCache.getCacheType(numbers[i]);
        }
        cache.remove(cacheKeys);
    }

    private static String getCacheType(String number) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        return RedisMetadataCache.getCacheType(appGroup, number);
    }

    private static String getCacheType(String appGroup, String number) {
        String accountId = CacheKeyUtil.getAcctId();
        if ("defaultGroup".equals(appGroup)) {
            return String.format(STR_META_STR, accountId, number);
        }
        return String.format("%s_meta_%s_%s", accountId, appGroup, number);
    }

    private static String getCacheKey(String key, int metaType) {
        return String.format("%s_%s", metaType, key);
    }
}

