/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.deploy;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.botp.DesignConvertRuleMeta;
import kd.bos.metadata.botp.DesignConvertRuleMetaL;
import kd.bos.metadata.botp.DesignWriteBackRuleMeta;
import kd.bos.metadata.botp.DesignWriteBackRuleMetaL;
import kd.bos.metadata.deploy.DeployAppMetadata;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.metadata.devportal.DesignAppMeta;
import kd.bos.metadata.devportal.DesignAppMetaL;
import kd.bos.metadata.devportal.DesignCloudMeta;
import kd.bos.metadata.devportal.DesignCloudMetaL;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.DesignEntityMetaL;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.DesignFormMetaL;
import kd.bos.util.SAXReaderUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class DeployMetadataBinder
extends DcBinder {
    private static final Log log = LogFactory.getLog(DeployMetadataBinder.class);
    private static Map<String, IDataEntityType> dts = new HashMap<String, IDataEntityType>();
    private SAXReader saxReader;

    public static void putDataEntityType(String name, Class<?> classz) {
        dts.put(name, OrmUtils.getDataEntityType(classz));
    }

    private SAXReader getSaxReader() {
        if (this.saxReader == null) {
            this.saxReader = SAXReaderUtil.getSAXReader();
        }
        return this.saxReader;
    }

    public IDataEntityType tryBindToType(String elementName, Map<String, String> attributes) {
        return dts.get(elementName);
    }

    public boolean writeSimpleProperty(Element serObj, ISimpleProperty property, Object entity) {
        if ("DataXml".equals(property.getName())) {
            String value = (String)property.getValue(entity);
            if (StringUtils.isBlank((CharSequence)value)) {
                return false;
            }
            StringReader strReader = new StringReader(value);
            SAXReader reader = this.getSaxReader();
            try {
                Document doc = reader.read((Reader)strReader);
                Element propElemnt = serObj.addElement(property.getName());
                propElemnt.add(doc.getRootElement());
            }
            catch (DocumentException e) {
                throw new OrmException("Deserialize.DocumentException", e.getMessage());
            }
            return true;
        }
        return super.writeSimpleProperty(serObj, property, entity);
    }

    public boolean readSimpleProperty(ISimpleProperty property, Element propElement, Object entity) {
        if ("DataXml".equals(property.getName())) {
            Document xmlDoc = DocumentHelper.createDocument();
            Element el = (Element)propElement.elements().get(0);
            xmlDoc.add(el.createCopy());
            StringWriter writer = new StringWriter();
            OutputFormat format = OutputFormat.createCompactFormat();
            format.setTrimText(false);
            XMLWriter xmlWrite = new XMLWriter((Writer)writer, format);
            try {
                xmlWrite.setIndentLevel(0);
                xmlWrite.write(xmlDoc);
                xmlWrite.close();
                ((Writer)writer).close();
            }
            catch (IOException e) {
                throw new OrmException("DeployMetadataBinder.readSimpleProperty", e.getMessage());
            }
            property.setValue(entity, (Object)((Object)writer).toString());
            return true;
        }
        return super.readSimpleProperty(property, propElement, entity);
    }

    static {
        dts.put("DesignFormMeta", OrmUtils.getDataEntityType(DesignFormMeta.class));
        dts.put("DesignFormMetaL", OrmUtils.getDataEntityType(DesignFormMetaL.class));
        dts.put("DesignEntityMeta", OrmUtils.getDataEntityType(DesignEntityMeta.class));
        dts.put("DesignEntityMetaL", OrmUtils.getDataEntityType(DesignEntityMetaL.class));
        dts.put("DesignConvertRuleMeta", OrmUtils.getDataEntityType(DesignConvertRuleMeta.class));
        dts.put("DesignConvertRuleMetaL", OrmUtils.getDataEntityType(DesignConvertRuleMetaL.class));
        dts.put("DesignWriteBackRuleMeta", OrmUtils.getDataEntityType(DesignWriteBackRuleMeta.class));
        dts.put("DesignWriteBackRuleMetaL", OrmUtils.getDataEntityType(DesignWriteBackRuleMetaL.class));
        dts.put("DesignAppMeta", OrmUtils.getDataEntityType(DesignAppMeta.class));
        dts.put("DesignAppMetaL", OrmUtils.getDataEntityType(DesignAppMetaL.class));
        dts.put("DeployMetadata", OrmUtils.getDataEntityType(DeployMetadata.class));
        dts.put("DeployAppMetadata", OrmUtils.getDataEntityType(DeployAppMetadata.class));
        dts.put("DesignCloudMeta", OrmUtils.getDataEntityType(DesignCloudMeta.class));
        dts.put("DesignCloudMetaL", OrmUtils.getDataEntityType(DesignCloudMetaL.class));
        try {
            dts.put("DesignEarlyWarnMeta", OrmUtils.getDataEntityType(Class.forName("kd.bos.metadata.earlywarn.warn.DesignEarlyWarnMeta")));
            dts.put("DesignEarlyWarnMetaL", OrmUtils.getDataEntityType(Class.forName("kd.bos.metadata.earlywarn.warn.DesignEarlyWarnMetaL")));
            dts.put("DesignBalanceRuleMeta", OrmUtils.getDataEntityType(Class.forName("kd.bos.metadata.balance.DesignBalanceRuleMeta")));
            dts.put("DesignBalanceRuleMetaL", OrmUtils.getDataEntityType(Class.forName("kd.bos.metadata.balance.DesignBalanceRuleMetaL")));
            dts.put("PDMEntityDesignMeta", OrmUtils.getDataEntityType(Class.forName("kd.bos.datamodel.metadata.pdm.PDMEntityDesignMeta")));
            dts.put("PDMDiagramDesignMeta", OrmUtils.getDataEntityType(Class.forName("kd.bos.datamodel.metadata.pdm.PDMDiagramDesignMeta")));
        }
        catch (ClassNotFoundException e) {
            log.error((Throwable)e);
        }
        try {
            Class designDynamicPluginBindL;
            Class designDynamicBindPlugin;
            Class designDynamicPluginL;
            Class designDynamicPlugin;
            Class designBizExtPlugin;
            Class designCtConvertRuleMetaL;
            Class designCtConvertRuleMeta;
            Class designBizExtCaseL;
            Class designBizExtCase = TypesContainer.getOrRegister((String)"kd.bos.designer.bizextplugin.BizExtCaseDesignMeta");
            if (designBizExtCase != null) {
                dts.put("BizExtCaseDesignMeta", OrmUtils.getDataEntityType((Class)designBizExtCase));
            }
            if ((designBizExtCaseL = TypesContainer.getOrRegister((String)"kd.bos.designer.bizextplugin.BizExtCaseDesignMeta_Lang")) != null) {
                dts.put("BizExtCaseDesignMeta_Lang", OrmUtils.getDataEntityType((Class)designBizExtCaseL));
            }
            if ((designCtConvertRuleMeta = TypesContainer.getOrRegister((String)"kd.bos.metadata.ctbotp.DesignCtConvertRuleMeta")) != null) {
                dts.put("DesignCtConvertRuleMeta", OrmUtils.getDataEntityType((Class)designCtConvertRuleMeta));
            }
            if ((designCtConvertRuleMetaL = TypesContainer.getOrRegister((String)"kd.bos.metadata.ctbotp.DesignCtConvertRuleMetaL")) != null) {
                dts.put("DesignCtConvertRuleMetaL", OrmUtils.getDataEntityType((Class)designCtConvertRuleMetaL));
            }
            if ((designBizExtPlugin = TypesContainer.getOrRegister((String)"kd.bos.designer.bizextplugin.BizExtPluginDesignMeta")) != null) {
                dts.put("BizExtPluginDesignMeta", OrmUtils.getDataEntityType((Class)designBizExtPlugin));
            }
            if ((designDynamicPlugin = TypesContainer.getOrRegister((String)"kd.bos.metadata.dynplugin.DynamicPluginDesignMeta")) != null) {
                dts.put("DynamicPluginDesignMeta", OrmUtils.getDataEntityType((Class)designDynamicPlugin));
            }
            if ((designDynamicPluginL = TypesContainer.getOrRegister((String)"kd.bos.metadata.dynplugin.DynamicPluginDesignMeta_Lang")) != null) {
                dts.put("DynamicPluginDesignMeta_Lang", OrmUtils.getDataEntityType((Class)designDynamicPluginL));
            }
            if ((designDynamicBindPlugin = TypesContainer.getOrRegister((String)"kd.bos.metadata.dynplugin.DynamicPluginBindDesignMeta")) != null) {
                dts.put("DynamicPluginBindDesignMeta", OrmUtils.getDataEntityType((Class)designDynamicBindPlugin));
            }
            if ((designDynamicPluginBindL = TypesContainer.getOrRegister((String)"kd.bos.metadata.dynplugin.DynamicPluginBindDesignMeta_Lang")) != null) {
                dts.put("DynamicPluginBindDesignMeta_Lang", OrmUtils.getDataEntityType((Class)designDynamicPluginBindL));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

