/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.deploy.gray;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.archive.tablemanager.TableManager;
import kd.bos.archive.tablemanager.meta.Imeta;
import kd.bos.archive.tablemanager.meta.MetaFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.xdb.exception.XdbException;
import kd.bos.xdb.tablemanager.meta.Column;

public class GrayMetaTableCreator {
    private static final String BOS_METADATA = "bos-metadata";
    String appGroup;

    public GrayMetaTableCreator(String appGroup) {
        this.appGroup = appGroup;
    }

    public boolean createTable() {
        int size;
        if (StringUtils.isBlank((CharSequence)this.appGroup)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u7070\u5ea6\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GrayMetaTableCreator_0", (String)BOS_METADATA, (Object[])new Object[0])});
        }
        List<String> tableNameList = this.getGrayMetaTableNames();
        if (DB.exitsTable((DBRoute)DBRoute.meta, (String)this.getGrayTableName(tableNameList.get((size = tableNameList.size()) - 1)))) {
            return false;
        }
        int beginIdx = -1;
        while (beginIdx != size && !DB.exitsTable((DBRoute)DBRoute.meta, (String)this.getGrayTableName(tableNameList.get(size - 1)))) {
            beginIdx = this.createGrayTable(tableNameList, beginIdx);
        }
        return true;
    }

    public void initAllAppGrayMeta() {
        if (StringUtils.isBlank((CharSequence)this.appGroup)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u7070\u5ea6\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GrayMetaTableCreator_0", (String)BOS_METADATA, (Object[])new Object[0])});
        }
        List<String> tableNameList = this.getGrayMetaTableNames();
        String checkTable = this.getGrayTableName(tableNameList.get(tableNameList.size() - 1));
        Integer dataCount = (Integer)DB.query((DBRoute)DBRoute.meta, (String)String.format("select count(1) from %s", checkTable), (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getInt(1);
                }
                return 0;
            }
        });
        if (dataCount == 0) {
            for (String tableName : tableNameList) {
                String[] joinColumns = this.getSyncGrayMetaTableRefColumn(tableName);
                this.converData(this.getGrayTableName(tableName), tableName, joinColumns);
            }
        }
    }

    private int createGrayTable(List<String> tableNameList, int index) {
        int beginIdx = 0;
        if (index != -1) {
            beginIdx = index;
        }
        for (int i = beginIdx; i < tableNameList.size(); ++i) {
            String tableName = tableNameList.get(i);
            String newTableName = this.getGrayTableName(tableName);
            if (DB.exitsTable((DBRoute)DBRoute.meta, (String)newTableName)) continue;
            try {
                TableManager.get().copyStructureTable(DBRoute.meta, newTableName, tableName, this.appGroup);
                continue;
            }
            catch (SQLException | XdbException e) {
                if (i == index) {
                    throw new KDException(e, BosErrorCode.bOS, new Object[]{String.format(ResManager.loadKDString((String)"\u521b\u5efa\u7070\u5ea6\u8868%s\u5931\u8d25\u3002", (String)"GrayMetaTableCreator_1", (String)BOS_METADATA, (Object[])new Object[0]), newTableName)});
                }
                return i;
            }
        }
        return tableNameList.size();
    }

    void converData(String inTableName, String fromTableName, String[] joinColumns) {
        this.backAndConverData(inTableName, fromTableName, null, joinColumns);
    }

    void backAndConverData(String inTableName, String fromTableName, String backTableName, String[] joinColumns) {
        Imeta meta = MetaFactory.getMeta((DBRoute)DBRoute.meta);
        List columnList = meta.queryColumns(DBRoute.meta, inTableName);
        StringBuilder delBakSql = new StringBuilder();
        StringBuilder bakSql = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)backTableName)) {
            delBakSql.append("delete from ").append(backTableName);
            bakSql.append("insert into ").append(backTableName).append(" (");
            bakSql.append(this.appendColumns(columnList));
            bakSql.append(") select ");
            bakSql.append(this.appendColumns(columnList));
            bakSql.append(" from ").append(inTableName).append(" A where ");
            bakSql.append(this.appendFilters(fromTableName, joinColumns, "A"));
        }
        StringBuilder delSql = new StringBuilder();
        delSql.append("delete from ").append(inTableName).append(" A where ");
        delSql.append(this.appendFilters(fromTableName, joinColumns, "A"));
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(inTableName).append(" (");
        sql.append(this.appendColumns(columnList));
        sql.append(") select ");
        sql.append(this.appendColumns(columnList));
        sql.append(" from ").append(fromTableName);
        try (TXHandle txh = TX.requiresNew();){
            if (StringUtils.isNotBlank((CharSequence)backTableName)) {
                DB.execute((DBRoute)DBRoute.meta, (String)delBakSql.toString());
                DB.execute((DBRoute)DBRoute.meta, (String)bakSql.toString());
            }
            DB.execute((DBRoute)DBRoute.meta, (String)delSql.toString());
            DB.execute((DBRoute)DBRoute.meta, (String)sql.toString());
        }
    }

    private String appendFilters(String fromTableName, String[] joinColumns, String sourceTableAlias) {
        StringBuilder sql = new StringBuilder();
        sql.append(" exists (select 1 from ").append(fromTableName).append(" WHERE ");
        sql.append(joinColumns[0]).append(" = ").append(sourceTableAlias).append(".").append(joinColumns[0]);
        for (int i = 1; i < joinColumns.length; ++i) {
            sql.append(" AND ").append(joinColumns[i]).append(" = ").append(sourceTableAlias).append(".").append(joinColumns[i]);
        }
        sql.append(")");
        return sql.toString();
    }

    private String appendColumns(List<Column> columnList) {
        StringBuilder sql = new StringBuilder();
        sql.append(columnList.get(0).getColumnName());
        for (int i = 1; i < columnList.size(); ++i) {
            sql.append(",").append(columnList.get(i).getColumnName());
        }
        return sql.toString();
    }

    private String getGrayTableName(String tabName) {
        return String.format("%s_%s", tabName, this.appGroup);
    }

    List<String> getGrayMetaTableNames() {
        ArrayList<String> tableNames = new ArrayList<String>(29);
        tableNames.add("T_META_FORM");
        tableNames.add("T_META_ENTITY");
        tableNames.add("T_META_FORMDESIGN");
        tableNames.add("T_META_FORMDESIGN_L");
        tableNames.add("T_META_ENTITYDESIGN");
        tableNames.add("T_META_ENTITYDESIGN_L");
        tableNames.add("T_META_ENTITYINFO");
        tableNames.add("T_META_MAINENTITYINFO");
        tableNames.add("T_META_MAINENTITYINFO_L");
        tableNames.add("T_META_OBJECTTYPEREF");
        tableNames.add("T_META_BIZCLOUD");
        tableNames.add("T_META_BIZCLOUD_L");
        tableNames.add("T_META_BIZAPP");
        tableNames.add("T_META_BIZAPP_L");
        tableNames.add("T_META_APPRUNTIME");
        tableNames.add("T_META_APPRUNTIME_L");
        tableNames.add("T_META_BIZUNITRELFORM");
        tableNames.add("T_META_MENURUNTIME");
        tableNames.add("T_META_MENURUNTIME_L");
        tableNames.add("T_META_PLUGINSCRIPT");
        tableNames.add("T_WARN_EARLYWARN");
        tableNames.add("T_WARN_EARLYWARN_L");
        tableNames.add("T_BOTP_CONVERTRULE");
        tableNames.add("T_BOTP_CONVERTRULE_L");
        tableNames.add("T_BOTP_WRITEBACKRULE");
        tableNames.add("T_BOTP_WRITEBACKRULE_L");
        tableNames.add("T_META_CARDREPOSITORY");
        tableNames.add("T_META_CARDREPOSITORY_L");
        tableNames.add("T_BAS_METASIGN");
        return tableNames;
    }

    String[] getSyncGrayMetaTableRefColumn(String tableName) {
        switch (tableName) {
            case "T_META_FORM": 
            case "T_META_ENTITY": 
            case "T_BAS_METASIGN": {
                return new String[]{"FNUMBER"};
            }
            case "T_META_FORMDESIGN_L": 
            case "T_META_ENTITYDESIGN_L": 
            case "T_META_MAINENTITYINFO_L": 
            case "T_META_BIZCLOUD_L": 
            case "T_META_BIZAPP_L": 
            case "T_WARN_EARLYWARN_L": 
            case "T_BOTP_CONVERTRULE_L": 
            case "T_BOTP_WRITEBACKRULE_L": 
            case "T_META_CARDREPOSITORY_L": {
                return new String[]{"FID", "FLOCALEID"};
            }
            case "T_META_APPRUNTIME": {
                return new String[]{"FAPPID"};
            }
            case "T_META_APPRUNTIME_L": {
                return new String[]{"FAPPID", "FLOCALEID"};
            }
            case "T_META_BIZUNITRELFORM": {
                return new String[]{"FBIZAPPID", "FBIZUNITID", "FFORMID"};
            }
        }
        return new String[]{"FID"};
    }
}

