/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.devportal;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheLoader;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.Base39Coder;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.IMetadataDaoPlugIn;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.devportal.AppDesignMetaReader;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.AppRuntimeMeta;
import kd.bos.metadata.devportal.AppRuntimeMetaL;
import kd.bos.metadata.devportal.AppWriter;
import kd.bos.metadata.devportal.MenuRuntimeMeta;
import kd.bos.metadata.devportal.MenuRuntimeMetaL;
import kd.bos.metadata.devportal.SpellMappingEntity;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.PinYinUtil;

public class AppMetaDaoPlugin
implements IMetadataDaoPlugIn {
    protected static final String T_META_APPRUNTIME_STR = "T_META_APPRUNTIME";
    protected static final String T_META_MENURUNTIME_STR = "T_META_MENURUNTIME";
    private static final String FORMDESIGN_TABLE = "T_META_FORMDESIGN";
    private static final String CACHEKEY_FORMNUMBER = "formnumber";
    protected static final String DELETE_FROM = "DELETE FROM %s ";
    protected static final String SELECT_FID_FROM_S_WHERE_FAPPID = "SELECT FID FROM %s WHERE FAPPID ";
    private static final String SELECT_1_FROM_S_WHERE_FBIZAPPID_AND_F_S_1 = "select 1 from %s where FBIZAPPID = ? AND F%s = '1'";
    private String appGroup;
    private static final String APPREBUILD_MENU_BATCHSIZE = "apprebuild.menusize";
    private static final int BATCH_SIZE = Integer.parseInt(System.getProperty("apprebuild.menusize", "9"));

    public String getAppGroup() {
        return this.appGroup;
    }

    @Override
    public void setAppGroup(String appGroup) {
        this.appGroup = appGroup;
    }

    private String getCloudNumberById(String id) {
        String sql = String.format("select FNUMBER from %s where FID = ? ", "T_META_BIZCLOUD");
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)id)};
        ResultSetHandler action = rs -> {
            if (rs.next()) {
                return rs.getString("FNUMBER");
            }
            return null;
        };
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    protected List<AbstractMetadata> buildRuntimeMetaList(AppDesignMetaReader reader, String appMasterId, String currentMetaId) {
        ArrayList<AbstractMetadata> list = new ArrayList<AbstractMetadata>();
        list.add(reader.loadMeta(appMasterId, true));
        return list;
    }

    protected AppRuntimeMeta getAppRuntimeMeta(AppMetadata appRuntimeMetadata, String id) {
        Object[] ids = new String[]{id};
        IDataEntityType dataEntityType = this.getGrayDataEntityType(OrmUtils.getDataEntityType(AppRuntimeMeta.class));
        Object[] datas = BusinessDataReader.load((Object[])ids, (IDataEntityType)dataEntityType);
        if (datas.length > 0) {
            return (AppRuntimeMeta)datas[0];
        }
        return null;
    }

    protected void deleteAppRuntimeMeta(AppMetadata appRuntimeMetadata, String ... numbers) {
        SqlBuilder deleteLangSql = new SqlBuilder();
        deleteLangSql.appendIn(String.format(DELETE_FROM, this.getTableName("T_META_APPRUNTIME_L")) + " WHERE FAPPID ", (Object[])numbers);
        DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)deleteLangSql);
        SqlBuilder deleteSql = new SqlBuilder();
        deleteSql.appendIn(String.format(DELETE_FROM, this.getTableName(T_META_APPRUNTIME_STR)) + " WHERE FAPPID ", (Object[])numbers);
        DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)deleteSql);
        if (SystemPropertyUtils.getBooleanExt((String)RequestContext.get().getTenantId(), (String)"use.spelldict", (Boolean)true).booleanValue()) {
            String id = appRuntimeMetadata.getId();
            SqlBuilder deleteAppDictDql = new SqlBuilder();
            deleteAppDictDql.appendIn(String.format(DELETE_FROM, this.getTableName("t_meta_dataspelldict")) + " WHERE FOBJID ", (Object[])new String[]{id});
            DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)deleteAppDictDql);
        }
    }

    protected void saveRuntimeMetaToDb(AbstractMetadata appRuntimeMetadata, Object[] runtimeMetas) {
        if (runtimeMetas.length == 0) {
            return;
        }
        IDataEntityType runtimeMetaType = this.getGrayDataEntityType(OrmUtils.getDataEntityType(runtimeMetas[0].getClass()));
        BusinessDataWriter.save((IDataEntityType)runtimeMetaType, (Object[])runtimeMetas);
    }

    protected void saveAppAndMenuName(Object[] appAndName) {
        IDataEntityType appAndMenuNameType = OrmUtils.getDataEntityType(SpellMappingEntity.class);
        BusinessDataWriter.save((IDataEntityType)appAndMenuNameType, (Object[])appAndName);
    }

    private void saveRuntimeMetaToDb(Object[] runtimeMetas) {
        if (runtimeMetas.length == 0) {
            return;
        }
        IDataEntityType runtimeMetaType = this.getGrayDataEntityType(OrmUtils.getDataEntityType(runtimeMetas[0].getClass()));
        BusinessDataWriter.save((IDataEntityType)runtimeMetaType, (Object[])runtimeMetas);
    }

    protected void deleteMenuRuntimeMeta(AppMetadata appRuntimeMetadata, String ... numbers) {
        SqlBuilder selectMenuLangFIDSql = new SqlBuilder();
        selectMenuLangFIDSql.appendIn(String.format(SELECT_FID_FROM_S_WHERE_FAPPID, this.getTableName(T_META_MENURUNTIME_STR)), (Object[])numbers);
        ResultSetHandler callBackLangHanlder = rs -> {
            ArrayList<Object> menuIds = new ArrayList<Object>();
            try {
                while (rs.next()) {
                    Object menuId = rs.getObject("FID");
                    menuIds.add(menuId);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return menuIds;
        };
        List menuIds = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)selectMenuLangFIDSql, (ResultSetHandler)callBackLangHanlder);
        if (!menuIds.isEmpty()) {
            String deleteMenuLangSql = String.format("DELETE FROM %s WHERE FID = ?", this.getTableName("T_META_MENURUNTIME_L"));
            ArrayList<Object[]> list = new ArrayList<Object[]>(10);
            for (int i = 0; i < menuIds.size(); ++i) {
                Object[] param = new Object[]{menuIds.get(i)};
                list.add(param);
            }
            DB.executeBatch((DBRoute)DBRoute.meta, (String)deleteMenuLangSql, list);
            SqlBuilder deleteMenuSql = new SqlBuilder();
            deleteMenuSql.appendIn(String.format(DELETE_FROM, this.getTableName(T_META_MENURUNTIME_STR)) + " WHERE FAPPID ", (Object[])numbers);
            DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)deleteMenuSql);
            if (SystemPropertyUtils.getBooleanExt((String)RequestContext.get().getTenantId(), (String)"use.spelldict", (Boolean)true).booleanValue()) {
                SqlBuilder deleteMenuDictDql = new SqlBuilder();
                deleteMenuDictDql.appendIn(String.format(DELETE_FROM, this.getTableName("t_meta_dataspelldict")) + " WHERE FOBJID", menuIds);
                DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)deleteMenuDictDql);
            }
        }
    }

    protected IDataEntityType getGrayDataEntityType(IDataEntityType dataEntityType) {
        IDataEntityType det;
        if (StringUtils.isBlank((CharSequence)this.appGroup) || "defaultGroup".equals(this.appGroup)) {
            return dataEntityType;
        }
        try {
            det = (IDataEntityType)dataEntityType.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{e.getMessage()});
        }
        det.setAlias(this.getTableName(det.getAlias()));
        return det;
    }

    @Override
    public void saveRuntimeMeta(boolean isDraft, AbstractMetadata[] metadatas) {
        AppDesignMetaReader adr = new AppDesignMetaReader();
        adr.setAppGroup(this.appGroup);
        for (AbstractMetadata metadata : metadatas) {
            List<AbstractMetadata> runtimeMetaList;
            if (!(metadata instanceof AppMetadata)) continue;
            String curId = metadata.getId();
            List<String> relIds = this.getSubApps(curId);
            ArrayList<AppMetadata> metas = new ArrayList<AppMetadata>();
            if (relIds != null) {
                for (String relId : relIds) {
                    AppMetadata appMeta = adr.loadMeta(relId, false);
                    metas.add(appMeta);
                }
            }
            if (metas.size() > 0) {
                AppWriter writer = new AppWriter();
                writer.setAppGroup(this.appGroup);
                writer.save(metas.toArray(new AppMetadata[metas.size()]));
            }
            AppMetadata appMetadata = (AppMetadata)metadata;
            String appMetaId = appMetadata.getId();
            adr.updateAppNumberAndIdCache(appMetaId, appMetadata.getNumber());
            String appMetaMasterId = appMetadata.getMasterId();
            if (!"2".equals(appMetadata.getDevType())) {
                appMetaMasterId = appMetadata.getId();
            }
            if ((runtimeMetaList = this.buildRuntimeMetaList(adr, appMetaMasterId, curId)).isEmpty()) {
                throw new KDException(BosErrorCode.nullError, new Object[]{"appMetadata is null"});
            }
            AppMetadata appDesignMetadata = adr.loadMeta(appMetaMasterId, false);
            List<String> langs = this.getEnableLangs();
            for (AbstractMetadata r : runtimeMetaList) {
                String orgFunc;
                String cloudNum;
                String id;
                AppMetadata appMetadataFull = (AppMetadata)r;
                if (!appMetaId.equals(appMetaMasterId) && appMetadataFull != null && appDesignMetadata != null) {
                    String deployStatus = appMetadataFull.getAppElement().getDeployStatus();
                    String masterDeployStatus = appDesignMetadata.getAppElement().getDeployStatus();
                    if (!masterDeployStatus.equals(deployStatus)) {
                        appMetadataFull.getAppElement().setDeployStatus(masterDeployStatus);
                    }
                }
                if (appMetadataFull == null) continue;
                String number = appMetadataFull.getNumber();
                if (number == null) {
                    number = " ";
                }
                if ((id = appMetadataFull.getId()) == null) {
                    id = " ";
                }
                Short seq = appMetadataFull.getAppElement().getSeq();
                String cloudId = appMetadataFull.getBizCloudID();
                if (cloudId == null) {
                    cloudId = " ";
                }
                if ((cloudNum = this.getCloudNumberById(cloudId)) == null) {
                    cloudNum = " ";
                }
                String dbRoute = appMetadataFull.getAppElement().getDbRoute();
                String image = appMetadataFull.getAppElement().getImage();
                String homeId = appMetadataFull.getAppElement().getMainFormID();
                String homeNum = " ";
                String homeURL = " ";
                String mainFormType = appMetadataFull.getAppElement().getMainFormType();
                String isv = appMetadataFull.getIsv();
                if ("1".equals(mainFormType)) {
                    homeURL = appMetadataFull.getAppElement().getHomeURL();
                    homeNum = " ";
                    homeId = " ";
                } else {
                    homeURL = " ";
                    if (StringUtils.isNotBlank((CharSequence)homeId)) {
                        homeNum = this.getFormNumberById(homeId, null);
                        if (homeNum == null) {
                            homeId = " ";
                            homeNum = " ";
                        }
                    } else {
                        homeId = " ";
                    }
                }
                String openType = appMetadataFull.getAppElement().getOpenType();
                String allUserApp = appMetadataFull.getAppElement().getAllUserApp();
                String userType = appMetadataFull.getAppElement().getUserType();
                if (userType == null) {
                    userType = " ";
                }
                if (StringUtils.isBlank((CharSequence)(orgFunc = appMetadataFull.getAppElement().getOrgFunc()))) {
                    orgFunc = " ";
                }
                Timestamp curTime = new Timestamp(System.currentTimeMillis());
                AppRuntimeMeta oldRuntimeMeta = this.getAppRuntimeMeta(appMetadataFull, id);
                String oldNumber = number;
                if (oldRuntimeMeta != null) {
                    oldNumber = oldRuntimeMeta.getAppid();
                }
                try (TXHandle txh = TX.requiresNew();){
                    try {
                        this.deleteMenuRuntimeMeta(appMetadataFull, oldNumber, number);
                        this.deleteAppRuntimeMeta(appMetadataFull, oldNumber, number);
                        String visible = appMetadataFull.getAppElement().getVisible();
                        String deployStatus = appMetadataFull.getAppElement().getDeployStatus();
                        boolean buildEnable = Boolean.getBoolean("appmeta.runtimebuild.enable");
                        if (!buildEnable || ("1".equals(visible) || "true".equals(visible)) && "2".equals(deployStatus)) {
                            boolean hasHelpCenterFlag;
                            Map<String, Object> appDataXml = this.buildAppDataXml(image, dbRoute, mainFormType, homeURL, isv);
                            AppRuntimeMeta appRuntimeMeta = this.buildAppRuntimeMeta(number, id, seq.shortValue(), cloudId, cloudNum, dbRoute, image, homeId, homeNum, openType, allUserApp, userType, orgFunc, curTime, appDataXml);
                            appRuntimeMeta.setVisible(visible);
                            appRuntimeMeta.setDeployStatus(deployStatus);
                            this.saveRuntimeMetaToDb(appMetadataFull, new Object[]{appRuntimeMeta});
                            LocaleString name = appMetadataFull.getAppElement().getName();
                            LocaleString desc = appMetadataFull.getAppElement().getDescription();
                            ArrayList<AppRuntimeMetaL> appRuntimeMetaLList = new ArrayList<AppRuntimeMetaL>(langs.size());
                            long[] appRunMetaPKs = DB.genGlobalLongIds((int)langs.size());
                            int appMetaLIdx = 0;
                            String fullSpellAppName = "";
                            String firstSpellAppName = "";
                            for (String lang : langs) {
                                String nameLang = (String)name.get((Object)lang);
                                if (StringUtils.isBlank((CharSequence)nameLang) && StringUtils.isBlank((CharSequence)((CharSequence)desc.get((Object)lang)))) continue;
                                if (nameLang == null) {
                                    nameLang = " ";
                                }
                                if ("zh_CN".equalsIgnoreCase(lang) && StringUtils.isNotBlank((CharSequence)nameLang)) {
                                    fullSpellAppName = PinYinUtil.getFullSpellByName(nameLang);
                                    firstSpellAppName = PinYinUtil.getFirstSpellByName(nameLang);
                                }
                                AppRuntimeMetaL appRuntimeMetaL = this.buildAppRuntimeMetaL(appRunMetaPKs[appMetaLIdx], number, lang, nameLang, desc);
                                appRuntimeMetaLList.add(appRuntimeMetaL);
                                ++appMetaLIdx;
                            }
                            this.saveRuntimeMetaToDb(appMetadataFull, appRuntimeMetaLList.toArray());
                            boolean insertPy2Dic = SystemPropertyUtils.getBooleanExt((String)RequestContext.get().getTenantId(), (String)"use.spelldict", (Boolean)true);
                            if (StringUtils.isNotBlank((CharSequence)fullSpellAppName) && StringUtils.isNotBlank((CharSequence)firstSpellAppName) && insertPy2Dic) {
                                SpellMappingEntity spellMappingEntity = new SpellMappingEntity();
                                spellMappingEntity.setObjId(appRuntimeMeta.getId());
                                spellMappingEntity.setType("app");
                                spellMappingEntity.setFullSpell(fullSpellAppName.toLowerCase());
                                spellMappingEntity.setFirstSpell(firstSpellAppName.toLowerCase());
                                this.saveAppAndMenuName(new Object[]{spellMappingEntity});
                            }
                            if (!(hasHelpCenterFlag = this.hasHelpCenterMenu(appMetadataFull)) && this.isAppWhiteList(appRuntimeMeta.getId(), "isapphelper")) {
                                appMetadataFull.getAppMenus().add(this.buildHelpMenu(appMetadataFull));
                            }
                            Map<String, LocaleString> formNameMap = this.getFormNameMap(appMetadataFull.getAppMenus(), langs);
                            Map<String, String> formNumberMap = this.getFormNumberMap(appMetadataFull.getAppMenus());
                            ArrayList<MenuRuntimeMeta> menuRuntimeMetaList = new ArrayList<MenuRuntimeMeta>(10);
                            ArrayList<MenuRuntimeMetaL> menuRuntimeMetaLList = new ArrayList<MenuRuntimeMetaL>(10);
                            int i = 0;
                            for (AppMenuElement menu : appMetadataFull.getAppMenus()) {
                                String menuParentId;
                                String permission;
                                String paramType;
                                if (!"true".equals(menu.getVisible()) && !"1".equals(menu.getVisible())) continue;
                                String menuId = menu.getId();
                                short menuSeq = menu.getSeq();
                                String formId = menu.getFormNumber();
                                String bizFormId = menu.getFormId();
                                if (StringUtils.isBlank((CharSequence)formId) && StringUtils.isNotBlank((CharSequence)bizFormId)) {
                                    formId = this.getFormNumberById(bizFormId, formNumberMap);
                                } else if (StringUtils.isNotBlank((CharSequence)formId) && StringUtils.isNotBlank((CharSequence)bizFormId)) {
                                    String formNumById = this.getFormNumberById(bizFormId, formNumberMap);
                                    if (StringUtils.isNotBlank((CharSequence)formNumById)) {
                                        if (!formId.equals(formNumById)) {
                                            if (this.checkNumber(formId)) {
                                                bizFormId = this.getFormIdByNumber(formId);
                                            } else if (this.checkNumber(formNumById)) {
                                                formId = formNumById;
                                            }
                                        }
                                    } else {
                                        bizFormId = this.getFormIdByNumber(formId);
                                    }
                                }
                                if (formId == null || formId.length() == 0) {
                                    formId = " ";
                                }
                                if (bizFormId == null || bizFormId.length() == 0) {
                                    bizFormId = " ";
                                }
                                if ((paramType = menu.getParameterType()) == null || paramType.length() == 0) {
                                    paramType = " ";
                                }
                                String parameters = menu.getParameter();
                                String menuOpenType = menu.getOpenType();
                                if (menuOpenType == null || menuOpenType.length() == 0) {
                                    menuOpenType = " ";
                                }
                                if ((permission = menu.getPermission()) == null || permission.length() == 0) {
                                    permission = " ";
                                }
                                if (StringUtils.isBlank((CharSequence)(menuParentId = menu.getParentId())) || appMetadataFull.getMapMenus().get(menuParentId) == null) {
                                    menuParentId = appMetaMasterId;
                                }
                                if (menuParentId == null || menuParentId.length() == 0) {
                                    menuParentId = " ";
                                }
                                String naviVector = menu.getVectorImage();
                                String shortcutIcon = menu.getIconShortcut();
                                LocaleString menuName = menu.getName();
                                LocaleString menuDesc = menu.getDescription();
                                LocaleString formName = formNameMap.get(menu.getFormNumber());
                                if (formName == null || formName.isEmpty()) {
                                    formName = this.getFormNameFromMeta(bizFormId, formId);
                                }
                                LinkedHashMap<String, Object> menuDataXml = new LinkedHashMap<String, Object>();
                                if (StringUtils.isNotBlank((CharSequence)naviVector)) {
                                    menuDataXml.put("naviVector", naviVector);
                                }
                                if (StringUtils.isNotBlank((CharSequence)shortcutIcon)) {
                                    menuDataXml.put("shortcutIcon", shortcutIcon);
                                }
                                MenuRuntimeMeta menuRuntimeMeta = this.buildMenuRuntimeMeta(menuId, number, menuSeq, formId, paramType, parameters, menuOpenType, permission, menuParentId, naviVector, shortcutIcon, curTime, menuDataXml, menu.getMenuType(), menu.getLinkUrl());
                                menuRuntimeMetaList.add(menuRuntimeMeta);
                                long[] menuMetaLPk = DB.genGlobalLongIds((int)langs.size());
                                int menuMetaLIdx = 0;
                                String fullSpellMenuName = "";
                                String firstSpellMenuName = "";
                                for (String lang : langs) {
                                    String menuName_Lang = (String)menuName.get((Object)lang);
                                    if (StringUtils.isBlank((CharSequence)menuName_Lang) && StringUtils.isBlank((CharSequence)((CharSequence)menuDesc.get((Object)lang))) && StringUtils.isBlank((CharSequence)((CharSequence)formName.get((Object)lang)))) continue;
                                    if (menuName_Lang == null) {
                                        menuName_Lang = " ";
                                    }
                                    if ("zh_CN".equalsIgnoreCase(lang) && StringUtils.isNotBlank((CharSequence)menuName_Lang)) {
                                        fullSpellMenuName = PinYinUtil.getFullSpellByName(menuName_Lang);
                                        firstSpellMenuName = PinYinUtil.getFirstSpellByName(menuName_Lang);
                                        if (StringUtils.isNotBlank((CharSequence)fullSpellAppName) && StringUtils.isNotBlank((CharSequence)firstSpellAppName) && insertPy2Dic) {
                                            SpellMappingEntity spellMappingEntity = new SpellMappingEntity();
                                            spellMappingEntity.setObjId(menuRuntimeMeta.getId());
                                            spellMappingEntity.setType("menu");
                                            spellMappingEntity.setFullSpell(fullSpellMenuName.toLowerCase());
                                            spellMappingEntity.setFirstSpell(firstSpellMenuName.toLowerCase());
                                            this.saveAppAndMenuName(new Object[]{spellMappingEntity});
                                        }
                                    }
                                    MenuRuntimeMetaL menuRuntimeMetaL = this.buildMenuRuntimeMetaL(menuMetaLPk[menuMetaLIdx], menuId, lang, menuName_Lang, menuDesc, formName);
                                    menuRuntimeMetaLList.add(menuRuntimeMetaL);
                                    ++menuMetaLIdx;
                                }
                                ++i;
                            }
                            if (!menuRuntimeMetaList.isEmpty()) {
                                this.saveRuntimeMetaToDb(appMetadataFull, menuRuntimeMetaList.toArray());
                            }
                            if (!menuRuntimeMetaLList.isEmpty()) {
                                for (int n = 0; n < menuRuntimeMetaLList.size(); n += BATCH_SIZE) {
                                    int startIndex = n;
                                    int endIndex = n + BATCH_SIZE;
                                    if (endIndex > menuRuntimeMetaLList.size()) {
                                        endIndex = menuRuntimeMetaLList.size();
                                    }
                                    List menuLSubList = menuRuntimeMetaLList.subList(startIndex, endIndex);
                                    this.saveRuntimeMetaToDb(appMetadataFull, menuLSubList.toArray());
                                }
                            }
                        }
                    }
                    catch (Throwable e) {
                        txh.markRollback();
                        throw e;
                    }
                }
                adr.cleanAppCache(appMetaId, appMetaMasterId, oldNumber);
                if (this.appGroup != null) continue;
                AppDesignMetaReader adrWithDefaultGroup = new AppDesignMetaReader();
                adrWithDefaultGroup.setAppGroup("defaultGroup");
                adrWithDefaultGroup.updateAppNumberAndIdCache(appMetaId, appMetadata.getNumber());
                adrWithDefaultGroup.cleanAppCache(appMetaId, appMetaMasterId, oldNumber);
            }
        }
    }

    private LocaleString getFormNameFromMeta(String bizFormId, String formId) {
        LocaleString formName = new LocaleString();
        if (StringUtils.isNotBlank((CharSequence)bizFormId) && StringUtils.isNotBlank((CharSequence)formId) && this.checkNumber(formId)) {
            MetadataReader reader = new MetadataReader();
            reader.setAppGroup(this.appGroup);
            AbstractMetadata formMeta = reader.readMetaForMetadataDao(bizFormId, OrmUtils.getDataEntityType(DesignFormMeta.class), true, false);
            if (formMeta == null && this.isGrayGroup()) {
                reader = new MetadataReader();
                formMeta = reader.readMetaForMetadataDao(bizFormId, OrmUtils.getDataEntityType(DesignFormMeta.class), true, false);
            }
            if (formMeta != null) {
                if ("PrintModel".equals(formMeta.getModelType())) {
                    PrintMetadata pm = (PrintMetadata)formMeta;
                    formName = pm.getName();
                } else {
                    FormMetadata fm = (FormMetadata)formMeta;
                    formName = fm.getName();
                }
            }
        }
        return formName;
    }

    private Map<String, LocaleString> getFormNameMap(List<AppMenuElement> menuElementList, List<String> langs) {
        if (menuElementList == null || menuElementList.isEmpty()) {
            return new HashMap<String, LocaleString>(1);
        }
        HashSet<String> formIdList = new HashSet<String>(10);
        menuElementList.forEach(menu -> {
            if (menu != null && StringUtils.isNotBlank((CharSequence)menu.getFormId())) {
                formIdList.add(menu.getFormNumber());
            }
        });
        if (formIdList.isEmpty()) {
            return new HashMap<String, LocaleString>(0);
        }
        Map<String, LocaleString> map = this.getRuntimeFormName(formIdList);
        return map;
    }

    private Map<String, String> getFormNumberMap(List<AppMenuElement> menuElementList) {
        if (menuElementList == null || menuElementList.isEmpty()) {
            return new HashMap<String, String>(1);
        }
        HashSet<String> formIdList = new HashSet<String>(10);
        menuElementList.forEach(menu -> {
            if (menu != null && StringUtils.isNotBlank((CharSequence)menu.getFormId())) {
                formIdList.add(menu.getFormId());
            }
        });
        if (formIdList.isEmpty()) {
            return new HashMap<String, String>(0);
        }
        Map<String, String> map = this.getRuntimeFormNumber(formIdList);
        return map;
    }

    private Map<String, LocaleString> getRuntimeFormName(Set<String> formIdList) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select a.fid,b.fname,b.flocaleid from t_meta_mainentityinfo a join t_meta_mainentityinfo_l b on a.fid = b.fid where ", new Object[0]).appendIn("a.fid", formIdList.toArray(new Object[formIdList.size()]));
        ResultSetHandler callBackHanlder = rs -> {
            HashMap<String, LocaleString> map = new HashMap<String, LocaleString>(16);
            try {
                while (rs.next()) {
                    String formId = rs.getString(1);
                    String name = rs.getString(2);
                    String localeId = rs.getString(3);
                    LocaleString nameLocale = new LocaleString();
                    if (map.get(formId) != null) {
                        nameLocale = (LocaleString)map.get(formId);
                    }
                    nameLocale.put(localeId, (Object)name);
                    map.put(formId, nameLocale);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{e.getMessage()});
            }
            return map;
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sql, (ResultSetHandler)callBackHanlder);
    }

    private Map<String, String> getRuntimeFormNumber(Set<String> formIdList) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select Fid,FNumber from t_meta_formdesign where ", new Object[0]).appendIn("fid", formIdList.toArray(new Object[formIdList.size()]));
        ResultSetHandler callBackHanlder = rs -> {
            HashMap<String, String> map = new HashMap<String, String>(16);
            try {
                while (rs.next()) {
                    String formId = rs.getString(1);
                    String number = rs.getString(2);
                    map.put(formId, number);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{e.getMessage()});
            }
            return map;
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sql, (ResultSetHandler)callBackHanlder);
    }

    private MenuRuntimeMetaL buildMenuRuntimeMetaL(long id, String menuId, String lang, String menuName_Lang, LocaleString menuDesc, LocaleString formName) {
        MenuRuntimeMetaL menuRuntimeMetaL = new MenuRuntimeMetaL();
        menuRuntimeMetaL.setPkid(Base39Coder.toString((long)id));
        menuRuntimeMetaL.setId(menuId);
        menuRuntimeMetaL.setLocaleid(lang);
        menuRuntimeMetaL.setName(menuName_Lang);
        menuRuntimeMetaL.setDescription((String)menuDesc.get((Object)lang));
        menuRuntimeMetaL.setFormname((String)formName.get((Object)lang));
        return menuRuntimeMetaL;
    }

    private MenuRuntimeMeta buildMenuRuntimeMeta(String menuId, String number, int menuSeq, String formId, String paramType, String parameters, String menuOpenType, String permission, String menuParentId, String naviVector, String shortcutIcon, Timestamp curTime, Map<String, Object> menuDataXml) {
        MenuRuntimeMeta menuRuntimeMeta = new MenuRuntimeMeta();
        menuRuntimeMeta.setId(menuId);
        menuRuntimeMeta.setAppid(number);
        menuRuntimeMeta.setSeq(menuSeq);
        menuRuntimeMeta.setFormid(formId);
        menuRuntimeMeta.setParamtype(paramType);
        menuRuntimeMeta.setParams(parameters);
        menuRuntimeMeta.setOpentype(menuOpenType);
        menuRuntimeMeta.setPermission(permission);
        menuRuntimeMeta.setParentid(menuParentId);
        menuRuntimeMeta.setNavivector(naviVector);
        menuRuntimeMeta.setShortcuticon(shortcutIcon);
        menuRuntimeMeta.setTimestamp(curTime);
        menuRuntimeMeta.setData(SerializationUtils.toJsonString(menuDataXml));
        return menuRuntimeMeta;
    }

    private MenuRuntimeMeta buildMenuRuntimeMeta(String menuId, String number, int menuSeq, String formId, String paramType, String parameters, String menuOpenType, String permission, String menuParentId, String naviVector, String shortcutIcon, Timestamp curTime, Map<String, Object> menuDataXml, String menuType, String linkUrl) {
        MenuRuntimeMeta menuRuntimeMeta = this.buildMenuRuntimeMeta(menuId, number, menuSeq, formId, paramType, parameters, menuOpenType, permission, menuParentId, naviVector, shortcutIcon, curTime, menuDataXml);
        menuRuntimeMeta.setMenuType(menuType);
        menuRuntimeMeta.setLinkUrl(linkUrl);
        return menuRuntimeMeta;
    }

    private AppMenuElement buildHelpMenu(AppMetadata appMetadataFull) {
        AppMenuElement appStarter = new AppMenuElement();
        String helpCenterUuid = Uuid16.create().toString();
        String subHelpCenterUuid = helpCenterUuid.substring(0, 11);
        String helpCenterId = subHelpCenterUuid + "#hpce";
        appStarter.setId(helpCenterId);
        Short appStartedMenuSeq = 32766;
        appStarter.setSeq(appStartedMenuSeq.shortValue());
        appStarter.setFormNumber("bas_appstarted");
        appStarter.setNumber("helpcentermenu");
        appStarter.setParameter(" ");
        appStarter.setVectorImage("kdfont kdfont-tishixinxi_l");
        appStarter.setIconShortcut("/icons/pc/entrance/helpcentre.png");
        HashMap<String, String> locValues = new HashMap<String, String>();
        locValues.put("zh_CN", ResManager.loadKDString((String)"\u5e2e\u52a9\u4e2d\u5fc3", (String)"AppMetaDaoPlugin_0", (String)"bos-metadata", (Object[])new Object[0]));
        locValues.put("zh_TW", ResManager.loadKDString((String)"\u5e6b\u52a9\u4e2d\u5fc3", (String)"AppMetaDaoPlugin_1", (String)"bos-metadata", (Object[])new Object[0]));
        locValues.put("en_US", "Help center");
        LocaleString asCaption = LocaleString.fromMap(locValues);
        appStarter.setCaption(asCaption);
        LocaleString asName = LocaleString.fromMap(locValues);
        appStarter.setName(asName);
        LocaleString asDesc = LocaleString.fromMap(locValues);
        appStarter.setDescription(asDesc);
        appStarter.setVisible(appMetadataFull.getAppElement().getVisible());
        return appStarter;
    }

    private AppRuntimeMetaL buildAppRuntimeMetaL(long id, String number, String lang, String nameLang, LocaleString desc) {
        AppRuntimeMetaL appRuntimeMetaL = new AppRuntimeMetaL();
        appRuntimeMetaL.setPkid(Base39Coder.toString((long)id));
        appRuntimeMetaL.setAppid(number);
        appRuntimeMetaL.setLocaleid(lang);
        appRuntimeMetaL.setName(nameLang);
        appRuntimeMetaL.setDescription((String)desc.get((Object)lang));
        return appRuntimeMetaL;
    }

    private AppRuntimeMeta buildAppRuntimeMeta(String number, String id, int seq, String cloudId, String cloudNum, String dbRoute, String image, String homeId, String homeNum, String openType, String allUserApp, String userType, String orgFunc, Timestamp curTime, Map<String, Object> appDataXml) {
        AppRuntimeMeta appRuntimeMeta = new AppRuntimeMeta();
        appRuntimeMeta.setAppid(number);
        appRuntimeMeta.setId(id);
        appRuntimeMeta.setSeq(seq);
        appRuntimeMeta.setCloudid(cloudId);
        appRuntimeMeta.setCloudnum(cloudNum);
        appRuntimeMeta.setDbroute(dbRoute);
        appRuntimeMeta.setImage(image);
        appRuntimeMeta.setHomeid(homeId);
        appRuntimeMeta.setHomenum(homeNum);
        appRuntimeMeta.setOpentype(openType);
        appRuntimeMeta.setAlluserapp(allUserApp);
        appRuntimeMeta.setUsertype(userType);
        appRuntimeMeta.setOrgfunc(orgFunc);
        appRuntimeMeta.setTimestamp(curTime);
        appRuntimeMeta.setData(SerializationUtils.toJsonString(appDataXml));
        return appRuntimeMeta;
    }

    private Map<String, Object> buildAppDataXml(String image, String dbRoute, String mainFormType, String homeURL, String isv) {
        LinkedHashMap<String, Object> appDataXml = new LinkedHashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)image)) {
            appDataXml.put("image", image);
        }
        if (StringUtils.isNotBlank((CharSequence)dbRoute)) {
            appDataXml.put("dbRoute", dbRoute);
        }
        if (StringUtils.isNotBlank((CharSequence)mainFormType)) {
            appDataXml.put("mainFormType", mainFormType);
        }
        if (StringUtils.isNotBlank((CharSequence)homeURL)) {
            appDataXml.put("homeURL", homeURL);
        }
        if (StringUtils.isNotBlank((CharSequence)isv)) {
            appDataXml.put("isv", isv);
        }
        return appDataXml;
    }

    private List<String> getEnableLangs() {
        IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        List languages = inteService.getRebuildMetaLang();
        if (!CollectionUtils.isEmpty((Collection)languages)) {
            ArrayList<String> langs = new ArrayList<String>();
            for (EnabledLang language : languages) {
                if (!StringUtils.isNotBlank((CharSequence)language.getNumber())) continue;
                langs.add(language.getNumber());
            }
            return langs;
        }
        return Arrays.asList("zh_CN", "zh_TW", "en_US");
    }

    private boolean checkNumber(String formId) {
        boolean isExists = this.checkNumber(this.appGroup, formId);
        if (!isExists) {
            return this.checkNumber("defaultGroup", formId);
        }
        return isExists;
    }

    private boolean checkNumber(String appGroup, String formId) {
        String sql = String.format("select 1 from %s where FNUMBER = ? ", AppGroupUtils.getAppGroupTableName((String)appGroup, (String)FORMDESIGN_TABLE));
        Object[] params = new SqlParameter[]{new SqlParameter("FNUMBGER", 12, (Object)formId)};
        return (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getInt(1) > 0;
                }
                return false;
            }
        });
    }

    private String getFormNumberById(String bizFormId, Map<String, String> formNumberMap) {
        if (formNumberMap != null && StringUtils.isNotBlank((CharSequence)formNumberMap.get(bizFormId))) {
            return formNumberMap.get(bizFormId);
        }
        String number = this.getNumberById(this.appGroup, bizFormId);
        if (StringUtils.isBlank((CharSequence)number) && this.isGrayGroup()) {
            number = this.getNumberById("defaultGroup", bizFormId);
        }
        return number;
    }

    private String getFormIdByNumber(String formId) {
        MetadataReader reader = new MetadataReader();
        reader.setAppGroup(this.appGroup);
        String number = reader.loadIdByNumber(formId, MetaCategory.Form);
        if (StringUtils.isBlank((CharSequence)number) && this.isGrayGroup()) {
            reader = new MetadataReader();
            number = reader.loadIdByNumber(formId, MetaCategory.Form);
        }
        return number;
    }

    private String getNumberById(final String appGroup, final String id) {
        String number = (String)ThreadCache.get((Object)(id + ".formnumber"), (CacheLoader)new CacheLoader<String>(){

            public String load() {
                String num = MetaCacheUtils.getDistributeCache(id, AppMetaDaoPlugin.CACHEKEY_FORMNUMBER, 0);
                if (num != null) {
                    return num;
                }
                String sql = String.format("select FNumber from %s where FId = ? ", AppGroupUtils.getAppGroupTableName((String)appGroup, (String)AppMetaDaoPlugin.FORMDESIGN_TABLE));
                Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)id)};
                ResultSetHandler<String> action = new ResultSetHandler<String>(){

                    public String handle(ResultSet rs) throws Exception {
                        if (rs.next()) {
                            return rs.getString(1);
                        }
                        return null;
                    }
                };
                num = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
                if (StringUtils.isNotBlank((CharSequence)num)) {
                    MetaCacheUtils.putDistributeCache(id, AppMetaDaoPlugin.CACHEKEY_FORMNUMBER, 0, num);
                }
                return num;
            }
        });
        return number;
    }

    protected List<String> getSubApps(String id) {
        String sql = String.format("SELECT FID from %s WHERE FPARENTID = ?", this.getTableName("T_Meta_BizApp"));
        Object[] params = new SqlParameter[]{new SqlParameter(":FPARENTID", 12, (Object)id)};
        Boolean ignoreExt = Boolean.valueOf(String.valueOf(ThreadCache.get((Object)"AppMetaDao.querySubApp.ignoreExtApp")));
        if (ignoreExt.booleanValue()) {
            sql = sql + " and FType != '2' ";
        }
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> list = new ArrayList<String>(10);
                while (rs.next()) {
                    list.add(rs.getString("FId"));
                }
                return list;
            }
        };
        List list = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
        if (this.isGrayGroup()) {
            sql = "SELECT FID from T_Meta_BizApp WHERE FPARENTID = ?";
            if (ignoreExt.booleanValue()) {
                sql = sql + " and FType != '2' ";
            }
            List bizappIds = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
            for (String appId : bizappIds) {
                if (list.contains(appId)) continue;
                list.add(appId);
            }
        }
        return list;
    }

    @Override
    public void saveRuntimeMeta(AbstractMetadata[] metadatas) {
        this.saveRuntimeMeta(false, metadatas);
    }

    @Override
    public void fillMetaTerm(AbstractMetadata meta, IDataEntityType designerMetaType, boolean runtime, List<String> ids) {
        if (!runtime) {
            return;
        }
        if (ids.isEmpty()) {
            return;
        }
        if (AppGroupUtils.isGrayGroup() || StringUtils.isNotBlank((CharSequence)this.appGroup) && !"defaultGroup".equals(this.appGroup)) {
            return;
        }
        String id = ids.remove(ids.size() - 1);
        Map<String, Map<String, Object>> localeData = MetadataDao.loadFullMetaTerm(designerMetaType, id, ids.toArray(new String[0]));
        meta.fillTermRes(localeData);
    }

    private boolean isAppWhiteList(String appId, String type) {
        String sql = String.format(SELECT_1_FROM_S_WHERE_FBIZAPPID_AND_F_S_1, "T_DEVP_APPWHITELIST", type);
        Object[] params = new SqlParameter[]{new SqlParameter(":FBIZAPPID", 12, (Object)appId)};
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getInt(1) > 0;
                }
                return false;
            }
        };
        return (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    private boolean hasHelpCenterMenu(AppMetadata appMetadata) {
        for (AppMenuElement menu : appMetadata.getAppMenus()) {
            String menuId = menu.getId();
            if (!menuId.endsWith("#hpce")) continue;
            return true;
        }
        return false;
    }

    private boolean isGrayGroup() {
        return StringUtils.isNotBlank((CharSequence)this.appGroup) && !"defaultGroup".equals(this.appGroup);
    }

    protected String getTableName(String tableName) {
        if (this.isGrayGroup()) {
            return String.format("%s_%s", tableName, this.appGroup);
        }
        return tableName;
    }
}

