/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.devportal;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class RetryTemplate {
    static Log log = LogFactory.getLog(RetryTemplate.class);
    private static final int DEFAULT_RETRY_TIME = 1;
    private int retryTime = 1;
    private int sleepTime = 0;

    public int getSleepTime() {
        return this.sleepTime;
    }

    public RetryTemplate setSleepTime(int sleepTime) {
        if (sleepTime < 0) {
            throw new IllegalArgumentException("sleepTime should equal or bigger than 0");
        }
        this.sleepTime = sleepTime;
        return this;
    }

    public int getRetryTime() {
        return this.retryTime;
    }

    public RetryTemplate setRetryTime(int retryTime) {
        if (retryTime <= 0) {
            throw new IllegalArgumentException("retryTime should bigger than 0");
        }
        this.retryTime = retryTime;
        return this;
    }

    protected abstract Boolean doBiz() throws Exception;

    public Boolean execute() throws InterruptedException {
        for (int i = 0; i < this.retryTime; ++i) {
            try {
                return this.doBiz();
            }
            catch (Exception e) {
                log.error("\u4e1a\u52a1\u6267\u884c\u51fa\u73b0\u5f02\u5e38\uff0ce: {}", (Throwable)e);
                Thread.sleep(this.sleepTime);
                continue;
            }
        }
        return false;
    }
}

