/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ca.CertRule;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.property.org.OrgRelationConfig;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.entity.CtLinkSet;
import kd.bos.metadata.entity.CtLinkSetItem;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.LinkSet;
import kd.bos.metadata.entity.LinkSetItem;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.businessfield.BillNoField;
import kd.bos.metadata.entity.businessfield.BillStatusField;
import kd.bos.metadata.entity.businessfield.BillTypeField;
import kd.bos.metadata.entity.businessfield.FilterField;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.entity.operation.OperationParameter;
import kd.bos.metadata.entity.operation.SaveParameter;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BillEntity
extends MainEntity {
    private List<Plugin> plugins = new ArrayList<Plugin>();
    private String pkFieldName;
    private String billTypePara;
    private String billStatus;
    private String forbidStatusName;
    private LinkSet linkSet = new LinkSet();
    private CtLinkSet ctLinkSet = new CtLinkSet();
    private String entityTypeId;
    private List<CertRule> signField = new ArrayList<CertRule>();
    private List<FilterField> fastFilters = new ArrayList<FilterField>();
    private String billNo;
    private String billType;
    private String mobileForm;
    private String billParameter;
    private String defaultPageSetting;
    private List<OrgRelationConfig> orgRelationConfigList = new ArrayList<OrgRelationConfig>();
    private String billKeyField;

    public String getBillNo() {
        return this.billNo;
    }

    @SimplePropertyAttribute
    public String getBillType() {
        return this.billType;
    }

    @Deprecated
    @SimplePropertyAttribute
    public String getMobileForm() {
        return this.mobileForm;
    }

    public void setMobileForm(String mobileForm) {
        this.mobileForm = mobileForm;
    }

    @SimplePropertyAttribute
    public String getDefaultPageSetting() {
        return this.defaultPageSetting;
    }

    public void setDefaultPageSetting(String defaultPageSetting) {
        this.defaultPageSetting = defaultPageSetting;
    }

    @SimplePropertyAttribute
    public String getBillParameter() {
        return this.billParameter;
    }

    public void setBillParameter(String billParameter) {
        this.billParameter = billParameter;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=FilterField.class)
    public List<FilterField> getFastFilters() {
        return this.fastFilters;
    }

    public void setFastFilters(List<FilterField> fastFilters) {
        this.fastFilters = fastFilters;
    }

    @SimplePropertyAttribute
    public String getForbidStatusName() {
        if (StringUtils.isBlank((CharSequence)this.forbidStatusName)) {
            for (Operation op : this.getOperations()) {
                OperationParameter oparams;
                if (!"disable".equalsIgnoreCase(op.getOperationType()) || !((oparams = op.getParameter()) instanceof SaveParameter)) continue;
                this.forbidStatusName = ((SaveParameter)oparams).getStatusFieldId();
                break;
            }
        }
        return this.forbidStatusName;
    }

    public void setForbidStatusName(String forbidStatusName) {
        this.forbidStatusName = forbidStatusName;
    }

    @SimplePropertyAttribute
    public String getBillStatus() {
        return this.billStatus;
    }

    public void setBillStatus(String billStatus) {
        this.billStatus = billStatus;
    }

    @SimplePropertyAttribute
    public String getPkFieldName() {
        return this.pkFieldName;
    }

    public void setPkFieldName(String pkFieldName) {
        this.pkFieldName = pkFieldName;
    }

    @SimplePropertyAttribute
    public String getBillTypePara() {
        return this.billTypePara;
    }

    public void setBillTypePara(String billTypePara) {
        this.billTypePara = billTypePara;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=CertRule.class)
    public List<CertRule> getSignField() {
        return this.signField;
    }

    public void setSignField(List<CertRule> signField) {
        this.signField = signField;
    }

    @ComplexPropertyAttribute
    public LinkSet getLinkSet() {
        return this.linkSet;
    }

    public void setLinkSet(LinkSet linkSet) {
        this.linkSet = linkSet;
    }

    @ComplexPropertyAttribute
    public CtLinkSet getCtLinkSet() {
        return this.ctLinkSet;
    }

    public void setCtLinkSet(CtLinkSet ctLinkSet) {
        this.ctLinkSet = ctLinkSet;
    }

    @SimplePropertyAttribute
    public String getEntityTypeId() {
        return this.entityTypeId;
    }

    public void setEntityTypeId(String entityTypeId) {
        this.entityTypeId = entityTypeId;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=Plugin.class)
    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    @CollectionPropertyAttribute(name="OrgRelationList", collectionItemPropertyType=OrgRelationConfig.class)
    public List<OrgRelationConfig> getOrgRelationConfigList() {
        return this.orgRelationConfigList;
    }

    public void setOrgRelationConfigList(List<OrgRelationConfig> orgRelationConfigList) {
        this.orgRelationConfigList = orgRelationConfigList;
    }

    @Override
    protected MainEntityType createDataEntityType() {
        return new BillEntityType();
    }

    @Override
    protected void registerProperties(MainEntityType mdt) {
        BillEntityType dt = (BillEntityType)mdt;
        Object pk = this.getPkType() == 0 ? new VarcharProp() : new LongProp();
        pk.setName("id");
        if ("FID".equalsIgnoreCase(this.getPkFieldName())) {
            pk.setAlias("FId");
        } else {
            pk.setAlias(this.getPkFieldName());
        }
        pk.setPrimaryKey(true);
        dt.addProperty((DynamicProperty)pk);
        dt.setBillNo("");
        for (EntityItem<?> item : this.getItems()) {
            if (item instanceof BillNoField) {
                this.billNo = item.getKey();
                dt.setBillNo(item.getKey());
            } else if (item instanceof BillStatusField) {
                BillStatusField statusField = (BillStatusField)item;
                String statusId = statusField.getId();
                if (!StringUtils.isEmpty((CharSequence)statusId)) {
                    if (statusId.equalsIgnoreCase(this.billStatus)) {
                        dt.setBillStatus(item.getKey());
                    } else if (statusId.equalsIgnoreCase(this.getForbidStatusName())) {
                        dt.setForbidStatus(item.getKey());
                    }
                }
            } else if (item instanceof BillTypeField) {
                this.billType = item.getKey();
                dt.setBillType(item.getKey());
                dt.setBillTypePara(this.billTypePara);
            }
            if (!item.getId().equalsIgnoreCase(this.getBillKeyField())) continue;
            dt.setBillKeyField(item.getKey());
        }
        if (this.getTableName() != null) {
            dt.setAlias(this.getTableName());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getEntityTypeId())) {
            TextProp entityType = new TextProp();
            entityType.setName("EntityTypeId");
            entityType.setAlias(this.getEntityTypeId());
            dt.addProperty((DynamicProperty)entityType);
            dt.setEntityTypeId(this.getEntityTypeId());
        }
        if (this.getBillParameter() != null) {
            dt.setBillParameter(this.getBillParameter());
        }
        if (this.getSignField() != null && this.getSignField().size() > 0) {
            dt.setSignField(this.getSignField().get(0).getSignfield());
        }
        dt.setDefaultPageSetting(this.getDefaultPageSetting());
        super.registerProperties((MainEntityType)dt);
        this.registLinkEntrys(dt);
    }

    private void registLinkEntrys(BillEntityType dt) {
        if (this.linkSet == null) {
            return;
        }
        for (LinkSetItem linkSetItem : this.linkSet.getItems()) {
            linkSetItem.registLinkEntryProp(this.entityMetadata, dt);
        }
    }

    private void registCtLinkEntrys(BillEntityType dt) {
        if (this.ctLinkSet == null) {
            return;
        }
        for (CtLinkSetItem linkSetItem : this.ctLinkSet.getItems()) {
            linkSetItem.registCtLinkEntryProp(this.entityMetadata, dt);
        }
    }

    @SimplePropertyAttribute
    public String getBillKeyField() {
        return this.billKeyField;
    }

    public void setBillKeyField(String billKeyField) {
        this.billKeyField = billKeyField;
    }
}

