/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity;

import java.sql.ResultSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.metadata.entity.BaseEntity;

public class CreateBasedataRefrenceTable {
    private static final String CREATE_TABLE_SQL = "create table %s (  FID                  bigint               not null,  FObjectID            %s                   not null,  FRefTableName        varchar(40)          not null,  FRefFieldName        varchar(40)          not null,  FRefCount            bigint               not null default 0,  constraint PK_T_MATERIAL_R primary key (FID) ) ";
    private static final String TABLE_IS_EXISTED_SQL = "SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s' ";
    private static final String CREATE_INDEX_SQL = "create index %s on %s (FObjectID ASC)";
    private BaseEntity baseDataEntity;

    public void create(BaseEntity baseDataEntity) {
        if (baseDataEntity == null) {
            return;
        }
        this.baseDataEntity = baseDataEntity;
        if (this.tableIsExisted()) {
            return;
        }
        try {
            this.createTable();
            this.createIndex();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean tableIsExisted() {
        String sql = String.format(TABLE_IS_EXISTED_SQL, this.buildRefTableName());
        return (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                return rs.next();
            }
        });
    }

    private void createTable() {
        String objIdDataType = "bigint";
        if (this.baseDataEntity.getPkType() == 0) {
            objIdDataType = "varchar(36)";
        }
        String createSQL = String.format(CREATE_TABLE_SQL, this.buildRefTableName(), objIdDataType);
        DB.execute((DBRoute)DBRoute.basedata, (String)createSQL, null);
    }

    private String buildRefTableName() {
        return this.baseDataEntity.getTableName() + "_R";
    }

    private String buildIndexName() {
        return "IDX_" + this.buildRefTableName() + "_OBJID";
    }

    private void createIndex() {
        String sql = String.format(CREATE_INDEX_SQL, this.buildIndexName(), this.buildRefTableName());
        DB.execute((DBRoute)DBRoute.basedata, (String)sql, null);
    }
}

