/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.FieldBuilder;
import kd.bos.metadata.exception.ErrorInfo;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class EntityItem<T extends DynamicProperty>
extends AbstractElement {
    protected FieldBuilder<T> fieldBuilder;
    private boolean isFieldBuilderInit = false;
    protected EntityMetadata entityMetadata;
    private int index;

    private FieldBuilder<T> getFieldBuilder() {
        if (this.fieldBuilder == null && !this.isFieldBuilderInit) {
            this.fieldBuilder = FieldBuilder.create(this.getClass().getSimpleName());
            if (this.fieldBuilder != null) {
                this.fieldBuilder.setEntityItem(this);
            }
            this.isFieldBuilderInit = true;
        }
        return this.fieldBuilder;
    }

    public void setEntityMetadata(EntityMetadata value) {
        this.entityMetadata = value;
    }

    protected void addBuildError(int level, String propertyName, String error) {
        ErrorInfo info = new ErrorInfo();
        info.setItemId(this.getId());
        info.setPropertyName(propertyName);
        info.setType("entity");
        info.setLevel(level);
        info.setError(error);
        if (this.entityMetadata.getBuildErrors().contains(info)) {
            return;
        }
        this.entityMetadata.addError(info);
    }

    public Map<String, Object> createTreeNode() {
        HashMap<String, Object> node = new HashMap<String, Object>();
        node.put("Id", this.getId());
        node.put("Type", this.getClass().getSimpleName());
        node.put("Name", this.getName() == null ? "" : this.getName().getLocaleValue());
        node.put("Key", this.getKey());
        node.put("ParentId", this.getParentId());
        return node;
    }

    public Map<String, Object> createTreeNodeByKey() {
        HashMap<String, Object> node = new HashMap<String, Object>();
        node.put("Id", this.getKey());
        node.put("Type", this.getClass().getSimpleName());
        node.put("Name", this.getName() == null ? "" : this.getName().getLocaleValue());
        return node;
    }

    protected void setDynamicProperty(T prop) {
        prop.setDisplayName(this.getName());
    }

    protected T createDynamicProperty() {
        return null;
    }

    public DynamicProperty registerProperty(DynamicObjectType dt) {
        DynamicProperty property = this.callBuilderFunc(() -> this.fieldBuilder.createDynamicProperty(), this::createDynamicProperty);
        this.setDynamicProperty(property);
        dt.addProperty(property);
        return property;
    }

    protected <R> R callBuilderFunc(Supplier<R> builderFunc, Supplier<R> defaultFunc) {
        R r = null;
        if (this.getFieldBuilder() != null) {
            r = builderFunc.get();
        }
        if (r == null && defaultFunc != null) {
            r = defaultFunc.get();
        }
        return r;
    }

    protected List<Map<String, Object>> createEntityTreeNodes() {
        ArrayList<Map<String, Object>> fieldlist = new ArrayList<Map<String, Object>>();
        fieldlist.add(this.createTreeNode());
        return fieldlist;
    }

    protected List<Map<String, Object>> createEntityTreeNodesByKey() {
        ArrayList<Map<String, Object>> fieldlist = new ArrayList<Map<String, Object>>();
        fieldlist.add(this.createTreeNodeByKey());
        return fieldlist;
    }

    @SimplePropertyAttribute
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

