/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.AppInfo;
import kd.bos.entity.BOSRuntime;
import kd.bos.entity.CtLinkSetElement;
import kd.bos.entity.EntityItemTypes;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ObjectTypeRef;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.RefPropType;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.ca.CertRule;
import kd.bos.entity.ca.SignOperate;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexType;
import kd.bos.entity.operate.OperationType;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.UserProp;
import kd.bos.entity.property.org.OrgRelationConfig;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.DesignMetaL;
import kd.bos.metadata.PermissionMeta;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.PublishAppMeta;
import kd.bos.metadata.RuntimeMetaCollection;
import kd.bos.metadata.dao.AppRebuilder;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.CtLinkSet;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.DesignEntityMetaL;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.IChildElement;
import kd.bos.metadata.entity.LinkSet;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.metadata.entity.ReportQueryEntity;
import kd.bos.metadata.entity.RuntimeEntityMeta;
import kd.bos.metadata.entity.businessfield.AbstractBasedataField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.FlexField;
import kd.bos.metadata.entity.businessfield.GroupField;
import kd.bos.metadata.entity.businessfield.IBasedataField;
import kd.bos.metadata.entity.businessfield.IRefBillField;
import kd.bos.metadata.entity.businessfield.ItemClass;
import kd.bos.metadata.entity.businessfield.ItemClassTypeField;
import kd.bos.metadata.entity.businessfield.MasterIdField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TelephoneField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.entity.operation.NetCtrlOperation;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.extensible.ExtElement;
import kd.bos.metadata.lang.LangWriter;
import kd.bos.metadata.perm.PermissionItem;
import kd.bos.script.annotations.KSMethod;
import kd.bos.service.ServiceFactory;
import kd.bos.service.TimeService;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class EntityMetadata
extends AbstractMetadata {
    private static Log log = LogFactory.getLog(EntityMetadata.class);
    private List<EntityItem<?>> items = new ArrayList();
    private Map<String, EntityItem<?>> mapItems;
    private Map<String, EntityItem<?>> mapKeyItems;
    private List<Operation> operations;
    private MainEntity rootEntity;
    private LocaleString name;
    private String oldKey;
    private boolean _isInitialize;
    private List<Entity<?, ?>> entities;
    MainEntityType dt;
    private String dbRouteKey;
    private boolean enabled = true;
    private transient boolean preparedRebuildFlag;
    private static Set<String> bampMoveAppList = new HashSet<String>(7);
    private List<ExtElement> extElements = new ArrayList<ExtElement>(10);

    @Override
    @KSMethod
    @SimplePropertyAttribute(displayName="sub system id")
    @DefaultValueAttribute(value="0")
    public Integer getSubSysId() {
        return this.subSysId;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=ExtElement.class, displayName="extension element")
    public List<ExtElement> getExtElements() {
        return this.extElements;
    }

    public void setExtElements(List<ExtElement> extElements) {
        this.extElements = extElements;
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        if (!this._isInitialize) {
            this.createIndex();
            if (this.rootEntity != null && !id.equals(this.rootEntity.getId())) {
                this.rootEntity.setId(id);
                this.createIndex(true);
            }
        }
    }

    public String getKey() {
        if (this.rootEntity == null) {
            return null;
        }
        return this.rootEntity.getKey();
    }

    public void setKey(String key) {
        if (!this._isInitialize) {
            this.createIndex();
            if (this.rootEntity != null) {
                this.rootEntity.setKey(key);
            }
        }
    }

    public String getOldKey() {
        return this.oldKey;
    }

    public void setOldKey(String oldKey) {
        this.oldKey = oldKey;
    }

    public List<Operation> getOperation() {
        if (this.operations == null) {
            return new ArrayList<Operation>();
        }
        return this.operations;
    }

    @SimplePropertyAttribute(displayName="name")
    public LocaleString getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.items.size() > 0) {
            return this.items.get(0).getName();
        }
        return null;
    }

    public void setName(LocaleString name) {
        this.name = name;
        if (!this._isInitialize) {
            this.createIndex();
            if (this.rootEntity != null) {
                this.rootEntity.setName(name);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=EntityItem.class, displayName="element")
    public List<EntityItem<?>> getItems() {
        return this.items;
    }

    public MainEntity getRootEntity() {
        this.createIndex();
        return this.rootEntity;
    }

    public List<Entity<?, ?>> getEntitys() {
        if (this.entities != null) {
            return this.entities;
        }
        this.entities = new ArrayList();
        this.createIndex();
        for (EntityItem<?> entityItem : this.items) {
            if (!(entityItem instanceof Entity)) continue;
            this.entities.add((Entity)entityItem);
        }
        return this.entities;
    }

    public void createIndex() {
        this.createIndex(false);
    }

    public void createIndex(boolean forece) {
        if (this.items.size() == 0) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u8868\u5355\u4e0a\u4e0d\u5b58\u5728\u4efb\u4f55\u5143\u7d20", (String)"EntityMetadata_0", (String)"bos-metadata", (Object[])new Object[0]));
        }
        if (this.mapItems == null || this.rootEntity == null || forece) {
            this.mapItems = new HashMap(16);
            this.mapKeyItems = new HashMap(16);
            this.rootEntity = (MainEntity)this.items.get(0);
            for (EntityItem<?> ap : this.items) {
                this.mapItems.put(ap.getId(), ap);
                this.mapKeyItems.put(ap.getKey(), ap);
                ap.setEntityMetadata(this);
                if (!(ap instanceof Entity)) continue;
                ((Entity)ap).getItems().clear();
            }
            for (EntityItem<?> item : this.items) {
                if (!(item instanceof IChildElement)) continue;
                Entity entity = (Entity)this.mapItems.get(((IChildElement)((Object)item)).getParentId());
                if (entity == null) {
                    entity = this.rootEntity;
                }
                entity.getItems().add(item);
            }
        }
    }

    public Map<String, Object> buildDesgnerTree() {
        this.createIndex();
        return this.rootEntity.createTreeNode();
    }

    public List<RuntimeEntityMeta> buildRuntimeMetadata(String runtimeVersion) {
        this.createIndex();
        RuntimeMetaCollection<RuntimeEntityMeta> metas = new RuntimeMetaCollection<RuntimeEntityMeta>();
        this.buildBusinessControl(metas);
        this.buildDataEntityType(metas, runtimeVersion);
        this.buildEntityOperations(metas);
        this.buildEntityNetCtrlOperation(metas);
        this.buildBaseDadaFieldFilter(metas);
        this.buildListSet(metas);
        this.buildCtListSet(metas);
        this.buildSubRuntimeMetadata(metas, runtimeVersion);
        this.buildBillParameter(metas);
        this.buildPermissionControlType(metas);
        this.buildEncryptedField(metas);
        this.preparedRebuildFlag = false;
        return metas;
    }

    public void prepareRebuild() {
        if (this.preparedRebuildFlag) {
            return;
        }
        this.prepareBaseDataNumberCache();
        this.preparedRebuildFlag = true;
    }

    private void prepareBaseDataNumberCache() {
        HashSet<String> entityIds = new HashSet<String>(10);
        for (EntityItem<?> it : this.items) {
            if (it instanceof AbstractBasedataField && StringUtils.isNotBlank((CharSequence)((AbstractBasedataField)it).getBaseEntityId())) {
                entityIds.add(((AbstractBasedataField)it).getBaseEntityId());
                continue;
            }
            if (it instanceof ItemClassTypeField && ((ItemClassTypeField)it).getItemTypes() != null) {
                for (ItemClass itemClass : ((ItemClassTypeField)it).getItemTypes()) {
                    if (!StringUtils.isNotBlank((CharSequence)itemClass.getBaseEntityId())) continue;
                    entityIds.add(itemClass.getBaseEntityId());
                }
                continue;
            }
            if (!(it instanceof MulBasedataField) || !StringUtils.isNotBlank((CharSequence)((MulBasedataField)it).getBaseEntityId())) continue;
            entityIds.add(((MulBasedataField)it).getBaseEntityId());
        }
        if (entityIds.isEmpty()) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getMasterId())) {
            entityIds.add(this.getMasterId());
        } else {
            entityIds.add(this.getId());
        }
        MetadataReader reader = new MetadataReader();
        reader.getEntityNumberByIdList(new ArrayList<String>(entityIds));
    }

    private void buildPrincipalRelation(List<RuntimeEntityMeta> metas) {
        BillEntity billEntity;
        List<OrgRelationConfig> lstRelation;
        if (this.getRootEntity() instanceof BillEntity && (lstRelation = (billEntity = (BillEntity)this.getRootEntity()).getOrgRelationConfigList()) != null && lstRelation.size() > 0) {
            RuntimeEntityMeta meta = this.createRuntimeEntityMeta();
            meta.setKey(this.getKey());
            meta.setType(RuntimeMetaType.PrincipalRelation.getValue());
            meta.setData(SerializationUtils.toJsonString(lstRelation));
            metas.add(meta);
        }
    }

    private void buildEncryptedField(List<RuntimeEntityMeta> metas) {
        HashMap map = new HashMap();
        this.getItems().forEach(e -> {
            if (e instanceof TextField) {
                if (((TextField)e).isEncrypt()) {
                    map.put(e.getKey(), e.getKey());
                }
            } else if (e instanceof TelephoneField && ((TelephoneField)e).isEncrypt()) {
                map.put(e.getKey(), e.getKey());
            }
        });
        RuntimeEntityMeta meta = this.createRuntimeEntityMeta();
        meta.setKey(this.getKey());
        meta.setType(RuntimeMetaType.EncryptedField.getValue());
        meta.setData(SerializationUtils.toJsonString(map));
        metas.add(meta);
    }

    private void buildBillParameter(List<RuntimeEntityMeta> metas) {
        if (this.getRootEntity() instanceof BillEntity) {
            BillEntity billEntity = (BillEntity)this.getRootEntity();
            RuntimeEntityMeta meta = this.createRuntimeEntityMeta();
            meta.setKey(this.getKey());
            meta.setType(RuntimeMetaType.BillParameter.getValue());
            meta.setData(billEntity.getBillParameter());
            metas.add(meta);
        }
    }

    private void buildSubRuntimeMetadata(List<RuntimeEntityMeta> metas, String runtimeVersion) {
        this.rootEntity.buildSubRuntimeMetadata(metas, runtimeVersion);
    }

    private void buildBusinessControl(List<RuntimeEntityMeta> metas) {
        RuntimeEntityMeta meta = this.createRuntimeEntityMeta();
        meta.setKey(this.getKey());
        meta.setType(RuntimeMetaType.BusinessControl.getValue());
        meta.setData(SerializationUtils.toJsonString((Object)this.rootEntity.getBusinessControl()));
        metas.add(meta);
    }

    public RuntimeEntityMeta createRuntimeEntityMeta() {
        RuntimeEntityMeta meta = new RuntimeEntityMeta();
        meta.setId(this.getId());
        meta.setNumber(this.getKey());
        return meta;
    }

    private void buildDataEntityType(List<RuntimeEntityMeta> metas, String runtimeVersion) {
        MainEntityType dt = this.buildDataEntityType();
        dt.setVersion(runtimeVersion);
        dt.setBOSVer(BOSRuntime.getVersion());
        RuntimeEntityMeta meta = this.createRuntimeEntityMeta();
        meta.setKey(this.getKey());
        meta.setType(RuntimeMetaType.Entity.getValue());
        meta.setData(EntityItemTypes.toJsonString((IDataEntityType)dt));
        metas.add(meta);
        if (Boolean.parseBoolean(System.getProperty("entitytable.sync.enable", "true"))) {
            try {
                Class<?> notifier = Class.forName("kd.bos.newdevportal.table.EntityMetaChangeNotifier");
                Method method = notifier.getMethod("saveMetaTableInfo", EntityMetadata.class, MainEntityType.class);
                method.invoke(notifier, this, dt);
            }
            catch (Exception e) {
                log.info("\u6570\u636e\u8868\u4fe1\u606f\u540c\u6b65\u5931\u8d25\uff08\u53ef\u5ffd\u7565\uff09:" + e.getMessage(), (Object)e);
            }
        }
    }

    public String getDBRouteKey() {
        if (this.rootEntity.getTableName() != null && StringUtils.startsWith((CharSequence)this.rootEntity.getTableName().toLowerCase(), (CharSequence)"t_meta")) {
            return "sys.meta";
        }
        if (StringUtils.isBlank((CharSequence)this.dbRouteKey)) {
            this.dbRouteKey = this.rootEntity.getdbRoute();
            if (StringUtils.isBlank((CharSequence)this.dbRouteKey)) {
                this.dbRouteKey = (String)ThreadCache.get((Object)(this.rootEntity.getId() + ".DBRouteKey"));
                if (StringUtils.isBlank((CharSequence)this.dbRouteKey)) {
                    this.dbRouteKey = this.getDbRouteKeyFromDb(this.rootEntity.getId());
                }
            }
        }
        return this.dbRouteKey;
    }

    private String getDbRouteKeyFromDb(String entityId) {
        String sql = String.format("select fdbroute from T_Meta_BizApp a inner join T_Meta_BizUnitRelForm b on a.fid = b.fbizappid where b.fformid = '%s'", entityId);
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                String id = "";
                if (rs.next()) {
                    id = rs.getString(1);
                }
                return id;
            }
        });
    }

    public MainEntityType buildDataEntityType() {
        this.createIndex();
        this.dt = this.rootEntity.buildDataEntityType();
        this.dbRouteKey = this.getDBRouteKey();
        this.dt.setAppId(this.getBizappNumber());
        this.dt.setBizAppNumber(this.getOriginAppNumber());
        this.dt.getRefPropTypes().addAll(this.getRefPropTypes());
        return this.dt;
    }

    public String getBizappNumber() {
        AppInfo appInfo = MetadataDao.getMasterAppInfo(this.getBizappId());
        if (appInfo == null && this.getBuildContext() != null && this.getBuildContext().isGray()) {
            AppRebuilder mr = new AppRebuilder(this.getBuildContext().getRebuildAppGroup());
            appInfo = mr.getMasterAppInfo(this.getBizappId());
        }
        if (appInfo == null) {
            return null;
        }
        if ("basedata".equals(appInfo.getNumber())) {
            return appInfo.getNumber();
        }
        if (BOSRuntime.isBOSCloud((String)appInfo.getCloudId()) || this.isBAMPMoveApp(appInfo.getNumber())) {
            return "bos";
        }
        return appInfo.getNumber();
    }

    private boolean isBAMPMoveApp(String bizappId) {
        return bampMoveAppList.contains(bizappId);
    }

    public String getOriginAppNumber() {
        AppInfo appInfo = MetadataDao.getMasterAppInfo(this.getBizappId());
        if (appInfo == null && this.getBuildContext() != null && this.getBuildContext().isGray()) {
            AppRebuilder mr = new AppRebuilder(this.getBuildContext().getRebuildAppGroup());
            appInfo = mr.getMasterAppInfo(this.getBizappId());
        }
        if (appInfo == null) {
            return null;
        }
        return appInfo.getNumber();
    }

    private void buildEntityOperations(List<RuntimeEntityMeta> metas) {
        HashMap<String, String> ops = new HashMap<String, String>();
        for (Operation op : this.rootEntity.getOperations()) {
            OperationType opTypeDefiner;
            MainEntity entity;
            List<CertRule> certRule;
            PermissionItem item;
            if (!ops.containsKey(op.getOperationType())) {
                ops.put(op.getOperationType(), op.getKey());
            }
            Map<String, Object> oper = op.createEntityOperate(this);
            if (op.getPermissionItemId() != null && (item = this.getRootEntity().getPermissionItem(op.getPermissionItemId())) != null) {
                oper.put("permission", item.getItemId());
            }
            if (this.getRootEntity() instanceof BillEntity && (certRule = ((BillEntity)(entity = this.getRootEntity())).getSignField()).size() > 0) {
                List signOperates = certRule.get(0).getSignoperate();
                for (SignOperate operate : signOperates) {
                    if (!StringUtils.equals((CharSequence)op.getKey(), (CharSequence)operate.getOpCode())) continue;
                    oper.put("sign", true);
                    break;
                }
                List verifyOperates = certRule.get(0).getVerifyoperate();
                for (SignOperate operate : verifyOperates) {
                    if (!StringUtils.equals((CharSequence)op.getKey(), (CharSequence)operate.getOpCode())) continue;
                    oper.put("verifySign", true);
                    break;
                }
            }
            if ((opTypeDefiner = OperationTypeCache.LoadSingle((String)((String)oper.get("type")))) != null && StringUtils.isNotBlank((CharSequence)opTypeDefiner.getWebApiClass())) {
                oper.put("webapi", opTypeDefiner.getWebApiClass());
            }
            RuntimeEntityMeta meta = this.createRuntimeEntityMeta();
            meta.setKey((String)oper.get("key"));
            meta.setType(RuntimeMetaType.Operate.getValue());
            meta.setData(SerializationUtils.toJsonString(oper));
            metas.add(meta);
        }
        Operations operations = new Operations();
        operations.setSave((String)ops.get("save"));
        operations.setSubmit((String)ops.get("submit"));
        operations.setUnSubmit((String)ops.get("unsubmit"));
        operations.setAudit((String)ops.get("audit"));
        operations.setUnAudit((String)ops.get("unaudit"));
        operations.setStatusConvert((String)ops.get("statusconvert"));
        operations.setDelete((String)ops.get("delete"));
        RuntimeEntityMeta meta = this.createRuntimeEntityMeta();
        meta.setKey(this.getKey());
        meta.setType(RuntimeMetaType.Operations.getValue());
        meta.setData(SerializationUtils.toJsonString((Object)operations));
        metas.add(meta);
    }

    private void buildEntityNetCtrlOperation(List<RuntimeEntityMeta> metas) {
        for (NetCtrlOperation op : this.rootEntity.getNetworkControl()) {
            Map<String, Object> oper = op.createEntityOperate(this);
            RuntimeEntityMeta meta = this.createRuntimeEntityMeta();
            meta.setKey((String)oper.get("key"));
            meta.setType(RuntimeMetaType.NetCtrlOperate.getValue());
            meta.setData(SerializationUtils.toJsonString(oper));
            metas.add(meta);
        }
    }

    private void buildPermissionControlType(List<RuntimeEntityMeta> metas) {
        PermissionControlType permissionControlType = new PermissionControlType();
        if (this.rootEntity.getPermissionControl() != null) {
            permissionControlType.setControlFunction(this.rootEntity.getPermissionControl().isControlFunction());
            permissionControlType.setAnonymousUserControl(this.rootEntity.getPermissionControl().isAnonymousUserControl());
            permissionControlType.setForbidDataPerm(this.rootEntity.getPermissionControl().isForbidDataPerm());
        }
        if (this.rootEntity.getPermissionDimension() != null) {
            permissionControlType.setDimension(this.rootEntity.getPermissionDimension().getDimension());
            permissionControlType.setDataDimension(this.rootEntity.getPermissionDimension().getDataDimension());
            permissionControlType.setDataDimensionField(this.rootEntity.getPermissionDimension().getDataDimensionField());
            permissionControlType.setDataAssistDimension(this.rootEntity.getPermissionDimension().getDataAssistDimension());
            permissionControlType.setDataAssistDimensionField(this.rootEntity.getPermissionDimension().getDataAssistDimensionField());
            String publishApps = this.rootEntity.getPermissionDimension().getPublishApps();
            if (StringUtils.isNotBlank((CharSequence)publishApps)) {
                List publishAppArr = (List)SerializationUtils.fromJsonString((String)publishApps, List.class);
                permissionControlType.setPublishApps(publishAppArr);
            }
        }
        RuntimeEntityMeta meta = this.createRuntimeEntityMeta();
        meta.setKey("CtrlType");
        meta.setType(RuntimeMetaType.PermissionControlType.getValue());
        meta.setData(SerializationUtils.toJsonString((Object)permissionControlType));
        metas.add(meta);
    }

    private void buildBaseDadaFieldFilter(List<RuntimeEntityMeta> metas) {
        for (EntityItem<?> item : this.items) {
            if (item instanceof IBasedataField) {
                ((IBasedataField)((Object)item)).buildBaseDadaFieldFilter(metas);
                continue;
            }
            if (!(item instanceof IRefBillField)) continue;
            ((IRefBillField)((Object)item)).buildBaseDadaFieldFilter(metas);
        }
    }

    public List<Map<String, Object>> buildFormOperations() {
        this.createIndex();
        if (this.operations == null) {
            this.operations = new ArrayList<Operation>(10);
        }
        ArrayList<Map<String, Object>> ops = new ArrayList<Map<String, Object>>(10);
        for (Operation op : this.rootEntity.getOperations()) {
            ops.add(op.createFormOperate());
            this.operations.add(op);
        }
        return ops;
    }

    private void buildListSet(List<RuntimeEntityMeta> metas) {
        if (this.rootEntity instanceof BillEntity) {
            LinkSet linkSet = ((BillEntity)this.rootEntity).getLinkSet();
            LinkSetElement linkSetElement = null;
            linkSetElement = linkSet == null ? new LinkSetElement() : ((BillEntity)this.rootEntity).getLinkSet().buildRuntimeListSet(this);
            RuntimeEntityMeta meta = this.createRuntimeEntityMeta();
            meta.setKey(this.getKey());
            meta.setType(RuntimeMetaType.LinkSet.getValue());
            meta.setData(SerializationUtils.toJsonString((Object)linkSetElement));
            metas.add(meta);
        }
    }

    private void buildCtListSet(List<RuntimeEntityMeta> metas) {
        if (this.rootEntity instanceof BillEntity) {
            CtLinkSet ctLinkSet = ((BillEntity)this.rootEntity).getCtLinkSet();
            CtLinkSetElement ctLinkSetElement = null;
            ctLinkSetElement = ctLinkSet == null ? new CtLinkSetElement() : ((BillEntity)this.rootEntity).getCtLinkSet().buildRuntimeListSet(this);
            RuntimeEntityMeta meta = this.createRuntimeEntityMeta();
            meta.setKey(this.getKey());
            meta.setType(RuntimeMetaType.CtLinkSet.getValue());
            meta.setData(SerializationUtils.toJsonString((Object)ctLinkSetElement));
            metas.add(meta);
        }
    }

    public List<PermissionMeta> buildPermissionMetas() {
        this.createIndex();
        return this.rootEntity.buildPermissionMetas();
    }

    public List<PublishAppMeta> buildPublishAppMetas() {
        this.createIndex();
        return this.rootEntity.buildPublishAppMetas();
    }

    public List<ObjectTypeRef> buildObjectTypeRefs() {
        List<ObjectTypeRef> list;
        if (this.dt == null) {
            this.buildDataEntityType();
        }
        if (!(list = this.buildObjectTypeRefs((IDataEntityType)this.dt)).isEmpty()) {
            long[] ids = DB.genGlobalLongIds((int)list.size());
            String sqlLoadIdByTime = this.buildSQLLoadIdByTime();
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).setId(ids[i]);
                list.get(i).setSqlLoadIdByTime(sqlLoadIdByTime);
            }
        }
        return list;
    }

    private List<ObjectTypeRef> buildObjectTypeRefs(IDataEntityType entityType) {
        ArrayList<ObjectTypeRef> list = new ArrayList<ObjectTypeRef>();
        HashMap designFields = new HashMap(16);
        for (EntityItem<?> item : this.getRootEntity().getItems()) {
            designFields.put(item.getKey(), item);
        }
        String tableName = StringUtils.isBlank((CharSequence)entityType.getAlias()) ? "" : entityType.getAlias();
        for (IDataEntityProperty property : entityType.getProperties()) {
            if (property instanceof ICollectionProperty) {
                list.addAll(this.buildObjectTypeRefs(((ICollectionProperty)property).getItemType()));
                continue;
            }
            if (StringUtils.isBlank((CharSequence)property.getAlias())) continue;
            EntityItem designField = (EntityItem)designFields.get(property.getName());
            String tableGroup = "";
            if (StringUtils.isNotBlank((CharSequence)tableName)) {
                tableGroup = String.format("%s%s", tableName, StringUtils.isBlank((CharSequence)property.getTableGroup()) ? "" : "_" + property.getTableGroup());
            }
            if (property instanceof ItemClassProp) {
                ItemClassTypeProp typeProp = (ItemClassTypeProp)this.dt.findProperty(((ItemClassProp)property).getTypePropName());
                if (typeProp == null) continue;
                Map baseEntities = typeProp.getBaseEntities();
                for (String refEntityNumber : typeProp.getBaseEntityIds()) {
                    String refEntityId = baseEntities != null && StringUtils.isNotBlank((CharSequence)((CharSequence)baseEntities.get(refEntityNumber))) ? (String)baseEntities.get(refEntityNumber) : "";
                    ObjectTypeRef ref = this.buildObjectTypeRef(refEntityId, refEntityNumber, tableGroup, property.getAlias());
                    list.add(ref);
                }
                continue;
            }
            if (property instanceof FlexProp) {
                FlexType ft = FlexEntityMetaUtils.getFlexType((int)((FlexProp)property).getFlexTypeId());
                String refEntityId = "";
                if (designField instanceof FlexField) {
                    refEntityId = ((FlexField)designField).getRefBaseFieldId();
                }
                ObjectTypeRef ref = this.buildObjectTypeRef(refEntityId, ft.getFormNumber(), tableGroup, property.getAlias());
                list.add(ref);
                continue;
            }
            if (!(property instanceof BasedataProp) || !StringUtils.isNotBlank((CharSequence)((BasedataProp)property).getBaseEntityId()) || !this.isRecordObjectTypeRef((BasedataProp)property)) continue;
            String refEntityId = "";
            if (designField instanceof BasedataField) {
                refEntityId = ((BasedataField)designField).getBaseEntityId();
            } else if (designField instanceof AbstractBasedataField) {
                refEntityId = ((AbstractBasedataField)designField).getBaseEntityId();
            }
            ObjectTypeRef ref = this.buildObjectTypeRef(refEntityId, ((BasedataProp)property).getBaseEntityId(), tableGroup, property.getAlias());
            if (property instanceof AssistantProp) {
                ref.setAsstTypeId(((AssistantProp)property).getAsstTypeId());
            }
            list.add(ref);
        }
        return list;
    }

    private ObjectTypeRef buildObjectTypeRef(String refEntityId, String refObjectType, String tableName, String fieldName) {
        ObjectTypeRef ref = new ObjectTypeRef();
        ref.setEntityId(this.getId());
        ref.setObjectTypeId(this.dt.getName());
        ref.setRefEntityId(refEntityId);
        ref.setRefObjectTypeId(refObjectType);
        ref.setTableName(tableName);
        ref.setFieldName(fieldName);
        return ref;
    }

    private String buildSQLLoadIdByTime() {
        if (this.dt == null) {
            return null;
        }
        ISimpleProperty pkProp = this.dt.getPrimaryKey();
        if (pkProp == null || StringUtils.isBlank((CharSequence)pkProp.getAlias())) {
            return null;
        }
        IDataEntityProperty modifyTimeProp = null;
        for (IDataEntityProperty prop : this.dt.getProperties()) {
            if (!(prop instanceof ModifyDateProp)) continue;
            modifyTimeProp = prop;
            break;
        }
        if (modifyTimeProp == null || StringUtils.isBlank((CharSequence)modifyTimeProp.getAlias())) {
            return null;
        }
        String tableName = this.dt.getAlias();
        String tableGroup = "";
        if (StringUtils.isNotBlank((CharSequence)tableName)) {
            tableGroup = String.format("%s%s", tableName, StringUtils.isBlank((CharSequence)modifyTimeProp.getTableGroup()) ? "" : "_" + modifyTimeProp.getTableGroup());
        }
        if (StringUtils.isBlank((CharSequence)tableGroup)) {
            return null;
        }
        return "select " + pkProp.getAlias() + " from " + tableGroup + " where " + modifyTimeProp.getAlias() + " > ?";
    }

    private boolean isRecordObjectTypeRef(BasedataProp property) {
        if (property.isIgnoreRefCheck()) {
            return false;
        }
        if (property instanceof UserProp) {
            if (property instanceof CreaterProp || property instanceof ModifierProp) {
                return false;
            }
            if (StringUtils.equals((CharSequence)"auditor", (CharSequence)property.getName()) || StringUtils.equals((CharSequence)"disabler", (CharSequence)property.getName())) {
                return false;
            }
        }
        return true;
    }

    public EntityItem<?> getItemById(String id) {
        this.createIndex();
        return this.mapItems.get(id);
    }

    public Field<?> getFieldById(String fieldId) {
        this.createIndex();
        EntityItem<?> o = this.mapItems.get(fieldId);
        if (o instanceof Field) {
            return (Field)o;
        }
        return null;
    }

    public Field<?> getFieldByKey(String fieldKey) {
        this.createIndex();
        EntityItem<?> o = this.mapKeyItems.get(fieldKey);
        if (o instanceof Field) {
            return (Field)o;
        }
        return null;
    }

    public EntryEntity getEntryById(String entryId) {
        this.createIndex();
        EntityItem<?> o = this.mapItems.get(entryId);
        if (o instanceof EntryEntity) {
            return (EntryEntity)o;
        }
        return null;
    }

    private List<RefPropType> getRefPropTypes() {
        HashMap<String, Set<String>> refObjectProps = new HashMap<String, Set<String>>();
        this.rootEntity.addRefPropTypes(refObjectProps);
        HashMap<String, GroupField> groupRefs = new HashMap<String, GroupField>();
        String masterEntityId = null;
        for (EntityItem<?> item : this.items) {
            MasterIdField masteridFld;
            if (item instanceof GroupField) {
                this.addRefBasedata(refObjectProps, groupRefs, item);
            } else if (item instanceof IBasedataField) {
                ((IBasedataField)((Object)item)).addRefBasedata(refObjectProps);
            } else if (item instanceof IRefBillField) {
                ((IRefBillField)((Object)item)).addRefBill(refObjectProps);
            }
            if (!(item instanceof MasterIdField) || (masteridFld = (MasterIdField)item).getMasterIdType() != 2) continue;
            masterEntityId = masteridFld.getBaseEntityId();
        }
        Map<String, String> entityNumMap = this.getEntityNumberByIds(refObjectProps.keySet());
        ArrayList<RefPropType> types = new ArrayList<RefPropType>(4);
        for (Map.Entry refObj : refObjectProps.entrySet()) {
            RefPropType type = new RefPropType();
            ArrayList props = new ArrayList(((Set)refObj.getValue()).size());
            props.addAll((Collection)refObj.getValue());
            Collections.sort(props);
            String entityNumber = entityNumMap.get(refObj.getKey());
            if (StringUtils.isBlank((CharSequence)entityNumber)) {
                entityNumber = MetadataDao.getEntityNumberById((String)refObj.getKey());
            }
            type.setId(entityNumber);
            type.setProps(StringUtils.join((Object[])props.toArray(new String[0]), (String)","));
            if (StringUtils.equals((CharSequence)((CharSequence)refObj.getKey()), (CharSequence)masterEntityId)) {
                type.setMaster(true);
            }
            types.add(type);
        }
        return types;
    }

    private Map<String, String> getEntityNumberByIds(Set<String> entityIds) {
        if (entityIds == null || entityIds.size() < 2) {
            return new HashMap<String, String>(0);
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select Fid, FNumber from T_META_ENTITYDESIGN where ", new Object[0]).appendIn("Fid", entityIds.toArray());
        ResultSetHandler<Map<String, String>> action = new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws Exception {
                HashMap<String, String> map = new HashMap<String, String>(16);
                while (rs.next()) {
                    String id = rs.getString(1);
                    String number = rs.getString(2);
                    map.put(id, number);
                }
                return map;
            }
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sql, (ResultSetHandler)action);
    }

    private void addRefBasedata(Map<String, Set<String>> refObjectProps, Map<String, GroupField> groupRefs, EntityItem<?> item) {
        BasedataField fld = (BasedataField)item;
        if (StringUtils.isNotBlank((CharSequence)fld.getBaseEntityId())) {
            Set<String> refProps = refObjectProps.get(fld.getBaseEntityId());
            if (refProps == null) {
                refProps = new HashSet<String>();
                refObjectProps.put(fld.getBaseEntityId(), refProps);
                if (item instanceof GroupField && StringUtils.isNotBlank((CharSequence)((GroupField)item).getGroupTableName())) {
                    groupRefs.put(fld.getBaseEntityId(), (GroupField)item);
                }
            }
            refProps.addAll(fld.getRuntimeRefProps());
        }
    }

    @Override
    public void beginInit() {
        this._isInitialize = true;
    }

    @Override
    public void endInit() {
        this.setPluginMetadataId();
        this._isInitialize = false;
    }

    private void setPluginMetadataId() {
        if (this.getItems().isEmpty()) {
            return;
        }
        if (!(this.getItems().get(0) instanceof MainEntity)) {
            return;
        }
        List<Operation> ops = ((MainEntity)this.getItems().get(0)).getOperations();
        for (Operation op : ops) {
            for (Plugin plugin : op.getPlugins()) {
                if (plugin.getMetadataId() != null) continue;
                plugin.setMetadataId(this.getId());
            }
        }
    }

    @Override
    public boolean isInitialized() {
        return this._isInitialize;
    }

    public void resetItemId(Map<String, String> idMap) {
        for (EntityItem<?> ap : this.items) {
            ap.resetItemId(idMap);
        }
        for (Operation op : this.rootEntity.getOperations()) {
            op.resetItemId(idMap);
        }
    }

    @Override
    public IDataEntityType getDesingerMetaType() {
        return OrmUtils.getDataEntityType(DesignEntityMeta.class);
    }

    @Override
    public IDataEntityType getDesingerMetaLType() {
        return OrmUtils.getDataEntityType(DesignEntityMetaL.class);
    }

    @Override
    protected void setDesignMeta(DesignMeta designMeta) {
        super.setDesignMeta(designMeta);
        designMeta.setNumber(this.getKey());
        designMeta.setTemplate(this.rootEntity.isTemplate());
        ((DesignEntityMeta)designMeta).setEnabled(this.enabled);
        TimeService timeService = new TimeService();
        ((DesignEntityMeta)designMeta).setModifyDate(timeService.getCurrentSystemTime());
    }

    @Override
    protected void setDesignMetaL(String localeId, DesignMetaL designMetaL) {
        super.setDesignMetaL(localeId, designMetaL);
        designMetaL.setNumber(this.getKey());
        designMetaL.setName((String)this.getName().getItem(localeId));
    }

    @Override
    public void convertFromDesignMeta(DesignMeta designMeta) {
        super.convertFromDesignMeta(designMeta);
        this.setKey(designMeta.getNumber());
        this.rootEntity.setTemplate(designMeta.isTemplate());
    }

    public boolean hasField() {
        for (EntityItem<?> item : this.items) {
            if (item instanceof Field) {
                return true;
            }
            if (item instanceof EntryEntity) {
                return true;
            }
            if (item instanceof QueryEntity) {
                return true;
            }
            if (!(item instanceof ReportQueryEntity)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void fillTermRes() {
    }

    @Override
    public void fillTermRes(Map<String, Map<String, Object>> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        MetadataSerializer serializer = new MetadataSerializer(this.getModelType());
        ArrayList<Map<String, Map<String, Object>>> list = new ArrayList<Map<String, Map<String, Object>>>(map.size());
        for (Map.Entry<String, Map<String, Object>> item : map.entrySet()) {
            HashMap<String, Map<String, Object>> data = new HashMap<String, Map<String, Object>>(1);
            data.put(item.getKey(), item.getValue());
            list.add(data);
        }
        LangWriter writer = new LangWriter(serializer.getBinder(), this, list);
        IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        List languages = inteService.getRebuildMetaLang();
        ArrayList<String> supportLanguages = new ArrayList<String>(languages.size());
        if (null != languages && !languages.isEmpty()) {
            for (EnabledLang lang : languages) {
                if (!StringUtils.isNotBlank((CharSequence)lang.getNumber())) continue;
                supportLanguages.add(lang.getNumber());
            }
        }
        writer.setLocaleValue(supportLanguages, true);
    }

    static {
        bampMoveAppList.add("base");
        bampMoveAppList.add("cts");
        bampMoveAppList.add("secm");
        bampMoveAppList.add("customize");
        bampMoveAppList.add("open");
        bampMoveAppList.add("sbd");
        bampMoveAppList.add("mpdm");
        bampMoveAppList.add("gmc");
    }
}

