/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.businessfield;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.exception.KDException;
import kd.bos.metadata.MetaBuildContext;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityMetadata;

public class BasedataEntitymetaReader {
    private static final CacheConfigInfo info = new CacheConfigInfo();
    private static final String BASEDATA_ENTITYMETA_CHCHE = "BasedataEntitymetaCache";

    private BasedataEntitymetaReader() {
    }

    protected static EntityMetadata readEntityMetaByFormId(String baseEntityId, MetaBuildContext ctx) {
        Boolean rebuildAll = Boolean.valueOf(String.valueOf(ThreadCache.get((Object)"rebuild.speed.model")));
        if (rebuildAll.booleanValue()) {
            EntityMetadata refBaseEntityMeta = BasedataEntitymetaReader.getEntityMetadata(baseEntityId, BasedataEntityType.FormId);
            if (refBaseEntityMeta == null) {
                MetadataReader reader = new MetadataReader();
                if (ctx != null) {
                    reader.setAppGroup(ctx.getRebuildAppGroup());
                }
                if ((refBaseEntityMeta = (EntityMetadata)reader.readEntityMetaByFormId(baseEntityId)) != null) {
                    BasedataEntitymetaReader.putEntitymetadata(baseEntityId, refBaseEntityMeta, BasedataEntityType.FormId);
                }
            }
            return refBaseEntityMeta;
        }
        MetadataReader reader = new MetadataReader();
        if (ctx != null) {
            reader.setAppGroup(ctx.getRebuildAppGroup());
        }
        return (EntityMetadata)reader.readEntityMetaByFormId(baseEntityId);
    }

    protected static EntityMetadata readEntityMeta(String baseEntityId) {
        Boolean rebuildAll = Boolean.valueOf(String.valueOf(ThreadCache.get((Object)"rebuild.speed.model")));
        if (rebuildAll.booleanValue()) {
            EntityMetadata entityMetadata = BasedataEntitymetaReader.getEntityMetadata(baseEntityId, BasedataEntityType.EntityId);
            if (entityMetadata == null && (entityMetadata = (EntityMetadata)MetadataDao.readMeta(baseEntityId, MetaCategory.Entity)) != null) {
                BasedataEntitymetaReader.putEntitymetadata(baseEntityId, entityMetadata, BasedataEntityType.EntityId);
            }
            return entityMetadata;
        }
        return (EntityMetadata)MetadataDao.readMeta(baseEntityId, MetaCategory.Entity);
    }

    protected static EntityMetadata readRuntimeEntityMeta(String baseEntityId) {
        Boolean rebuildAll = Boolean.valueOf(String.valueOf(ThreadCache.get((Object)"rebuild.speed.model")));
        if (rebuildAll.booleanValue()) {
            EntityMetadata entityMetadata = BasedataEntitymetaReader.getEntityMetadata(baseEntityId, BasedataEntityType.EntityRuntime);
            if (entityMetadata == null && (entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta(baseEntityId, MetaCategory.Entity)) != null) {
                BasedataEntitymetaReader.putEntitymetadata(baseEntityId, entityMetadata, BasedataEntityType.EntityRuntime);
            }
            return entityMetadata;
        }
        return (EntityMetadata)MetadataDao.readRuntimeMeta(baseEntityId, MetaCategory.Entity);
    }

    private static LocalMemoryCache getLocalCache() {
        String region = CacheKeyUtil.getAcctId();
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(region, BASEDATA_ENTITYMETA_CHCHE, info);
    }

    private static void putEntitymetadata(String baseEntityId, EntityMetadata entityMetadata, BasedataEntityType type) {
        BasedataEntitymetaReader.getLocalCache().put(BasedataEntitymetaReader.makeCacheKey(baseEntityId, type), (Object)entityMetadata);
    }

    private static EntityMetadata getEntityMetadata(String baseEntityId, BasedataEntityType type) {
        return (EntityMetadata)BasedataEntitymetaReader.getLocalCache().get(BasedataEntitymetaReader.makeCacheKey(baseEntityId, type));
    }

    public static void removeLocalCache() {
        BasedataEntitymetaReader.getLocalCache().clear();
    }

    private static String makeCacheKey(String entityId, BasedataEntityType type) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        if (StringUtils.isNotBlank((CharSequence)appGroup) && !"defaultGroup".equals(appGroup)) {
            return (appGroup + "." + entityId + "." + type.getValue()).toLowerCase();
        }
        return (entityId + "." + (Object)((Object)type)).toLowerCase();
    }

    static {
        info.setTimeout(3600);
        info.setMaxItemSize(10000);
    }

    static enum BasedataEntityType {
        FormId(0),
        EntityId(1),
        EntityRuntime(2);

        private short nCode;

        private BasedataEntityType(int _nCode) {
            this.nCode = (short)_nCode;
        }

        public short getValue() {
            return this.nCode;
        }

        public static BasedataEntityType valueOf(short value) {
            for (BasedataEntityType item : BasedataEntityType.values()) {
                if (item.getValue() != value) continue;
                return item;
            }
            throw new KDException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u628a\u6570\u503c%d\u8f6c\u6362\u4e3aBasedataEntityType\u679a\u4e3e\u7c7b\u578b", (String)"BasedataEntitymetaReader_0", (String)"bos-metadata", (Object[])new Object[0]), value));
        }

        public static BasedataEntityType valueOf(int value) {
            return BasedataEntityType.valueOf((short)value);
        }
    }
}

