/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.businessfield;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.BizBasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.AbstractBasedataField;
import kd.bos.metadata.entity.businessfield.BasedataEntitymetaReader;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BasedataField
extends AbstractBasedataField<BasedataProp> {
    private boolean lableHyperlink;
    private boolean allowAutoList = true;
    private boolean cacheLookUpList = true;
    private boolean bizBasedata = false;
    private boolean viewDetail = true;
    private String baseEntityNumber;
    private boolean ignoreRefCheck = false;
    private String dbDefValue;

    @Override
    public String getFilterControlType() {
        return "basedata";
    }

    @Override
    public String getRptColFieldType() {
        return "basedata";
    }

    @Override
    public String getCompareGroupID() {
        return "0,1,2";
    }

    @SimplePropertyAttribute(name="LableHyperlink")
    @DefaultValueAttribute(value="true")
    public boolean isLableHyperlink() {
        return this.lableHyperlink;
    }

    public void setLableHyperlink(boolean lableHyperlink) {
        this.lableHyperlink = lableHyperlink;
    }

    @SimplePropertyAttribute(name="AllowAutoList")
    @DefaultValueAttribute(value="true")
    public boolean isAllowAutoList() {
        return this.allowAutoList;
    }

    public void setAllowAutoList(boolean allowAutoList) {
        this.allowAutoList = allowAutoList;
    }

    @SimplePropertyAttribute(name="CacheLookUpList")
    @DefaultValueAttribute(value="true")
    public boolean isCacheLookUpList() {
        return this.cacheLookUpList;
    }

    public void setCacheLookUpList(boolean cacheLookUpList) {
        this.cacheLookUpList = cacheLookUpList;
    }

    @SimplePropertyAttribute(name="BizBasedata")
    public boolean isBizBasedata() {
        return this.bizBasedata;
    }

    public void setBizBasedata(boolean bizBasedata) {
        this.bizBasedata = bizBasedata;
    }

    @SimplePropertyAttribute(name="ViewDetail")
    @DefaultValueAttribute(value="true")
    public boolean isViewDetail() {
        return this.viewDetail;
    }

    public void setViewDetail(boolean viewDetail) {
        this.viewDetail = viewDetail;
    }

    public void setBaseEntityNumber(String baseEntityNumber) {
        this.baseEntityNumber = baseEntityNumber;
    }

    @SimplePropertyAttribute(name="IgnoreRefCheck")
    public boolean isIgnoreRefCheck() {
        return this.ignoreRefCheck;
    }

    public void setIgnoreRefCheck(boolean ignoreRefCheck) {
        this.ignoreRefCheck = ignoreRefCheck;
    }

    @Override
    public int getFieldDBType() {
        EntityMetadata entityMetadata = BasedataEntitymetaReader.readEntityMeta(this.getBaseEntityId());
        int pkType = -9;
        if (entityMetadata != null) {
            for (Entity<?, ?> entity : entityMetadata.getEntitys()) {
                if (!(entity instanceof BillEntity)) continue;
                pkType = ((BillEntity)entity).getPkType() == 0 ? 12 : -5;
                break;
            }
        }
        this.dbDefValue = pkType == -5 ? "0" : " ";
        return pkType;
    }

    @Override
    public int getFieldLen() {
        return 36;
    }

    @Override
    protected FieldEdit createServerEditor() {
        if (this.isBizBasedata()) {
            return new BizBasedataEdit();
        }
        return new BasedataEdit();
    }

    @Override
    protected void setServerEditorProperties(FieldEdit editor) {
        super.setServerEditorProperties(editor);
        this.setServerBasedataEditor((BasedataEdit)editor);
    }

    @Override
    protected BasedataProp createDynamicProperty() {
        return new BasedataProp();
    }

    @Override
    protected void setDynamicProperty(BasedataProp prop) {
        super.setDynamicProperty(prop);
        prop.setMustInput(this.isMustInput());
        prop.setIgnoreRefCheck(this.isIgnoreRefCheck());
        this.setBasedataProp(prop);
    }

    @Override
    public Map<String, Object> createEditor() {
        Map<String, Object> ctlRet = super.createEditor();
        this.setClientBasedataEditor(ctlRet);
        if (this.entityMetadata != null) {
            String baseEntityNumber = MetadataDao.getEntityNumberById(this.getBaseEntityId());
            if (StringUtils.isNotBlank((CharSequence)baseEntityNumber)) {
                ctlRet.put("ei", baseEntityNumber);
            }
        } else if (StringUtils.isNotBlank((CharSequence)this.baseEntityNumber)) {
            ctlRet.put("ei", this.baseEntityNumber);
        }
        if (this.lableHyperlink) {
            ctlRet.put("ln", this.lableHyperlink);
        }
        if (!this.allowAutoList) {
            ctlRet.put("al", this.allowAutoList);
        }
        if (!this.cacheLookUpList) {
            ctlRet.put("cl", this.cacheLookUpList);
        }
        if (!this.viewDetail) {
            ctlRet.put("vtb", this.viewDetail);
        }
        return ctlRet;
    }

    @Override
    public List<Map<String, Object>> createEntityTreeNodes(boolean isAllNode, int level) {
        return this.createRefBasedataTreeNodes(isAllNode, level);
    }

    @Override
    public String getDBDefValue() {
        if (this.dbDefValue == null) {
            return super.getDBDefValue();
        }
        return this.dbDefValue;
    }
}

