/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.businessfield;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.ExchangeRateProp;
import kd.bos.form.field.ExchangeRateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ExchangeRateField
extends DecimalField {
    private String originalCurrencyFieldId;
    private String targetCurrencyFieldId;
    private String exRateTypeFieldId;
    private String exRateDateFieldId;
    private String exRateQuotationId;

    @SimplePropertyAttribute
    public String getOriginalCurrencyFieldId() {
        return this.originalCurrencyFieldId;
    }

    public void setOriginalCurrencyFieldId(String originalCurrencyFieldId) {
        this.originalCurrencyFieldId = originalCurrencyFieldId;
    }

    @SimplePropertyAttribute
    public String getTargetCurrencyFieldId() {
        return this.targetCurrencyFieldId;
    }

    public void setTargetCurrencyFieldId(String targetCurrencyFieldId) {
        this.targetCurrencyFieldId = targetCurrencyFieldId;
    }

    @SimplePropertyAttribute
    public String getExRateTypeFieldId() {
        return this.exRateTypeFieldId;
    }

    public void setExRateTypeFieldId(String exRateTypeFieldId) {
        this.exRateTypeFieldId = exRateTypeFieldId;
    }

    @SimplePropertyAttribute
    public String getExRateDateFieldId() {
        return this.exRateDateFieldId;
    }

    public void setExRateDateFieldId(String exRateDateFieldId) {
        this.exRateDateFieldId = exRateDateFieldId;
    }

    @SimplePropertyAttribute
    public String getExRateQuotationId() {
        return this.exRateQuotationId;
    }

    public void setExRateQuotationId(String exRateQuotationId) {
        this.exRateQuotationId = exRateQuotationId;
    }

    @Override
    protected DecimalProp createDynamicProperty() {
        return new ExchangeRateProp();
    }

    @Override
    protected void setDynamicProperty(DecimalProp prop) {
        super.setDynamicProperty(prop);
        ExchangeRateProp prop1 = (ExchangeRateProp)prop;
        String oriId = this.getOriginalCurrencyFieldId();
        String tarId = this.getTargetCurrencyFieldId();
        if (StringUtils.isNotEmpty((String)oriId) && StringUtils.isNotEmpty((String)tarId) && this.entityMetadata != null) {
            Field<?> oriField = this.entityMetadata.getFieldById(oriId);
            Field<?> tarField = this.entityMetadata.getFieldById(tarId);
            if (oriField != null && tarField != null) {
                prop1.setOriginalCurrencyFieldKey(oriField.getKey());
                prop1.setTargetCurrencyFieldKey(tarField.getKey());
            }
        }
    }

    @Override
    protected FieldEdit createServerEditor() {
        return new ExchangeRateEdit();
    }

    @Override
    protected void setServerEditorProperties(FieldEdit editor) {
        super.setServerEditorProperties(editor);
        if (this.getFieldById(this.getOriginalCurrencyFieldId()) != null && this.getFieldById(this.getTargetCurrencyFieldId()) != null && this.getFieldById(this.getExRateTypeFieldId()) != null && this.getFieldById(this.getExRateDateFieldId()) != null && this.getFieldById(this.getExRateQuotationId()) != null) {
            ((ExchangeRateEdit)editor).setOriginalCurrencyFieldKey(this.getFieldKeyById(this.getOriginalCurrencyFieldId()));
            ((ExchangeRateEdit)editor).setTargetCurrencyFieldKey(this.getFieldKeyById(this.getTargetCurrencyFieldId()));
            ((ExchangeRateEdit)editor).setExRateTypeFieldKey(this.getFieldKeyById(this.getExRateTypeFieldId()));
            ((ExchangeRateEdit)editor).setExRateDateFieldKey(this.getFieldKeyById(this.getExRateDateFieldId()));
            ((ExchangeRateEdit)editor).setExRateQuotationKey(this.getFieldKeyById(this.getExRateQuotationId()));
        }
    }

    private String getFieldKeyById(String id) {
        return this.entityMetadata.getFieldById(id).getKey();
    }

    private Field getFieldById(String id) {
        return this.entityMetadata.getFieldById(id);
    }

    @Override
    public Map<String, Object> createEditor() {
        Map<String, Object> editor = super.createEditor();
        ArrayList<String> keyList = new ArrayList<String>();
        String oriId = this.getOriginalCurrencyFieldId();
        String tarId = this.getTargetCurrencyFieldId();
        if (StringUtils.isNotEmpty((String)oriId) && StringUtils.isNotEmpty((String)tarId) && this.entityMetadata != null) {
            Field<?> oriField = this.entityMetadata.getFieldById(oriId);
            Field<?> tarField = this.entityMetadata.getFieldById(tarId);
            if (oriField != null && tarField != null) {
                keyList.add(oriField.getKey());
                keyList.add(tarField.getKey());
                editor.put("scaleDependencies", keyList);
            }
        }
        return editor;
    }
}

