/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.businessfield;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexType;
import kd.bos.entity.property.FlexProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.FlexEdit;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.FlatFieldAp;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FlexField
extends Field<FlexProp> {
    private int flexType;
    private String refBaseFieldId;
    private String displayProperty = "name";
    private LocaleString emptyText;
    private boolean is_ShowFrequent;

    @SimplePropertyAttribute(name="ShowFrequent")
    public boolean isShowFrequent() {
        return this.is_ShowFrequent;
    }

    public void setShowFrequent(boolean isShowFrequent) {
        this.is_ShowFrequent = isShowFrequent;
    }

    @SimplePropertyAttribute
    public LocaleString getEmptyText() {
        return this.emptyText;
    }

    public void setEmptyText(LocaleString value) {
        this.emptyText = value;
    }

    public FlexField() {
        this.defValueType = 0;
        this.mustInputType = 0;
    }

    @Override
    public int getFieldDBType() {
        return -5;
    }

    @SimplePropertyAttribute
    public int getFlexType() {
        return this.flexType;
    }

    public void setFlexType(int flexType) {
        FlexType flexTypeObject;
        String flexDefDispProperty;
        this.flexType = flexType;
        if (flexType != 0 && StringUtils.isNotBlank((CharSequence)(flexDefDispProperty = (flexTypeObject = FlexEntityMetaUtils.getFlexType((int)flexType)).getDisplayProperty()))) {
            if (flexDefDispProperty.equals("1")) {
                this.displayProperty = "number";
            } else if (flexDefDispProperty.equals("2")) {
                this.displayProperty = "name";
            } else if (flexDefDispProperty.equals("3")) {
                this.displayProperty = "number,name";
            }
        }
    }

    @SimplePropertyAttribute
    public String getRefBaseFieldId() {
        return this.refBaseFieldId;
    }

    public void setRefBaseFieldId(String refBaseFieldId) {
        this.refBaseFieldId = refBaseFieldId;
    }

    @Override
    protected FieldEdit createServerEditor() {
        FlexEdit flexEdit = new FlexEdit();
        flexEdit.setFlexTypeId(this.flexType);
        flexEdit.setBasedataShowFrequent(this.is_ShowFrequent);
        return flexEdit;
    }

    @Override
    public FlexProp createDynamicProperty() {
        FlexProp prop = new FlexProp();
        if (this.refBaseFieldId != null && this.entityMetadata.getFieldById(this.refBaseFieldId) != null) {
            prop.setBasePropertyKey(this.entityMetadata.getFieldById(this.refBaseFieldId).getKey());
        }
        prop.setDisplayProp(this.displayProperty);
        return prop;
    }

    @Override
    public Map<String, Object> createEditor() {
        ControlAp controlAp;
        Optional<ControlAp> optional;
        Map<String, Object> editor = super.createEditor();
        editor.put("type", "flexfield");
        if (this.refBaseFieldId != null && this.entityMetadata.getFieldById(this.refBaseFieldId) != null) {
            editor.put("majorKey", this.getMajorKey());
        }
        if (this.formMetadata != null && (optional = this.formMetadata.getItems().stream().filter(x -> x.getKey().equals(this.getKey())).findFirst()).isPresent() && (controlAp = optional.get()).getCustomProperties().containsKey("FlexBatchInput")) {
            editor.put("batchInput", controlAp.getCustomProperties().get("FlexBatchInput"));
        }
        if (StringUtils.isNotBlank((Object)this.getEmptyText())) {
            editor.put("emptytip", this.getEmptyText());
        }
        return editor;
    }

    @Override
    protected void setDynamicProperty(FlexProp prop) {
        super.setDynamicProperty(prop);
        String name = (String)prop.getDisplayName().getDefaultItem();
        if (this.getFlexType() != 0) {
            prop.setFlexTypeId(this.getFlexType());
            if (StringUtils.isEmpty((CharSequence)this.getRefBaseFieldId())) {
                this.addBuildError(2, "RefBaseFieldId", String.format(ResManager.loadKDString((String)"%s\uff1a\u5173\u8054\u7684\u57fa\u7840\u8d44\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FlexField_2", (String)"bos-metadata", (Object[])new Object[0]), name));
            }
        } else {
            this.addBuildError(2, "FlexType", String.format(ResManager.loadKDString((String)"%s\uff1a\u201c\u5f39\u6027\u57df\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FlexField_3", (String)"bos-metadata", (Object[])new Object[0]), name));
        }
        prop.setDbIgnore(true);
        prop.setMustInput(this.isMustInput());
    }

    @Override
    public void resetItemId(Map<String, String> idMap) {
        super.resetItemId(idMap);
        String newid = idMap.get(this.getRefBaseFieldId());
        if (newid != null) {
            this.setRefBaseFieldId(newid);
        }
    }

    @Override
    public Map<String, Object> createEntityTreeNode() {
        Map<String, Object> col = super.createEntityTreeNode();
        col.put("Type", "FlexListColumnAp");
        col.put("SchemeFilterApType", "FlexSchemeFilterColumnAp");
        return col;
    }

    @Override
    public String getFilterControlType() {
        return "basedata";
    }

    @Override
    public Field<?> getControlField() {
        return this.entityMetadata.getFieldById(this.refBaseFieldId);
    }

    private String getMajorKey() {
        if (this.formMetadata != null) {
            List<ControlAp<?>> items = this.formMetadata.getItems();
            for (ControlAp<?> controlAp : items) {
                if (!(controlAp instanceof FieldAp) || !StringUtils.isNotBlank((CharSequence)((FieldAp)controlAp).getFieldId()) || !this.refBaseFieldId.equals(((FieldAp)controlAp).getFieldId()) || controlAp instanceof FlatFieldAp) continue;
                return controlAp.getKey();
            }
        }
        return this.entityMetadata.getFieldById(this.refBaseFieldId).getKey();
    }
}

