/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.commonfield;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.cache.PromptWordCacheNew;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.lang.Lang;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IDBField;
import kd.bos.service.InteTimeZone;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DateRangeField
extends Field<DateTimeProp> {
    private static final String BOS_METADATA = "bos-metadata";
    private String startDateFieldKey;
    private String startDateFieldName;
    private String endDateFieldKey;
    private String endDateFieldName;
    private LocaleString emptyText;
    private String defValue;
    private int regionType = 1;

    public DateRangeField() {
        this.defValueType = 0;
    }

    @Override
    public void addBinderMap(Map<String, List<String>> binderMap, String fieldApKey) {
        super.addBinderMap(binderMap, fieldApKey);
        this.addBinderMap(binderMap, this.getStartDateFieldKey(), fieldApKey);
        this.addBinderMap(binderMap, this.getEndDateFieldKey(), fieldApKey);
    }

    @Override
    public List<IDBField> getDBFields() {
        ArrayList<IDBField> list = new ArrayList<IDBField>();
        DateTimeField startTimeField = new DateTimeField();
        startTimeField.setFieldName(this.getStartDateFieldName());
        list.add(startTimeField);
        DateTimeField endTimeField = new DateTimeField();
        endTimeField.setFieldName(this.getEndDateFieldName());
        list.add(endTimeField);
        return list;
    }

    @SimplePropertyAttribute
    public int getRegionType() {
        return this.regionType;
    }

    public void setRegionType(int regionType) {
        this.regionType = regionType;
    }

    @SimplePropertyAttribute
    public String getStartDateFieldKey() {
        return StringUtils.isBlank((CharSequence)this.startDateFieldKey) ? this.getKey() + "_startdate" : this.startDateFieldKey.trim();
    }

    @SimplePropertyAttribute
    public String getStartDateFieldName() {
        return this.startDateFieldName;
    }

    @SimplePropertyAttribute
    public String getEndDateFieldKey() {
        return StringUtils.isBlank((CharSequence)this.endDateFieldKey) ? this.getKey() + "_enddate" : this.endDateFieldKey.trim();
    }

    @SimplePropertyAttribute
    public String getEndDateFieldName() {
        return this.endDateFieldName;
    }

    public void setStartDateFieldKey(String startDateFieldKey) {
        this.startDateFieldKey = startDateFieldKey;
    }

    public void setStartDateFieldName(String startDateFieldName) {
        this.startDateFieldName = startDateFieldName;
    }

    public void setEndDateFieldKey(String endDateFieldKey) {
        this.endDateFieldKey = endDateFieldKey;
    }

    public void setEndDateFieldName(String endDateFieldName) {
        this.endDateFieldName = endDateFieldName;
    }

    @SimplePropertyAttribute
    public LocaleString getEmptyText() {
        return this.emptyText;
    }

    public void setEmptyText(LocaleString emptyText) {
        this.emptyText = emptyText;
    }

    @SimplePropertyAttribute
    public String getDefValue() {
        return this.defValue;
    }

    public void setDefValue(String defValue) {
        this.defValue = defValue;
    }

    @Override
    protected FieldEdit createServerEditor() {
        return new DateRangeEdit();
    }

    @Override
    public Map<String, Object> createEditor() {
        Map<String, Object> editor = super.createEditor();
        editor.put("type", "daterange");
        editor.put("regiontype", this.regionType);
        if (StringUtils.isNotBlank((Object)this.getEmptyText())) {
            editor.put("emptytip", this.getEmptyText());
        }
        return editor;
    }

    @Override
    protected DateTimeProp createDynamicProperty() {
        if (this.regionType == 1) {
            return new DateProp();
        }
        return new DateTimeProp();
    }

    @Override
    protected void setDynamicProperty(DateTimeProp prop) {
        super.setDynamicProperty(prop);
        prop.setName(this.getStartDateFieldKey());
        prop.setAlias(this.startDateFieldName);
        prop.setDisplayName(DateRangeField.joinLocaleString(this.getName(), this.getDisplaySuffName(ResManager.loadKDString((String)".\u5f00\u59cb", (String)"DateRangeField_0", (String)BOS_METADATA, (Object[])new Object[0]), "DateRangeField_0", BOS_METADATA)));
        prop.setDbIgnore(StringUtils.isBlank((CharSequence)this.startDateFieldName));
        prop.setRegionType(this.regionType);
    }

    private LocaleString getDisplaySuffName(String desc, String resId, String projectName) {
        IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        List langs = inteService.getEnabledLang();
        LocaleString localeString = new LocaleString(ResManager.loadKDString((String)desc, (String)resId, (String)projectName, (Object[])new Object[0]));
        for (EnabledLang enabledLang : langs) {
            Lang lang = Lang.from((String)enabledLang.getNumber());
            localeString.setItem(lang.toString(), (Object)PromptWordCacheNew.getPromptWord((String)desc, (String)resId, (Lang)lang, (String)projectName, (Object[])new Object[0]));
        }
        return localeString;
    }

    @Override
    protected void setServerEditorProperties(FieldEdit editor) {
        DateRangeEdit dateRangeEdit = (DateRangeEdit)editor;
        dateRangeEdit.setStartDateFieldKey(this.getStartDateFieldKey());
        dateRangeEdit.setEndDateFieldKey(this.getEndDateFieldKey());
        super.setServerEditorProperties(editor);
    }

    @Override
    public DynamicProperty registerProperty(DynamicObjectType dt) {
        DateTimeProp beginDateProp = (DateTimeProp)super.registerProperty(dt);
        if (beginDateProp == null) {
            throw new NullPointerException("registerproperty error,beginDateProp is null");
        }
        beginDateProp.setRelateDateTimeRange(this.getEndDateFieldKey());
        beginDateProp.setStartDateTimeRange(true);
        this.setDynamicProperty(beginDateProp);
        Object endDateProp = this.regionType == 1 ? new DateProp() : new DateTimeProp();
        endDateProp.setRelateDateTimeRange(this.getStartDateFieldKey());
        endDateProp.setName(this.getEndDateFieldKey());
        endDateProp.setAlias(this.endDateFieldName);
        endDateProp.setTableGroup(beginDateProp.getTableGroup());
        endDateProp.setDisplayName(DateRangeField.joinLocaleString(this.getName(), this.getDisplaySuffName(ResManager.loadKDString((String)".\u7ed3\u675f", (String)"DateRangeField_1", (String)BOS_METADATA, (Object[])new Object[0]), "DateRangeField_1", BOS_METADATA)));
        endDateProp.setDbIgnore(StringUtils.isBlank((CharSequence)this.endDateFieldName));
        endDateProp.setFeatures(this.getFeatures().getValue());
        dt.registerSimpleProperty((DynamicSimpleProperty)endDateProp);
        if (this.isMustInput()) {
            endDateProp.setMustInput(this.isMustInput());
        }
        if (StringUtils.isNotBlank((CharSequence)this.defValue)) {
            String[] defSplit = this.defValue.split(",");
            beginDateProp.setDefValue((Object)this.getCorrctFmtDefValue(defSplit[0].trim()));
            if (defSplit.length > 1) {
                endDateProp.setDefValue((Object)this.getCorrctFmtDefValue(defSplit[1].trim()));
            }
        }
        return beginDateProp;
    }

    private String getCorrctFmtDefValue(String defValue) {
        if (StringUtils.isBlank((CharSequence)defValue)) {
            return defValue;
        }
        if (this.regionType == 2) {
            try {
                InteTimeZone.getSysTimeZone().parse(defValue, (DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
                return defValue;
            }
            catch (ParseException e) {
                try {
                    Date date = InteTimeZone.getSysTimeZone().parse(defValue, (DateFormat)new SimpleDateFormat("yyyy-MM-dd"));
                    return InteTimeZone.getSysTimeZone().format(date, (DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
                }
                catch (ParseException e1) {
                    return defValue;
                }
            }
        }
        return defValue;
    }

    private static LocaleString joinLocaleString(LocaleString str1, LocaleString str2) {
        LocaleString str = new LocaleString();
        for (Map.Entry entry : str1.entrySet()) {
            String localeId = (String)entry.getKey();
            String val1 = (String)entry.getValue();
            String val2 = (String)str2.get((Object)localeId);
            val2 = StringUtils.isBlank((CharSequence)val2) ? str2.toString() : val2;
            String val = val1 + val2;
            str.put(localeId, (Object)val);
        }
        return str;
    }

    private Map<String, Object> createEntityTreeNodeByName(String key, String fieldName, LocaleString name) {
        HashMap<String, Object> entityNode = new HashMap<String, Object>(16);
        entityNode.put("Id", key);
        entityNode.put("Type", "DateListColumnAp");
        entityNode.put("DataType", "datetime");
        entityNode.put("Name", name.toString());
        entityNode.put("CreateType", 1);
        entityNode.put("compareGroupId", "5,0,1,2,4");
        entityNode.put("IsMulti", false);
        entityNode.put("Custom", true);
        entityNode.put("SeqType", "NotSeq");
        EntityItem<?> entityItem = this.entityMetadata.getItemById(this.getParentId());
        entityNode.put("EntryEntity", entityItem instanceof EntryEntity);
        entityNode.put("IsBaseData", false);
        entityNode.put("ClientType", "text");
        entityNode.put("FilterApType", "FilterColumnAp");
        entityNode.put("CommonFilterApType", "CommonDateFilterColumnAp");
        entityNode.put("SchemeFilterApType", "SchemeFilterColumnAp");
        entityNode.put("MobCommonFilterApType", "MobCommonDateFilterColumnAp");
        entityNode.put("IsFieldPropAliasEmpty", StringUtils.isBlank((CharSequence)fieldName));
        return entityNode;
    }

    @Override
    public List<Map<String, Object>> createEntityTreeNodes(boolean isAllNode, int level, boolean isIncludeEntry) {
        ArrayList<Map<String, Object>> entityNodes = new ArrayList<Map<String, Object>>();
        entityNodes.add(this.createEntityTreeNodeByName(this.getStartDateFieldKey(), this.getStartDateFieldName(), DateRangeField.joinLocaleString(this.getName(), new LocaleString(ResManager.loadKDString((String)".\u5f00\u59cb", (String)"DateRangeField_0", (String)BOS_METADATA, (Object[])new Object[0])))));
        entityNodes.add(this.createEntityTreeNodeByName(this.getEndDateFieldKey(), this.getEndDateFieldName(), DateRangeField.joinLocaleString(this.getName(), new LocaleString(ResManager.loadKDString((String)".\u7ed3\u675f", (String)"DateRangeField_1", (String)BOS_METADATA, (Object[])new Object[0])))));
        return entityNodes;
    }
}

