/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.commonfield;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.SummaryToField;
import kd.bos.entity.format.IUseRegion;
import kd.bos.entity.property.DecimalProp;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.commonfield.Field;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DecimalField
extends Field<DecimalProp>
implements IUseRegion {
    private int precision = 23;
    private int scale = 10;
    private String dataScope;
    private BigDecimal defValue;
    private boolean zeroShow;
    private boolean useRegion;
    private LocaleString emptyText;
    private LocaleString lockedEmptyTip;
    private SummaryToField summaryToField;
    private boolean isNeedFormat = false;

    public DecimalField() {
        this.defValueType = 1;
    }

    @Override
    protected DecimalProp createDynamicProperty() {
        return new DecimalProp();
    }

    @Override
    protected void setDynamicProperty(DecimalProp prop) {
        super.setDynamicProperty(prop);
        prop.setEnableNull(this.isEnableNull());
        if (this.isEnableNull() && StringUtils.isBlank((Object)this.getDefValue())) {
            prop.setDefValue(null);
            prop.setDefaultValue(null);
        } else {
            prop.setDefValue((Object)this.getDefValue());
        }
        Field<?> field = this.getControlField();
        if (field != null) {
            prop.setControlPropName(field.getKey());
        }
        prop.setPrecision(this.getPrecision());
        prop.setScale(this.getScale());
        this.setPropDataScope(prop);
        prop.setUseRegion(this.useRegion);
        prop.setZeroShow(this.isZeroShow());
        prop.setSummaryToField(this.getSummaryToField());
    }

    private void setPropDataScope(DecimalProp prop) {
        String minDataScope = this.getMinDataScope();
        String maxDataScope = this.getMaxDataScope();
        BigDecimal min = null;
        BigDecimal max = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)minDataScope)) {
                min = new BigDecimal(minDataScope);
            }
            if (StringUtils.isNotBlank((CharSequence)maxDataScope)) {
                max = new BigDecimal(maxDataScope);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (min != null) {
            prop.setDataScope(this.getDataScope());
            prop.setMin(min);
            if (StringUtils.equals((CharSequence)"[", (CharSequence)this.getMinDataScopeMark())) {
                prop.setInclMin(true);
            }
        }
        if (max != null) {
            prop.setDataScope(this.getDataScope());
            prop.setMax(max);
            if (StringUtils.equals((CharSequence)"]", (CharSequence)this.getMaxDataScopeMark())) {
                prop.setInclMax(true);
            }
        }
    }

    @Override
    @SimplePropertyAttribute
    @DefaultValueAttribute(value="23")
    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    @Override
    public int getFieldDBType() {
        return 3;
    }

    @Override
    @SimplePropertyAttribute
    @DefaultValueAttribute(value="10")
    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @SimplePropertyAttribute(name="DataScope")
    public String getDataScope() {
        return this.dataScope;
    }

    public void setDataScope(String dataScope) {
        this.dataScope = dataScope;
    }

    @SimplePropertyAttribute(name="ZeroShow")
    public boolean isZeroShow() {
        return this.zeroShow;
    }

    public void setZeroShow(boolean zeroShow) {
        this.zeroShow = zeroShow;
    }

    @SimplePropertyAttribute
    public LocaleString getEmptyText() {
        return this.emptyText;
    }

    public void setEmptyText(LocaleString value) {
        this.emptyText = value;
    }

    @SimplePropertyAttribute
    public LocaleString getLockedEmptyTip() {
        return this.lockedEmptyTip;
    }

    public void setLockedEmptyTip(LocaleString lockedEmptyTip) {
        this.lockedEmptyTip = lockedEmptyTip;
    }

    @ComplexPropertyAttribute
    public SummaryToField getSummaryToField() {
        return this.summaryToField;
    }

    public void setSummaryToField(SummaryToField summaryToField) {
        this.summaryToField = summaryToField;
    }

    @Override
    protected FieldEdit createServerEditor() {
        return new DecimalEdit();
    }

    @Override
    public Map<String, Object> createEditor() {
        String minString;
        Map<String, Object> editor = super.createEditor();
        editor.put("type", "number");
        editor.put("nt", "D");
        editor.put("pc", this.getPrecision());
        editor.put("sc", this.getScale());
        editor.put("zs", this.isZeroShow());
        String maxString = this.getMaxDataScope();
        if (!StringUtils.isBlank((CharSequence)maxString)) {
            editor.put("max", new BigDecimal(maxString));
            editor.put("maxm", this.getMaxDataScopeMark());
        }
        if (!StringUtils.isBlank((CharSequence)(minString = this.getMinDataScope()))) {
            editor.put("min", new BigDecimal(minString));
            editor.put("minm", this.getMinDataScopeMark());
        }
        if (StringUtils.isNotBlank((Object)this.getEmptyText())) {
            editor.put("emptytip", this.getEmptyText());
        }
        if (StringUtils.isNotBlank((Object)this.getLockedEmptyTip())) {
            editor.put("lockedemptytip", this.getLockedEmptyTip());
        }
        editor.put("roundMethod", "1");
        return editor;
    }

    public String getMaxDataScope() {
        String scope = StringUtils.substringAfter((String)this.dataScope, (String)",");
        if (StringUtils.isBlank((CharSequence)scope)) {
            return scope;
        }
        int subIndex = scope.indexOf("]");
        if (subIndex >= 0) {
            scope = scope.substring(0, subIndex);
        }
        if ((subIndex = scope.indexOf(")")) >= 0) {
            scope = scope.substring(0, subIndex);
        }
        return scope;
    }

    public String getMinDataScope() {
        String scope = StringUtils.substringBefore((String)this.dataScope, (String)",");
        if (StringUtils.isBlank((CharSequence)scope)) {
            return scope;
        }
        int subIndex = scope.indexOf("[");
        if (subIndex >= 0) {
            scope = scope.substring(subIndex + 1);
        }
        if ((subIndex = scope.indexOf("(")) >= 0) {
            scope = scope.substring(subIndex + 1);
        }
        return scope;
    }

    public String getMaxDataScopeMark() {
        if (StringUtils.isBlank((CharSequence)this.dataScope)) {
            return "";
        }
        if (this.dataScope.endsWith(")") || this.dataScope.endsWith("]")) {
            int lastIndex = this.dataScope.lastIndexOf("]") & this.dataScope.lastIndexOf(")");
            return this.dataScope.substring(lastIndex, lastIndex + 1);
        }
        return "";
    }

    public String getMinDataScopeMark() {
        if (StringUtils.isBlank((CharSequence)this.dataScope)) {
            return "";
        }
        if (this.dataScope.startsWith("(") || this.dataScope.startsWith("[")) {
            return this.dataScope.substring(0, 1);
        }
        return "";
    }

    @SimplePropertyAttribute
    public BigDecimal getDefValue() {
        if (this.isEnableNull() && this.defValue == null) {
            return null;
        }
        return this.defValue == null ? BigDecimal.ZERO : this.defValue;
    }

    public void setDefValue(BigDecimal defValue) {
        this.defValue = defValue;
    }

    @Override
    public String getCompareGroupID() {
        return "0,4";
    }

    @Override
    public String getFilterControlType() {
        return "number";
    }

    @Override
    public Map<String, Object> createEntityTreeNode() {
        Map<String, Object> col = super.createEntityTreeNode();
        col.put("DataType", "decimal");
        col.put("Type", "DecimalListColumnAp");
        col.put("ZeroShow", this.isZeroShow());
        Field<?> field = this.getControlField();
        if (field != null) {
            col.put("ControlPropName", field.getKey());
        }
        return col;
    }

    public void setUseRegion(boolean useRegion) {
        this.useRegion = useRegion;
    }

    @SimplePropertyAttribute(name="NeedFormat")
    @DefaultValueAttribute(value="false")
    public boolean isNeedFormat() {
        return this.isNeedFormat;
    }

    public void setNeedFormat(boolean isNeedFormat) {
        this.isNeedFormat = isNeedFormat;
    }
}

