/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.commonfield;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.upload.UploadOption;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DropdownItem {
    private String id;
    private String key;
    private LocaleString title;
    private LocaleString subTitle;
    private String operationKey;
    private String background;
    private boolean isSwitch;
    private boolean isTheme;
    private boolean isMerge;
    private String lock;
    private String visible = "init,new,edit,view,submit,audit";
    private static Map<String, Integer> mapVis = new HashMap<String, Integer>(4);
    protected static Map<String, Integer> mapLock = new HashMap<String, Integer>(3);
    private String imageKey;
    private int index = 0;
    private boolean uploadable;
    private UploadOption uploadConfig;

    @SimplePropertyAttribute
    public boolean getIsSwitch() {
        return this.isSwitch;
    }

    public void setIsSwitch(boolean isSwitch) {
        this.isSwitch = isSwitch;
    }

    @SimplePropertyAttribute
    public boolean getIsTheme() {
        return this.isTheme;
    }

    public void setIsTheme(boolean isTheme) {
        this.isTheme = isTheme;
    }

    @SimplePropertyAttribute
    public boolean getIsMerge() {
        return this.isMerge;
    }

    public void setIsMerge(boolean isMerge) {
        this.isMerge = isMerge;
    }

    public DropdownItem() {
    }

    public DropdownItem(String key, String title, String subTitle, String operationKey, String rgb) {
        this.key = key;
        this.title = new LocaleString(title);
        this.subTitle = new LocaleString(subTitle);
        this.operationKey = operationKey;
        this.background = rgb;
    }

    public DropdownItem(String key, String title, String subTitle, String operationKey, String rgb, String lock) {
        this(key, title, subTitle, operationKey, rgb);
        this.lock = lock;
    }

    public DropdownItem(String key, String title, String subTitle, String operationKey, String rgb, String lock, String visible) {
        this(key, title, subTitle, operationKey, rgb, lock);
        this.visible = visible;
    }

    public int getVisibleValue() {
        String vi = this.getVisible();
        if (vi == null) {
            return 63;
        }
        if (vi.contains("default") || vi.contains("lookup")) {
            String string = vi = StringUtils.isNotBlank((CharSequence)vi) && !vi.contains("init") ? vi + ",init" : vi;
        }
        if (StringUtils.isEmpty((CharSequence)vi)) {
            return 0;
        }
        String[] vs = vi.split(",");
        int ret = 0;
        for (String v : vs) {
            if (!mapVis.containsKey(v)) continue;
            ret |= mapVis.get(v).intValue();
        }
        return ret;
    }

    protected int getLockValue(String lockString) {
        if (StringUtils.isBlank((CharSequence)lockString)) {
            return 0;
        }
        String[] vs = lockString.split(",");
        int ret = 0;
        for (String v : vs) {
            if (!mapLock.containsKey(v)) continue;
            ret |= mapLock.get(v).intValue();
        }
        return ret;
    }

    public Map<String, Object> createControl() {
        int lo;
        HashMap<String, Object> ctl = new HashMap<String, Object>();
        ctl.put("id", this.key);
        ctl.put("key", this.key);
        ctl.put("title", this.title);
        ctl.put("subTitle", this.subTitle);
        ctl.put("operationKey", this.operationKey);
        ctl.put("background", this.background);
        ctl.put("isSwitch", this.isSwitch);
        ctl.put("isTheme", this.isTheme);
        ctl.put("isMerge", this.isMerge);
        ctl.put("imageKey", this.imageKey);
        int v = this.getVisibleValue();
        if (v != 63) {
            ctl.put("vi", v);
        }
        if ((lo = this.getLockValue(this.getLock())) != 0) {
            ctl.put("l", lo);
        }
        ctl.put("iu", this.isUploadable());
        ctl.put("uconfig", this.getUploadConfig());
        return ctl;
    }

    @SimplePropertyAttribute(isPrimaryKey=true)
    public String getId() {
        if (StringUtils.isBlank((CharSequence)this.id)) {
            this.id = DB.genStringId((String)"");
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @SimplePropertyAttribute
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @SimplePropertyAttribute
    public LocaleString getTitle() {
        return this.title;
    }

    public void setTitle(LocaleString title) {
        this.title = title;
    }

    @SimplePropertyAttribute
    public String getOperationKey() {
        return this.operationKey;
    }

    public void setOperationKey(String operationKey) {
        this.operationKey = operationKey;
    }

    @SimplePropertyAttribute
    public LocaleString getSubTitle() {
        return this.subTitle;
    }

    public void setSubTitle(LocaleString subTitle) {
        this.subTitle = subTitle;
    }

    @SimplePropertyAttribute
    public String getBackground() {
        return this.background;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    @SimplePropertyAttribute
    public String getLock() {
        return this.lock;
    }

    public void setLock(String lock) {
        this.lock = lock;
    }

    @SimplePropertyAttribute
    public String getVisible() {
        return this.visible;
    }

    public void setVisible(String visible) {
        this.visible = visible;
    }

    @SimplePropertyAttribute
    public String getImageKey() {
        return this.imageKey;
    }

    public void setImageKey(String imageKey) {
        this.imageKey = imageKey;
    }

    @SimplePropertyAttribute(name="Uploadable")
    public boolean isUploadable() {
        return this.uploadable;
    }

    public void setUploadable(boolean uploadable) {
        this.uploadable = uploadable;
    }

    @ComplexPropertyAttribute
    public UploadOption getUploadConfig() {
        return this.uploadConfig;
    }

    public void setUploadConfig(UploadOption uploadConfig) {
        this.uploadConfig = uploadConfig;
    }

    @SimplePropertyAttribute
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    static {
        mapVis.put("new", 1);
        mapVis.put("edit", 2);
        mapVis.put("view", 4);
        mapVis.put("init", 8);
        mapVis.put("submit", 16);
        mapVis.put("audit", 32);
        mapVis.put("default", 1);
        mapVis.put("lookup", 2);
        mapLock.put("new", 1);
        mapLock.put("edit", 2);
        mapLock.put("view", 4);
        mapLock.put("submit", 16);
        mapLock.put("audit", 32);
    }
}

