/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.commonfield;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BooleanProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.RadioEdit;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class RadioField
extends Field<BooleanProp> {
    private String group;
    private String items;

    @SimplePropertyAttribute
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @SimplePropertyAttribute
    public String getItems() {
        return this.items;
    }

    public void setItems(String items) {
        this.items = items;
    }

    @Override
    public int getFieldDBType() {
        return 1;
    }

    @Override
    public String getCompareGroupID() {
        return "10";
    }

    @Override
    public Map<String, Object> createEditor() {
        Map<String, Object> ctlRet = super.createEditor();
        ctlRet.put("type", "radio");
        ctlRet.put("v", this.items);
        if (StringUtils.isNotBlank((CharSequence)this.group)) {
            Optional<ControlAp> first;
            ctlRet.put("group", this.group);
            if (this.formMetadata != null && (first = this.formMetadata.getItems().stream().filter(i -> i instanceof FieldAp && StringUtils.equalsIgnoreCase((CharSequence)this.group, (CharSequence)((FieldAp)i).getFieldId())).findFirst()).isPresent()) {
                FieldAp fieldAp = (FieldAp)first.get();
                ctlRet.put("group", fieldAp.getKey());
            }
        }
        return ctlRet;
    }

    @Override
    protected BooleanProp createDynamicProperty() {
        BooleanProp prop = new BooleanProp();
        prop.setSysField(true);
        return prop;
    }

    @Override
    public void resetItemId(Map<String, String> idMap) {
        super.resetItemId(idMap);
        String newid = idMap.get(this.getGroup());
        if (newid != null) {
            this.setGroup(newid);
        }
    }

    @Override
    public List<Map<String, Object>> createEntityTreeNodes(boolean isAllNode) {
        return new ArrayList<Map<String, Object>>();
    }

    @Override
    public String getFilterControlType() {
        return "enum";
    }

    @Override
    protected FieldEdit createServerEditor() {
        return new RadioEdit();
    }

    @Override
    protected void setServerEditorProperties(FieldEdit editor) {
        RadioEdit radioEdit = (RadioEdit)editor;
        super.setServerEditorProperties(editor);
        radioEdit.setGroup(this.getGroup());
        radioEdit.setItems(this.getItems());
    }
}

