/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.commonfield;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TimeRangeEdit;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IDBField;
import kd.bos.metadata.entity.commonfield.TimeField;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TimeRangeField
extends Field<TimeProp> {
    private static final String BOS_METADATA = "bos-metadata";
    private String startDateFieldKey;
    private String startDateFieldName;
    private String endDateFieldKey;
    private String endDateFieldName;
    private LocaleString emptyText;
    private String defValue;

    @Override
    public void addBinderMap(Map<String, List<String>> binderMap, String fieldApKey) {
        super.addBinderMap(binderMap, fieldApKey);
        this.addBinderMap(binderMap, this.getStartDateFieldKey(), fieldApKey);
        this.addBinderMap(binderMap, this.getEndDateFieldKey(), fieldApKey);
    }

    @Override
    public List<IDBField> getDBFields() {
        ArrayList<IDBField> list = new ArrayList<IDBField>();
        TimeField startDateTimeField = new TimeField();
        startDateTimeField.setFieldName(this.getStartDateFieldName());
        list.add(startDateTimeField);
        TimeField endDateTimeField = new TimeField();
        endDateTimeField.setFieldName(this.getEndDateFieldName());
        list.add(endDateTimeField);
        return list;
    }

    @Override
    public int getFieldDBType() {
        return 4;
    }

    @Override
    protected FieldEdit createServerEditor() {
        return new TimeRangeEdit();
    }

    @Override
    public Map<String, Object> createEditor() {
        Map<String, Object> editor = super.createEditor();
        editor.put("type", "timerange");
        if (StringUtils.isNotBlank((Object)this.getEmptyText())) {
            editor.put("emptytip", this.getEmptyText());
        }
        return editor;
    }

    @Override
    protected TimeProp createDynamicProperty() {
        return new TimeProp();
    }

    @Override
    public DynamicProperty registerProperty(DynamicObjectType dt) {
        TimeProp beginDateProp = this.createDynamicProperty();
        beginDateProp.setRelateTimeRange(this.getEndDateFieldKey());
        beginDateProp.setStartTimeRange(true);
        this.setDynamicProperty(beginDateProp);
        dt.addProperty((DynamicProperty)beginDateProp);
        TimeProp endTimeProp = new TimeProp();
        endTimeProp.setRelateTimeRange(this.getStartDateFieldKey());
        endTimeProp.setStartTimeRange(false);
        endTimeProp.setName(this.getEndDateFieldKey());
        endTimeProp.setAlias(this.getEndDateFieldName());
        endTimeProp.setTableGroup(beginDateProp.getTableGroup());
        endTimeProp.setDisplayName(TimeRangeField.joinLocaleString(this.getName(), ResManager.getLocaleString((String)".\u7ed3\u675f", (String)"TimeRangeField_0", (String)BOS_METADATA)));
        endTimeProp.setDbIgnore(StringUtils.isBlank((CharSequence)this.getEndDateFieldName()));
        endTimeProp.setFeatures(this.getFeatures().getValue());
        dt.registerSimpleProperty((DynamicSimpleProperty)endTimeProp);
        if (this.isMustInput()) {
            endTimeProp.setMustInput(this.isMustInput());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getDefValue())) {
            String[] defSplit = this.getDefValue().split(",");
            beginDateProp.setDefValue((Object)defSplit[0].trim());
            if (defSplit.length > 1) {
                endTimeProp.setDefValue((Object)defSplit[1].trim());
            }
        }
        return beginDateProp;
    }

    private static LocaleString joinLocaleString(LocaleString str1, LocaleString str2) {
        LocaleString str = new LocaleString();
        for (Map.Entry entry : str1.entrySet()) {
            String localeId = (String)entry.getKey();
            String val1 = (String)entry.getValue();
            String val2 = (String)str2.get((Object)localeId);
            val2 = StringUtils.isBlank((CharSequence)val2) ? str2.toString() : val2;
            String val = val1 + val2;
            str.put(localeId, (Object)val);
        }
        return str;
    }

    @Override
    protected void setServerEditorProperties(FieldEdit editor) {
        TimeRangeEdit timeRangeEdit = (TimeRangeEdit)editor;
        timeRangeEdit.setStartDateFieldKey(this.getStartDateFieldKey());
        timeRangeEdit.setEndDateFieldKey(this.getEndDateFieldKey());
        super.setServerEditorProperties(editor);
    }

    @Override
    protected void setDynamicProperty(TimeProp prop) {
        super.setDynamicProperty(prop);
        prop.setName(this.getStartDateFieldKey());
        prop.setAlias(this.startDateFieldName);
        prop.setDisplayName(TimeRangeField.joinLocaleString(this.getName(), ResManager.getLocaleString((String)".\u5f00\u59cb", (String)"TimeRangeField_1", (String)BOS_METADATA)));
        prop.setDbIgnore(StringUtils.isBlank((CharSequence)this.startDateFieldName));
    }

    @SimplePropertyAttribute(name="StartDateFieldKey")
    public String getStartDateFieldKey() {
        return StringUtils.isBlank((CharSequence)this.startDateFieldKey) ? this.getKey() + "_starttime" : this.startDateFieldKey.trim();
    }

    public void setStartDateFieldKey(String startDateFieldKey) {
        this.startDateFieldKey = startDateFieldKey;
    }

    @SimplePropertyAttribute(name="StartDateFieldName")
    public String getStartDateFieldName() {
        return this.startDateFieldName;
    }

    public void setStartDateFieldName(String startDateFieldName) {
        this.startDateFieldName = startDateFieldName;
    }

    @SimplePropertyAttribute(name="EndDateFieldKey")
    public String getEndDateFieldKey() {
        return StringUtils.isBlank((CharSequence)this.endDateFieldKey) ? this.getKey() + "_endtime" : this.endDateFieldKey.trim();
    }

    public void setEndDateFieldKey(String endDateFieldKey) {
        this.endDateFieldKey = endDateFieldKey;
    }

    @SimplePropertyAttribute(name="EndDateFieldName")
    public String getEndDateFieldName() {
        return this.endDateFieldName;
    }

    public void setEndDateFieldName(String endDateFieldName) {
        this.endDateFieldName = endDateFieldName;
    }

    @SimplePropertyAttribute
    public String getDefValue() {
        return this.defValue;
    }

    public void setDefValue(String defValue) {
        this.defValue = defValue;
    }

    @SimplePropertyAttribute
    public LocaleString getEmptyText() {
        return this.emptyText;
    }

    public void setEmptyText(LocaleString emptyText) {
        this.emptyText = emptyText;
    }

    @Override
    public List<Map<String, Object>> createEntityTreeNodes(boolean isAllNode, int level, boolean isIncludeEntry) {
        ArrayList<Map<String, Object>> entityNodes = new ArrayList<Map<String, Object>>();
        entityNodes.add(this.createEntityTreeNodeByName(this.getStartDateFieldKey(), TimeRangeField.joinLocaleString(this.getName(), ResManager.getLocaleString((String)".\u5f00\u59cb", (String)"TimeRangeField_1", (String)BOS_METADATA))));
        entityNodes.add(this.createEntityTreeNodeByName(this.getEndDateFieldKey(), TimeRangeField.joinLocaleString(this.getName(), ResManager.getLocaleString((String)".\u7ed3\u675f", (String)"TimeRangeField_0", (String)BOS_METADATA))));
        return entityNodes;
    }

    private Map<String, Object> createEntityTreeNodeByName(String key, LocaleString name) {
        HashMap<String, Object> entityNode = new HashMap<String, Object>();
        entityNode.put("Id", key);
        entityNode.put("Type", "TimeListColumnAp");
        entityNode.put("DataType", "time");
        entityNode.put("Name", name.toString());
        entityNode.put("CreateType", 1);
        entityNode.put("compareGroupId", "5,0,1,2,4");
        entityNode.put("IsMulti", false);
        entityNode.put("Custom", true);
        entityNode.put("SeqType", "NotSeq");
        EntityItem<?> entityItem = this.entityMetadata.getItemById(this.getParentId());
        entityNode.put("EntryEntity", entityItem instanceof EntryEntity);
        entityNode.put("IsBaseData", true);
        entityNode.put("ClientType", "text");
        entityNode.put("FilterApType", "FilterColumnAp");
        entityNode.put("CommonFilterApType", "CommonDateFilterColumnAp");
        entityNode.put("SchemeFilterApType", "SchemeFilterColumnAp");
        return entityNode;
    }
}

