/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.report;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.metadata.entity.commonfield.Field;

public class FieldTypeBuilder {
    private static Map<String, String> fieldTypeMap = new HashMap<String, String>();

    private FieldTypeBuilder() {
        throw new IllegalStateException("Utility class");
    }

    public static String getFieldType(String fullFieldName) {
        return fieldTypeMap.get(fullFieldName);
    }

    public static String getFieldType(Field<?> field) {
        String fieldType = FieldTypeBuilder.getFieldType(field.getClass().getName());
        if (StringUtils.isNotBlank((CharSequence)fieldType)) {
            return fieldType;
        }
        return field.getRptColFieldType();
    }

    public static void setFieldType(String key, String value) {
        fieldTypeMap.put(key, value);
    }

    static {
        String commonPrefix = "kd.bos.metadata.entity.commonfield.";
        String bussinessPrefix = "kd.bos.metadata.entity.businessfield.";
        fieldTypeMap.put(commonPrefix + "AdminDivisionField", "text");
        fieldTypeMap.put(commonPrefix + "TextField", "text");
        fieldTypeMap.put(commonPrefix + "LargeTextField", "text");
        fieldTypeMap.put(commonPrefix + "TextAreaField", "text");
        fieldTypeMap.put(commonPrefix + "AttachmentCountField", "integer");
        fieldTypeMap.put(commonPrefix + "IntegerField", "integer");
        fieldTypeMap.put(commonPrefix + "BigIntField", "bigint");
        fieldTypeMap.put(commonPrefix + "DecimalField", "decimal");
        fieldTypeMap.put(commonPrefix + "DateTimeField", "date");
        fieldTypeMap.put(commonPrefix + "DateField", "date");
        fieldTypeMap.put(commonPrefix + "CheckBoxField", "checkbox");
        fieldTypeMap.put(commonPrefix + "PictureField", "picture");
        fieldTypeMap.put(commonPrefix + "RadioField", "boolean");
        fieldTypeMap.put(commonPrefix + "FormulaField", "formula");
        fieldTypeMap.put(commonPrefix + "ComboField", "combofield");
        fieldTypeMap.put(commonPrefix + "MulComboField", "combofield");
        fieldTypeMap.put(commonPrefix + "RadioOptGroupField", "combofield");
        fieldTypeMap.put(commonPrefix + "CheckBoxGroupField", "combofield");
        fieldTypeMap.put(commonPrefix + "StepperField", "stepper");
        fieldTypeMap.put(bussinessPrefix + "AmountField", "amount");
        fieldTypeMap.put(bussinessPrefix + "UnitField", "unit");
        fieldTypeMap.put(bussinessPrefix + "CurrencyField", "currency");
        fieldTypeMap.put(bussinessPrefix + "BasedataField", "basedata");
        fieldTypeMap.put(bussinessPrefix + "FlexField", "flex");
        fieldTypeMap.put(bussinessPrefix + "UserField", "user");
        fieldTypeMap.put(bussinessPrefix + "QtyField", "qty");
        fieldTypeMap.put(bussinessPrefix + "PriceField", "price");
        fieldTypeMap.put(bussinessPrefix + "CreateDateField", "date");
        fieldTypeMap.put(bussinessPrefix + "ModifyDateField", "date");
        fieldTypeMap.put(bussinessPrefix + "BillStatusField", "combofield");
        fieldTypeMap.put(bussinessPrefix + "ItemClassTypeField", "combofield");
        fieldTypeMap.put(bussinessPrefix + "MaterielField", "basedata");
        fieldTypeMap.put(bussinessPrefix + "BaseUnitqtyField", "baseunitqty");
        fieldTypeMap.put(bussinessPrefix + "PrintTimeField", "date");
        fieldTypeMap.put(bussinessPrefix + "PrintUserField", "user");
    }
}

