/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.entity.validation;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.lang.Lang;
import kd.bos.metadata.entity.validation.ValidationType;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ValidationTypes {
    private List<ValidationType> types = new ArrayList<ValidationType>();
    private Map<String, ValidationType> dctTypes = null;
    private Date createTime = new Date();
    private static final long CACHE_OVERTIME = 600000L;
    private List<String> loadedLangs = new ArrayList<String>(3);

    @CollectionPropertyAttribute(collectionItemPropertyType=ValidationType.class)
    public List<ValidationType> getTypes() {
        return this.types;
    }

    public void setTypes(List<ValidationType> types) {
        this.types = types;
    }

    public ValidationType find(String typeId) {
        this.createDictionary();
        return this.dctTypes.get(typeId);
    }

    public boolean isCacheOverTime() {
        Date currTime = new Date();
        if (this.createTime == null) {
            this.createTime = new Date();
        }
        return Long.compare(currTime.getTime() - this.createTime.getTime(), 600000L) > 0;
    }

    private synchronized void createDictionary() {
        if (this.dctTypes == null) {
            this.dctTypes = new HashMap<String, ValidationType>(16);
            for (ValidationType type : this.types) {
                this.dctTypes.put(type.getId(), type);
            }
        }
    }

    public boolean isLoaded(Lang lang) {
        if (lang == null) {
            return true;
        }
        return this.loadedLangs.contains(lang.toString());
    }

    public void setLoaded(Lang lang) {
        if (lang != null && !this.loadedLangs.contains(lang.toString())) {
            this.loadedLangs.add(lang.toString());
        }
    }
}

