/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ConfigItem;
import kd.bos.entity.CtlSchemaInfo;
import kd.bos.form.control.Control;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.form.ControlBuilder;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.Style;
import kd.bos.script.annotations.KSMethod;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class ControlAp<T extends Control>
extends AbstractElement {
    private static final String DEFAULT = "default";
    private String foreColor;
    private String backColor;
    private int fontsize = 12;
    private String fontWeight;
    protected String visible = "init,new,edit,view,submit,audit";
    private String lock;
    private LocaleString width;
    private LocaleString height;
    private int index;
    private Style style;
    private int zIndex;
    private String alignSelf = "default";
    private String textAlign = "default";
    private boolean hidden;
    private boolean invisible;
    protected int grow = 0;
    protected int shrink = 1;
    private String radius;
    protected FormMetadata formMetadata;
    private static Map<String, Integer> mapVis = new HashMap<String, Integer>(11);
    protected static Map<String, Integer> mapLock = new HashMap<String, Integer>(7);
    private boolean autoTextWrap = false;
    private String customeStyles;
    private String tableHeaderCellBackColor;
    private static final String CUSTOM_IS = "isCustom";
    private static final String CUSTOM_SCHEMA_INFO = "schemaInfo";
    private static final String CUSTOM_CONFIG_ITEMS = "ci";
    protected ControlBuilder<T> controlBuilder;
    private boolean isControlBuilderInit = false;

    private ControlBuilder<T> getControlBuilder() {
        if (this.controlBuilder == null && !this.isControlBuilderInit) {
            this.controlBuilder = ControlBuilder.create(this.getClass().getSimpleName());
            if (this.controlBuilder != null) {
                this.controlBuilder.setControlAp(this);
            }
            this.isControlBuilderInit = true;
        }
        return this.controlBuilder;
    }

    protected <R> R callBuilderFunc(Supplier<R> builderFunc, Supplier<R> defaultFunc) {
        R r = null;
        if (this.getControlBuilder() != null) {
            r = builderFunc.get();
        }
        if (r == null && defaultFunc != null) {
            r = defaultFunc.get();
        }
        return r;
    }

    @SimplePropertyAttribute
    public LocaleString getWidth() {
        return this.width;
    }

    public void setWidth(LocaleString width) {
        this.width = width;
    }

    @SimplePropertyAttribute(name="Hidden")
    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @SimplePropertyAttribute(name="Invisible")
    public boolean isInvisible() {
        return this.invisible;
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
    }

    @SimplePropertyAttribute
    public LocaleString getHeight() {
        return this.height;
    }

    public void setHeight(LocaleString height) {
        this.height = height;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="12")
    @KSMethod
    public int getFontSize() {
        return this.fontsize;
    }

    @KSMethod
    public void setFontSize(int fontsize) {
        this.fontsize = fontsize;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getFontWeight() {
        return this.fontWeight;
    }

    @KSMethod
    public void setFontWeight(String fontWeight) {
        this.fontWeight = fontWeight;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getForeColor() {
        return this.foreColor;
    }

    @KSMethod
    public void setForeColor(String foreColor) {
        this.foreColor = foreColor;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getBackColor() {
        return this.backColor;
    }

    @KSMethod
    public void setBackColor(String backColor) {
        this.backColor = backColor;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="init,new,edit,view,submit,audit")
    public String getVisible() {
        return this.visible;
    }

    public void setVisible(String visible) {
        this.visible = visible == null ? "init,new,edit,view,submit,audit" : visible;
    }

    @SimplePropertyAttribute
    public String getLock() {
        return this.lock;
    }

    public void setLock(String lock) {
        this.lock = lock;
    }

    @SimplePropertyAttribute
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @SimplePropertyAttribute(name="AutoTextWrap")
    public boolean isAutoTextWrap() {
        return this.autoTextWrap;
    }

    public void setAutoTextWrap(boolean autoTextWrap) {
        this.autoTextWrap = autoTextWrap;
    }

    public Map<String, Object> createControl() {
        HashMap<String, Object> ctl = new HashMap<String, Object>(16);
        ctl.put("id", this.getKey().toLowerCase());
        if (StringUtils.isNotBlank((Object)this.height)) {
            ctl.put("h", this.height);
        }
        if (StringUtils.isNotBlank((Object)this.width)) {
            ctl.put("w", this.width);
        }
        if (this.fontsize != 12) {
            ctl.put("fs", this.fontsize);
        }
        if (StringUtils.isNotBlank((CharSequence)this.fontWeight) && !"normal".equals(this.fontWeight)) {
            ctl.put("fw", this.fontWeight);
        }
        if (StringUtils.isNotBlank((CharSequence)this.foreColor)) {
            ctl.put("fc", this.foreColor);
        }
        if (StringUtils.isNotBlank((CharSequence)this.backColor)) {
            ctl.put("bc", this.backColor);
        }
        if (this.getStyle() != null) {
            ctl.put("s", this.style.getStyle());
        }
        if (this.grow > 0) {
            ctl.put("gr", this.grow);
        }
        if (StringUtils.isNotBlank((CharSequence)this.radius)) {
            ctl.put("rd", this.radius);
        }
        if (this.shrink != 1) {
            ctl.put("sk", this.shrink);
        }
        if (this.zIndex != 0) {
            ctl.put("zIndex", this.zIndex);
        }
        if (!DEFAULT.equals(this.alignSelf)) {
            ctl.put("as", this.alignSelf);
        }
        if (!DEFAULT.equals(this.getTextAlign())) {
            ctl.put("text-align", this.getTextAlign());
        }
        if (this.isInvisible()) {
            ctl.put("vi", 0);
        } else {
            int v = this.getVisibleValue();
            if (v != 63) {
                ctl.put("vi", v);
            }
        }
        int lo = this.getLockValue(this.getLock());
        if (lo != 0) {
            ctl.put("l", lo);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getCustomeStyles())) {
            ctl.put("cstyles", this.getCustomeStyles());
        }
        if (this.autoTextWrap) {
            ctl.put("atw", this.isAutoTextWrap());
        }
        if (this.getIsCustom()) {
            ctl.put(CUSTOM_IS, true);
            ctl.put(CUSTOM_SCHEMA_INFO, this.getCustomCtlSchemaInfo());
            ctl.put(CUSTOM_CONFIG_ITEMS, this.getCustomConfigData());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getTableHeaderCellBackColor())) {
            ctl.put("thcb", this.getTableHeaderCellBackColor());
        }
        ctl.putAll(this.getCustomProperties());
        ControlBuilder<T> builder = this.getControlBuilder();
        if (builder != null) {
            builder.createControl(ctl);
        }
        return ctl;
    }

    public Map<String, Object> createDesignerControl() {
        HashMap<String, Object> ctl = new HashMap<String, Object>();
        ctl.put("Id", this.getId());
        ctl.put("Type", this.getUITypeName());
        return ctl;
    }

    protected String getUITypeName() {
        DataEntityTypeAttribute typeAttribute = this.getClass().getAnnotation(DataEntityTypeAttribute.class);
        if (typeAttribute != null) {
            return typeAttribute.name();
        }
        return this.getClass().getSimpleName();
    }

    @KSMethod
    public T buildRuntimeControl() {
        Control ctl = this.callBuilderFunc(() -> this.controlBuilder.createRuntimeControl(), this::createRuntimeControl);
        this.setRuntimeSimpleProperties(ctl);
        if (this.controlBuilder != null) {
            this.controlBuilder.setRuntimeSimpleProperties(ctl);
        }
        return (T)ctl;
    }

    protected void fireBeforeCreateRuntimeControl() {
    }

    protected T createRuntimeControl() {
        return (T)new Control();
    }

    protected void setRuntimeSimpleProperties(T ctl) {
        ctl.setKey(this.getKey().toLowerCase());
        ctl.setCustomeStyles(this.customeStyles);
        ctl.setLock(this.getLock());
        ctl.setLockIntegerVal(Integer.valueOf(this.getLockValue(this.getLock())));
        ctl.setInvisible(this.isInvisible());
        ctl.setVisibleIntegerVal(Integer.valueOf(this.getVisibleValue()));
        ctl.setDesignHidden(this.isHidden());
        ctl.getCustomProperties().putAll(this.getCustomProperties());
    }

    public int getVisibleValue() {
        return this.callBuilderFunc(() -> this.controlBuilder.getVisibleValue(), this::getVisibleValueInner);
    }

    private int getVisibleValueInner() {
        String visible = this.getVisible();
        if (visible == null) {
            return 63;
        }
        if (visible.contains(DEFAULT) || visible.contains("lookup")) {
            String string = visible = StringUtils.isNotBlank((CharSequence)visible) && !visible.contains("init") ? visible + ",init" : visible;
        }
        if (StringUtils.isEmpty((CharSequence)visible)) {
            return 0;
        }
        String[] vs = visible.split(",");
        int ret = 0;
        for (String v : vs) {
            ret |= mapVis.get(v).intValue();
        }
        return ret;
    }

    protected int getLockValue(String lockString) {
        if (StringUtils.isBlank((CharSequence)lockString)) {
            return 0;
        }
        String[] vs = lockString.split(",");
        int ret = 0;
        for (String v : vs) {
            ret |= mapLock.get(v).intValue();
        }
        return ret;
    }

    @SimplePropertyAttribute
    public int getGrow() {
        return this.grow;
    }

    public void setGrow(int grow) {
        this.grow = grow;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="1")
    public int getShrink() {
        return this.shrink;
    }

    public void setShrink(int shrink) {
        this.shrink = shrink;
    }

    @ComplexPropertyAttribute
    @KSMethod
    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    @SimplePropertyAttribute
    public String getRadius() {
        return this.radius;
    }

    public void setRadius(String radius) {
        this.radius = radius;
    }

    @SimplePropertyAttribute
    public int getZIndex() {
        return this.zIndex;
    }

    public void setZIndex(int zIndex) {
        this.zIndex = zIndex;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="default")
    public String getAlignSelf() {
        return this.alignSelf;
    }

    public void setAlignSelf(String alignSelf) {
        this.alignSelf = alignSelf;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="default")
    public String getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(String textAlign) {
        this.textAlign = textAlign;
    }

    protected void addBuildError(int level, String propertyName, String error) {
        ErrorInfo info = new ErrorInfo();
        info.setItemId(this.getId());
        info.setPropertyName(propertyName);
        info.setType("form");
        info.setLevel(level);
        info.setError(error);
        this.formMetadata.addError(info);
    }

    void setFormMetadata(FormMetadata formMetadata) {
        this.formMetadata = formMetadata;
    }

    public void resetEntityItemId(Map<String, String> idMap) {
    }

    @SimplePropertyAttribute
    public String getCustomeStyles() {
        return this.customeStyles;
    }

    public void setCustomeStyles(String customeStyles) {
        this.customeStyles = customeStyles;
    }

    @SimplePropertyAttribute(name="TableHeaderCellBackColor")
    public String getTableHeaderCellBackColor() {
        return this.tableHeaderCellBackColor;
    }

    public void setTableHeaderCellBackColor(String tableHeaderCellBackColor) {
        this.tableHeaderCellBackColor = tableHeaderCellBackColor;
    }

    protected boolean getIsCustom() {
        return false;
    }

    protected CtlSchemaInfo getCustomCtlSchemaInfo() {
        return null;
    }

    protected List<ConfigItem> getCustomConfigData() {
        return null;
    }

    protected void sendPermissionId2Front(Map<String, Object> ctl, String opeKey) {
        if (this.formMetadata == null || this.formMetadata.getEntityMetadata() == null) {
            return;
        }
        String opk = "submitandnew".equalsIgnoreCase(opeKey) ? "submit" : opeKey;
        this.formMetadata.getEntityMetadata().getRootEntity().getOperations().stream().filter(o -> StringUtils.equals((CharSequence)opk, (CharSequence)o.getKey())).findFirst().ifPresent(op -> {
            if (StringUtils.isBlank((CharSequence)op.getPermissionItemId())) {
                return;
            }
            ctl.put("permissionId", op.getPermissionItemId());
        });
    }

    static {
        mapVis.put("new", 1);
        mapVis.put("edit", 2);
        mapVis.put("view", 4);
        mapVis.put("init", 8);
        mapVis.put("submit", 16);
        mapVis.put("audit", 32);
        mapVis.put(DEFAULT, 1);
        mapVis.put("lookup", 2);
        mapLock.put("new", 1);
        mapLock.put("edit", 2);
        mapLock.put("view", 4);
        mapLock.put("submit", 16);
        mapLock.put("audit", 32);
    }
}

