/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.form.control;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.form.container.Container;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EmbedSubEntryGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeSubEntryGrid;
import kd.bos.metadata.entity.EmbedSubEntryEntity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.ITreeEntryEntity;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.TreeEntryEntity;
import kd.bos.metadata.entity.TreeSubEntryEntity;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.container.GridFlatPanelAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldContainerAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.metadata.form.control.OperationColumnAp;
import kd.bos.metadata.form.rule.FormRule;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.script.annotations.KSMethod;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class EntryAp
extends ContainerAp<AbstractGrid> {
    private static final String[] PAGE_ROW_OPTIONS = new String[]{"5", "10", "20", "50", "100", "500", "1000", "3000", "5000"};
    private static final String MAX_PAGE_ROW = "5000";
    private static final String FILTER = "filter";
    private static final String SORT = "sort";
    private Tips ctlTips;
    private int titleFontSize = 12;
    private boolean titleAutoWrap;
    private String columnWidthStyle;
    private int pageRow;
    private String maxPageRow = "5000";
    private boolean splitPage = false;
    private String toolbarLocation = "-1";
    private int orderAndFilter;
    private boolean sumWithFilter;
    private boolean showSeq;
    private boolean showTreeSeq = false;
    private boolean autoRowHeight;
    private boolean multi = true;
    private boolean showSelChexkbox;
    private List<FormRule> rules = new ArrayList<FormRule>();
    private String entryId;
    private String rowHeight;
    private String maxRowHeight;
    private String headHeight;
    private EntryEntity entry;
    private boolean hasOperateIcon = false;
    private List<String> subEntryGrids;
    private boolean showFlatPanel;
    private String pageType = "";
    private boolean showGridConfig;
    private LocaleString busyTip;
    private List<Map<String, String>> freezeList;
    private List<Map<String, String>> initField;
    private boolean dragEntryRow = false;

    @ComplexPropertyAttribute
    public Tips getCtlTips() {
        return this.ctlTips;
    }

    public void setCtlTips(Tips ctlTips) {
        this.ctlTips = ctlTips;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="12")
    public int getTitleFontSize() {
        return this.titleFontSize;
    }

    public void setTitleFontSize(int titleFontSize) {
        this.titleFontSize = titleFontSize;
    }

    @SimplePropertyAttribute(name="ColumnWidthStyle")
    public String getColumnWidthStyle() {
        return this.columnWidthStyle;
    }

    public void setColumnWidthStyle(String columnWidthStyle) {
        this.columnWidthStyle = columnWidthStyle;
    }

    @SimplePropertyAttribute(name="TitleAutoWrap")
    public boolean isTitleAutoWrap() {
        return this.titleAutoWrap;
    }

    public void setTitleAutoWrap(boolean titleAutoWrap) {
        this.titleAutoWrap = titleAutoWrap;
    }

    @SimplePropertyAttribute
    public int getPageRow() {
        return this.pageRow;
    }

    public void setPageRow(int pageRow) {
        this.pageRow = pageRow;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="5000")
    public String getMaxPageRow() {
        return this.maxPageRow;
    }

    public void setMaxPageRow(String maxPageRow) {
        this.maxPageRow = maxPageRow;
    }

    @SimplePropertyAttribute(name="SplitPage")
    @DefaultValueAttribute(value="false")
    public boolean isSplitPage() {
        return this.splitPage;
    }

    public void setSplitPage(boolean splitPage) {
        this.splitPage = splitPage;
    }

    @SimplePropertyAttribute(name="ToolbarLocation")
    @DefaultValueAttribute(value="-1")
    public String getToolbarLocation() {
        return this.toolbarLocation;
    }

    public void setToolbarLocation(String toolbarLocation) {
        this.toolbarLocation = toolbarLocation;
    }

    @SimplePropertyAttribute(name="OrderAndFilter")
    public int getOrderAndFilter() {
        return this.orderAndFilter;
    }

    public void setOrderAndFilter(int orderAndFilter) {
        this.orderAndFilter = orderAndFilter;
    }

    @SimplePropertyAttribute(name="SumWithFilter")
    public boolean isSumWithFilter() {
        return this.sumWithFilter;
    }

    public void setSumWithFilter(boolean sumWithFilter) {
        this.sumWithFilter = sumWithFilter;
    }

    @SimplePropertyAttribute(name="ShowSeq")
    public boolean isShowSeq() {
        return this.showSeq;
    }

    public void setShowSeq(boolean showSeq) {
        this.showSeq = showSeq;
    }

    @SimplePropertyAttribute(name="ShowTreeSeq")
    public boolean isShowTreeSeq() {
        return this.showTreeSeq;
    }

    public void setShowTreeSeq(boolean showTreeSeq) {
        this.showTreeSeq = showTreeSeq;
    }

    @SimplePropertyAttribute(name="AutoRowHeight")
    public boolean isAutoRowHeight() {
        return this.autoRowHeight;
    }

    public void setAutoRowHeight(boolean autoRowHeight) {
        this.autoRowHeight = autoRowHeight;
    }

    @SimplePropertyAttribute(name="Multi")
    @DefaultValueAttribute(value="true")
    public boolean isMulti() {
        return this.multi;
    }

    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    @SimplePropertyAttribute(name="ShowSelChexkbox")
    public boolean isShowSelChexkbox() {
        return this.showSelChexkbox;
    }

    public void setShowSelChexkbox(boolean showSelChexkbox) {
        this.showSelChexkbox = showSelChexkbox;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=FormRule.class)
    public List<FormRule> getRules() {
        return this.rules;
    }

    @SimplePropertyAttribute
    public String getEntryId() {
        return this.entryId;
    }

    public void setEntryId(String value) {
        this.entryId = value;
    }

    @SimplePropertyAttribute
    public String getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(String rowHeight) {
        this.rowHeight = rowHeight;
    }

    @SimplePropertyAttribute
    public String getMaxRowHeight() {
        return this.maxRowHeight;
    }

    public void setMaxRowHeight(String maxRowHeight) {
        this.maxRowHeight = maxRowHeight;
    }

    @SimplePropertyAttribute
    public String getHeadHeight() {
        return this.headHeight;
    }

    public void setHeadHeight(String headHeight) {
        this.headHeight = headHeight;
    }

    public void setEntry(EntryEntity entry) {
        this.entry = entry;
    }

    @SimplePropertyAttribute(name="HasOperateIcon")
    public boolean getHasOperateIcon() {
        return this.hasOperateIcon;
    }

    public void setHasOperateIcon(boolean flag) {
        this.hasOperateIcon = flag;
    }

    public EntryEntity getEntry() {
        return this.entry;
    }

    public List<String> getSubEntryGrids() {
        return this.subEntryGrids;
    }

    public void setSubEntryGrids(List<String> subEntryGrids) {
        this.subEntryGrids = subEntryGrids;
    }

    @SimplePropertyAttribute(name="ShowFlatPanel")
    public boolean isShowFlatPanel() {
        return this.showFlatPanel;
    }

    public void setShowFlatPanel(boolean showFlatPanel) {
        this.showFlatPanel = showFlatPanel;
    }

    @SimplePropertyAttribute(name="PageType")
    public String getPageType() {
        return this.pageType;
    }

    public void setPageType(String type) {
        this.pageType = type;
    }

    @SimplePropertyAttribute(name="ShowGridConfig")
    public boolean isShowGridConfig() {
        return this.showGridConfig;
    }

    public void setShowGridConfig(boolean showGridConfig) {
        this.showGridConfig = showGridConfig;
    }

    @SimplePropertyAttribute
    @KSMethod
    public LocaleString getBusyTip() {
        return this.busyTip;
    }

    public void setBusyTip(LocaleString busyTip) {
        this.busyTip = busyTip;
    }

    @SimplePropertyAttribute
    public List<Map<String, String>> getFreezeList() {
        return this.freezeList;
    }

    public void setFreezeList(List<Map<String, String>> freezeList) {
        this.freezeList = freezeList;
    }

    @SimplePropertyAttribute
    public List<Map<String, String>> getInitField() {
        return this.initField;
    }

    public void setInitField(List<Map<String, String>> initField) {
        this.initField = initField;
    }

    @SimplePropertyAttribute(name="DragEntryRow")
    public boolean isDragEntryRow() {
        return this.dragEntryRow;
    }

    public void setDragEntryRow(boolean dragEntryRow) {
        this.dragEntryRow = dragEntryRow;
    }

    @Override
    public Map<String, Object> createControl() {
        Map<String, Object> ctl = super.createControl();
        ctl.put("type", "grid");
        ctl.put("text", this.getName());
        ctl.put("rk", "rk");
        ctl.put("seq", "seq");
        ctl.put("pt", this.getPageType());
        if (this.isShowGridConfig()) {
            ctl.put("showGridConfig", this.isShowGridConfig());
        }
        if (this.isAutoRowHeight()) {
            ctl.put("arh", this.isAutoRowHeight());
        }
        if (this.isAutoRowHeight() && StringUtils.isNotBlank((CharSequence)this.getMaxRowHeight())) {
            ctl.put("mrh", this.getMaxRowHeight());
        }
        if (!this.isAutoRowHeight() && StringUtils.isNotBlank((CharSequence)this.getRowHeight())) {
            ctl.put("rh", this.getRowHeight());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getHeadHeight())) {
            ctl.put("hh", this.getHeadHeight());
        }
        if (this.isShowSelChexkbox()) {
            ctl.put("selchexkbox", true);
        }
        if (this.entry != null) {
            ctl.put("phide", !this.isSplitPage());
            if (StringUtils.isNotBlank((CharSequence)this.toolbarLocation) && !"-1".equals(this.toolbarLocation)) {
                ctl.put("tl", this.toolbarLocation);
            }
            ctl.put("defaultrows", this.entry.getDefaultRows());
            if (this.entry instanceof ITreeEntryEntity) {
                ctl.put("treeentry", true);
            }
            if (StringUtils.isNotBlank((CharSequence)this.entry.getSelectType())) {
                ctl.put("selectType", this.entry.getSelectType());
            }
            ctl.put("keyFieldId", this.getKeyFieldKey());
            if (this.entry instanceof EmbedSubEntryEntity) {
                ctl.put("type", "embedgrid");
            }
        }
        if (!this.isMulti()) {
            ctl.put("ismul", false);
        }
        if (this.getCtlTips() != null) {
            ctl.put("tips", this.getCtlTips());
        }
        if (this.showSeq) {
            ctl.put("hasOperateIcon", this.getHasOperateIcon());
            if (this.getHasOperateIcon()) {
                ctl.put("insertentryOperation", "insertentry");
                ctl.put("deleteentryOperation", "deleteentry");
            }
        }
        if (this.isShowFlatPanel()) {
            ctl.put("sfp", this.isShowFlatPanel());
        }
        if (this.isShowFlatPanel()) {
            ctl.put("sfp", this.isShowFlatPanel());
            List<Object> views = this.createEntryView();
            if (views != null && views.size() > 0) {
                ctl.put("views", this.createEntryView());
            }
        }
        if (this.getBusyTip() != null) {
            ctl.put("busyTip", this.getBusyTip());
        }
        if (this.isSumWithFilter()) {
            ctl.put("sumWithFilter", this.isSumWithFilter());
        }
        if (this.isShowTreeSeq()) {
            ctl.put("showTreeSeq", this.isShowTreeSeq());
        }
        if (this.getTitleFontSize() != 12) {
            ctl.put("tfs", this.getTitleFontSize());
        }
        if (this.isTitleAutoWrap()) {
            ctl.put("taw", this.isTitleAutoWrap());
        }
        if (this.isDragEntryRow()) {
            ctl.put("dragEntryRow", this.isDragEntryRow());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getColumnWidthStyle())) {
            ctl.put("columnWidthStyle", this.getColumnWidthStyle());
        }
        if (StringUtils.isNotBlank((Object)this.getOrderAndFilter())) {
            ctl.put("orderAndFilter", this.getOrderAndFilter());
        }
        if (this.isSplitPage() && StringUtils.isNotBlank((CharSequence)this.getMaxPageRow()) && !StringUtils.equals((CharSequence)MAX_PAGE_ROW, (CharSequence)this.getMaxPageRow()) && Arrays.asList(PAGE_ROW_OPTIONS).contains(this.getMaxPageRow())) {
            ctl.put("pageRowOptions", Arrays.stream(PAGE_ROW_OPTIONS).filter(opt -> Integer.parseInt(opt) <= Integer.parseInt(this.getMaxPageRow())).collect(Collectors.toList()));
        }
        return ctl;
    }

    @Override
    protected void createChildControls(Map<String, Object> ctl) {
        ctl.put("columns", this.createColumns());
    }

    private List<Object> createEntryView() {
        ArrayList<Object> views = new ArrayList<Object>();
        for (int i = 0; i < this.getItems().size(); ++i) {
            ControlAp<?> item = this.getItems().get(i);
            if (item.getVisibleValue() == 0 || item.isHidden() || !(item instanceof GridFlatPanelAp)) continue;
            GridFlatPanelAp fldAp = (GridFlatPanelAp)item;
            Map<String, Object> newCols = fldAp.createControl();
            views.add(newCols);
        }
        return views;
    }

    protected List<Object> createColumns() {
        ArrayList<Object> cols = new ArrayList<Object>();
        Map<String, Object> col = this.createHiddenColumn("rk");
        cols.add(col);
        this.createSysInnerColumns(cols);
        for (int i = 0; i < this.getItems().size(); ++i) {
            ControlAp<?> item = this.getItems().get(i);
            if (item.getVisibleValue() == 0 || item.isHidden()) continue;
            if (item instanceof EntryFieldGroupAp) {
                EntryFieldGroupAp group = (EntryFieldGroupAp)item;
                cols.add(group.createControl(this.getOrderAndFilter()));
                continue;
            }
            if (item instanceof EntryFieldContainerAp) {
                Map<String, Object> map = item.createControl();
                map.putAll(this.getOrderAndFilterMap(this.getOrderAndFilter()));
                cols.add(map);
                continue;
            }
            if (item instanceof OperationColumnAp) {
                cols.add(item.createControl());
                if (i != 0) continue;
                Collections.swap(cols, 0, cols.size() - 1);
                continue;
            }
            if (item instanceof EntryFieldAp) {
                EntryFieldAp fldAp = (EntryFieldAp)item;
                List<Object> newCols = fldAp.createColumns();
                this.createOrderAndFilterColumn(newCols);
                cols.addAll(newCols);
                continue;
            }
            List<Object> customCol = this.customCreateColumn(item);
            if (customCol == null || customCol.isEmpty()) continue;
            cols.addAll(customCol);
        }
        return cols;
    }

    protected List<Object> customCreateColumn(ControlAp<?> item) {
        return null;
    }

    private void createSysInnerColumns(List<Object> cols) {
        Map<String, Object> col = this.createColumn("seq", new LocaleString("zh_CN", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"EntryAp_0", (String)"bos-metadata", (Object[])new Object[0])));
        if (!this.isShowSeq()) {
            col.put("visible", false);
        }
        col.put("type", "numberfield");
        col.put("isColPageFixed", true);
        cols.add(col);
    }

    private Map<String, Object> createColumn(String key, LocaleString caption) {
        HashMap<String, Object> col = new HashMap<String, Object>();
        col.put("dataIndex", key);
        col.put("header", caption);
        col.put("width", 50);
        return col;
    }

    private Map<String, Object> createHiddenColumn(String key) {
        Map<String, Object> col = this.createColumn(key, new LocaleString("zh_CN", key));
        col.put("visible", false);
        return col;
    }

    @Override
    protected AbstractGrid createRuntimeControl() {
        if (this.entry instanceof SubEntryEntity) {
            if (this.entry instanceof TreeSubEntryEntity) {
                return new TreeSubEntryGrid();
            }
            if (this.entry instanceof EmbedSubEntryEntity) {
                return new EmbedSubEntryGrid();
            }
            return new SubEntryGrid();
        }
        if (this.entry instanceof TreeEntryEntity) {
            return new TreeEntryGrid();
        }
        return new EntryGrid();
    }

    @Override
    protected void setRuntimeSimpleProperties(Container ctl) {
        super.setRuntimeSimpleProperties(ctl);
        if (this.entry != null) {
            EntryGrid entryGrid = (EntryGrid)ctl;
            entryGrid.setEntryKey(this.entry.getKey());
            entryGrid.setSplitPage(this.isSplitPage());
            if (StringUtils.isNotBlank((CharSequence)this.toolbarLocation) && !"-1".equals(this.toolbarLocation)) {
                entryGrid.setToolbarLocation(this.getToolbarLocation());
            }
            entryGrid.setPageRow(this.getPageRow());
            if (this.isSplitPage() && this.getPageRow() == 0) {
                entryGrid.setPageRow(5000);
            }
            if (this.isSplitPage() && StringUtils.isNotBlank((CharSequence)this.getMaxPageRow()) && !StringUtils.equals((CharSequence)MAX_PAGE_ROW, (CharSequence)this.getMaxPageRow()) && Arrays.asList(PAGE_ROW_OPTIONS).contains(this.getMaxPageRow())) {
                entryGrid.setMaxPageRow(this.getMaxPageRow());
            }
            entryGrid.setRuleCount(this.getRules().size() + this.getEntry().getRules().size());
            entryGrid.setSubEntryGrids(this.getSubEntryGrids());
            entryGrid.setPageType(this.getPageType());
            entryGrid.setSumWithFilter(this.isSumWithFilter());
            entryGrid.setFreezeList(this.handleFreezeList(this.getFreezeList()));
            entryGrid.setInitField(this.getInitField());
            if (StringUtils.isNotBlank((CharSequence)this.getColumnWidthStyle())) {
                entryGrid.setColumnWidthStyle(this.getColumnWidthStyle());
            }
        }
    }

    @Override
    public void resetEntityItemId(Map<String, String> idMap) {
        super.resetEntityItemId(idMap);
        String newId = idMap.get(this.getEntryId());
        if (newId != null) {
            this.setEntryId(newId);
        }
    }

    private void createOrderAndFilterColumn(List<Object> cols) {
        if (cols == null || cols.isEmpty()) {
            return;
        }
        Map col = (Map)cols.get(0);
        col.putAll(this.getOrderAndFilterMap(this.getOrderAndFilter()));
    }

    private Map<String, Object> getOrderAndFilterMap(int orderAndFilter) {
        HashMap<String, Object> col = new HashMap<String, Object>();
        col.put(FILTER, true);
        col.put(SORT, true);
        switch (orderAndFilter) {
            case 1: {
                col.put(FILTER, false);
                col.put(SORT, false);
                break;
            }
            case 2: {
                col.put(FILTER, false);
                break;
            }
            case 3: {
                col.put(SORT, false);
            }
        }
        return col;
    }

    private String getKeyFieldKey() {
        String keyFieldId = this.entry.getKeyFieldId();
        String keyFieldKey = null;
        if (StringUtils.isNotBlank((CharSequence)keyFieldId)) {
            for (EntityItem<?> item : this.entry.getItems()) {
                if (!StringUtils.equals((CharSequence)keyFieldId, (CharSequence)item.getId())) continue;
                keyFieldKey = item.getKey();
                break;
            }
        }
        return keyFieldKey;
    }

    private List<Map<String, String>> handleFreezeList(List<Map<String, String>> freezeList) {
        ArrayList<Map<String, String>> newFreezeList = new ArrayList<Map<String, String>>(this.getItems().size());
        if (!CollectionUtils.isEmpty(freezeList)) {
            Map<String, Map> listMap = freezeList.stream().collect(Collectors.toMap(x -> (String)x.get("freezelistkey") + "_" + (String)x.get("listname"), v -> v, (k, v) -> v));
            for (ControlAp<?> item : this.getItems()) {
                Map<String, String> map = new HashMap<String, String>(1);
                String key = item.getKey() + "_" + item.getName().toString();
                if (listMap.containsKey(key)) {
                    map = listMap.get(key);
                } else {
                    map.put("freezelistkey", item.getKey());
                    map.put("listname", String.valueOf(item.getName()));
                    map.put("isfreeze", "false");
                }
                newFreezeList.add(map);
            }
        }
        return newFreezeList;
    }
}

