/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.lang;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.SubSystemType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.entity.TipLinkTitle;
import kd.bos.metadata.entity.businessfield.ItemClass;
import kd.bos.metadata.entity.businessfield.billstatusfield.StatusItem;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.metadata.entity.operation.NetCtrlOperation;
import kd.bos.metadata.lang.LocaleItem;

public class LangItemBuilder {
    private DcBinder binder;
    private List<LocaleItem> localeItems = new ArrayList<LocaleItem>();
    private String sourceLocaleId;
    private String destLocaleId;

    public LangItemBuilder(DcBinder binder) {
        this.binder = binder;
    }

    public LangItemBuilder(DcBinder binder, String sourceLocaleId, String destLocaleId) {
        this.binder = binder;
        this.sourceLocaleId = sourceLocaleId;
        this.destLocaleId = destLocaleId;
    }

    public List<LocaleItem> getLocaleItems() {
        return this.localeItems;
    }

    public List<Map<String, ILocaleValue<?>>> getLocaleItemValues() {
        ArrayList vals = new ArrayList(10);
        for (LocaleItem item : this.localeItems) {
            vals.add(item.getItemValue());
        }
        return vals;
    }

    public void builderResouces(Object currentEntity, Object baseEntity) {
        this.localeItems = new ArrayList<LocaleItem>();
        if (currentEntity != null) {
            this.builderResouces(currentEntity, currentEntity.getClass().getSimpleName(), baseEntity);
        }
    }

    private void builderResouces(Object currentEntity, String parentId, Object baseEntity) {
        if (currentEntity == null) {
            return;
        }
        IDataEntityType currentEntityType = this.binder.getDataEntityType(currentEntity);
        if (this.shouldCompare(currentEntityType, baseEntity)) {
            this.buildRes(currentEntity, parentId, baseEntity, currentEntityType);
        } else {
            this.buildRes(currentEntity, parentId, currentEntityType);
        }
    }

    public void rebuilderResouces(Object currentEntity, Object baseEntity, Map<String, Object> localeItems) {
        if (currentEntity != null) {
            this.rebuilderResouces(currentEntity, currentEntity.getClass().getSimpleName(), baseEntity, localeItems);
        }
    }

    protected void rebuilderResouces(Object currentEntity, String parentId, Object baseEntity, Map<String, Object> localeItems) {
        if (currentEntity == null) {
            return;
        }
        IDataEntityType currentEntityType = this.binder.getDataEntityType(currentEntity);
        if (this.shouldCompare(currentEntityType, baseEntity)) {
            this.rebuildRes(currentEntity, parentId, baseEntity, currentEntityType, localeItems);
        } else {
            this.rebuildRes(currentEntity, parentId, currentEntityType, localeItems);
        }
    }

    public void rebuildRes(Object currentEntity, String parentId, IDataEntityType currentEntityType, Map<String, Object> localeItems) {
        if (currentEntityType == null) {
            return;
        }
        for (IDataEntityProperty p : currentEntityType.getProperties()) {
            String Id = parentId + "." + p.getName();
            Object val = p.getValue(currentEntity);
            if (p instanceof ISimpleProperty) {
                if (!(val instanceof ILocaleValue) || ((ILocaleValue)val).size() <= 0) continue;
                Map value = (Map)localeItems.get(Id);
                Map oldLocale = (Map)val;
                if (oldLocale.get("en_US") == null) {
                    oldLocale.put("en_US", oldLocale.toString());
                    p.setValue(currentEntity, (Object)LocaleString.fromMap((Map)oldLocale));
                }
                if (localeItems.get(Id) == null) continue;
                oldLocale.putAll(value);
                p.setValue(currentEntity, (Object)LocaleString.fromMap((Map)oldLocale));
                continue;
            }
            if (p instanceof IComplexProperty) {
                this.rebuilderResouces(val, Id, null, localeItems);
                continue;
            }
            List listValue = (List)val;
            if (listValue == null) continue;
            for (Object objVal : listValue) {
                String entryId = this.getPk(objVal).toString();
                if (objVal instanceof ComboItem) {
                    entryId = parentId + "." + entryId;
                }
                this.rebuilderResouces(objVal, entryId, null, localeItems);
            }
        }
    }

    public void rebuildRes(Object currentEntity, String parentId, Object baseEntity, IDataEntityType currentEntityType, Map<String, Object> localeItems) {
        for (IDataEntityProperty p : currentEntityType.getProperties()) {
            String Id = parentId + "." + p.getName();
            Object val = p.getValue(currentEntity);
            if (p instanceof ISimpleProperty) {
                if (!(val instanceof ILocaleValue) || val == null) continue;
                ILocaleValue baseLValue = (ILocaleValue)p.getValue(baseEntity);
                ILocaleValue currentLValue = (ILocaleValue)val;
                if (currentLValue.get("en_US") == null) {
                    currentLValue.put("en_US", baseLValue.toString());
                    p.setValue(currentEntity, (Object)currentLValue);
                }
                if (baseLValue != null && (baseLValue.get((Object)this.sourceLocaleId) == null || currentLValue.get((Object)this.sourceLocaleId) == null || baseLValue.get((Object)this.sourceLocaleId).equals(currentLValue.get((Object)this.sourceLocaleId))) && (baseLValue.get((Object)this.destLocaleId) == null || currentLValue.get((Object)this.destLocaleId) == null || baseLValue.get((Object)this.destLocaleId).equals(currentLValue.get((Object)this.destLocaleId))) || localeItems.get(Id) == null) continue;
                Map value = (Map)localeItems.get(Id);
                ILocaleValue oldLocale = currentLValue;
                oldLocale.putAll(value);
                p.setValue(currentEntity, (Object)LocaleString.fromMap((Map)oldLocale));
                continue;
            }
            if (p instanceof IComplexProperty) {
                Object baseVal = p.getValue(baseEntity);
                this.rebuilderResouces(val, Id, baseVal, localeItems);
                continue;
            }
            if (!(p instanceof ICollectionProperty)) continue;
            this.rebuilderCollectionReources((ICollectionProperty)p, currentEntityType, currentEntity, baseEntity, Id, localeItems);
        }
    }

    private void rebuilderCollectionReources(ICollectionProperty property, IDataEntityType currentEntityType, Object currentEntity, Object baseEntity, String parentId, Map<String, Object> localeItems) {
        Object currentValue = property.getValue(currentEntity);
        Object baseValue = property.getValue(baseEntity);
        if (currentValue == null) {
            return;
        }
        if (baseValue == null) {
            List listValue = (List)currentValue;
            for (Object objVal : listValue) {
                this.rebuilderResouces(objVal, parentId, localeItems);
            }
        } else {
            List currentList = (List)currentValue;
            List baseList = (List)baseValue;
            for (Object objVal : currentList) {
                Object baseVal = this.getBaseObject(baseList, objVal);
                String entryId = this.getPk(objVal).toString();
                if (objVal instanceof ComboItem) {
                    entryId = parentId + "." + entryId;
                }
                this.rebuilderResouces(objVal, entryId, baseVal, localeItems);
            }
        }
    }

    public void buildRes(Object currentEntity, String parentId, IDataEntityType currentEntityType) {
        if (currentEntityType == null) {
            return;
        }
        for (IDataEntityProperty p : currentEntityType.getProperties()) {
            String Id = parentId + "." + p.getName();
            Object val = p.getValue(currentEntity);
            if (p instanceof ISimpleProperty) {
                if (p.getPropertyType() == null || !ILocaleValue.class.isAssignableFrom(p.getPropertyType())) continue;
                LocaleItem item = new LocaleItem();
                item.setId(Id);
                item.setDataEntity(currentEntity);
                item.setProperty((ISimpleProperty)p);
                this.localeItems.add(item);
                continue;
            }
            if (p instanceof IComplexProperty) {
                this.builderResouces(val, Id, null);
                continue;
            }
            List listValue = (List)val;
            if (listValue == null) continue;
            for (Object objVal : listValue) {
                String entryId = this.getPk(objVal).toString();
                if (objVal instanceof ComboItem || objVal instanceof StatusItem || objVal instanceof NetCtrlOperation || objVal instanceof DropdownItem || objVal instanceof ItemClass || objVal instanceof TipLinkTitle) {
                    entryId = parentId + "." + entryId;
                }
                this.builderResouces(objVal, entryId, null);
            }
        }
    }

    public void buildRes(Object currentEntity, String parentId, Object baseEntity, IDataEntityType currentEntityType) {
        for (IDataEntityProperty p : currentEntityType.getProperties()) {
            String Id = parentId + "." + p.getName();
            Object val = p.getValue(currentEntity);
            if (p instanceof ISimpleProperty) {
                if (p.getPropertyType() == null || !ILocaleValue.class.isAssignableFrom(p.getPropertyType())) continue;
                ILocaleValue baseLValue = (ILocaleValue)p.getValue(baseEntity);
                ILocaleValue currentLValue = (ILocaleValue)val;
                if (!(baseLValue == null || currentLValue == null && baseLValue != null || baseLValue.get((Object)this.sourceLocaleId) != null && currentLValue.get((Object)this.sourceLocaleId) != null && !baseLValue.get((Object)this.sourceLocaleId).equals(currentLValue.get((Object)this.sourceLocaleId))) && (baseLValue.get((Object)this.destLocaleId) == null || currentLValue.get((Object)this.destLocaleId) == null || baseLValue.get((Object)this.destLocaleId).equals(currentLValue.get((Object)this.destLocaleId)))) continue;
                LocaleItem item = new LocaleItem();
                item.setId(Id);
                item.setInherited(true);
                item.setDataEntity(currentEntity);
                item.setProperty((ISimpleProperty)p);
                this.localeItems.add(item);
                continue;
            }
            if (p instanceof IComplexProperty) {
                Object baseVal = p.getValue(baseEntity);
                this.builderResouces(val, Id, baseVal);
                continue;
            }
            if (!(p instanceof ICollectionProperty)) continue;
            this.builderCollectionReources((ICollectionProperty)p, currentEntityType, currentEntity, baseEntity, Id);
        }
    }

    private void builderCollectionReources(ICollectionProperty property, IDataEntityType currentEntityType, Object currentEntity, Object baseEntity, String parentId) {
        Object currentValue = property.getValue(currentEntity);
        Object baseValue = property.getValue(baseEntity);
        if (currentValue == null) {
            return;
        }
        if (baseValue == null) {
            List listValue = (List)currentValue;
            for (Object objVal : listValue) {
                this.builderResouces(objVal, parentId);
            }
        } else {
            List currentList = (List)currentValue;
            List baseList = (List)baseValue;
            for (Object objVal : currentList) {
                Object baseVal = this.getBaseObject(baseList, objVal);
                String entryId = this.getPk(objVal).toString();
                if (objVal instanceof ComboItem) {
                    entryId = parentId + "." + entryId;
                }
                this.builderResouces(objVal, entryId, baseVal);
            }
        }
    }

    public Object getBaseObject(List<?> baseList, Object curentObject) {
        Object sPk = this.getPk(curentObject);
        for (Object baseObject : baseList) {
            Object tPk = this.getPk(baseObject);
            if (!tPk.equals(sPk)) continue;
            return baseObject;
        }
        return null;
    }

    private Object getPk(Object obj) {
        ISimpleProperty pkProp = this.binder.getDataEntityType(obj).getPrimaryKey();
        if (pkProp == null) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u53d1\u73b0\u5176\u660e\u7ec6\u7c7b\u578b%s\u6ca1\u6709\u5b9a\u4e49\u4e3b\u952e\u3002", (String)"LangItemBuilder_0", (SubSystemType)SubSystemType.BOS, (Object[])new Object[0]), this.binder.getDataEntityType(obj).getName()));
        }
        Object pk = pkProp.getValue(obj);
        if (pk == null) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u53d1\u73b0\u5176\u660e\u7ec6\u7c7b\u578b\u4e3b\u952e\u4e3a\u7a7a\u3002", (String)"LangItemBuilder_1", (SubSystemType)SubSystemType.BOS, (Object[])new Object[0]), new Object[0]));
        }
        return pk;
    }

    private boolean shouldCompare(IDataEntityType currentEntityType, Object baseEntity) {
        if (baseEntity != null) {
            IDataEntityType baseEntityType = this.binder.getDataEntityType(baseEntity);
            return currentEntityType == baseEntityType;
        }
        return false;
    }
}

