/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.lang;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.rule.ObjectMapper;

public class LangResource {
    private static Log log = LogFactory.getLog(LangResource.class);

    public static <T> T loadResourceByUrl(URL url, Class<T> serClass) {
        Object result = null;
        StringBuilder sBuffer = new StringBuilder();
        try {
            String path;
            if (url == null) {
                return serClass.newInstance();
            }
            if (Lang.defaultLang() == Lang.get()) {
                path = url.toExternalForm();
            } else {
                String resPath = url.toExternalForm();
                String currentLang = Lang.get().toString();
                int lastDot = resPath.lastIndexOf(46);
                if (-1 != lastDot) {
                    String prefix = resPath.substring(0, lastDot);
                    String suffix = resPath.substring(lastDot);
                    path = prefix + '.' + currentLang + suffix;
                } else {
                    path = url.toExternalForm();
                }
            }
            try (BufferedReader xmlStringReader = new BufferedReader(new InputStreamReader(new URL(path).openStream(), "UTF-8"));){
                String s;
                while ((s = xmlStringReader.readLine()) != null) {
                    sBuffer.append(s);
                }
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
            result = ObjectMapper.fromXML(sBuffer.toString(), serClass);
        }
        catch (Exception e) {
            try {
                result = serClass.newInstance();
            }
            catch (Exception exception) {
                result = null;
            }
        }
        return (T)result;
    }
}

