/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.treebuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.businessfield.AbstractBasedataField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.MasterIdField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.treebuilder.BuildHelper;
import kd.bos.metadata.treebuilder.EntityFieldTreeBuildOption;
import kd.bos.metadata.treebuilder.IFormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildHelper;

class EntityFieldTreeBuilderImpl
implements IFormTreeBuilder {
    private EntityMetadata entityMetadata;
    private MainEntity rootEntity;
    private EntityFieldTreeBuildOption option;
    private boolean includeHead = true;
    private Set<String> matchedEntitys = new HashSet<String>();

    private void initParameter() {
        if (StringUtils.isNotBlank((CharSequence)this.option.getCurrentEntity())) {
            this.matchedEntitys.add(this.option.getCurrentEntity());
            EntityItem<?> currItem = this.entityMetadata.getItemById(this.option.getCurrentEntity());
            if (currItem != null) {
                boolean bl = this.includeHead = this.option.isIncludeParentEntity() || currItem instanceof MainEntity;
                if (this.option.isIncludeParentEntity() && currItem instanceof SubEntryEntity) {
                    this.matchedEntitys.add(currItem.getParentId());
                }
                if (this.option.isIncludeChildEntity()) {
                    for (EntityItem entityItem : this.entityMetadata.getEntitys()) {
                        if (!StringUtils.equals((CharSequence)currItem.getId(), (CharSequence)entityItem.getParentId())) continue;
                        this.matchedEntitys.add(entityItem.getId());
                    }
                }
            }
        }
    }

    public EntityFieldTreeBuilderImpl(EntityMetadata entityMetadata, EntityFieldTreeBuildOption option) {
        this.entityMetadata = entityMetadata;
        this.entityMetadata.createIndex();
        this.rootEntity = this.entityMetadata.getRootEntity();
        this.option = option;
        if (this.option == null) {
            this.option = new EntityFieldTreeBuildOption();
        }
        this.initParameter();
    }

    @Override
    public TreeNode build() {
        TreeNode root = this.buildRootNode();
        for (Entity<?, ?> entity : this.entityMetadata.getEntitys()) {
            if (!(entity instanceof MainEntity) ? this.option.isOnlyBillHead() || !this.canAddEntry(entity) : !this.includeHead) continue;
            TreeNode entityNode = this.buildEntityAndFields(entity);
            if (entityNode == null || entityNode.getChildren() == null || entityNode.getChildren().isEmpty()) continue;
            root.addChild(entityNode);
        }
        return root;
    }

    private TreeNode buildRootNode() {
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(this.rootEntity.getKey());
        root.setIsOpened(true);
        root.setData((Object)this.rootEntity.getId());
        if (this.rootEntity.getName() == null) {
            root.setText(this.rootEntity.getKey());
        } else {
            root.setText(this.rootEntity.getName().toString());
            root.setLongText(root.getText());
        }
        return root;
    }

    private TreeNode buildEntityNode(Entity<?, ?> entity) {
        TreeNode entityNode = new TreeNode();
        if (entity instanceof MainEntity) {
            entityNode.setParentid(this.rootEntity.getKey());
            entityNode.setId("_headNode_");
            entityNode.setData((Object)this.rootEntity.getId());
            entityNode.setText(ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"EntityFieldTreeBuilderImpl_0", (String)"bos-metadata", (Object[])new Object[0]));
            entityNode.setLongText(entityNode.getText());
        } else {
            String entityTypeName;
            entityNode.setParentid(this.rootEntity.getKey());
            entityNode.setId(entity.getKey());
            entityNode.setData((Object)entity.getId());
            String string = entityTypeName = entity instanceof SubEntryEntity ? ResManager.loadKDString((String)"(\u5b50\u5355\u636e\u4f53)", (String)"EntityFieldTreeBuilderImpl_1", (String)"bos-metadata", (Object[])new Object[0]) : ResManager.loadKDString((String)"(\u5355\u636e\u4f53)", (String)"EntityFieldTreeBuilderImpl_2", (String)"bos-metadata", (Object[])new Object[0]);
            if (entity.getName() == null) {
                entityNode.setText(entity.getKey() + entityTypeName);
            } else {
                entityNode.setText(entity.getName().toString() + entityTypeName);
            }
            entityNode.setLongText(entity.getName().toString());
        }
        return entityNode;
    }

    private TreeNode buildEntityAndFields(Entity<?, ?> entity) {
        TreeNode entityNode = this.buildEntityNode(entity);
        String entityText = null;
        if (!(entity instanceof MainEntity)) {
            entityText = entity.getName().toString();
        }
        if (this.option.isIncludePKField()) {
            entityNode.addChildren(this.buildPKFieldNode(entity, entityNode));
        }
        for (EntityItem<?> entityItem : entity.getItems()) {
            TreeNode bdFldNode;
            if (!(entityItem instanceof Field) || !this.canAddField((Field)entityItem)) continue;
            if (entityItem instanceof MulBasedataField) {
                TreeNode muliBDFldNode = this.buildMuliBaseFieldNode((MulBasedataField)entityItem, entityNode, entityText);
                if (muliBDFldNode == null) continue;
                entityNode.addChild(muliBDFldNode);
                continue;
            }
            if (entityItem instanceof BasedataField) {
                bdFldNode = this.buildBaseFieldNode((AbstractBasedataField)entityItem, entityNode, entityText);
                if (bdFldNode == null) continue;
                entityNode.addChild(bdFldNode);
                continue;
            }
            if (entityItem instanceof MasterIdField && ((MasterIdField)entityItem).getMasterIdType() == 2) {
                bdFldNode = this.buildBaseFieldNode((AbstractBasedataField)entityItem, entityNode, entityText);
                if (bdFldNode == null) continue;
                entityNode.addChild(bdFldNode);
                continue;
            }
            if (!this.option.isOutKey()) {
                entityNode.addChild(this.buildFieldNode((Field)entityItem, entityNode, entityText));
                continue;
            }
            List<TreeNode> childNodes = this.buildPropNodes((Field)entityItem, entityNode, entityText);
            for (TreeNode node : childNodes) {
                entityNode.addChild(node);
            }
        }
        return entityNode;
    }

    private TreeNode buildBaseFieldNode(AbstractBasedataField<?> bdField, TreeNode parentNode, String parentText) {
        String capPreFix;
        TreeNode bdFieldNode = null;
        bdFieldNode = this.buildFieldNode(bdField, parentNode, parentText);
        String string = capPreFix = bdField.getName() == null ? bdField.getKey() : bdField.getName().toString();
        if (this.option.isIncludeBDRefProp()) {
            String refBaseEntityId = bdField.getBaseEntityId();
            if (StringUtils.isBlank((CharSequence)refBaseEntityId)) {
                return bdFieldNode;
            }
            String refBaseEntityNumber = MetadataDao.getEntityNumberById(refBaseEntityId);
            if (refBaseEntityNumber == null) {
                return bdFieldNode;
            }
            if (bdFieldNode == null) {
                bdFieldNode = this.buildFieldNode(bdField, parentNode, parentText);
            }
            BasedataEntityType dt = null;
            if (bdField instanceof MasterIdField && this.option.isIncludeAllMasterProps()) {
                dt = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)refBaseEntityNumber);
                String string2 = capPreFix = dt.getDisplayName() == null ? capPreFix : dt.getDisplayName().toString();
                if (this.option.isOutTextWithKey()) {
                    bdFieldNode.setText(capPreFix + "(" + bdField.getKey() + ")");
                } else {
                    bdFieldNode.setText(capPreFix);
                }
            } else {
                dt = (BasedataEntityType)EntityMetadataCache.getSubDataEntityType((String)refBaseEntityNumber, (Collection)bdField.getRuntimeRefProps());
            }
            List<TreeNode> refPropNodes = PropTreeBuildHelper.buildRefBaseDataTypeNodes((MainEntityType)dt, bdFieldNode, bdField.getKey(), capPreFix, this.option);
            if (!refPropNodes.isEmpty()) {
                TreeNode idNode = PropTreeBuildHelper.buildPropNode((IDataEntityProperty)dt.getPrimaryKey(), bdFieldNode, bdField.getKey(), "", this.option.isDynamicText());
                idNode.setText(String.format(ResManager.loadKDString((String)"%1$s.\u5185\u7801(%2$s)", (String)"EntityFieldTreeBuilderImpl_5", (String)"bos-metadata", (Object[])new Object[0]), capPreFix, idNode.getId()));
                String longText = idNode.getText();
                if (StringUtils.isNotBlank((CharSequence)parentText)) {
                    longText = parentText + "." + longText;
                }
                idNode.setLongText(longText);
                bdFieldNode.addChild(idNode);
                for (TreeNode refPropNode : refPropNodes) {
                    String text = refPropNode.getText();
                    if (StringUtils.isNotBlank((CharSequence)parentText)) {
                        refPropNode.setLongText(parentText + "." + text);
                        continue;
                    }
                    refPropNode.setLongText(text);
                }
                bdFieldNode.addChildren(refPropNodes);
            }
        }
        return bdFieldNode;
    }

    private TreeNode buildMuliBaseFieldNode(MulBasedataField muliBDField, TreeNode parentNode, String parentText) {
        TreeNode bdFieldNode = null;
        bdFieldNode = this.buildFieldNode(muliBDField, parentNode, parentText);
        if (this.option.isIncludeBDRefProp()) {
            BasedataEntityType dt;
            List<TreeNode> refPropNodes;
            String refBaseEntityId = muliBDField.getBaseEntityId();
            if (StringUtils.isBlank((CharSequence)refBaseEntityId)) {
                return bdFieldNode;
            }
            String refBaseEntityNumber = MetadataDao.getEntityNumberById(refBaseEntityId);
            if (refBaseEntityNumber == null) {
                return bdFieldNode;
            }
            if (bdFieldNode == null) {
                bdFieldNode = this.buildFieldNode(muliBDField, parentNode, parentText);
            }
            if (!(refPropNodes = PropTreeBuildHelper.buildRefBaseDataTypeNodes((MainEntityType)(dt = (BasedataEntityType)EntityMetadataCache.getSubDataEntityType((String)refBaseEntityNumber, (Collection)muliBDField.getRuntimeRefProps())), bdFieldNode, muliBDField.getKey(), muliBDField.getName().toString(), this.option)).isEmpty()) {
                TreeNode idNode = PropTreeBuildHelper.buildPropNode((IDataEntityProperty)dt.getPrimaryKey(), bdFieldNode, muliBDField.getKey(), "", this.option.isDynamicText());
                idNode.setText(String.format(ResManager.loadKDString((String)"%s.\u5185\u7801", (String)"EntityFieldTreeBuilderImpl_6", (String)"bos-metadata", (Object[])new Object[0]), muliBDField.getName().toString()));
                refPropNodes.add(idNode);
                Iterator<TreeNode> refPropNodeItertor = refPropNodes.iterator();
                while (refPropNodeItertor.hasNext()) {
                    int length;
                    String[] ids;
                    TreeNode refPropNode = refPropNodeItertor.next();
                    String text = refPropNode.getText();
                    if (StringUtils.isNotBlank((CharSequence)parentText)) {
                        refPropNode.setLongText(parentText + "." + text);
                    } else {
                        refPropNode.setLongText(text);
                    }
                    if (!this.option.isSpecialTreatmentMulBDProp() || (ids = refPropNode.getId().split("\\."))[(length = ids.length) - 1].equals(dt.getNameProperty()) || ids[length - 1].equals(dt.getNumberProperty())) continue;
                    refPropNodeItertor.remove();
                }
                bdFieldNode.addChildren(refPropNodes);
            }
        }
        return bdFieldNode;
    }

    private List<TreeNode> buildPKFieldNode(Entity<?, ?> entity, TreeNode parentNode) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        TreeNode idNode = new TreeNode(parentNode.getId(), entity.getKey() + ".id", String.format(ResManager.loadKDString((String)"%s.\u5185\u7801", (String)"EntityFieldTreeBuilderImpl_6", (String)"bos-metadata", (Object[])new Object[0]), entity.getName().toString()));
        nodes.add(idNode);
        if (entity instanceof EntryEntity) {
            TreeNode seqNode = new TreeNode(parentNode.getId(), entity.getKey() + ".seq", String.format(ResManager.loadKDString((String)"%s.\u5e8f\u53f7", (String)"EntityFieldTreeBuilderImpl_7", (String)"bos-metadata", (Object[])new Object[0]), entity.getName().toString()));
            nodes.add(seqNode);
        }
        return nodes;
    }

    private TreeNode buildFieldNode(Field<?> field, TreeNode parentNode, String parentText) {
        TreeNode node = new TreeNode();
        node.setParentid(parentNode.getId());
        node.setId(this.option.isOutKey() ? field.getKey() : field.getId());
        node.setData((Object)field.getId());
        node.setType(field.getClass().getSimpleName());
        if (this.option.isOutTextWithKey()) {
            node.setText(field.getName().toString() + "(" + field.getKey() + ")");
        } else {
            node.setText(field.getName().toString());
        }
        String longText = node.getText();
        if (StringUtils.isNotBlank((CharSequence)parentText)) {
            longText = parentText + "." + longText;
        }
        node.setLongText(longText);
        return node;
    }

    private List<TreeNode> buildPropNodes(Field<?> field, TreeNode parentNode, String parentText) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        List<Map<String, Object>> items = field.createEntityTreeNodes(true, 2, false);
        for (Map<String, Object> item : items) {
            String key = (String)item.get("Id");
            String name = (String)item.get("Name");
            TreeNode node = new TreeNode();
            node.setParentid(parentNode.getId());
            node.setId(key);
            node.setData((Object)key);
            node.setType((String)item.get("Type"));
            if (this.option.isOutTextWithKey()) {
                node.setText(name + "(" + key + ")");
            } else {
                node.setText(name);
            }
            String longText = node.getText();
            if (StringUtils.isNotBlank((CharSequence)parentText)) {
                longText = parentText + "." + longText;
            }
            node.setLongText(longText);
            nodes.add(node);
        }
        return nodes;
    }

    private boolean canAddEntry(Entity<?, ?> entity) {
        if (!this.matchedEntitys.isEmpty()) {
            return this.matchedEntitys.contains(entity.getId()) || this.matchedEntitys.contains(entity.getKey());
        }
        return true;
    }

    private boolean canAddField(Field<?> field) {
        if (BuildHelper.isAssignableFrom(this.option.getInvalidClassTypes(), field.getClass())) {
            return false;
        }
        return this.option.getMatchedClassTypes().isEmpty() || BuildHelper.isAssignableFrom(this.option.getMatchedClassTypes(), field.getClass());
    }
}

