/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.treebuilder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.RefEntityTypeCache;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.tree.TreeNode;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.treebuilder.ControlsAndFieldTreeBuilder;
import kd.bos.metadata.treebuilder.ControlsTreeBuildOption;
import kd.bos.metadata.treebuilder.ControlsTreeBuilderImpl;
import kd.bos.metadata.treebuilder.EntityFieldTreeBuildOption;
import kd.bos.metadata.treebuilder.EntityFieldTreeBuilderImpl;
import kd.bos.metadata.treebuilder.FilterFieldBuildOption;
import kd.bos.metadata.treebuilder.FilterFieldBuilderImpl;
import kd.bos.metadata.treebuilder.FormFieldTreeBuildOption;
import kd.bos.metadata.treebuilder.FormFieldTreeBuilderImpl;
import kd.bos.metadata.treebuilder.PrintEntityFieldTreeBuilderImpl;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.metadata.treebuilder.PropTreeBuilderImpl;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FormTreeBuilder {
    public static TreeNode buildControlsTree(List<Map<String, Object>> formContext, ControlsTreeBuildOption option) {
        FormMetadata formMetadata = FormTreeBuilder.deserialzeFormMetadata(formContext);
        ControlsTreeBuilderImpl builder = new ControlsTreeBuilderImpl(formMetadata, option);
        return builder.build();
    }

    public static TreeNode buildFormFieldTree(List<Map<String, Object>> formContext, List<Map<String, Object>> entityContext, FormFieldTreeBuildOption option) {
        FormMetadata formMetadata = FormTreeBuilder.deserialzeFormMetadata(formContext);
        EntityMetadata entityMetadata = entityContext == null ? null : FormTreeBuilder.deserializeEntityMetadata(entityContext);
        FormFieldTreeBuilderImpl builder = new FormFieldTreeBuilderImpl(formMetadata, entityMetadata, option);
        return builder.build();
    }

    public static TreeNode buildFormFieldControlsTree(FormMetadata formMetadata, ControlsTreeBuildOption option) {
        ControlsAndFieldTreeBuilder builder = new ControlsAndFieldTreeBuilder(formMetadata, option);
        return builder.build();
    }

    public static TreeNode buildEntityFieldsTree(List<Map<String, Object>> entityContext, EntityFieldTreeBuildOption option) {
        EntityMetadata entityMetadata = FormTreeBuilder.deserializeEntityMetadata(entityContext);
        EntityFieldTreeBuilderImpl builder = new EntityFieldTreeBuilderImpl(entityMetadata, option);
        return builder.build();
    }

    public static TreeNode buildEntityFieldsTree(EntityMetadata entityMetadata, EntityFieldTreeBuildOption option) {
        EntityFieldTreeBuilderImpl builder = new EntityFieldTreeBuilderImpl(entityMetadata, option);
        return builder.build();
    }

    public static TreeNode buildPrintEntityFieldsTree(EntityMetadata entityMetadata, EntityFieldTreeBuildOption option) {
        PrintEntityFieldTreeBuilderImpl builder = new PrintEntityFieldTreeBuilderImpl(entityMetadata, option);
        return builder.build();
    }

    public static TreeNode buildDynamicPropertyTree(MainEntityType mainType, PropTreeBuildOption option) {
        PropTreeBuilderImpl builder = new PropTreeBuilderImpl(mainType, option);
        return builder.build();
    }

    public static TreeNode buildRefEntityTree(String entityNumber, PropTreeBuildOption option) {
        RefEntityType refEntityType = RefEntityTypeCache.getRefEntityType((String)entityNumber, (boolean)true);
        return FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)refEntityType, option);
    }

    public static List<FilterField> buildFilterFields(MainEntityType mainType, FilterFieldBuildOption option) {
        FilterFieldBuilderImpl filterFieldBuilderImpl = new FilterFieldBuilderImpl(mainType, option);
        return filterFieldBuilderImpl.buildFilterFields();
    }

    public static List<Map<String, Object>> buildFilterColumns(MainEntityType mainType, FilterFieldBuildOption option) {
        FilterFieldBuilderImpl filterFieldBuilderImpl = new FilterFieldBuilderImpl(mainType, option);
        return filterFieldBuilderImpl.buildFilterColumns();
    }

    public static FormMetadata deserialzeFormMetadata(List<Map<String, Object>> formContext) {
        HashMap<String, Object> formMeta = new HashMap<String, Object>();
        formMeta.put("Items", formContext);
        formMeta.put("_Type_", "FormMetadata");
        String formType = formContext.get(0).get("_Type_").toString();
        String modelType = EntityMetadataUtil.getModelTypeByForm(formType);
        MetadataSerializer template = new MetadataSerializer(modelType);
        return (FormMetadata)template.deserializeFromMap(formMeta, null);
    }

    public static EntityMetadata deserializeEntityMetadata(List<Map<String, Object>> entityContext) {
        HashMap<String, Object> formMeta = new HashMap<String, Object>();
        entityContext.get(0).remove("ReportFilterMeta");
        formMeta.put("Items", entityContext);
        formMeta.put("_Type_", "EntityMetadata");
        String type = entityContext.get(0).get("_Type_").toString();
        String modelType = EntityMetadataUtil.getModelTypeByEntity(type);
        MetadataSerializer template = new MetadataSerializer(modelType);
        return (EntityMetadata)template.deserializeFromMap(formMeta, null);
    }

    public static Object deserializeElement(String modelType, Map<String, Object> item) {
        MetadataSerializer template = new MetadataSerializer(modelType);
        return template.deserializeFromMap(item, null);
    }
}

