/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.treebuilder;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;

public class MulFieldTreePlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TreeNodeCheckListener {
    private static final Log LOG = LogFactory.getLog(MulFieldTreePlugin.class);
    private static final String TREEVIEW_FIELD = "fieldtree";
    private static final String BTN_OK = "btnok";
    private static final String BTN_REMOVE = "btnremove";
    private static final String ENTRY_SELECTED_FIELDS = "selectfields";
    private static final String FIELD_DISPLAY_NAME = "ftdisplayname";
    private static final String FIELD_NAME = "ftname";
    private static final String CACHE_TREE_NODES = "treenodes";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_OK, BTN_REMOVE});
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_SELECTED_FIELDS);
        grid.addRowClickListener((RowClickEventListener)this);
        TreeView fieldtree = (TreeView)this.getView().getControl(TREEVIEW_FIELD);
        fieldtree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        TreeNode rootNode = this.initTreeNodes();
        this.initSelectedFields(rootNode);
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (ENTRY_SELECTED_FIELDS.equals(source.getKey())) {
            this.delete();
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_REMOVE.equals(key)) {
            this.delete();
        } else if (BTN_OK.equals(key)) {
            this.returnData();
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        String json = this.getPageCache().getBigObject(CACHE_TREE_NODES);
        if (StringUtils.isBlank((CharSequence)json)) {
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEW_FIELD);
        List currChecks = tree.getTreeState().getCheckedNodeIds();
        List<String> checkNodes = this.getSelectFields();
        IDataModel model = this.getModel();
        if (evt.getChecked().booleanValue()) {
            if (checkNodes.isEmpty() || currChecks.removeAll(checkNodes)) {
                if (currChecks.isEmpty()) {
                    return;
                }
                for (String id : currChecks) {
                    TreeNode node = root.getTreeNode(id, 16);
                    if (node == null || node.getChildren() != null) continue;
                    int row = model.createNewEntryRow(ENTRY_SELECTED_FIELDS);
                    model.setValue(FIELD_NAME, (Object)node.getId(), row);
                    model.setValue(FIELD_DISPLAY_NAME, (Object)node.getText(), row);
                }
            }
        } else if (currChecks.isEmpty() || checkNodes.removeAll(currChecks)) {
            for (int i = 0; i < checkNodes.size(); ++i) {
                TreeNode node = root.getTreeNode(checkNodes.get(i), 16);
                if (node == null || node.getChildren() == null) continue;
                checkNodes.remove(i);
            }
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i = model.getEntryRowCount(ENTRY_SELECTED_FIELDS) - 1; i >= 0; --i) {
                if (!checkNodes.contains(model.getValue(FIELD_NAME, i))) continue;
                list.add(i);
            }
            int[] rows = list.stream().mapToInt(Integer::valueOf).toArray();
            model.deleteEntryRows(ENTRY_SELECTED_FIELDS, rows);
        }
    }

    protected void returnData() {
        List<String> fieldKeys = this.getSelectFields();
        String selectedFields = "";
        if (!fieldKeys.isEmpty()) {
            selectedFields = StringUtils.join((Object[])fieldKeys.toArray(), (String)",");
        }
        this.getView().returnDataToParent((Object)selectedFields);
        this.getView().close();
    }

    private void delete() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_SELECTED_FIELDS);
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        IDataModel model = this.getModel();
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (int row : rows) {
            if (row < 0) continue;
            nodeIds.add((String)model.getValue(FIELD_NAME, row));
        }
        model.deleteEntryRows(ENTRY_SELECTED_FIELDS, rows);
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEW_FIELD);
        tree.uncheckNodes(nodeIds);
    }

    private TreeNode initTreeNodes() {
        String json = this.getNodeFromParent();
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        TreeNode rootNode = null;
        if (StringUtils.isNotBlank((CharSequence)json)) {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        } else if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            rootNode = this.buildTreeRootNode(entityNumber);
            json = SerializationUtils.toJsonString((Object)rootNode);
        }
        if (rootNode == null) {
            return new TreeNode("", "0", "");
        }
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEW_FIELD);
        tree.addNode(rootNode);
        this.getPageCache().putBigObject(CACHE_TREE_NODES, json);
        return rootNode;
    }

    private String getNodeFromParent() {
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        if (StringUtils.isBlank((CharSequence)parentPageId)) {
            return null;
        }
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        if (parentView == null) {
            return null;
        }
        return parentView.getPageCache().getBigObject("fieldtreeshow_treenodejson");
    }

    private TreeNode buildTreeRootNode(String entityNumber) {
        MainEntityType mainEntityType = null;
        try {
            mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        }
        catch (RuntimeException exp) {
            LOG.error((Throwable)exp);
            return null;
        }
        PropTreeBuildOption option = new PropTreeBuildOption();
        return FormTreeBuilder.buildDynamicPropertyTree(mainEntityType, option);
    }

    private void initSelectedFields(TreeNode rootNode) {
        String selectedFields = (String)this.getView().getFormShowParameter().getCustomParam("selectedfields");
        if (StringUtils.isBlank((CharSequence)selectedFields)) {
            return;
        }
        String[] fieldKeys = StringUtils.split((String)selectedFields, (String)",");
        this.getModel().batchCreateNewEntryRow(ENTRY_SELECTED_FIELDS, fieldKeys.length);
        ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>(fieldKeys.length);
        for (int i = 0; i < fieldKeys.length; ++i) {
            String fieldKey = fieldKeys[i];
            TreeNode node = rootNode.getTreeNode(fieldKey, 16);
            if (node == null) {
                this.getModel().setValue(FIELD_DISPLAY_NAME, (Object)fieldKey, i);
                this.getModel().setValue(FIELD_NAME, (Object)fieldKey, i);
                continue;
            }
            checkNodes.add(node);
            this.getModel().setValue(FIELD_DISPLAY_NAME, (Object)node.getText(), i);
            this.getModel().setValue(FIELD_NAME, (Object)fieldKey, i);
        }
        if (!checkNodes.isEmpty()) {
            TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW_FIELD);
            treeView.checkNodes(checkNodes);
        }
    }

    private List<String> getSelectFields() {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection(ENTRY_SELECTED_FIELDS);
        ArrayList<String> fieldKeys = new ArrayList<String>(rows.size());
        for (DynamicObject row : rows) {
            String fieldKey = row.getString(FIELD_NAME);
            if (!StringUtils.isNotBlank((CharSequence)fieldKey)) continue;
            fieldKeys.add(fieldKey);
        }
        return fieldKeys;
    }
}

