/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.vercompare;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.DefaultSyncFunction;
import kd.bos.dataentity.IListSyncFunction;
import kd.bos.dataentity.ListSync;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.DataEntityTypeFlag;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.SubSystemType;
import kd.bos.dataentity.serialization.DcAction;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.IBindEqualsFunc;
import kd.bos.dataentity.serialization.IBindToStringFunc;
import kd.bos.dataentity.serialization.ISupplier;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.metadata.vercompare.DcTreeNode;
import org.apache.commons.beanutils.ConvertUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

class DcTreeSerializerWriteImplement {
    private static final String BOS_METADATA = "bos-metadata";
    private static final String LIST_ITEM_EQUATABLE = "ListItemEquatable";
    private DcBinder binder;
    private boolean serializeComplexProperty;
    private boolean localeValueFull;
    private boolean onlyDiff = true;
    private Map<Class<?>, Tuple<IBindToStringFunc, Boolean>> convertToStrFuncCache;
    private Map<Class<?>, IBindEqualsFunc> equalsFuncCache;
    private RefObject<DcTreeNode> tempRef_serObj = new RefObject();
    private RefObject<Boolean> tempRef_isCData = new RefObject((Object)false);

    private static String getElement() {
        return ResManager.loadKDString((String)"\u5143\u7d20", (String)"DcTreeSerializerWriteImplement_1", (String)BOS_METADATA, (Object[])new Object[0]);
    }

    private static String getExtElement() {
        return ResManager.loadKDString((String)"\u6269\u5c55\u5143\u7d20", (String)"DcTreeSerializerWriteImplement_2", (String)BOS_METADATA, (Object[])new Object[0]);
    }

    public DcTreeSerializerWriteImplement(DcBinder binder, boolean serializeComplexProperty, boolean isLocaleValueFull) {
        this.binder = binder;
        this.serializeComplexProperty = serializeComplexProperty;
        this.localeValueFull = isLocaleValueFull;
        this.convertToStrFuncCache = new HashMap();
        this.equalsFuncCache = new HashMap();
    }

    public boolean isOnlyDiff() {
        return this.onlyDiff;
    }

    public void setOnlyDiff(boolean onlyDiff) {
        this.onlyDiff = onlyDiff;
    }

    public final DcTreeNode diffCompare(IDataEntityType dt, Object currentEntity, Object baseEntity) {
        DcTreeNode documentNode = new DcTreeNode();
        this.WriteObject(documentNode, dt, currentEntity, baseEntity, null);
        if (documentNode.isChildNodesEmpty() && this.onlyDiff) {
            return new DcTreeNode();
        }
        return documentNode.getChildNodes().get(0);
    }

    private DcTreeNode WriteObject(DcTreeNode parentNode, IDataEntityType currentEntityType, Object currentEntity, Object baseEntity, DcAction action) {
        if (currentEntity == null) {
            throw new IllegalArgumentException("currentEntity");
        }
        DcTreeNode entityNode = null;
        currentEntityType = this.WriteObjectElement(parentNode, currentEntityType, currentEntity, baseEntity, action, this.tempRef_serObj);
        entityNode = (DcTreeNode)this.tempRef_serObj.argvalue;
        if (this.shouldCompare(currentEntityType, baseEntity)) {
            entityNode.setAction("edit");
            if (currentEntityType.getFlag() != DataEntityTypeFlag.Primitive) {
                for (IDataEntityProperty p : currentEntityType.getProperties()) {
                    if (this.binder.getOnlyDbProperty() && p.isDbIgnore()) continue;
                    ISimpleProperty sp = (ISimpleProperty)(p instanceof ISimpleProperty ? p : null);
                    if (sp != null) {
                        this.WriteSimpleProperties(entityNode, sp, currentEntity, baseEntity);
                        continue;
                    }
                    IComplexProperty cpx = (IComplexProperty)(p instanceof IComplexProperty ? p : null);
                    if (cpx != null && this.serializeComplexProperty) {
                        this.WriteComplexProperties(entityNode, cpx, currentEntity, baseEntity);
                        continue;
                    }
                    ICollectionProperty cp = (ICollectionProperty)(p instanceof ICollectionProperty ? p : null);
                    if (cp == null) continue;
                    this.WriteCollectionProperties(entityNode, cp, currentEntityType, currentEntity, baseEntity);
                }
                Element customProps = DocumentHelper.createElement((String)"customProps");
                this.binder.writeCustomXmlProperties(customProps, currentEntity, baseEntity);
                Map<String, Object> custProps = this.getCustomProps(customProps);
                if (!custProps.isEmpty()) {
                    entityNode.setCustProps(custProps);
                }
            }
        } else {
            if (currentEntityType.getFlag() != DataEntityTypeFlag.Primitive) {
                for (IDataEntityProperty p : currentEntityType.getProperties()) {
                    if (this.binder.getOnlyDbProperty() && p.isDbIgnore()) continue;
                    ISimpleProperty sp = (ISimpleProperty)(p instanceof ISimpleProperty ? p : null);
                    if (sp != null) {
                        this.WriteSimpleProperties_S(entityNode, sp, currentEntity);
                        continue;
                    }
                    IComplexProperty cpx = (IComplexProperty)(p instanceof IComplexProperty ? p : null);
                    if (cpx != null && this.serializeComplexProperty) {
                        this.WriteComplexProperties_S(entityNode, cpx, currentEntity);
                        continue;
                    }
                    ICollectionProperty cp = (ICollectionProperty)(p instanceof ICollectionProperty ? p : null);
                    if (cp == null) continue;
                    this.WriteCollectionProperties_S(entityNode, cp, currentEntity);
                }
            }
            Element customProps = DocumentHelper.createElement((String)"customProps");
            this.binder.writeCustomXmlProperties(customProps, currentEntity, baseEntity);
            Map<String, Object> custProps = this.getCustomProps(customProps);
            if (!custProps.isEmpty()) {
                entityNode.setCustProps(custProps);
            }
        }
        return entityNode;
    }

    private Map<String, Object> getCustomProps(Element element) {
        List elements = element.elements();
        HashMap<String, Object> customProps = new HashMap<String, Object>(16);
        for (Element ele : elements) {
            String name = ele.getName();
            String text = ele.getText();
            customProps.put(name, text);
        }
        return customProps;
    }

    private IDataEntityType WriteObjectElement(DcTreeNode parentNode, IDataEntityType dt, Object entity, Object baseEntity, DcAction action, RefObject<DcTreeNode> serObj) {
        Object pkTemp;
        IDataEntityType newDt = this.getDataEntityType(entity);
        if (newDt != null && !newDt.equals(dt)) {
            dt = newDt;
        }
        DcTreeNode arrObj = parentNode.addComplexNode(this.binder.bindToName(dt), dt.getDisplayName());
        if (dt == null) {
            throw new ORMDesignException("??????", String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%s\u5fc5\u987b\u5b9e\u73b0IDataEntityBase\u624d\u80fd\u8fdb\u884c\u5e8f\u5217\u5316\u64cd\u4f5c\u3002", (String)"DcTreeSerializerWriteImplement_0", (String)BOS_METADATA, (Object[])new Object[0]), entity.getClass().getName()));
        }
        serObj.argvalue = arrObj;
        Map attributes = this.binder.getDataEntityAttributes(entity);
        arrObj.putAttributes(attributes);
        ISimpleProperty pk = dt.getPrimaryKey();
        String pkValue = null;
        if (pk != null && (pkTemp = pk.getValue(entity)) != null) {
            pkValue = this.convertToString(pk, entity, pkTemp);
        }
        if (baseEntity == null && action == null) {
            action = DcAction.ListAction_Add;
        }
        if (action != null && !DcAction.ListAction_Add.equals(action)) {
            arrObj.setAction(action.getActionName());
            assert (StringUtils.isNotEmpty((CharSequence)pkValue));
        }
        arrObj.setItemId(pkValue);
        IDataEntityProperty nameProp = (IDataEntityProperty)dt.getProperties().get((Object)"Name");
        if (nameProp instanceof ISimpleProperty) {
            arrObj.setItemName(this.convertToString((ISimpleProperty)nameProp, entity, nameProp.getValue(entity)));
        }
        return dt;
    }

    private void WriteSimpleProperties(DcTreeNode entityNode, ISimpleProperty property, Object currentEntity, Object baseEntity) {
        Object currentValue = property.getValue(currentEntity);
        Object baseValue = property.getValue(baseEntity);
        IBindEqualsFunc equalsFunc = this.getEqualsFunc(property.getPropertyType());
        boolean isEquals = equalsFunc.equals(currentValue, baseValue);
        if (!isEquals || !this.onlyDiff) {
            DcTreeNode propNode = entityNode.addSimplePropNode(property.getName(), property.getDisplayName());
            propNode.setAction("edit");
            this.tempRef_isCData.argvalue = false;
            String baseValueToString = this.convertToString(property, currentEntity, baseValue, this.tempRef_isCData);
            DcTreeNode.PropValue basePropValue = new DcTreeNode.PropValue(baseValueToString == null ? "" : baseValueToString);
            if (baseValue == null) {
                basePropValue.setAction("setnull");
            } else if (!this.binder.isSerializeDefaultValue() && !property.shouldSerializeValue(currentEntity)) {
                basePropValue.setAction("reset");
            }
            propNode.setBaseValue(basePropValue);
            String currValueToString = this.convertToString(property, currentEntity, currentValue, this.tempRef_isCData);
            DcTreeNode.PropValue currPropValue = new DcTreeNode.PropValue(currValueToString == null ? "" : currValueToString);
            if (currentValue == null) {
                currPropValue.setAction("setnull");
            } else if (!this.binder.isSerializeDefaultValue() && !property.shouldSerializeValue(currentEntity)) {
                currPropValue.setAction("reset");
            }
            propNode.setCurrValue(currPropValue);
        }
    }

    private void WriteSimpleProperties_S(DcTreeNode entityNode, ISimpleProperty property, Object entity) {
        if (this.binder.isSerializeDefaultValue() || property.shouldSerializeValue(entity)) {
            DcTreeNode propNode = entityNode.addSimplePropNode(property.getName(), property.getDisplayName());
            propNode.setCurrValue(new DcTreeNode.PropValue());
            Object value = property.getValue(entity);
            if (null == value) {
                propNode.getCurrValue().setAction("setnull");
            } else {
                this.tempRef_isCData.argvalue = false;
                String valueToString = this.convertToString(property, entity, value, this.tempRef_isCData);
                valueToString = valueToString == null ? "" : valueToString;
                propNode.getCurrValue().setValue(valueToString);
            }
        }
    }

    private void WriteComplexProperties(DcTreeNode entityNode, IComplexProperty property, Object currentEntity, Object baseEntity) {
        Object currentValue = property.getValue(currentEntity);
        Object baseValue = property.getValue(baseEntity);
        if (currentValue == null) {
            if (baseValue != null) {
                DcTreeNode propNode = entityNode.addComplexNode(property.getName(), property.getDisplayName());
                propNode.setAction("setnull");
            }
        } else {
            DcTreeNode propNode = entityNode.addComplexNode(property.getName(), property.getDisplayName());
            DcTreeNode propValueNode = this.WriteObject(propNode, property.getComplexType(), currentValue, baseValue, null);
            propNode.setAction(propValueNode.getAction());
            if (propValueNode.isChildNodesEmpty() && this.onlyDiff) {
                entityNode.remove(propNode);
            }
        }
    }

    private void WriteCollectionProperties(DcTreeNode entityNode, final ICollectionProperty property, final IDataEntityType currentEntityType, Object currentEntity, Object baseEntity) {
        Object currentValue = property.getValue(currentEntity);
        Object baseValue = property.getValue(baseEntity);
        if (currentValue == null) {
            if (baseValue != null) {
                this.WriteRemoveCollectionProperty(entityNode, property, baseValue);
            }
        } else if (baseValue == null) {
            this.WriteCollectionProperty(entityNode, property, currentValue);
        } else {
            ISupplier<String> getMessage = new ISupplier<String>(){

                public String get() {
                    return String.format(ResManager.loadKDString((String)"\u5728\u5e8f\u5217\u5316\u5bf9\u8c61%1$s\u7684\u96c6\u5408\u5c5e\u6027%2$s\u65f6%3$s", (String)"DcTreeSerializerReadImplement_02", (String)DcTreeSerializerWriteImplement.BOS_METADATA, (Object[])new Object[0]), currentEntityType.getName(), property.getName(), "\uff0c");
                }
            };
            final List currentList = (List)(currentValue instanceof List ? currentValue : null);
            if (currentList == null) {
                throw new OrmException("WriteCollectionProperties", String.format(ResManager.loadKDString((String)"%1$s\u53d1\u73b0\u5176(\u5f53\u524d\u5217\u8868)\u5c5e\u6027\u7684\u8fd4\u56de\u7c7b\u578b%2$s\u4e0d\u652f\u6301IEnumerable\u63a5\u53e3\u3002", (String)"DcTreeSerializerReadImplement_03", (String)BOS_METADATA, (Object[])new Object[0]), getMessage.get(), property.getPropertyType().getName()));
            }
            final List baseList = (List)(baseValue instanceof List ? baseValue : null);
            if (baseList == null) {
                throw new OrmException("WriteCollectionProperties", String.format(ResManager.loadKDString((String)"%1$s\u53d1\u73b0\u5176\uff08\u57fa\u5217\u8868\uff09\u5c5e\u6027\u7684\u8fd4\u56de\u7c7b\u578b%2$s\u4e0d\u652f\u6301IEnumerable\u63a5\u53e3\u3002", (String)"DcTreeSerializerReadImplement_04", (String)BOS_METADATA, (Object[])new Object[0]), getMessage.get(), property.getPropertyType().getSigners()));
            }
            LocaleString displayName = this.getElementLocalString(property);
            DcTreeNode collectionPropNode = entityNode.addCollectionNode(property.getName(), displayName);
            collectionPropNode.setAction("edit");
            DefaultSyncFunction<Object, Object> syncFunc = new DefaultSyncFunction<Object, Object>((ISupplier)getMessage, collectionPropNode, property){
                final /* synthetic */ ISupplier val$getMessage;
                final /* synthetic */ DcTreeNode val$collectionPropNode;
                final /* synthetic */ ICollectionProperty val$property;
                {
                    this.val$getMessage = iSupplier;
                    this.val$collectionPropNode = dcTreeNode;
                    this.val$property = iCollectionProperty;
                }

                public boolean equals(Object s, Object t) {
                    return DcTreeSerializerWriteImplement.this.listItemEquatable(currentList, baseList, s, t, (ISupplier<String>)this.val$getMessage);
                }

                public void update(Object s, Object t) {
                    DcTreeSerializerWriteImplement.this.WriteEditObject(this.val$collectionPropNode, this.val$property.getItemType(), s, t);
                }

                public void add(List<Object> col, Object item) {
                    DcTreeSerializerWriteImplement.this.WriteAddObject(this.val$collectionPropNode, this.val$property.getItemType(), item);
                }

                public Object create(Object o) {
                    return o;
                }

                public void remove(List<Object> col, Object item, int index) {
                    DcTreeSerializerWriteImplement.this.WriteRemoveObject(this.val$collectionPropNode, item);
                }
            };
            ListSync.Sync((List)currentList, (List)baseList, (IListSyncFunction)syncFunc, (boolean)false);
            if (collectionPropNode.isChildNodesEmpty()) {
                entityNode.remove(collectionPropNode);
            }
        }
    }

    private LocaleString getElementLocalString(ICollectionProperty property) {
        LocaleString displayName = property.getDisplayName();
        if (DcTreeSerializerWriteImplement.getElement().equals(displayName.getLocaleValue())) {
            displayName = new LocaleString(ResManager.loadKDString((String)"\u5143\u7d20", (String)"DcTreeSerializerWriteImplement_1", (String)BOS_METADATA, (Object[])new Object[0]));
        } else if (DcTreeSerializerWriteImplement.getExtElement().equals(displayName.getLocaleValue())) {
            displayName = new LocaleString(ResManager.loadKDString((String)"\u6269\u5c55\u5143\u7d20", (String)"DcTreeSerializerWriteImplement_2", (String)BOS_METADATA, (Object[])new Object[0]));
        }
        return displayName;
    }

    private void WriteEditObject(DcTreeNode collectionPropNode, IDataEntityType currentEntityType, Object currentEntity, Object baseEntity) {
        DcTreeNode val = this.WriteObject(collectionPropNode, currentEntityType, currentEntity, baseEntity, DcAction.ListAction_Edit);
        if (!this.IsNeedWrite(val)) {
            collectionPropNode.remove(val);
        }
    }

    private boolean IsNeedWrite(DcTreeNode val) {
        return !val.isChildNodesEmpty();
    }

    private void WriteAddObject(DcTreeNode collectionPropNode, IDataEntityType currentEntityType, Object currentEntity) {
        this.WriteObject(collectionPropNode, currentEntityType, currentEntity, null, DcAction.ListAction_Add);
    }

    private void WriteRemoveObject(DcTreeNode collectionPropNode, Object t) {
        IDataEntityType dt = this.getDataEntityType(t);
        if (dt != null) {
            ISimpleProperty pk = dt.getPrimaryKey();
            DcTreeNode item = collectionPropNode.addComplexNode(this.binder.bindToName(dt), dt.getDisplayName());
            item.setAction("remove");
            item.setItemId(this.convertToString(pk, t, pk.getValue(t)));
            IDataEntityProperty nameProp = (IDataEntityProperty)dt.getProperties().get((Object)"Name");
            if (nameProp instanceof ISimpleProperty) {
                item.setItemName(this.convertToString((ISimpleProperty)nameProp, t, nameProp.getValue(t)));
            }
        }
    }

    private void WriteCollectionProperties_S(DcTreeNode entityNode, ICollectionProperty property, Object entity) {
        this.WriteCollectionProperty(entityNode, property, property.getValue(entity));
    }

    private void WriteCollectionProperty(DcTreeNode entityNode, ICollectionProperty property, Object value) {
        List listValue = (List)(value instanceof List ? value : null);
        if (listValue != null && listValue.size() > 0) {
            LocaleString displayName = this.getElementLocalString(property);
            DcTreeNode collectionPropNode = entityNode.addCollectionNode(property.getName(), displayName);
            for (Object item : listValue) {
                this.WriteObject(collectionPropNode, property.getItemType(), item, null, DcAction.ListAction_Add);
            }
        }
    }

    private void WriteRemoveCollectionProperty(DcTreeNode entityNode, ICollectionProperty property, Object baseValue) {
        List listValue = (List)(baseValue instanceof List ? baseValue : null);
        if (listValue != null && listValue.size() > 0) {
            LocaleString displayName = this.getElementLocalString(property);
            DcTreeNode collectionPropNode = entityNode.addCollectionNode(property.getName(), displayName);
            for (Object item : listValue) {
                this.WriteRemoveObject(collectionPropNode, item);
            }
        }
    }

    private void WriteComplexProperties_S(DcTreeNode entityNode, IComplexProperty property, Object entity) {
        DcTreeNode propNode;
        DcTreeNode propValueNode;
        Object value = property.getValue(entity);
        if (value != null && (propValueNode = this.WriteObject(propNode = entityNode.addComplexNode(property.getName(), property.getDisplayName()), property.getComplexType(), value, null, null)).isChildNodesEmpty()) {
            entityNode.remove(propNode);
        }
    }

    protected boolean shouldCompare(IDataEntityType currentEntityType, Object baseEntity) {
        IDataEntityType baseEntityType;
        return baseEntity != null && currentEntityType.equals(baseEntityType = this.binder.getDataEntityType(baseEntity));
    }

    private IDataEntityType getDataEntityType(Object dataEntity) {
        if (dataEntity == null) {
            return null;
        }
        IDataEntityType dt = this.binder.tryBindToType(dataEntity.getClass().getSimpleName(), null);
        if (dt != null) {
            return dt;
        }
        return this.binder.getDataEntityType(dataEntity);
    }

    protected String convertToString(ISimpleProperty property, Object dataEntity, Object value) {
        if (value instanceof ILocaleValue && this.localeValueFull) {
            return SerializationUtils.toJsonString((Object)value);
        }
        if (value instanceof ILocaleValue) {
            RefObject tempRef_isCData = new RefObject((Object)false);
            IBindToStringFunc func = this.getConvertFunc(property.getPropertyType(), (RefObject<Boolean>)tempRef_isCData);
            String valueToString = func.apply(property, dataEntity, ((ILocaleValue)value).getItem(this.binder.getLCId()));
            return valueToString == null ? "" : valueToString;
        }
        if (value instanceof Map || value instanceof List) {
            return SerializationUtils.toJsonString((Object)value);
        }
        RefObject tempRef_isCData = new RefObject((Object)false);
        IBindToStringFunc func = this.getConvertFunc(property.getPropertyType(), (RefObject<Boolean>)tempRef_isCData);
        return func.apply(property, dataEntity, value);
    }

    private String convertToString(ISimpleProperty property, Object dataEntity, Object value, RefObject<Boolean> isCData) {
        if (value instanceof ILocaleValue && this.localeValueFull) {
            return SerializationUtils.toJsonString((Object)value);
        }
        if (value instanceof ILocaleValue) {
            IBindToStringFunc func = this.getConvertFunc(property.getPropertyType(), isCData);
            String valueToString = func.apply(property, dataEntity, ((ILocaleValue)value).getItem(this.binder.getLCId()));
            return valueToString == null ? "" : valueToString;
        }
        if (value instanceof Map || value instanceof List) {
            return SerializationUtils.toJsonString((Object)value);
        }
        IBindToStringFunc func = this.getConvertFunc(property.getPropertyType(), isCData);
        return func.apply(property, dataEntity, value);
    }

    protected IBindToStringFunc getConvertFunc(Class<?> propertyType, RefObject<Boolean> isCData) {
        Tuple result = null;
        result = this.convertToStrFuncCache.get(propertyType);
        if (result == null) {
            IBindToStringFunc func = this.createConvertFunc(propertyType, isCData);
            result = new Tuple((Object)func, isCData.argvalue);
            this.convertToStrFuncCache.put(propertyType, (Tuple<IBindToStringFunc, Boolean>)result);
        }
        isCData.argvalue = result.item2;
        return (IBindToStringFunc)result.item1;
    }

    IBindToStringFunc createConvertFunc(Class<?> propertyType, RefObject<Boolean> isCData) {
        IBindToStringFunc func = new IBindToStringFunc(){

            public String apply(ISimpleProperty sp, Object dataEntity, Object value) {
                if (value instanceof String) {
                    return (String)value;
                }
                if (value instanceof Date) {
                    return String.valueOf(((Date)value).getTime());
                }
                if (value instanceof LocaleString) {
                    return (String)((LocaleString)value).getItem(DcTreeSerializerWriteImplement.this.binder.getLCId());
                }
                return (String)ConvertUtils.convert((Object)value, String.class);
            }
        };
        if ((func = this.binder.bindToStringFunc(propertyType, func, isCData)) == null) {
            throw new IllegalArgumentException("BindToStringFunc");
        }
        return func;
    }

    protected IBindEqualsFunc getEqualsFunc(Class<?> propertyType) {
        IBindEqualsFunc result = null;
        result = this.equalsFuncCache.get(propertyType);
        if (result == null) {
            result = this.createEqualsFunc(propertyType);
            this.equalsFuncCache.put(propertyType, result);
        }
        return result;
    }

    protected IBindEqualsFunc createEqualsFunc(Class<?> propertyType) {
        Object func = ILocaleString.class.isAssignableFrom(propertyType) ? new IBindEqualsFunc(){

            public Boolean equals(Object currentValue, Object baseValue) {
                ILocaleString currentLv = (ILocaleString)currentValue;
                ILocaleString baseLv = (ILocaleString)baseValue;
                if (currentLv == null) {
                    if (baseLv == null) {
                        return true;
                    }
                    return false;
                }
                if (baseLv == null) {
                    return false;
                }
                String lcid = DcTreeSerializerWriteImplement.this.binder.getLCId();
                String currentItem = (String)currentLv.getItem(lcid);
                String baseitem = (String)baseLv.getItem(lcid);
                if (StringUtils.isBlank((CharSequence)currentItem) && StringUtils.isBlank((CharSequence)baseitem)) {
                    return true;
                }
                return StringUtils.equals((CharSequence)currentItem, (CharSequence)baseitem);
            }
        } : (byte[].class.isAssignableFrom(propertyType) ? new IBindEqualsFunc(){

            public Boolean equals(Object currentValue, Object baseValue) {
                if (currentValue == null) {
                    if (baseValue == null) {
                        return true;
                    }
                    return false;
                }
                byte[] currentArray = (byte[])currentValue;
                byte[] baseArray = (byte[])baseValue;
                if (currentArray.length != baseArray.length) {
                    return false;
                }
                for (int i = 0; i < currentArray.length; ++i) {
                    if (currentArray[i] == baseArray[i]) continue;
                    return false;
                }
                return true;
            }
        } : new IBindEqualsFunc(){

            public Boolean equals(Object currentValue, Object baseValue) {
                if (currentValue == baseValue) {
                    return true;
                }
                if (currentValue != null) {
                    return currentValue.equals(baseValue);
                }
                return baseValue.equals(currentValue);
            }
        });
        if ((func = this.binder.bindEqualsFunc(propertyType, func)) == null) {
            throw new IllegalArgumentException("BindEqualsFunc");
        }
        return func;
    }

    protected boolean listItemEquatable(List<?> sList, List<?> tList, Object s, Object t, ISupplier<String> getMessage) {
        ISimpleProperty srcPk = this.binder.getDataEntityType(s).getPrimaryKey();
        if (srcPk == null) {
            throw new OrmException(LIST_ITEM_EQUATABLE, String.format(ResManager.loadKDString((String)"%1$s\u53d1\u73b0\u5176\u660e\u7ec6\u7c7b\u578b%2$s\u6ca1\u6709\u5b9a\u4e49\u4e3b\u952e\u3002", (String)"DcSerializerWrite_0", (SubSystemType)SubSystemType.BOS, (Object[])new Object[0]), getMessage.get(), this.binder.getDataEntityType(s).getName()));
        }
        Object sPk = srcPk.getValue(s);
        if (sPk == null) {
            int index = -1;
            if (sList != null) {
                index = sList.indexOf(s);
            }
            throw new OrmException(LIST_ITEM_EQUATABLE, String.format(ResManager.loadKDString((String)"%1$s\u53d1\u73b0(\u5f53\u524d\u5217\u8868)\u5176\u7b2c%2$s\u7684\u4e3b\u952e\u4e3a\u7a7a\uff0c\u5e8f\u5217\u5316\u524d\u5fc5\u987b\u586b\u5145\u4e3b\u952e\u3002", (String)"DcSerializerWrite_1", (SubSystemType)SubSystemType.BOS, (Object[])new Object[0]), getMessage.get(), index));
        }
        ISimpleProperty targetPk = this.binder.getDataEntityType(t).getPrimaryKey();
        if (targetPk == null) {
            throw new OrmException(LIST_ITEM_EQUATABLE, String.format(ResManager.loadKDString((String)"%1$s\u53d1\u73b0\u5176\u660e\u7ec6\u7c7b\u578b%2$s\u6ca1\u6709\u5b9a\u4e49\u4e3b\u952e\u3002", (String)"DcSerializerWrite_0", (SubSystemType)SubSystemType.BOS, (Object[])new Object[0]), getMessage.get(), this.binder.getDataEntityType(t).getName()));
        }
        Object tPk = targetPk.getValue(t);
        if (tPk == null) {
            int index = -1;
            if (tList != null) {
                index = tList.indexOf(t);
            }
            throw new OrmException(LIST_ITEM_EQUATABLE, String.format(ResManager.loadKDString((String)"%1$s\u53d1\u73b0(\u57fa\u5217\u8868)\u5176\u7b2c%2$s\u7684\u4e3b\u952e\u4e3a\u7a7a\uff0c\u5e8f\u5217\u5316\u524d\u5fc5\u987b\u586b\u5145\u4e3b\u952e\u3002", (String)"DcSerializerWrite_2", (SubSystemType)SubSystemType.BOS, (Object[])new Object[0]), getMessage.get(), index));
        }
        return sPk.equals(tPk);
    }
}

