/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.vercompare;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.DesignEntityMetaL;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.DesignFormMetaL;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.vercompare.DeployFormSerializer;
import kd.bos.metadata.vercompare.MetaMergeUtils;

public class FormMetaSerializer
extends DeployFormSerializer {
    private static Log log = LogFactory.getLog(FormMetaSerializer.class);
    protected FormMetadata formMetadata;
    protected EntityMetadata entityMetadata;
    protected AbstractMetadata formBaseMeta;
    protected AbstractMetadata entityBaseMeta;
    protected DesignFormMeta designFormMeta;
    protected DesignEntityMeta designEntityMeta;
    protected DesignFormMetaL designFormMetaL;
    protected DesignEntityMetaL designEntityMetaL;
    private MetadataSerializer serializer;

    public FormMetaSerializer(String xml) {
        super(xml);
        this.serializerToObject();
    }

    public MetadataSerializer getMetadataSerializer() {
        return this.serializer;
    }

    public FormMetadata getFormMetadata() {
        return this.formMetadata;
    }

    public EntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    public AbstractMetadata getFormBaseMeta() {
        return this.formBaseMeta;
    }

    public AbstractMetadata getEntityBaseMeta() {
        return this.entityBaseMeta;
    }

    public DesignFormMeta getDesignFormMeta() {
        return this.designFormMeta;
    }

    public DesignEntityMeta getDesignEntityMeta() {
        return this.designEntityMeta;
    }

    public DesignFormMetaL getDesignFormMetaL() {
        return this.designFormMetaL;
    }

    public DesignEntityMetaL getDesignEntityMetaL() {
        return this.designEntityMetaL;
    }

    @Override
    public void serializerToObject() {
        super.serializerToObject();
        String formXml = null;
        String entityXml = null;
        String modelType = null;
        DeployMetadata deployMetadata = this.getDeployMetadata();
        if (deployMetadata != null && !deployMetadata.getDesignMetas().isEmpty()) {
            for (AbstractDesignMeta metadata : deployMetadata.getDesignMetas()) {
                if (metadata instanceof DesignFormMeta) {
                    this.designFormMeta = (DesignFormMeta)metadata;
                    formXml = metadata.getDataXml();
                    modelType = ((DesignFormMeta)metadata).getModelType();
                    continue;
                }
                if (metadata instanceof DesignEntityMeta) {
                    this.designEntityMeta = (DesignEntityMeta)metadata;
                    entityXml = metadata.getDataXml();
                    continue;
                }
                if (metadata instanceof DesignFormMetaL) {
                    this.designFormMetaL = (DesignFormMetaL)metadata;
                    formXml = metadata.getDataXml();
                    String number = metadata.getNumber();
                    modelType = MetaMergeUtils.getModelTypeByNumber(number);
                    continue;
                }
                if (!(metadata instanceof DesignEntityMetaL)) continue;
                this.designEntityMetaL = (DesignEntityMetaL)metadata;
                entityXml = metadata.getDataXml();
            }
        }
        this.serializer = new MetadataSerializer(modelType, true);
        this.handleFormMetadata(this.serializer, formXml, entityXml);
    }

    private void handleFormMetadata(MetadataSerializer serializer, String formXml, String entityXml) {
        if (formXml != null) {
            this.formMetadata = (FormMetadata)this.getMetadata(serializer, formXml);
            this.formBaseMeta = (FormMetadata)this.getBaseMetadata(serializer, formXml);
        }
        if (entityXml != null) {
            this.entityMetadata = (EntityMetadata)this.getMetadata(serializer, entityXml);
            this.entityBaseMeta = (EntityMetadata)this.getBaseMetadata(serializer, entityXml);
        }
    }

    private AbstractMetadata readBaseMetadata(AbstractMetadata metadata) {
        MetadataReader reader = new MetadataReader();
        String devType = this.getType(metadata, "page");
        if (StringUtils.isBlank((CharSequence)devType)) {
            throw new RuntimeException(String.format("page %s type is blank", metadata.getId()));
        }
        boolean isOriForm = !"2".equals(devType);
        reader.setFillExtends(isOriForm);
        return reader.readMeta(metadata.getParentId(), metadata.getDesingerMetaType(), false, true);
    }

    private Object getBaseMetadata(MetadataSerializer serializer, String xml) {
        AbstractMetadata sourceMeta = (AbstractMetadata)serializer.deserializeFromXml(xml, null);
        if (StringUtils.isBlank((CharSequence)sourceMeta.getParentId())) {
            return null;
        }
        return this.readBaseMetadata(sourceMeta);
    }

    private Object getMetadata(MetadataSerializer serializer, String xml) {
        AbstractMetadata sourceMeta = (AbstractMetadata)serializer.deserializeFromXml(xml, null);
        if (StringUtils.isBlank((CharSequence)sourceMeta.getParentId())) {
            return sourceMeta;
        }
        AbstractMetadata sourceBaseMetadata = this.readBaseMetadata(sourceMeta);
        return serializer.deserializeFromXml(xml, sourceBaseMetadata);
    }
}

