/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.vercompare;

import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.DesignMetaL;
import kd.bos.metadata.dao.IMetadataDaoPlugIn;
import kd.bos.metadata.dao.MetadataServicePlugInProxy;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.vercompare.DcTreeNode;
import kd.bos.metadata.vercompare.DcTreeSerializer;
import kd.bos.metadata.vercompare.FormMetaSerializer;
import kd.bos.metadata.vercompare.MergeContext;
import kd.bos.metadata.vercompare.XmlFormMetadata;

public class XcEntityMetadata
extends XmlFormMetadata {
    private FormMetaSerializer lastSerializer;
    private FormMetaSerializer baseSerializer;
    private EntityMetadata entityMetadata;

    public FormMetaSerializer getLastSerializer() {
        return this.lastSerializer;
    }

    public FormMetaSerializer getBaseSerializer() {
        return this.baseSerializer;
    }

    public EntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    @Override
    public DcTreeNode compare(String xmlVer1, String xmlVer2, boolean isOnlyDiff) {
        this.lastSerializer = new FormMetaSerializer(xmlVer1);
        EntityMetadata lastEntityMeta = this.lastSerializer.getEntityMetadata();
        this.baseSerializer = new FormMetaSerializer(xmlVer2);
        EntityMetadata baseEntityMeta = this.baseSerializer.getEntityMetadata();
        if (lastEntityMeta == null || baseEntityMeta == null) {
            return null;
        }
        DcTreeSerializer dcTreeSerializer = new DcTreeSerializer(this.lastSerializer.getMetadataSerializer().getBinder());
        dcTreeSerializer.setOnlyDiff(isOnlyDiff);
        return dcTreeSerializer.serialize(baseEntityMeta, lastEntityMeta);
    }

    @Override
    public Object merge(Object baseEntity, DcTreeNode dcTreeNode, MergeContext mergeContext) {
        if (dcTreeNode == null) {
            this.entityMetadata = (EntityMetadata)baseEntity;
            if (mergeContext.isMultiLang()) {
                this.setDesignMetaL(this.lastSerializer.getDesignEntityMetaL(), this.baseSerializer.getDesignEntityMetaL());
                return this.lastSerializer.getDesignEntityMetaL();
            }
            this.setDesignMeta(this.lastSerializer.getDesignEntityMeta(), this.baseSerializer.getDesignEntityMeta());
            return this.lastSerializer.getDesignEntityMeta();
        }
        DcTreeSerializer dcTreeSerializer = new DcTreeSerializer(this.lastSerializer.getMetadataSerializer().getBinder());
        this.entityMetadata = (EntityMetadata)dcTreeSerializer.deserialize(dcTreeNode, baseEntity);
        this.entityMetadata.createIndex(true);
        IMetadataDaoPlugIn plugIn = MetadataServicePlugInProxy.create(this.entityMetadata.getModelType());
        plugIn.clearRootChildenParentId(this.entityMetadata);
        if (this.lastSerializer.getEntityBaseMeta() != null) {
            plugIn.clearRootChildenParentId(this.lastSerializer.getEntityBaseMeta());
        }
        String entityXml = this.lastSerializer.getMetadataSerializer().buildDiffXml(this.entityMetadata, this.lastSerializer.getEntityBaseMeta(), false);
        this.convert(this.entityMetadata, mergeContext);
        if (mergeContext.isMultiLang()) {
            DesignMetaL designMetaL = this.entityMetadata.convertToDesignMetaL(mergeContext.getLocaleId(), entityXml);
            this.setDesignMetaL(designMetaL, this.baseSerializer.getDesignEntityMetaL());
            return designMetaL;
        }
        DesignMeta meta = this.entityMetadata.convertToDesignMeta(entityXml);
        this.setDesignMeta(meta, this.baseSerializer.getDesignEntityMeta());
        return meta;
    }

    private void convert(EntityMetadata entityMetadata, MergeContext mergeContext) {
        if (mergeContext.getFormMetadata() == null) {
            return;
        }
        FormMetadata formMetadata = mergeContext.getFormMetadata();
        entityMetadata.setBizappId(formMetadata.getBizappId());
        entityMetadata.setSubSysId(formMetadata.getSubSysId());
        entityMetadata.setModelType(formMetadata.getModelType());
        entityMetadata.setKey(formMetadata.getKey());
        entityMetadata.getRootEntity().setKey(formMetadata.getKey());
        entityMetadata.setInheritPath(formMetadata.getInheritPath());
        entityMetadata.setDevType(formMetadata.getDevType());
        entityMetadata.setMasterId(formMetadata.getMasterId());
        entityMetadata.setEnabled(entityMetadata.isEnabled());
        entityMetadata.setName(formMetadata.getName());
    }

    @Override
    public void setDesignMetaL(DesignMetaL designMetaL, DesignMetaL baseDesignMeta) {
        super.setDesignMetaL(designMetaL, baseDesignMeta);
    }

    @Override
    public void setDesignMeta(DesignMeta designMeta, DesignMeta baseDesignMeta) {
        if (designMeta == null || baseDesignMeta == null) {
            return;
        }
        super.setDesignMeta(designMeta, baseDesignMeta);
        ((DesignEntityMeta)designMeta).setModifyDate(((DesignEntityMeta)baseDesignMeta).getModifyDate());
    }
}

