/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;

public class DifferentialControlInfo
implements Serializable {
    private static final long serialVersionUID = 7344193887611901755L;
    private Boolean mustInput;
    private Map<String, Boolean> visible = new HashMap<String, Boolean>(5);
    private Map<String, Boolean> lock = new HashMap<String, Boolean>(5);
    private String fieldKey;
    private String defaultValue;
    private boolean localCache = false;
    private String fieldId;
    private String entityFieldKey;
    private static Map<String, Integer> mapLock = new HashMap<String, Integer>(7);
    private static Map<String, Integer> mapVis = new HashMap<String, Integer>(11);
    private static final String DEFAULT = "default";

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.checkLocalCache();
        this.defaultValue = defaultValue;
    }

    public String getFieldKey() {
        return this.fieldKey;
    }

    public void setFieldKey(String fieldKey) {
        this.checkLocalCache();
        this.fieldKey = fieldKey;
    }

    public Boolean isMustInput() {
        return this.mustInput;
    }

    public void setMustInput(boolean mustInput) {
        this.checkLocalCache();
        this.mustInput = mustInput;
    }

    public Map<String, Boolean> getVisible() {
        return this.visible;
    }

    public void setVisible(Map<String, Boolean> visible) {
        this.checkLocalCache();
        this.visible = visible;
    }

    public Map<String, Boolean> getLock() {
        return this.lock;
    }

    public void setLock(Map<String, Boolean> lock) {
        this.checkLocalCache();
        this.lock = lock;
    }

    public void addVisible(String status, boolean visible) {
        this.checkLocalCache();
        this.visible.put(status, visible);
    }

    public void addLock(String status, boolean visible) {
        this.checkLocalCache();
        this.lock.put(status, visible);
    }

    public Boolean isLock(String status) {
        Boolean isLock = null;
        String statusLowCase = status.toLowerCase();
        if (this.lock.containsKey(statusLowCase)) {
            isLock = this.lock.get(statusLowCase);
        } else if (status.equals("ADDNEW") && this.lock.containsKey("new")) {
            isLock = this.lock.get("new");
        }
        return isLock;
    }

    public Boolean isVisible(String status) {
        Boolean isVisible = null;
        String statusLowCase = status.toLowerCase();
        if (this.visible.containsKey(statusLowCase)) {
            isVisible = this.visible.get(statusLowCase);
        } else if (status.equals("ADDNEW") && this.lock.containsKey("new")) {
            isVisible = this.visible.get("new");
        }
        return isVisible;
    }

    public boolean isLocalCache() {
        return this.localCache;
    }

    public void setLocalCache(boolean localCache) {
        this.localCache = localCache;
    }

    private void checkLocalCache() {
        if (this.localCache) {
            throw new KDException(new ErrorCode("DifferentialControlInfo_01", "DifferentialControlInfo is in local cache, could't be modify."), new Object[0]);
        }
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String fieldId) {
        this.checkLocalCache();
        this.fieldId = fieldId;
    }

    public String getEntityFieldKey() {
        return this.entityFieldKey;
    }

    public void setEntityFieldKey(String entityFieldKey) {
        this.checkLocalCache();
        this.entityFieldKey = entityFieldKey;
    }

    public int getLockValue() {
        if (this.getLock() == null) {
            return mapLock.get("view");
        }
        int ret = 0;
        for (Map.Entry<String, Boolean> lock : this.getLock().entrySet()) {
            if (!lock.getValue().booleanValue()) continue;
            ret = ret | mapLock.get(lock.getKey()) | mapLock.get("view");
        }
        return ret;
    }

    public int getVisibleValueInner() {
        if (this.getVisible() == null) {
            return 63;
        }
        StringBuilder visibleBuilder = new StringBuilder();
        String visible = "";
        for (Map.Entry<String, Boolean> visibleMap : this.getVisible().entrySet()) {
            if (!visibleMap.getValue().booleanValue()) continue;
            visibleBuilder.append(visibleMap.getKey()).append(",");
        }
        visible = visibleBuilder.toString();
        if (visible.contains(",")) {
            visible = visible.substring(0, visible.length() - 1);
        }
        if (visible.contains(DEFAULT) || visible.contains("lookup")) {
            String string = visible = StringUtils.isNotBlank((CharSequence)visible) && !visible.contains("init") ? visible + ",init" : visible;
        }
        if (StringUtils.isEmpty((CharSequence)visible)) {
            return 0;
        }
        String[] vs = visible.split(",");
        int ret = 0;
        for (String v : vs) {
            ret |= mapVis.get(v).intValue();
        }
        return ret;
    }

    static {
        mapVis.put("new", 1);
        mapVis.put("edit", 2);
        mapVis.put("view", 4);
        mapVis.put("init", 8);
        mapVis.put("submit", 16);
        mapVis.put("audit", 32);
        mapVis.put(DEFAULT, 1);
        mapVis.put("lookup", 2);
        mapLock.put("new", 1);
        mapLock.put("edit", 2);
        mapLock.put("view", 4);
        mapLock.put("submit", 16);
        mapLock.put("audit", 32);
    }
}

