/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.CtLinkSetElement;
import kd.bos.entity.EntityMetadataLocalDiskCache;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.entity.property.org.OrgRelationConfig;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.sharemeta.ShareMetaUtil;

class EntityMetadataLocalCache {
    private static final CacheConfigInfo info;
    private static final Object OBJECT;
    private static final String CACHETYPE_TABLEDEFINE = "bos.tabledefinebyid";
    private static final String LOCALCACHE_MAXITEMSIZE = "meta.localcache.entity.maxitemsize";
    private static final String LOCALCACHE_TIMEOUT = "meta.localcache.entity.timeout";
    private static final Log logger;
    private static boolean mergeRegion;

    private EntityMetadataLocalCache() {
    }

    static LocalMemoryCache getOrCreateLocalCache(CacheConfigInfo info, String cacheRegion) {
        if (mergeRegion) {
            cacheRegion = "metadata";
        }
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(cacheRegion, "EntityMetadata", info);
    }

    private static LocalMemoryCache getLocalCache(String entitynumber) {
        String region = CacheKeyUtil.getAcctId();
        if (StringUtils.isNotBlank((CharSequence)entitynumber)) {
            region = ShareMetaUtil.getLocalCacheRegion(region, entitynumber);
        }
        return EntityMetadataLocalCache.getOrCreateLocalCache(info, region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheBaseDataFieldFilterMeta(String formId, String key, Object value) {
        ConcurrentHashMap<String, Object> concurrentHashMap = (ConcurrentHashMap<String, Object>)EntityMetadataLocalCache.getLocalCache(formId).get(EntityMetadataLocalCache.getBaseDataFieldFilterRegionKey(formId));
        if (concurrentHashMap == null) {
            Object object = OBJECT;
            synchronized (object) {
                concurrentHashMap = new ConcurrentHashMap<String, Object>();
            }
        }
        concurrentHashMap.put(key.toLowerCase(), value);
        EntityMetadataLocalCache.getLocalCache(formId).put(EntityMetadataLocalCache.getBaseDataFieldFilterRegionKey(formId), concurrentHashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getBaseDataFieldFilterMeta(String formId, String key) {
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)EntityMetadataLocalCache.getLocalCache(formId).get(EntityMetadataLocalCache.getBaseDataFieldFilterRegionKey(formId));
        if (concurrentHashMap == null) {
            Object object = OBJECT;
            synchronized (object) {
                concurrentHashMap = new ConcurrentHashMap();
            }
        }
        return (T)concurrentHashMap.get(key.toLowerCase());
    }

    public static MainEntityType getDataEntityType(String entitynumber) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.Entity, entitynumber);
        MainEntityType dt = (MainEntityType)((Object)EntityMetadataLocalCache.getLocalCache(entitynumber).get(key));
        if (dt == null && EntityMetadataLocalDiskCache.getLocalDiskCacheEnabled()) {
            return (MainEntityType)((Object)EntityMetadataLocalDiskCache.getThreadCache(key));
        }
        return dt;
    }

    public static void putDataEntityType(MainEntityType dt) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.Entity, dt.getName());
        EntityMetadataLocalCache.getLocalCache(dt.getName()).put(key, (Object)dt);
        if (EntityMetadataLocalDiskCache.getLocalDiskCacheEnabled()) {
            EntityMetadataLocalDiskCache.putThreadCache(key, (Object)dt);
        }
    }

    public static RefEntityType getRefDataEntityType(String entitynumber) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.Entity, entitynumber + ".ref");
        RefEntityType dt = (RefEntityType)((Object)EntityMetadataLocalCache.getLocalCache(entitynumber).get(key));
        if (dt == null && EntityMetadataLocalDiskCache.getLocalDiskCacheEnabled()) {
            return (RefEntityType)((Object)EntityMetadataLocalDiskCache.getThreadCache(key));
        }
        return dt;
    }

    public static void putRefDataEntityType(RefEntityType dt) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.Entity, dt.getName() + ".ref");
        EntityMetadataLocalCache.getLocalCache(dt.getName()).put(key, (Object)dt);
        if (EntityMetadataLocalDiskCache.getLocalDiskCacheEnabled()) {
            EntityMetadataLocalDiskCache.putThreadCache(key, (Object)dt);
        }
    }

    static RefEntityType getNoFillRefDataEntityType(String entitynumber) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.Entity, entitynumber + ".nofillref");
        return (RefEntityType)((Object)EntityMetadataLocalCache.getLocalCache(entitynumber).get(key));
    }

    static void putNoFillRefDataEntityType(RefEntityType dt) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.Entity, dt.getName() + ".nofillref");
        EntityMetadataLocalCache.getLocalCache(dt.getName()).put(key, (Object)dt);
    }

    static void clearNoFillRefDataEntityType(String entitynumber) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.Entity, entitynumber + ".nofillref");
        EntityMetadataLocalCache.getLocalCache(entitynumber).put(key, (Object)RefEntityType.Empty);
    }

    public static void remove(String entitynumber) {
        EntityMetadataLocalCache.remove("", entitynumber);
        EntityMetadataLocalCache.getLocalCache(CACHETYPE_TABLEDEFINE).clear();
    }

    static void remove(String appGroup, String entitynumber) {
        String key;
        LocalMemoryCache localCache = EntityMetadataLocalCache.getLocalCache(entitynumber);
        String[] keys = new String[RuntimeMetaType.values().length];
        int i = 0;
        for (RuntimeMetaType type : RuntimeMetaType.values()) {
            keys[i] = key = EntityMetadataLocalCache.makeCacheKey(appGroup, type, entitynumber);
            ++i;
        }
        localCache.remove(keys);
        key = EntityMetadataLocalCache.makeCacheKey(appGroup, RuntimeMetaType.Entity, entitynumber + ".ref");
        localCache.remove(new String[]{key});
        key = EntityMetadataLocalCache.makeCacheKey(appGroup, RuntimeMetaType.Entity, entitynumber + ".nofillref");
        localCache.remove(new String[]{key});
        EntityMetadataLocalCache.getLocalCache(entitynumber).remove(new String[]{EntityMetadataLocalCache.getBaseDataFieldFilterRegionKey(appGroup, entitynumber)});
        StringBuilder sb = new StringBuilder();
        if (Boolean.getBoolean("entitymeta.localcache.remove.printstack")) {
            StackTraceElement[] stes = Thread.currentThread().getStackTrace();
            int size = stes.length > 50 ? 50 : stes.length;
            for (int j = 1; j < size; ++j) {
                sb.append("\tat ").append(stes[j]);
            }
            logger.info("\u5143\u6570\u636e{}\u88ab\u79fb\u9664\u7f13\u5b58\u3002EntityMetaLocalCache remove stack:\n{}", (Object)entitynumber, (Object)sb);
        }
        EntityMetadataLocalDiskCache.remove(appGroup, entitynumber);
    }

    public static TableDefine getTableDefine(String entityNumber, String entityKey) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.TableDefine, entityNumber);
        Map cache = (Map)EntityMetadataLocalCache.getLocalCache(entityNumber).get(key);
        if (cache == null) {
            return null;
        }
        return (TableDefine)cache.get(entityKey == null ? "" : entityKey.toLowerCase());
    }

    public static void putTableDefine(String entityNumber, String entityKey, TableDefine tableDefine) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.TableDefine, entityNumber);
        ConcurrentHashMap<String, TableDefine> cache = (ConcurrentHashMap<String, TableDefine>)EntityMetadataLocalCache.getLocalCache(entityNumber).get(key);
        if (cache == null) {
            cache = new ConcurrentHashMap<String, TableDefine>();
            EntityMetadataLocalCache.getLocalCache(entityNumber).put(key, cache);
        }
        cache.put(entityKey == null ? "" : entityKey.toLowerCase(), tableDefine);
    }

    public static TableDefine getTableDefine(Long tableId) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.TableDefine, String.valueOf(tableId));
        return (TableDefine)EntityMetadataLocalCache.getLocalCache(CACHETYPE_TABLEDEFINE).get(key);
    }

    public static void putTableDefine(Long tableId, TableDefine tableDefine) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.TableDefine, String.valueOf(tableId));
        EntityMetadataLocalCache.getLocalCache(CACHETYPE_TABLEDEFINE).put(key, (Object)tableDefine);
    }

    public static LinkSetElement getLinkSet(String entityNumber) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.LinkSet, entityNumber);
        return (LinkSetElement)EntityMetadataLocalCache.getLocalCache(entityNumber).get(key);
    }

    public static CtLinkSetElement getCtLinkSet(String entityNumber) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.CtLinkSet, entityNumber);
        return (CtLinkSetElement)EntityMetadataLocalCache.getLocalCache(entityNumber).get(key);
    }

    public static void putLinkSet(String entityNumber, LinkSetElement linkSet) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.LinkSet, entityNumber);
        EntityMetadataLocalCache.getLocalCache(entityNumber).put(key, (Object)linkSet);
    }

    public static void putCtLinkSet(String entityNumber, CtLinkSetElement ctLinkSet) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.CtLinkSet, entityNumber);
        EntityMetadataLocalCache.getLocalCache(entityNumber).put(key, (Object)ctLinkSet);
    }

    public static Map<String, Object> getDataEntityOperate(String entityNumber, String operKey) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.Operate, entityNumber);
        Map cache = (Map)EntityMetadataLocalCache.getLocalCache(entityNumber).get(key);
        if (cache == null) {
            return null;
        }
        return (Map)cache.get(operKey == null ? "" : operKey.toLowerCase());
    }

    public static void putDataEntityOperate(String entityNumber, String operKey, Map<String, Object> operate) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.Operate, entityNumber);
        ConcurrentHashMap<String, Map<String, Object>> cache = (ConcurrentHashMap<String, Map<String, Object>>)EntityMetadataLocalCache.getLocalCache(entityNumber).get(key);
        if (cache == null) {
            cache = new ConcurrentHashMap<String, Map<String, Object>>();
            EntityMetadataLocalCache.getLocalCache(entityNumber).put(key, cache);
        }
        cache.put(operKey == null ? "" : operKey.toLowerCase(), operate);
    }

    public static AppInfo getAppInfo(String appId) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.App, appId);
        return (AppInfo)EntityMetadataLocalCache.getLocalCache("").get(key);
    }

    public static void putAppInfo(String appId, AppInfo appInfo) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.App, appId);
        EntityMetadataLocalCache.getLocalCache("").put(key, (Object)appInfo);
    }

    public static PermissionControlType getPermissionControlType(String entityNumber) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.PermissionControlType, entityNumber);
        return (PermissionControlType)EntityMetadataLocalCache.getLocalCache(entityNumber).get(key);
    }

    public static void putPermissionControlType(String entityNumber, PermissionControlType permissionControlType) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.PermissionControlType, entityNumber);
        EntityMetadataLocalCache.getLocalCache(entityNumber).put(key, (Object)permissionControlType);
    }

    public static Set<String> getPermissionItems(String entityNumber) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.PermissionItems, entityNumber);
        return (Set)EntityMetadataLocalCache.getLocalCache(entityNumber).get(key);
    }

    public static void putPermissionItems(String entityNumber, Set<String> permItems) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.PermissionItems, entityNumber);
        EntityMetadataLocalCache.getLocalCache(entityNumber).put(key, permItems);
    }

    public static Map<String, List<Map<String, Object>>> getNetCtrlOperate(String entityNumber) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.NetCtrlOperate, entityNumber);
        return (Map)EntityMetadataLocalCache.getLocalCache(entityNumber).get(key);
    }

    public static void putNetCtrlOperate(String entityNumber, Map<String, List<Map<String, Object>>> netCtrls) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.NetCtrlOperate, entityNumber);
        EntityMetadataLocalCache.getLocalCache(entityNumber).put(key, netCtrls);
    }

    public static Map<String, OrgRelationConfig> getPrincipalRelation(String entityNumber) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.PrincipalRelation, entityNumber);
        return (Map)EntityMetadataLocalCache.getLocalCache(entityNumber).get(key);
    }

    public static void putPrincipalRelation(String entityNumber, Map<String, OrgRelationConfig> principalRelation) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.PrincipalRelation, entityNumber);
        EntityMetadataLocalCache.getLocalCache(entityNumber).put(key, principalRelation);
    }

    public static String getBizAppNumber(String entityNumber) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.BizAppNumber, entityNumber);
        return (String)EntityMetadataLocalCache.getLocalCache(entityNumber).get(key);
    }

    public static void putBizAppNumber(String entityNumber, String bizAppNumber) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.BizAppNumber, entityNumber);
        EntityMetadataLocalCache.getLocalCache(entityNumber).put(key, (Object)bizAppNumber);
    }

    private static String getBaseDataFieldFilterRegionKey(String formId) {
        return EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.BaseDataFieldFilter, formId);
    }

    private static String getBaseDataFieldFilterRegionKey(String appGroup, String formId) {
        return EntityMetadataLocalCache.makeCacheKey(appGroup, RuntimeMetaType.BaseDataFieldFilter, formId);
    }

    public static Map<String, List<String>> getLockFields(String formId) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.lockFields, formId);
        return (Map)EntityMetadataLocalCache.getLocalCache(formId).get(key);
    }

    public static void putLockFields(String formId, Map<String, List<String>> lockFields) {
        String key = EntityMetadataLocalCache.makeCacheKey(RuntimeMetaType.lockFields, formId);
        EntityMetadataLocalCache.getLocalCache(formId).put(key, lockFields);
    }

    private static String makeCacheKey(RuntimeMetaType type, String entitynumber) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        return EntityMetadataLocalCache.makeCacheKey(appGroup, type, entitynumber);
    }

    static String makeCacheKey(String appGroup, RuntimeMetaType type, String entitynumber) {
        String cacheKey = "";
        if (mergeRegion) {
            cacheKey = ShareMetaUtil.getLocalCacheRegion(CacheKeyUtil.getAcctId(), entitynumber) + ".";
        }
        if (StringUtils.isNotBlank((CharSequence)appGroup) && !"defaultGroup".equals(appGroup)) {
            cacheKey = cacheKey + appGroup + ".";
        }
        cacheKey = cacheKey + entitynumber + "." + type.getValue();
        return cacheKey.toLowerCase();
    }

    static {
        String timeoutStr;
        OBJECT = new Object();
        logger = LogFactory.getLog(EntityMetadataLocalCache.class);
        mergeRegion = true;
        int maxItemSize = 200000;
        int timeout = 43200;
        String itemSizeStr = System.getProperty(LOCALCACHE_MAXITEMSIZE);
        if (StringUtils.isNotBlank((CharSequence)itemSizeStr)) {
            maxItemSize = Integer.parseInt(itemSizeStr);
        }
        if (StringUtils.isNotBlank((CharSequence)(timeoutStr = System.getProperty(LOCALCACHE_TIMEOUT)))) {
            timeout = Integer.parseInt(timeoutStr);
        }
        boolean isTimeToLive = Boolean.getBoolean("meta.localcache.entity.istimetolive");
        info = new CacheConfigInfo();
        info.setTimeout(timeout);
        info.setMaxItemSize(maxItemSize);
        info.setTimeToLive(isTimeToLive);
        mergeRegion = Boolean.getBoolean("meta.localcache.mergeregion");
    }
}

