/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.config.EnvConfigurationUtil;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.CtLinkSetElement;
import kd.bos.entity.EntityItemTypes;
import kd.bos.entity.EntityMetadataLocalDiskCache;
import kd.bos.entity.IEntityMetaDataProvider;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.property.org.OrgRelationConfig;
import kd.bos.entity.pureplatform.PurePlatformBlackList;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.runmode.RunModeService;
import kd.bos.org.utils.Utils;
import kd.bos.product.ICoreProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;

public class EntityMetadataProvider
implements IEntityMetaDataProvider {
    private static final String BOS_ENTITY_METADATA = "bos-entity-metadata";
    private static final String MASTER = "Master";
    private Log logger = LogFactory.getLog(this.getClass());
    private MetadataService metadataService;

    public EntityMetadataProvider() {
        this((MetadataService)ServiceFactory.getService(MetadataService.class));
    }

    public EntityMetadataProvider(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    @Override
    public String getRuntimeMetadataVersion(String number) {
        return this.metadataService.getRuntimeMetadataVersion(number);
    }

    @Override
    public Map<String, String> batchLoadRuntmeMetadataVersion(Collection<String> numbers) {
        return this.metadataService.batchLoadRuntimeMetadataVersion(numbers);
    }

    @Override
    public AppInfo getAppInfo(String number) {
        String infoStr = this.metadataService.loadAppInfo(number);
        if (StringUtils.isBlank((CharSequence)infoStr)) {
            ErrorCode errorCode = new ErrorCode("bos.appMetaDataNotExist", ResManager.loadKDString((String)"\u5e94\u7528%s\u8fd0\u884c\u671f\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"EntityMetadataProvider_0", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]));
            throw new KDException(errorCode, new Object[]{number});
        }
        AppInfo info = (AppInfo)SerializationUtils.fromJsonString((String)infoStr, AppInfo.class);
        if (StringUtils.isBlank((CharSequence)info.getNumber())) {
            info = null;
        }
        return info;
    }

    @Override
    public List<AppMenuInfo> getAppMenusInfoByAppId(String number) {
        String infoStr = this.metadataService.getAppMenusInfoByAppId(number);
        ArrayList<AppMenuInfo> menus = new ArrayList(10);
        if (StringUtils.isBlank((CharSequence)infoStr)) {
            this.logger.info("\u5e94\u7528\u3010" + number + "\u3011\u8fd0\u884c\u671f\u83dc\u5355\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002");
        } else {
            menus = SerializationUtils.fromJsonStringToList((String)infoStr, AppMenuInfo.class);
        }
        this.removePurePlatformBlackList(menus);
        this.removeByBlacklist(number, menus);
        return menus;
    }

    private void removePurePlatformBlackList(List<AppMenuInfo> menus) {
        try {
            if (Utils.isListEmpty(menus)) {
                return;
            }
            if (!EnvConfigurationUtil.isPurePlatform()) {
                return;
            }
            this.logger.info("\u7eaf\u5e73\u53f0\u73af\u5883\u542f\u7528\u83dc\u5355\u9ed1\u540d\u5355\u3002");
            Iterator<AppMenuInfo> it = menus.iterator();
            while (it.hasNext()) {
                AppMenuInfo menu = it.next();
                if (PurePlatformBlackList.getSysMenuBlackList().contains(menu.getId())) {
                    it.remove();
                    continue;
                }
                if (PurePlatformBlackList.getBaseMenuBlackList().contains(menu.getId())) {
                    it.remove();
                    continue;
                }
                if ("0N6MYZEOHTU7".equals(menu.getId())) {
                    it.remove();
                    continue;
                }
                if (!menu.getAppId().equals("bal")) continue;
                it.remove();
            }
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u7eaf\u5e73\u53f0\u73af\u5883\u83dc\u5355\u9ed1\u540d\u5355remove\u83dc\u5355\u51fa\u9519", (Throwable)e);
        }
    }

    private void removeByBlacklist(String appNumber, List<AppMenuInfo> menus) {
        try {
            AppMenuInfo menu;
            Iterator<AppMenuInfo> it;
            if (Utils.isListEmpty(menus)) {
                return;
            }
            RunModeService runModeService = (RunModeService)ServiceFactory.getService(RunModeService.class);
            int product = runModeService.getRunModeCode();
            List formBlacklist = runModeService.loadEntityBlacklistByAppNumber(product, appNumber);
            ICoreProductSettingService productService = (ICoreProductSettingService)ServiceFactory.getService(ICoreProductSettingService.class);
            List blackForms = productService.getFormBlackListByAppId(appNumber);
            List blackMenuIds = productService.getAppMenuBlackList(appNumber);
            if (Utils.isListNotEmpty((List)formBlacklist)) {
                it = menus.iterator();
                while (it.hasNext()) {
                    menu = it.next();
                    if (!StringUtils.isNotBlank((CharSequence)menu.getFormId()) || !formBlacklist.contains(menu.getFormId())) continue;
                    it.remove();
                }
            }
            if (Utils.isListNotEmpty((List)blackForms) || Utils.isListNotEmpty((List)blackMenuIds)) {
                it = menus.iterator();
                while (it.hasNext()) {
                    menu = it.next();
                    if ((!StringUtils.isNotBlank((CharSequence)menu.getFormId()) || !formBlacklist.contains(menu.getFormId()) && !blackForms.contains(menu.getFormId())) && !blackMenuIds.contains(menu.getId())) continue;
                    it.remove();
                }
            }
        }
        catch (Exception e) {
            this.logger.error(String.format("\u6839\u636e\u8fd0\u884c\u6a21\u5f0f\u5e94\u7528{%s}\u8868\u5355\u9ed1\u540d\u5355\u53bb\u6389\u83dc\u5355\u51fa\u9519", appNumber), (Throwable)e);
        }
    }

    @Override
    public AppMenuInfo getAppMenuInfo(String appNumber, String menuId) {
        List<AppMenuInfo> menus = this.getAppMenusInfoByAppId(appNumber);
        if (menus == null) {
            ErrorCode errorCode = new ErrorCode("bos.appMetaDataNotExist", ResManager.loadKDString((String)"\u5e94\u7528%1$s\u7684\u8fd0\u884c\u671f\u83dc\u5355%2$s\u4e0d\u5b58\u5728\u3002", (String)"EntityMetadataProvider_3", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]));
            throw new KDException(errorCode, new Object[]{appNumber, menuId});
        }
        AppMenuInfo menu = null;
        for (AppMenuInfo menuInfo : menus) {
            if (!menuInfo.getId().equals(menuId)) continue;
            menu = menuInfo;
            break;
        }
        return menu;
    }

    @Override
    public MainEntityType getDataEntityType(String number) {
        String str = EntityMetadataLocalDiskCache.get(RuntimeMetaType.Entity, number);
        if (str == null || str.length() == 0) {
            str = this.metadataService.loadEntityMeta(number);
            if (str == null || str.length() == 0) {
                throw new KDException(BosErrorCode.entityMetaDataNotExist, new Object[]{number});
            }
            EntityMetadataLocalDiskCache.put(RuntimeMetaType.Entity, number, str);
        }
        return (MainEntityType)EntityItemTypes.fromJsonString(str);
    }

    @Override
    public RefEntityType getRefEntityType(String number) {
        String str = EntityMetadataLocalDiskCache.get(RuntimeMetaType.Entity, number);
        if (str == null || str.length() == 0) {
            str = this.metadataService.loadEntityMeta(number);
            if (str == null || str.length() == 0) {
                throw new KDException(BosErrorCode.entityMetaDataNotExist, new Object[]{number});
            }
            EntityMetadataLocalDiskCache.put(RuntimeMetaType.Entity, number, str);
        }
        return this.createRefEntityType(str);
    }

    @Override
    public Map<String, RefEntityType> getRefEntityTypes(Collection<String> numbers) {
        HashMap<String, String> refEntityStrMap = new HashMap<String, String>(numbers.size());
        ArrayList<String> notCacheNumbers = new ArrayList<String>(16);
        for (String number : numbers) {
            String str = EntityMetadataLocalDiskCache.get(RuntimeMetaType.Entity, number);
            if (str == null || str.length() == 0) {
                notCacheNumbers.add(number);
                continue;
            }
            refEntityStrMap.put(number, str);
        }
        refEntityStrMap.putAll(this.metadataService.loadEntityMetas(notCacheNumbers));
        HashMap<String, RefEntityType> resultMap = new HashMap<String, RefEntityType>(refEntityStrMap.size());
        for (Map.Entry entry : refEntityStrMap.entrySet()) {
            String str = (String)entry.getValue();
            if (str == null || str.length() == 0) {
                throw new KDException(BosErrorCode.entityMetaDataNotExist, new Object[]{entry.getKey()});
            }
            resultMap.put((String)entry.getKey(), this.createRefEntityType(str));
        }
        return resultMap;
    }

    @Override
    public String getEntityNumberById(String entityId) {
        return this.metadataService.getEntityNumberById(entityId);
    }

    @Override
    public String getAppNumberById(String id) {
        return this.metadataService.getAppNumberById(id);
    }

    @Override
    public Map<String, String> getAppNumberByEntityNumbers(List<Object> entityNumbers) {
        return this.metadataService.getAppNumberByEntityNumbers(entityNumbers);
    }

    @Override
    public Map<String, Object> getDataEntityOperate(String entityNumber, String operKey) {
        String str = this.metadataService.loadEntityOperationMeta(entityNumber, operKey);
        this.logger.debug(entityNumber + operKey + str);
        if (StringUtils.isBlank((CharSequence)str)) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u4e0a\u6ca1\u6709\u7f16\u7801\u4e3a%2$s\u7684\u64cd\u4f5c", (String)"EntityMetadataProvider_4", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), entityNumber, operKey));
        }
        return (Map)SerializationUtils.fromJsonString((String)str, Map.class);
    }

    @Override
    public Operations getDataEntityOperations(String entityNumber) {
        String str = this.metadataService.loadEntityRuntimeMeta(entityNumber, (int)RuntimeMetaType.Operations.getValue(), entityNumber);
        if (StringUtils.isBlank((CharSequence)str)) {
            return new Operations();
        }
        return (Operations)SerializationUtils.fromJsonString((String)str, Operations.class);
    }

    @Override
    public List<Map<String, Object>> getDataEntityOperate(String entityNumber) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
        List listOperate = this.metadataService.loadEntityAllOperationMeta(entityNumber);
        for (String operate : listOperate) {
            Map operateMap = (Map)SerializationUtils.fromJsonString((String)operate, Map.class);
            list.add(operateMap);
        }
        return list;
    }

    @Override
    public Map<String, List<String>> getDataEntityOperationKeys(Collection<String> entityNumbers) {
        return this.metadataService.getDataEntityOperationKeys(entityNumbers);
    }

    @Override
    public Map<String, List<Map<String, Object>>> getDataEntityNetCtrlOperate(String entityNumber) {
        List strlist = this.metadataService.loadEntityNetCtrlOperationMeta(entityNumber);
        this.logger.debug(entityNumber);
        if (strlist == null || strlist.isEmpty()) {
            return null;
        }
        HashMap<String, List<Map<String, Object>>> netCtrl = new HashMap<String, List<Map<String, Object>>>();
        for (String str : strlist) {
            Map map = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
            String groupId = (String)map.get("groupId");
            ArrayList<Map> list = (ArrayList<Map>)netCtrl.get(groupId);
            if (list == null) {
                list = new ArrayList<Map>();
                netCtrl.put(groupId, list);
            }
            list.add(map);
        }
        return netCtrl;
    }

    @Override
    public DynamicObjectType getSubDataEntityType(String entityNumber, Collection<String> properties) {
        return this.getDataEntityType(entityNumber).getSubEntityType(properties);
    }

    @Override
    public FilterCondition getBaseDataFieldFilterMeta(String entityNumber, String key) {
        String filter = this.metadataService.loadBaseDataFieldFilterMeta(entityNumber, key);
        if (!StringUtils.isBlank((CharSequence)filter)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
            return filterCondition;
        }
        return null;
    }

    @Override
    public String getPluginScripts(String scriptName) {
        String strPlugin = this.metadataService.loadFormPluginScriptMeta("", scriptName);
        return strPlugin;
    }

    @Override
    public List<String> getFeatureEnabledEntity(String entityNumber, String featureName) {
        String str = this.metadataService.loadEntityRuntimeMeta(entityNumber, (int)RuntimeMetaType.Features.getValue(), featureName);
        if (StringUtils.isBlank((CharSequence)str)) {
            return new ArrayList<String>();
        }
        return SerializationUtils.fromJsonStringToList((String)str, String.class);
    }

    @Override
    public LinkSetElement getLinkSet(String entityNumber) {
        String str = this.metadataService.loadEntityRuntimeMeta(entityNumber, (int)RuntimeMetaType.LinkSet.getValue(), entityNumber);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        LinkSetElement linkSet = (LinkSetElement)SerializationUtils.fromJsonString((String)str, LinkSetElement.class);
        return linkSet;
    }

    @Override
    public CtLinkSetElement getCtLinkSet(String entityNumber) {
        String str = this.metadataService.loadEntityRuntimeMeta(entityNumber, (int)RuntimeMetaType.CtLinkSet.getValue(), entityNumber);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        CtLinkSetElement ctLinkSet = (CtLinkSetElement)SerializationUtils.fromJsonString((String)str, CtLinkSetElement.class);
        return ctLinkSet;
    }

    @Override
    public TableDefine loadTableDefine(String entityNumber, String entityKey) {
        String str = this.metadataService.loadTableDefine(entityNumber, entityKey);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        TableDefine tableDefine = (TableDefine)SerializationUtils.fromJsonString((String)str, TableDefine.class);
        return tableDefine;
    }

    @Override
    public TableDefine loadTableDefine(Long tableId) {
        String str = this.metadataService.loadTableDefine(tableId);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        TableDefine tableDefine = (TableDefine)SerializationUtils.fromJsonString((String)str, TableDefine.class);
        return tableDefine;
    }

    @Override
    public PermissionControlType getPermissionControlType(String entityNumber) {
        String str = this.metadataService.loadEntityRuntimeMeta(entityNumber, (int)RuntimeMetaType.PermissionControlType.getValue(), "CtrlType");
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        PermissionControlType permissionControlType = (PermissionControlType)SerializationUtils.fromJsonString((String)str, PermissionControlType.class);
        return permissionControlType;
    }

    @Override
    public Set<String> getPermissionItems(String entityNumber) {
        return this.metadataService.loadPermissionItems(entityNumber);
    }

    @Override
    public Map<String, OrgRelationConfig> getDataEntityPrincipalRelation(String entityNumber) {
        HashMap<String, OrgRelationConfig> mapPrincipalRelation = null;
        String str = this.metadataService.loadEntityPrincipalRelationMeta(entityNumber);
        if (StringUtils.isNotBlank((CharSequence)str)) {
            List lstRelation = SerializationUtils.fromJsonStringToList((String)str, OrgRelationConfig.class);
            mapPrincipalRelation = new HashMap<String, OrgRelationConfig>(16);
            for (OrgRelationConfig relation : lstRelation) {
                String key = relation.getTrustee().getNumber();
                mapPrincipalRelation.put(key, relation);
            }
        }
        return mapPrincipalRelation;
    }

    @Override
    public Map<String, List<String>> getEnabledControlsMap(String formId) {
        return this.metadataService.getEnabledControlsMap(formId);
    }

    private RefEntityType createRefEntityType(String str) {
        boolean hasBillNo;
        Map jsonMap = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        boolean isBill = jsonMap.get("_Type_").equals("BillEntityType");
        jsonMap.put("_Type_", "RefEntityType");
        List refPropTypes = (List)jsonMap.get("RefPropTypes");
        if (refPropTypes != null) {
            for (Map refPropType : refPropTypes) {
                if (refPropType.containsKey(MASTER) && refPropType.get(MASTER) != null && ((Boolean)refPropType.get(MASTER)).booleanValue()) continue;
                refPropType.remove("Props");
            }
        }
        RefEntityType refEntityType = (RefEntityType)EntityItemTypes.fromMap(jsonMap);
        if (isBill && (hasBillNo = ((ArrayList)jsonMap.get("Properties")).stream().anyMatch(p -> "billno".equalsIgnoreCase((String)((HashMap)p).get("Name"))))) {
            refEntityType.setBillNo("billno");
        }
        return refEntityType;
    }
}

