/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.ISupportInitialize;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IGeoPointProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.ExtractOption;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.JsonSubEntryType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.RefEntityTypeCache;
import kd.bos.entity.RefPropType;
import kd.bos.entity.TreeSubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.script.annotations.KSMethod;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

@SdkPublic
public abstract class EntityType
extends DynamicObjectType
implements ISupportInitialize {
    private static final long serialVersionUID = 1120196914636102277L;
    private transient boolean _isInitialize;
    protected transient Map<String, IDataEntityProperty> propindexs;
    protected volatile transient Map<String, IDataEntityProperty> fields;
    private int ruleCount;

    public EntityType() {
    }

    public EntityType(String name) {
        super(name);
    }

    @SimplePropertyAttribute
    public int getRuleCount() {
        return this.ruleCount;
    }

    public void setRuleCount(int ruleCount) {
        this.ruleCount = ruleCount;
    }

    @KSMethod
    public IDataEntityProperty findProperty(String name) {
        this.createPropIndexs();
        return this.propindexs.get(name);
    }

    @KSMethod
    public Map<String, IDataEntityProperty> getFields() {
        this.createFieldsDictionary();
        LinkedHashMap<String, IDataEntityProperty> fieldProps = new LinkedHashMap<String, IDataEntityProperty>();
        fieldProps.putAll(this.fields);
        return fieldProps;
    }

    public void addProperty(DynamicProperty prop) {
        IDataEntityProperty property;
        super.addProperty(prop);
        prop = this.getProperty(prop.getName());
        if (this.propindexs != null) {
            this.createPropIndex((IDataEntityType)this, (IDataEntityProperty)prop, this.propindexs);
        }
        if (this.fields != null && (property = this.createFieldDictionary((IDataEntityProperty)prop)) != null) {
            this.fields.put(property.getName(), property);
        }
    }

    public void createPropIndexs() {
        if (this.propindexs == null) {
            CaseInsensitiveMap tmpMap = new CaseInsensitiveMap();
            this.createPropIndexs((IDataEntityType)this, (Map<String, IDataEntityProperty>)tmpMap);
            this.propindexs = tmpMap;
        }
    }

    protected void createPropIndexs(IDataEntityType type, Map<String, IDataEntityProperty> map) {
        for (IDataEntityProperty prop : type.getProperties()) {
            this.createPropIndex(type, prop, map);
        }
    }

    private void createPropIndex(IDataEntityType type, IDataEntityProperty prop, Map<String, IDataEntityProperty> map) {
        if (prop == type.getPrimaryKey() || type instanceof EntryType && ("seq".equals(prop.getName()) || type instanceof TreeSubEntryType && "pid".equals(prop.getName()))) {
            map.put(type.getName() + "." + prop.getName(), prop);
        } else {
            map.put(prop.getName(), prop);
        }
        if (prop instanceof ICollectionProperty && !(prop instanceof DynamicLocaleProperty)) {
            this.createPropIndexs(((ICollectionProperty)prop).getItemType(), map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFieldsDictionary() {
        if (this.fields == null) {
            EntityType entityType = this;
            synchronized (entityType) {
                if (this.fields == null) {
                    LinkedHashMap<String, IDataEntityProperty> fieldProps = new LinkedHashMap<String, IDataEntityProperty>();
                    for (IDataEntityProperty prop : this.getProperties()) {
                        IDataEntityProperty property = this.createFieldDictionary(prop);
                        if (property == null) continue;
                        fieldProps.put(property.getName(), property);
                    }
                    this.fields = fieldProps;
                }
            }
        }
    }

    private IDataEntityProperty createFieldDictionary(IDataEntityProperty prop) {
        if (prop instanceof IFieldHandle && !((IFieldHandle)prop).isSysField()) {
            return prop;
        }
        return null;
    }

    protected DynamicSimpleProperty createLocaleTypePkProperty() {
        return new VarcharProp();
    }

    @KSMethod
    public boolean isDbIgnore() {
        return StringUtils.isBlank((CharSequence)this.getAlias());
    }

    protected DynamicSimpleProperty createLocaleTypeLocaleProperty() {
        return new VarcharProp();
    }

    @KSMethod
    public final EntityType getSubEntityType(Collection<String> properties) {
        Set<String> setprops = this.getSubEntityTypeProperties(properties);
        ArrayList<String> props = Collections.list(Collections.enumeration(setprops));
        Collections.sort(props);
        return this.createSubEntityType(props);
    }

    protected Set<String> getSubEntityTypeProperties(Collection<String> properties) {
        HashSet<String> setprops = null;
        if (properties instanceof Set) {
            setprops = (HashSet<String>)properties;
        } else {
            setprops = new HashSet<String>(16);
            for (String prop : properties) {
                setprops.add(prop);
            }
        }
        return setprops;
    }

    protected EntityType createSubEntityType(List<String> props) {
        EntityType eType = null;
        try {
            eType = (EntityType)((Object)this.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return eType.createSubEntityTypeInner(props);
    }

    EntityType createSubEntityTypeInner(List<String> props) {
        ExtractOption option = new ExtractOption();
        option.setIncludeRefId(true);
        BasedataProp masterProp = null;
        ArrayList<String> refMasterProps = new ArrayList<String>();
        HashMap<String, EntryProp> fkFieldMap = new HashMap<String, EntryProp>(6);
        this.supplementItemClassType(props);
        boolean isEmptyPropCollection = this.getProperties() == null || this.getProperties().isEmpty();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (String string : props) {
            boolean effectiveProp;
            String[] paths = string.split("\\.");
            IDataEntityProperty p = this.findProperty(paths[0]);
            boolean bl = effectiveProp = p != null || isEmptyPropCollection;
            if (p instanceof EntryProp && paths.length > 1) {
                String fkFieldName;
                String path = "";
                StringBuilder buf = new StringBuilder(paths[1]);
                for (int i = 2; i < paths.length; ++i) {
                    buf.append('.').append(paths[i]);
                }
                path = buf.toString();
                IDataEntityProperty findProp = ((EntryType)((EntryProp)p).getItemType()).findProperty(path);
                if (findProp == null) {
                    findProp = ((EntryType)((EntryProp)p).getItemType()).getProperty(path);
                }
                if (StringUtils.isNotEmpty((CharSequence)(fkFieldName = ((EntryProp)p).getFkFieldName()))) {
                    fkFieldName = fkFieldName.toLowerCase(Locale.ENGLISH);
                    if (fkFieldMap.containsKey(p.getName())) {
                        EntryProp entryP = (EntryProp)fkFieldMap.get(p.getName());
                        if (entryP != null && findProp != null && StringUtils.equals((CharSequence)fkFieldName, (CharSequence)findProp.getAlias())) {
                            fkFieldMap.put(p.getName(), null);
                        }
                    } else if (findProp != null && fkFieldName.equals(findProp.getAlias())) {
                        fkFieldMap.put(p.getName(), null);
                    } else {
                        fkFieldMap.put(p.getName(), (EntryProp)p);
                    }
                }
                p = findProp;
            }
            if (p != null) {
                this.registerSubProp(option, p);
                if (p instanceof MasterBasedataProp) {
                    masterProp = (MasterBasedataProp)p;
                    if (paths.length > 1) {
                        refMasterProps.add(string.substring(p.getName().length() + 1));
                    }
                }
            }
            if (!effectiveProp) continue;
            sb.append(string).append(',');
        }
        for (Map.Entry entry : fkFieldMap.entrySet()) {
            EntryProp p = (EntryProp)entry.getValue();
            if (p == null) continue;
            String fkFieldName = p.getFkFieldName().toLowerCase();
            IDataEntityProperty fkField = null;
            for (IDataEntityProperty dataProp : p.getItemType().getProperties()) {
                if (!fkFieldName.equals(dataProp.getAlias())) continue;
                fkField = dataProp;
                break;
            }
            if (fkField == null) continue;
            this.registerSubProp(option, fkField);
        }
        if (masterProp != null) {
            if (masterProp.getComplexType() == null && refMasterProps.isEmpty()) {
                refMasterProps.add("id");
            }
            if (!refMasterProps.isEmpty()) {
                RefPropType refProp = new RefPropType();
                refProp.setId(masterProp.getBaseEntityId());
                refProp.setMaster(true);
                refProp.setProps(StringUtils.join((Object[])refMasterProps.toArray(), (String)","));
                ArrayList<RefPropType> arrayList = new ArrayList<RefPropType>();
                arrayList.add(refProp);
                RefEntityType refMasterType = (RefEntityType)RefEntityTypeCache.getRefTypes(arrayList, true).get(refProp.getId());
                refMasterType.setCacheFlag("RefMasterType");
                masterProp.setComplexType((IDataEntityType)refMasterType);
            }
            String master_extname = masterProp.getComplexType().getExtendName();
            int n = masterProp.getComplexType().getProperties().size();
            String cacheFlag = String.format("%s_%s_%s", n, master_extname.length(), master_extname.hashCode());
            this.setCacheFlag(cacheFlag);
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(']');
        this.sub(option);
        this.setExtendName(sb.insert(0, this.getName()).toString());
        return this;
    }

    private void registerSubProp(ExtractOption option, IDataEntityProperty p) {
        if (p != null) {
            option.register(p.getParent().getName(), new String[]{p.getName()});
            if (p.getParent() instanceof EntryType) {
                this.registerSubProp(option, this.findProperty(p.getParent().getName()));
            }
            if (p.getParent() instanceof JsonSubEntryType) {
                this.registerSubProp(option, this.findProperty(p.getParent().getName() + "_json"));
            }
        }
    }

    protected void sub(ExtractOption option) {
        HashSet<String> selectedProperties = option.GetExtractedProperties(this.getName());
        if (selectedProperties == null) {
            selectedProperties = new HashSet<String>(0);
        }
        boolean addLocale = false;
        LinkedHashMap<String, Object> newProperties = new LinkedHashMap<String, Object>(selectedProperties.size());
        for (IDataEntityProperty property : this.getProperties()) {
            IDataEntityProperty addressProp;
            IDataEntityProperty latitudeProp;
            DynamicProperty refIdProp;
            String currentPropertyName = property.getName();
            if (!EntityType.exists(selectedProperties, currentPropertyName) && property != this.getPrimaryKey()) continue;
            if ("multilanguagetext".equals(currentPropertyName)) {
                if (!addLocale) {
                    newProperties.putIfAbsent(property.getName(), property);
                    addLocale = true;
                }
            } else {
                newProperties.putIfAbsent(property.getName(), property);
            }
            if (property instanceof DynamicCollectionProperty) {
                DynamicCollectionProperty colp = (DynamicCollectionProperty)property;
                if (!(colp.getItemType() instanceof EntityType)) continue;
                EntityType itemType = (EntityType)colp.getItemType();
                itemType.sub(option);
                continue;
            }
            if (property instanceof BasedataProp && option.isIncludeRefId()) {
                refIdProp = this.getProperty(((BasedataProp)property).getRefIdPropName());
                if (refIdProp == null) continue;
                newProperties.putIfAbsent(refIdProp.getName(), refIdProp);
                continue;
            }
            if (property instanceof RefBillProp && option.isIncludeRefId()) {
                refIdProp = this.getProperty(((RefBillProp)property).getRefIdPropName());
                if (refIdProp == null) continue;
                newProperties.putIfAbsent(refIdProp.getName(), refIdProp);
                continue;
            }
            if (!addLocale && property instanceof MuliLangTextProp) {
                DynamicCollectionProperty localeCollectionProp = this.getLocaleProperty();
                newProperties.putIfAbsent(localeCollectionProp.getName(), localeCollectionProp);
                addLocale = true;
                continue;
            }
            if (!(property instanceof IGeoPointProperty)) continue;
            IDataEntityProperty longitudeProp = ((IGeoPointProperty)property).getLongitudeProperty();
            if (longitudeProp != null) {
                newProperties.putIfAbsent(longitudeProp.getName(), longitudeProp);
            }
            if ((latitudeProp = ((IGeoPointProperty)property).getLatitudeProperty()) != null) {
                newProperties.putIfAbsent(latitudeProp.getName(), latitudeProp);
            }
            if ((addressProp = ((IGeoPointProperty)property).getAddressProperty()) == null) continue;
            newProperties.putIfAbsent(addressProp.getName(), addressProp);
        }
        this.resetProperties(new ArrayList(newProperties.values()));
        this.propindexs = null;
    }

    private static boolean exists(Set<String> array, String str) {
        if (array != null) {
            return array.contains(str);
        }
        return false;
    }

    public void beginInit() {
        this._isInitialize = true;
    }

    public boolean isInitialized() {
        return this._isInitialize;
    }

    public synchronized void endInit() {
        this._isInitialize = false;
        this.fillMuliLangTextProp();
        this.getPrimaryKey();
    }

    protected void fillMuliLangTextProp() {
        DynamicCollectionProperty prop = this.getLocaleProperty();
        if (prop != null) {
            for (IDataEntityProperty p : prop.getItemType().getProperties()) {
                DynamicProperty mp = this.getProperty(p.getName());
                if (!(mp instanceof MuliLangTextProp)) continue;
                ((MuliLangTextProp)mp).setLocaleProperty((IDataEntityProperty)prop, (DynamicSimpleProperty)p);
            }
        }
    }

    protected void afterClone() {
        super.afterClone();
        this.propindexs = null;
        this.fields = null;
    }

    private void supplementItemClassType(List<String> props) {
        ArrayList<String> itemClassTypes = new ArrayList<String>(props.size());
        for (String prop : props) {
            ItemClassProp itemClassProp;
            String typePropName;
            IDataEntityProperty p = this.processSubProp(prop);
            if (!(p instanceof ItemClassProp) || props.contains(typePropName = (itemClassProp = (ItemClassProp)p).getTypePropName()) || itemClassTypes.contains(typePropName)) continue;
            itemClassTypes.add(typePropName);
        }
        props.addAll(itemClassTypes);
    }

    private IDataEntityProperty processSubProp(String prop) {
        String[] paths = prop.split("\\.");
        IDataEntityProperty p = this.findProperty(paths[0]);
        if (p instanceof EntryProp && paths.length > 1) {
            String path = "";
            StringBuilder buf = new StringBuilder(paths[1]);
            for (int i = 2; i < paths.length; ++i) {
                buf.append('.').append(paths[i]);
            }
            path = buf.toString();
            IDataEntityProperty findProp = ((EntryType)((EntryProp)p).getItemType()).findProperty(path);
            if (findProp == null) {
                findProp = ((EntryType)((EntryProp)p).getItemType()).getProperty(path);
            }
            p = findProp;
        }
        return p;
    }
}

