/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.ISupportInitialize;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.entity.TipLinkTitle;
import kd.bos.entity.TipsLink;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class Tips
implements Serializable,
ISupportInitialize {
    private static final long serialVersionUID = -2978234800337062965L;
    private String type;
    private LocaleString title;
    private LocaleString content;
    private String billno;
    private String place;
    private boolean link;
    private List<Map<String, Object>> linkData;
    private List<TipLinkTitle> linkTitles = new ArrayList<TipLinkTitle>(3);
    private transient List<Map<String, Object>> runtimeLinkData = new ArrayList<Map<String, Object>>(3);
    private boolean showIcon = true;
    private String iconClassName;
    private String triggerType;
    private Boolean isConfirm = false;
    public static final String Warp = "\r\n";
    public static final String Tab = "\t";
    public static final String Text = "text";
    public static final String Bill = "bill";
    private transient boolean _isInitialize;

    public Tips() {
    }

    public Tips(String type, String billno) {
        this.type = type;
        this.billno = billno;
    }

    public Tips(String type, LocaleString title, LocaleString content, boolean link, List<Map<String, Object>> linkData) {
        this.type = type;
        this.title = title;
        this.content = content;
        this.link = link;
        this.linkData = linkData;
    }

    @SimplePropertyAttribute(name="IsConfirm")
    @DefaultValueAttribute(value="false")
    public boolean isIsConfirm() {
        return this.isConfirm;
    }

    public void setIsConfirm(boolean isConfirm) {
        this.isConfirm = isConfirm;
    }

    public List<Map<String, Object>> getLinkData() {
        if (this.runtimeLinkData != null && !this.runtimeLinkData.isEmpty()) {
            return this.runtimeLinkData;
        }
        return this.linkData;
    }

    private void generateRuntimeLinkData() {
        this.runtimeLinkData = new ArrayList<Map<String, Object>>(10);
        if (this.linkData == null || this.linkData.isEmpty()) {
            return;
        }
        if (this.linkData.get(0).get("name") != null) {
            this.runtimeLinkData.addAll(this.linkData);
        } else {
            HashMap titles = new HashMap(this.linkTitles.size());
            this.linkTitles.forEach(t -> titles.put(t.getIndex(), t.getDisplayName()));
            for (Map<String, Object> it : this.linkData) {
                if (it == null) continue;
                HashMap<String, Object> info = new HashMap<String, Object>(it.size());
                info.putAll(it);
                this.runtimeLinkData.add(info);
                String index = info.get("index").toString();
                LocaleString title = (LocaleString)titles.get(index);
                if (title == null || title.isEmpty()) continue;
                info.put("name", title);
            }
        }
    }

    public void setLinkData(List<Map<String, Object>> linkData) {
        this.runtimeLinkData = linkData;
        this.setOriLinkData(linkData);
    }

    @SimplePropertyAttribute(name="LinkData")
    public List<Map<String, Object>> getOriLinkData() {
        return this.linkData;
    }

    public void setOriLinkData(List<Map<String, Object>> linkData) {
        this.linkData = linkData;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=TipLinkTitle.class, name="LinkTitles")
    public List<TipLinkTitle> getLinkTitles() {
        return this.linkTitles;
    }

    public void setLinkTitles(List<TipLinkTitle> linkTitles) {
        this.linkTitles = linkTitles;
    }

    @SimplePropertyAttribute(name="Link")
    public boolean isLink() {
        return this.link;
    }

    public void setLink(boolean link) {
        this.link = link;
    }

    @SimplePropertyAttribute(name="Place")
    public String getPlace() {
        return this.place;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    @SimplePropertyAttribute(name="Type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @SimplePropertyAttribute(name="Title")
    public LocaleString getTitle() {
        return this.title;
    }

    public void setTitle(LocaleString title) {
        this.title = title;
    }

    @SimplePropertyAttribute(name="Content")
    public LocaleString getContent() {
        return this.content;
    }

    public void setContent(LocaleString content) {
        this.content = content;
    }

    @SimplePropertyAttribute(name="Billno")
    public String getBillno() {
        return this.billno;
    }

    public void setBillno(String billno) {
        this.billno = billno;
    }

    public static List<Map<String, Object>> createLinkData(List<TipsLink> tipsLink) {
        if (tipsLink != null && tipsLink.size() > 0) {
            ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>(tipsLink.size());
            tipsLink.forEach(link -> {
                HashMap<String, Object> tmMap = new HashMap<String, Object>(3);
                tmMap.put("index", link.getIndex());
                tmMap.put("name", link.getCodeName());
                tmMap.put("code", link.getCode());
                data.add(tmMap);
            });
            return data;
        }
        return Collections.EMPTY_LIST;
    }

    public static List<Map<String, Object>> createLinkData(TipsLink tipsLink) {
        if (tipsLink != null) {
            return Tips.createLinkData(Collections.singletonList(tipsLink));
        }
        return Collections.EMPTY_LIST;
    }

    public static String insertLinkPlaceholder(int index) {
        return "#{" + index + "}";
    }

    @SimplePropertyAttribute(name="ShowIcon")
    @DefaultValueAttribute(value="true")
    public boolean isShowIcon() {
        return this.showIcon;
    }

    public void setShowIcon(boolean showIcon) {
        this.showIcon = showIcon;
    }

    @SimplePropertyAttribute(name="IconClassName")
    public String getIconClassName() {
        return this.iconClassName;
    }

    public void setIconClassName(String iconClassName) {
        this.iconClassName = iconClassName;
    }

    @SimplePropertyAttribute(name="TriggerType")
    public String getTriggerType() {
        return this.triggerType;
    }

    public void setTriggerType(String triggerType) {
        this.triggerType = triggerType;
    }

    public void endInit() {
        this._isInitialize = false;
        this.distinctLinkTitle();
        this.generateRuntimeLinkData();
    }

    private void distinctLinkTitle() {
        if (this.linkTitles.isEmpty()) {
            return;
        }
        this.linkTitles = new ArrayList<TipLinkTitle>(this.linkTitles.stream().collect(Collectors.toMap(it -> it.getIndex(), it -> it)).values());
    }

    private boolean isEndInit() {
        return !this._isInitialize;
    }

    public void beginInit() {
        this._isInitialize = true;
    }

    public boolean isInitialized() {
        return this._isInitialize;
    }
}

