/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.datamodel;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.InteTimeZone;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.TransType;

class CurrentDateTimeService {
    private static Log log = LogFactory.getLog(CurrentDateTimeService.class);

    CurrentDateTimeService() {
    }

    protected static Object getCurrentDate() {
        Object value = null;
        try {
            SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            InteTimeZone userTimeZone = InteTimeZone.getUserTimeZone((long)Long.parseLong(RequestContext.getOrCreate().getUserId()));
            InteTimeZone sysTimeZone = InteTimeZone.getSysTimeZone();
            value = sysTimeZone.format(sysTimeZone.parse(userTimeZone.format(new Date(), (DateFormat)datetimeFormat), (DateFormat)datetimeFormat), (DateFormat)dateFormat);
            value = sysTimeZone.parse(value.toString(), (DateFormat)dateFormat);
            if (Boolean.getBoolean("mvc.dst.offset.enable")) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeZone(sysTimeZone.getTimeZone());
                calendar.setTime((Date)value);
                calendar.set(11, 12);
                value = calendar.getTime();
            }
        }
        catch (ParseException e) {
            log.info(e.getMessage());
        }
        return value;
    }

    protected static Object getCurrentDatetime(IDataEntityProperty fieldProp) {
        Object value = null;
        try {
            SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            InteTimeZone sysTimeZone = InteTimeZone.getSysTimeZone();
            if (fieldProp instanceof DateTimeProp && TransType.SYSTIMEZONE.getValue() == ((DateTimeProp)fieldProp).getTimeZoneTransType()) {
                DateFormat systemTimeZoneDateFormat = KDDateFormatUtils.getSystemTimeZoneDateFormat();
                value = systemTimeZoneDateFormat.format(new Date());
            } else {
                value = sysTimeZone.parse(sysTimeZone.format(new Date(), (DateFormat)datetimeFormat), (DateFormat)datetimeFormat);
            }
        }
        catch (ParseException e) {
            log.info(e.getMessage());
        }
        return value;
    }

    protected static Date getCurrentDateOrgTZ(Object orgValue, boolean isDateTime, boolean isDateTimeProp) {
        Date value = null;
        Long orgId = null;
        if (orgValue instanceof DynamicObject) {
            orgId = (Long)((DynamicObject)orgValue).getPkValue();
        } else if (orgValue instanceof Long) {
            orgId = (Long)orgValue;
        }
        InteTimeZone timeZone = orgId == null || orgValue instanceof Long ? InteTimeZone.getUserTimeZone((long)RequestContext.getOrCreate().getCurrUserId()) : InteTimeZone.getOrgTimeZone((Long)orgId);
        try {
            InteTimeZone sysTimeZone = InteTimeZone.getSysTimeZone();
            if (isDateTime && isDateTimeProp) {
                SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                value = sysTimeZone.parse(timeZone.format(new Date(), (DateFormat)dateTimeFormat), (DateFormat)dateTimeFormat);
            } else {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                value = sysTimeZone.parse(timeZone.format(new Date(), (DateFormat)dateFormat), (DateFormat)dateFormat);
            }
        }
        catch (ParseException e) {
            log.info(e.getMessage());
        }
        return value;
    }

    protected static Date getCurrentDateSysTZ() {
        Date value = null;
        try {
            SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            InteTimeZone sysTimeZone = InteTimeZone.getSysTimeZone();
            value = sysTimeZone.parse(sysTimeZone.format(new Date(), (DateFormat)datetimeFormat), (DateFormat)dateFormat);
            if (Boolean.getBoolean("mvc.dst.offset.enable")) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeZone(sysTimeZone.getTimeZone());
                calendar.setTime(value);
                calendar.set(11, 12);
                value = calendar.getTime();
            }
        }
        catch (ParseException e) {
            log.info(e.getMessage());
        }
        return value;
    }
}

