/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.datamodel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.UnitProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.InteTimeZone;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FmtInfoUtils {
    private static final Log log = LogFactory.getLog(FmtInfoUtils.class);
    public static final String Prop_Amount_Precision = "ap";
    public static final String Prop_Price_Precision = "pp";
    public static final String Prop_Currency_Symbol = "cs";
    public static final String Prop_Show_Currency_Symbol = "scs";
    public static final String Prop_Currency_Number = "cn";
    public static final String Prop_Precision = "pa";
    public static final String Prop_Convert_Type = "ct";
    public static final String Prop_Unit_Precision = "ps";
    public static final String Prop_Time_Zone = "timezone";
    public static final String Prop_Today = "today";
    public static final String Key_AppParams_MaterialPrecision = "ismaterialprecisionenable";
    private static final int DEFAULT_AMOUNT_PRECISION = 2;
    private static final int DEFAULT_PRICE_PRECISION = 4;
    private static final String DEFAULT_CURRENCY_SYMBOL = "\u00a5";
    private static final String PRECISION = "precision";
    private static final String MASTER_ID = "masterid";
    private static final String MATERIAL_ID = "materialid";
    private static final String BD_MUL_TIME_ASURE_UNIT = "bd_multimeasureunit";

    public static Map<String, Object> getMainCurrencyFmt() {
        HashMap<String, Object> fmt = new HashMap<String, Object>();
        fmt.put(Prop_Amount_Precision, 2);
        fmt.put(Prop_Price_Precision, 4);
        fmt.put(Prop_Currency_Symbol, DEFAULT_CURRENCY_SYMBOL);
        fmt.put(Prop_Show_Currency_Symbol, true);
        return fmt;
    }

    public static Map<String, Object> getCurrencyFmt(DynamicObject currencySym) {
        HashMap<String, Object> fmt = new HashMap<String, Object>();
        if (currencySym == null) {
            fmt.put(Prop_Amount_Precision, 2);
            fmt.put(Prop_Price_Precision, 4);
        } else {
            fmt.put(Prop_Amount_Precision, currencySym.get("amtprecision"));
            fmt.put(Prop_Price_Precision, currencySym.get("priceprecision"));
            fmt.put(Prop_Currency_Symbol, currencySym.get("sign"));
            fmt.put(Prop_Currency_Number, currencySym.get("number"));
            if (currencySym.getDataEntityType().getProperties().get((Object)"isshowsign") != null) {
                fmt.put(Prop_Show_Currency_Symbol, currencySym.get("isshowsign"));
            }
        }
        return fmt;
    }

    public static Map<String, Object> getUnitFmt(DynamicObject unitSym) {
        if (unitSym == null) {
            return null;
        }
        HashMap<String, Object> fmt = new HashMap<String, Object>();
        fmt.put(Prop_Precision, unitSym.get("precisionaccount"));
        fmt.put(Prop_Convert_Type, unitSym.get("conversiontype"));
        fmt.put(Prop_Unit_Precision, unitSym.get(PRECISION));
        return fmt;
    }

    public static Map<String, Object> getTimeZone(DynamicObject org) {
        if (org == null) {
            return null;
        }
        HashMap<String, Object> fmt = new HashMap<String, Object>();
        InteTimeZone zone = InteTimeZone.getOrgTimeZone((Long)((Long)org.getPkValue()));
        if (zone != null) {
            fmt.put(Prop_Time_Zone, zone.getTimeZoneDesc());
            fmt.put(Prop_Today, zone.format(new Date()));
        }
        return fmt;
    }

    public static Map<String, Object> getUnitFmt(DynamicObject unitSym, DynamicObject material) {
        if (unitSym == null) {
            return null;
        }
        if (FmtInfoUtils.applyMaterialPrecision()) {
            return FmtInfoUtils.getUnitFmtFormMateriel(unitSym, material, null);
        }
        return FmtInfoUtils.getUnitFmt(unitSym);
    }

    public static boolean applyMaterialPrecision() {
        String appId = "0efa1992000000ac";
        SystemParamService systemParamService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);
        Map baseparam = systemParamService.loadSystemParameterFromCache(null, appId, "15", RequestContext.get().getOrgId(), 0L);
        if (baseparam == null) {
            return false;
        }
        Object ismaterialprecisionenable = baseparam.get(Key_AppParams_MaterialPrecision);
        return ismaterialprecisionenable != null && Boolean.parseBoolean(String.valueOf(ismaterialprecisionenable));
    }

    public static boolean applyMaterialPrecision(IDataModel dataModel) {
        Object rs = dataModel.getContextVariable(Key_AppParams_MaterialPrecision);
        if (rs != null) {
            return Boolean.parseBoolean(String.valueOf(rs));
        }
        boolean enable = FmtInfoUtils.applyMaterialPrecision();
        dataModel.putContextVariable(Key_AppParams_MaterialPrecision, enable);
        return enable;
    }

    public static Map<String, Object> getUnitFmt(UnitProp prop, DynamicObject unitObj, DynamicObject materielObj) {
        return FmtInfoUtils.getUnitFmt(prop, unitObj, materielObj, null);
    }

    public static Map<String, Object> getUnitFmt(UnitProp prop, DynamicObject unitObj, DynamicObject materielObj, Map<String, Map<String, Integer>> mapping) {
        if (StringUtils.isBlank((CharSequence)prop.getMaterielField())) {
            return FmtInfoUtils.getUnitFmt(unitObj);
        }
        return FmtInfoUtils.getUnitFmtFormMateriel(unitObj, materielObj, mapping);
    }

    public static Map<String, Map<String, Object>> getMultiUnitPrecisionMapping(List<DynamicObject> materielObjs) {
        DynamicObject[] datas;
        HashMap<String, Map<String, Object>> mapping = new HashMap<String, Map<String, Object>>();
        if (materielObjs == null || materielObjs.isEmpty()) {
            return mapping;
        }
        ArrayList<Object> masterIds = new ArrayList<Object>();
        for (DynamicObject material : materielObjs) {
            if (material == null) continue;
            if (material.get(MASTER_ID) instanceof DynamicObject) {
                masterIds.add(((DynamicObject)material.get(MASTER_ID)).getPkValue());
                continue;
            }
            masterIds.add(material.get(MASTER_ID));
        }
        if (masterIds.isEmpty()) {
            return mapping;
        }
        String selectFields = "id,precision,measureunitid,materialid";
        QFilter filter = new QFilter(MATERIAL_ID, "in", masterIds);
        for (DynamicObject obj : datas = FmtInfoUtils.loadData(BD_MUL_TIME_ASURE_UNIT, selectFields, new QFilter[]{filter})) {
            if (mapping.get(obj.get(MATERIAL_ID).toString()) == null) {
                mapping.put(obj.get(MATERIAL_ID).toString(), new HashMap());
            }
            ((Map)mapping.get(obj.get(MATERIAL_ID).toString())).put(obj.get("measureunitid").toString(), obj.get(PRECISION));
        }
        return mapping;
    }

    private static Map<String, Object> getUnitFmtFormMateriel(DynamicObject unitSym, DynamicObject material, Map<String, Map<String, Integer>> mapping) {
        Map<String, Object> fmt = FmtInfoUtils.getUnitFmt(unitSym);
        if (!FmtInfoUtils.applyMaterialPrecision()) {
            return fmt;
        }
        if (unitSym == null) {
            return null;
        }
        Object unitId = unitSym.get("id");
        if (fmt == null || material == null) {
            return fmt;
        }
        Object materialId = 0L;
        materialId = material.get(MASTER_ID) instanceof DynamicObject ? ((DynamicObject)material.get(MASTER_ID)).getPkValue() : material.get(MASTER_ID);
        if (materialId == null && material.getPkValue() != null) {
            String objEntityName;
            Object objId = material.getPkValue();
            DynamicObject obj = FmtInfoUtils.loadSingleFromCache(objId, objEntityName = material.getDataEntityType().getName(), "id,materialid");
            if (obj == null) {
                log.warn(MessageFormat.format("\u7269\u6599\u7cbe\u5ea6\u83b7\u53d6\u5f02\u5e38\uff0cmasterid is null, entity={0} pk={1}", material.getDataEntityType().getName(), material.getPkValue()));
                return fmt;
            }
            materialId = obj.get(MASTER_ID) instanceof DynamicObject ? ((DynamicObject)obj.get(MASTER_ID)).getPkValue() : obj.get(MASTER_ID);
        }
        if (materialId == null) {
            log.warn(MessageFormat.format("\u7269\u6599\u7cbe\u5ea6\u83b7\u53d6\u5f02\u5e38\uff0cmasterid is null, entity={0} pk={1}", material.getDataEntityType().getName(), material.getPkValue()));
            return fmt;
        }
        if (mapping != null && mapping.containsKey(materialId.toString()) && mapping.get(materialId.toString()).containsKey(unitId.toString())) {
            fmt.put(Prop_Unit_Precision, mapping.get(materialId.toString()).get(unitId.toString()));
            return fmt;
        }
        QFilter[] filters = new QFilter[]{new QFilter(MATERIAL_ID, "=", materialId), new QFilter("measureunitid", "=", unitId)};
        String selectFields = "id,precision";
        int precision = -1;
        DynamicObject[] datas = FmtInfoUtils.loadData(BD_MUL_TIME_ASURE_UNIT, selectFields, filters);
        if (datas != null && datas.length > 0) {
            precision = datas[0].getInt(PRECISION);
        }
        if (precision != -1) {
            fmt.put(Prop_Unit_Precision, precision);
        }
        return fmt;
    }

    private static DynamicObject loadSingleFromCache(Object pk, String entityName, String selectFields) {
        DynamicObject obj = null;
        try {
            Class<?> servie = Class.forName("kd.bos.servicehelper.BusinessDataServiceHelper");
            Method method = servie.getMethod("loadSingleFromCache", Object.class, String.class, String.class);
            obj = (DynamicObject)method.invoke(servie, pk, entityName, selectFields);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new KDException(BosErrorCode.bOS, MessageFormat.format("query material err,entityname={0},pk={1}", entityName, pk), (Throwable)e);
        }
        return obj;
    }

    private static DynamicObject[] loadData(String entityName, String selectFields, QFilter[] filters) {
        try {
            Class<?> servie = Class.forName("kd.bos.servicehelper.BusinessDataServiceHelper");
            Method method = servie.getMethod("loadFromCache", String.class, String.class, filters.getClass());
            Map obj = (Map)method.invoke(servie, entityName, selectFields, filters);
            return obj.values().toArray(new DynamicObject[0]);
        }
        catch (Exception e) {
            ORM orm = ORM.create();
            try (DataSet ds = orm.queryDataSet("FmtInfoUtils", entityName, selectFields, filters, null);){
                DynamicObjectCollection rows = orm.toPlainDynamicObjectCollection(ds);
                DynamicObject[] dynamicObjectArray = (DynamicObject[])rows.toArray((Object[])new DynamicObject[0]);
                return dynamicObjectArray;
            }
        }
    }
}

