/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.datamodel;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.DataEntityCacheType;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;

@SdkPublic
public class ORMUtil {
    private static final String ID_AND_NAME = "id,name";
    private static final String COUNTRY = "country";
    private static final String GROUP_TITLE = "groupTitle";
    private static final String ITEMS = "items";
    private static final String BOS_ENTITY_CORE = "bos-entity-core";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static Log logger = LogFactory.getLog(ORMUtil.class);
    private static final String DATA_FIELD_ENABLE = "enable";
    private static final String YES = "1";
    private static final String ENTITY_NAME_ADMIN_DIVISION = "bd_admindivision";
    private static final String ENTITY_NAME_ADMIN_DIVISION_LEVEL = "bd_admindivisionlevel";
    private static final String ENTITY_NAME_COUNTRY = "bd_country";
    private static final char FULL_NAME_SEPARATOR_OLD = '_';
    private static final char FULL_NAME_SEPARATOR_SPL = '/';
    private static final char FULL_NAME_SEPARATOR_CURR = ".".charAt(0);
    private static final String DEFAULT_ORDER = "name asc";
    private static final String ID = "id";
    private static final String FULLNAME = "fullname";
    private static final String[] SELECTED_PROPERTIES = new String[]{"number", "name", "parent", "basedatafield", "fullspell", "simplespell", "description", "citynumber", "iscity", "areacode", "longnumber", "fullname", "isleaf", "enable", "country", "level", "issystem", "createtime", "modifytime"};
    private static final DistributeSessionlessCache REDIS_CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    private static final String ADMIN_DIVISION_CACHE_PREFIX = "bos:bd_admindivision:";

    public static List<Map<String, String>> getCountrys() {
        ORM orm = ORM.create();
        QFilter filter = new QFilter(DATA_FIELD_ENABLE, "=", (Object)YES);
        DynamicObjectCollection dynamicObjects = orm.query(ENTITY_NAME_COUNTRY, ID_AND_NAME, filter.toArray(), DEFAULT_ORDER);
        return ORMUtil.getIdNameMapping((List<DynamicObject>)dynamicObjects);
    }

    public static List<Map<String, String>> getAdmindivisionLevelsByCountryId(String countryId) {
        List<Map<String, String>> result = new ArrayList<Map<String, String>>(10);
        try {
            ORM orm = ORM.create();
            QFilter filter = new QFilter(COUNTRY, "=", (Object)Long.parseLong(countryId));
            filter.and(DATA_FIELD_ENABLE, "=", (Object)YES);
            DynamicObjectCollection dynamicObjects = orm.query(ENTITY_NAME_ADMIN_DIVISION_LEVEL, ID_AND_NAME, filter.toArray(), "level asc");
            result = ORMUtil.getIdNameMapping((List<DynamicObject>)dynamicObjects, false);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private static List<Map<String, String>> getIdNameMapping(List<DynamicObject> dynamicObjects, boolean needSort) {
        List<Map<String, String>> result = new ArrayList<Map<String, String>>(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put(ID, dynamicObject.get(ID).toString());
            map.put(NAME, dynamicObject.get(NAME).toString());
            result.add(map);
        }
        if ((Lang.zh_TW == Lang.get() || Lang.zh_CN == Lang.get()) && needSort) {
            result = ORMUtil.getChineseOrderList(result);
        }
        return result;
    }

    private static List<Map<String, String>> getIdNameMapping(List<DynamicObject> dynamicObjects) {
        return ORMUtil.getIdNameMapping(dynamicObjects, true);
    }

    private static List<Map<String, String>> getChineseOrderList(List<Map<String, String>> chineseList) {
        return chineseList.stream().sorted(Comparator.comparing(chinese -> ORMUtil.toPinyin((String)chinese.get(NAME)))).collect(Collectors.toList());
    }

    public static String toPinyin(String chinese) {
        StringBuilder result = new StringBuilder();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        defaultFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
        try {
            for (int i = 0; i < chinese.length(); ++i) {
                String[] pinyins = PinyinHelper.toHanyuPinyinStringArray((char)chinese.charAt(i), (HanyuPinyinOutputFormat)defaultFormat);
                String pin = "";
                pin = pinyins != null && pinyins.length > 0 ? (chinese.contains(ResManager.loadKDString((String)"\u91cd\u5e86", (String)"ORMUtil_0", (String)"bos-entity-metadata", (Object[])new Object[0])) && pinyins.length > 1 ? pinyins[1] : pinyins[0]) : String.valueOf(chinese.charAt(i));
                result.append(pin);
            }
        }
        catch (Exception e) {
            logger.error(String.format("\u8f6c\u6362\u62fc\u97f3\u9519\u8bef,%s", e.getMessage()), (Throwable)e);
        }
        return result.toString();
    }

    public static List<Map<String, Object>> getProvincesByCountryId(String countryId) {
        List<Map<String, Object>> provinces = new ArrayList<Map<String, Object>>(4);
        try {
            ORM orm = ORM.create();
            QFilter filter = new QFilter(COUNTRY, "=", (Object)Long.parseLong(countryId));
            filter.and(DATA_FIELD_ENABLE, "=", (Object)YES);
            QFilter filter1 = new QFilter("level", "=", (Object)1);
            QFilter[] filters = new QFilter[]{filter, filter1};
            DynamicObjectCollection dynamicObjects = orm.query(ENTITY_NAME_ADMIN_DIVISION, "id,name,simplespell", filters, DEFAULT_ORDER);
            if (dynamicObjects == null || dynamicObjects.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            ArrayList provinces1 = new ArrayList(10);
            ArrayList provinces2 = new ArrayList(10);
            ArrayList provinces3 = new ArrayList(10);
            ArrayList provinces4 = new ArrayList(10);
            ArrayList provinces5 = new ArrayList(10);
            for (DynamicObject dynamicObject : dynamicObjects) {
                HashMap<String, String> map = new HashMap<String, String>(2);
                map.put(ID, dynamicObject.get(ID).toString());
                map.put(NAME, dynamicObject.get(NAME).toString());
                String groupField = dynamicObject.get(NAME).toString();
                if (Lang.zh_CN == Lang.get() || Lang.zh_TW == Lang.get()) {
                    groupField = ORMUtil.toPinyin(groupField);
                }
                if (StringUtils.isEmpty((String)groupField)) continue;
                char i = groupField.toUpperCase().charAt(0);
                if (!StringUtils.isNotEmpty((String)groupField)) continue;
                if (i >= 'A' && i <= 'G') {
                    provinces1.add(map);
                    continue;
                }
                if (i >= 'H' && i <= 'K') {
                    provinces2.add(map);
                    continue;
                }
                if (i >= 'L' && i <= 'S') {
                    provinces3.add(map);
                    continue;
                }
                if (i >= 'T' && i <= 'Z') {
                    provinces4.add(map);
                    continue;
                }
                provinces5.add(map);
            }
            HashMap<String, Object> map1 = new HashMap<String, Object>(2);
            map1.put(GROUP_TITLE, "A-G");
            map1.put(ITEMS, provinces1);
            provinces.add(map1);
            HashMap<String, Object> map2 = new HashMap<String, Object>(2);
            map2.put(GROUP_TITLE, "H-K");
            map2.put(ITEMS, provinces2);
            provinces.add(map2);
            HashMap<String, Object> map3 = new HashMap<String, Object>(2);
            map3.put(GROUP_TITLE, "L-S");
            map3.put(ITEMS, provinces3);
            provinces.add(map3);
            HashMap<String, Object> map4 = new HashMap<String, Object>(2);
            map4.put(GROUP_TITLE, "T-Z");
            map4.put(ITEMS, provinces4);
            provinces.add(map4);
            HashMap<String, Object> map5 = new HashMap<String, Object>(2);
            map5.put(GROUP_TITLE, "#");
            map5.put(ITEMS, provinces5);
            provinces.add(map5);
            provinces = provinces.stream().filter(provinceGroupMap -> ((List)provinceGroupMap.get(ITEMS)).size() > 0).collect(Collectors.toList());
            provinces.forEach(provinceGroupMap -> {
                List orderByNamePinyinList = ((List)provinceGroupMap.get(ITEMS)).stream().sorted(Comparator.comparing(provinceMap -> ORMUtil.toPinyin((String)provinceMap.get(NAME)))).collect(Collectors.toList());
                provinceGroupMap.put(ITEMS, orderByNamePinyinList);
            });
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return provinces;
    }

    public static List<Map<String, String>> getProvincesByCountryIdForMobile(String countryId) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter(COUNTRY, "=", (Object)ORMUtil.idFormStringToLong(countryId));
        filter.and(DATA_FIELD_ENABLE, "=", (Object)YES);
        filter.and("level", "=", (Object)1);
        DynamicObjectCollection dynamicObjects = orm.query(ENTITY_NAME_ADMIN_DIVISION, ID_AND_NAME, filter.toArray(), DEFAULT_ORDER);
        if (dynamicObjects.size() == 0) {
            return Collections.emptyList();
        }
        return ORMUtil.getIdNameMapping((List<DynamicObject>)dynamicObjects);
    }

    public static List<Map<String, String>> getAdminDivisionsByParentId(String parentId) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter("parent", "=", (Object)Long.parseLong(parentId));
        filter.and(DATA_FIELD_ENABLE, "=", (Object)YES);
        DynamicObjectCollection dynamicObjects = orm.query(ENTITY_NAME_ADMIN_DIVISION, ID_AND_NAME, filter.toArray(), DEFAULT_ORDER);
        return ORMUtil.getIdNameMapping((List<DynamicObject>)dynamicObjects);
    }

    public static Map<String, Object> getAdminDivisionInfo(String adminId) {
        HashMap<String, Object> adminDivisionInfo = new HashMap<String, Object>(4);
        try {
            DynamicObject admindivision = ORMUtil.getAdminDivisionInfoById(adminId);
            if (admindivision != null) {
                DynamicObject country = admindivision.getDynamicObject(COUNTRY);
                if (country == null || country.getInt(ID) == 0) {
                    DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType(ENTITY_NAME_COUNTRY, Arrays.asList((Object[])new String[]{ID, NAME, NUMBER}.clone()));
                    long countryId = ORMUtil.getCountryFromRedis(adminId);
                    Map<Object, DynamicObject> pk2Country = ORMUtil.loadFromCache(new Object[]{countryId}, subDataEntityType, false);
                    country = pk2Country.get(countryId);
                }
                adminDivisionInfo.put("countryId", country.getString(ID));
                adminDivisionInfo.put("countryName", country.getString(NAME));
                String fullname = admindivision.getString(FULLNAME);
                String[] fullNameArr = new String[]{};
                if (StringUtils.isNotEmpty((String)fullname)) {
                    fullname = org.apache.commons.lang3.StringUtils.replaceChars((String)fullname, (char)FULL_NAME_SEPARATOR_CURR, (char)'_');
                    fullNameArr = fullname.split(String.valueOf('_'));
                }
                adminDivisionInfo.put("adminvisionAry", fullNameArr);
                String longNumber = admindivision.getString("longnumber");
                adminDivisionInfo.put("selectedIds", ORMUtil.getAdminDivisionIdByLongNumber(longNumber));
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u884c\u653f\u533a\u5212\u4fe1\u606f\u6709\u8bef", (Throwable)e);
        }
        return adminDivisionInfo;
    }

    public static DynamicObject getAdminDivisionInfoById(String adminId) {
        DynamicObject admindivision = null;
        try {
            if (StringUtils.isEmpty((String)adminId)) {
                return null;
            }
            Long pk = Long.valueOf(adminId);
            Map<Object, DynamicObject> rets = ORMUtil.loadFromCache(ENTITY_NAME_ADMIN_DIVISION, new QFilter[]{new QFilter(ID, "=", (Object)pk)});
            admindivision = rets.get(pk);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u884c\u653f\u533a\u5212\u4fe1\u606f\u6709\u8bef", (Throwable)e);
        }
        return admindivision;
    }

    public static Object getAdminDivisionByName(String fullname) {
        try {
            fullname = org.apache.commons.lang3.StringUtils.replaceChars((String)fullname, (char)'/', (char)'_');
            fullname = org.apache.commons.lang3.StringUtils.replaceChars((String)fullname, (char)FULL_NAME_SEPARATOR_CURR, (char)'_');
            String adminDivisionFullName = fullname.substring(fullname.indexOf(95) + 1);
            String countryName = fullname.substring(0, fullname.indexOf(95));
            QFilter filter = new QFilter(FULLNAME, "=", (Object)adminDivisionFullName);
            filter.and("country.name", "=", (Object)countryName);
            filter.and(DATA_FIELD_ENABLE, "=", (Object)YES);
            Map<Object, DynamicObject> dynamicObjects = ORMUtil.loadFromCache(ENTITY_NAME_ADMIN_DIVISION, filter.toArray());
            if (dynamicObjects != null && !dynamicObjects.isEmpty()) {
                return dynamicObjects.entrySet().stream().findFirst().map(Map.Entry::getKey).orElse(null);
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u957f\u540d\u79f0\u83b7\u53d6\u884c\u653f\u533a\u5212\u5931\u8d25: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static Map<Object, DynamicObject> loadFromCache(String entityName, QFilter[] filters) {
        Set<String> selectedPropSet = Arrays.stream(SELECTED_PROPERTIES).collect(Collectors.toSet());
        DynamicObjectType type = EntityMetadataCache.getSubDataEntityType(entityName, selectedPropSet);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
        Object[] pks = cacheManager.getCachePks(filters);
        if (pks == null) {
            try {
                Class<?> service = Class.forName("kd.bos.data.BusinessDataReader");
                Method method = service.getMethod("loadFromCache", String.class, filters.getClass());
                Map result = (Map)method.invoke(service, entityName, filters);
                result.forEach((id, adminDivision) -> ORMUtil.putCountry2Redis(id, adminDivision.getDynamicObject(COUNTRY)));
                return result;
            }
            catch (Exception e) {
                logger.error(String.format("\u901a\u8fc7\u53cd\u5c04\u521b\u5efaBusinessDataReader\u5931\u8d25\uff0c%s", e.getMessage()), (Throwable)e);
                try {
                    ORM orm = ORM.create();
                    DynamicObject dynamicObject = orm.queryOne(entityName, filters);
                    Long id2 = Optional.ofNullable(dynamicObject).map(item -> item.getLong(ID)).orElse(null);
                    if (id2 != null) {
                        HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>();
                        map.put(id2, dynamicObject);
                        ORMUtil.putCountry2Redis(id2, dynamicObject.getDynamicObject(COUNTRY));
                        return map;
                    }
                }
                catch (Exception e1) {
                    logger.error(String.format("\u901a\u8fc7ORM\u67e5\u8be2\u884c\u653f\u533a\u5212\u9519\u8bef\uff0c%s", e1.getMessage()), (Throwable)e1);
                }
            }
        }
        if (pks != null) {
            return ORMUtil.loadFromCache(pks, type, false);
        }
        return new HashMap<Object, DynamicObject>(0);
    }

    private static void putCountry2Redis(Object adminDivisionId, DynamicObject country) {
        REDIS_CACHE.put(ADMIN_DIVISION_CACHE_PREFIX + adminDivisionId.toString(), (Object)country.getString(ID));
    }

    private static long getCountryFromRedis(Object adminDivisionId) {
        String countryString = (String)REDIS_CACHE.get(ADMIN_DIVISION_CACHE_PREFIX + adminDivisionId.toString());
        if (StringUtils.isEmpty((String)countryString)) {
            ORM orm = ORM.create();
            DynamicObject dynamicObject = orm.queryOne(ENTITY_NAME_ADMIN_DIVISION, new QFilter[]{new QFilter(ID, "=", (Object)Long.valueOf(adminDivisionId.toString()))});
            if (dynamicObject != null && dynamicObject.getDynamicObject(COUNTRY) != null) {
                ORMUtil.putCountry2Redis(adminDivisionId, dynamicObject.getDynamicObject(COUNTRY));
                return (Long)dynamicObject.getDynamicObject(COUNTRY).getPkValue();
            }
            return 0L;
        }
        return Long.parseLong(countryString);
    }

    private static long idFormStringToLong(String id) {
        long adminIdTypeLong = -1L;
        try {
            if (StringUtils.isNotEmpty((String)id)) {
                adminIdTypeLong = Long.parseLong(id);
            }
        }
        catch (Exception e) {
            logger.error("id\u5e94\u8be5\u662f\u4e00\u4e2aLong\u7c7b\u578b" + e.getMessage(), (Throwable)e);
        }
        return adminIdTypeLong;
    }

    public static Object getAdminDivisionFullName(String adminId) {
        Map<String, Object> info = ORMUtil.getAdminDivisionInfo(adminId);
        if (info.isEmpty()) {
            return null;
        }
        Object countryName = info.getOrDefault("countryName", StringUtils.getEmpty());
        QFilter qFilter = new QFilter(ID, "=", (Object)ORMUtil.idFormStringToLong(adminId));
        Map<Object, DynamicObject> map = ORMUtil.loadFromCache(ENTITY_NAME_ADMIN_DIVISION, qFilter.toArray());
        DynamicObject dynamicObject = map.values().stream().findFirst().orElse(null);
        if (dynamicObject == null) {
            return null;
        }
        String fullname = dynamicObject.getString(FULLNAME);
        String result = countryName + "/" + String.join((CharSequence)"/", (String[])info.getOrDefault("adminvisionAry", new String[0]));
        if (StringUtils.isNotEmpty((String)fullname) && '_' == fullname.charAt(fullname.length() - 1)) {
            result = result + '/';
        }
        return result;
    }

    public static Map<Object, DynamicObject> loadFromCache(Object[] pkArray, DynamicObjectType dt, boolean loadReferenceData) {
        LinkedHashMap<Object, DynamicObject> oDynamicObject = new LinkedHashMap<Object, DynamicObject>(16);
        ArrayList<Object> notFindFromCachePkArray = new ArrayList<Object>(10);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)dt);
        Map cacheMap = cacheManager.get(pkArray);
        ISimpleProperty pkProp = dt.getPrimaryKey();
        for (Object pk : pkArray) {
            DynamicObject dataEntity = (DynamicObject)cacheMap.get(pk);
            if (dataEntity != null) {
                boolean bShare = dt.getCacheType().equals((Object)DataEntityCacheType.Share);
                if (bShare) {
                    oDynamicObject.put(pkProp.getValueFast((Object)dataEntity), dataEntity);
                    continue;
                }
                DynamicObject newObj = (DynamicObject)dt.createInstance();
                for (IDataEntityProperty prop : dt.getProperties()) {
                    Object val = prop.getValue((Object)dataEntity);
                    prop.setValue((Object)newObj, val);
                }
                oDynamicObject.put(pkProp.getValueFast((Object)newObj), newObj);
                continue;
            }
            notFindFromCachePkArray.add(pk);
        }
        if (notFindFromCachePkArray.size() > 0) {
            Object[] notCacheObjecs = ORMUtil.load(notFindFromCachePkArray.toArray(), dt, Boolean.TRUE);
            cacheManager.put(notCacheObjecs);
            for (Object o : notCacheObjecs) {
                oDynamicObject.put(pkProp.getValueFast(o), (DynamicObject)o);
            }
        }
        Object[] results = oDynamicObject.values().toArray(new DynamicObject[0]);
        if (loadReferenceData && results.length > 0) {
            ORMUtil.loadRefence(results, (IDataEntityType)dt);
        }
        return oDynamicObject;
    }

    public static DynamicObject[] load(Object[] pkArray, DynamicObjectType type, Boolean loadReferenceData) {
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)type);
        Object[] array = (DynamicObject[])dataManager.read(pkArray);
        if (loadReferenceData.booleanValue()) {
            CachedLoadReferenceObjectManager manager = new CachedLoadReferenceObjectManager((IDataEntityType)type, false);
            manager.Load(array);
        }
        return array;
    }

    public static void loadRefence(Object[] dataEntitys, IDataEntityType type) {
        CachedLoadReferenceObjectManager manager = new CachedLoadReferenceObjectManager(type, false);
        manager.Load(dataEntitys);
    }

    private static List<String> getAdminDivisionIdByLongNumber(String longNumber) {
        if (StringUtils.isEmpty((String)longNumber)) {
            return Collections.emptyList();
        }
        String[] numbers = org.apache.commons.lang3.StringUtils.split((String)longNumber, (String)".");
        QFilter filter = new QFilter(NUMBER, "in", (Object)numbers);
        Map<Object, DynamicObject> objectsMap = ORMUtil.loadFromCache(ENTITY_NAME_ADMIN_DIVISION, filter.toArray());
        return objectsMap.keySet().stream().map(String::valueOf).collect(Collectors.toList());
    }
}

