/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.FilterKeyValue;
import kd.bos.entity.filter.FilterKeyValueCollection;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ControlFilters {
    private Map<String, List<Object>> fastFilters = new HashMap<String, List<Object>>(16);
    private Map<String, ControlFilter> filters = new HashMap<String, ControlFilter>(16);
    private Map<String, List<ControlFilter>> filtersListMap = new HashMap<String, List<ControlFilter>>(16);
    private List<Map<String, List<Object>>> andFilter;
    private String searchText;
    private ControlFilter currentControlFilter;

    public List<Map<String, List<Object>>> getAndFilter() {
        return this.andFilter;
    }

    public void setAndFilter(List<Map<String, List<Object>>> andFilter) {
        this.andFilter = andFilter;
    }

    public String getSearchText() {
        return this.searchText;
    }

    @SdkInternal
    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    @Deprecated
    public Map<String, ControlFilter> getFilters() {
        return this.filters;
    }

    public Map<String, List<ControlFilter>> getFiltersListMap() {
        return this.filtersListMap;
    }

    public ControlFilter getCurrentControlFilter() {
        return this.currentControlFilter;
    }

    private List<Object> getFilterKeyValueByKey(FilterKeyValueCollection filterKeyValueCollection, String key) {
        for (FilterKeyValue filterKeyValue : filterKeyValueCollection.getFilterKeyValues()) {
            if (!key.equals(filterKeyValue.getKey())) continue;
            return filterKeyValue.getValue();
        }
        return new ArrayList<Object>();
    }

    private List<Object> getFilerId(FilterKeyValueCollection filterKeyValueCollection) {
        return this.getFilterKeyValueByKey(filterKeyValueCollection, "Id");
    }

    private List<Object> getFilerValue(FilterKeyValueCollection filterKeyValueCollection) {
        return this.getFilterKeyValueByKey(filterKeyValueCollection, "Value");
    }

    private List<Object> getFilerName(FilterKeyValueCollection filterKeyValueCollection) {
        return this.getFilterKeyValueByKey(filterKeyValueCollection, "FieldName");
    }

    private List<Object> getCompare(FilterKeyValueCollection filterKeyValueCollection) {
        return this.getFilterKeyValueByKey(filterKeyValueCollection, "Compare");
    }

    @SdkInternal
    public ControlFilters(FilterKeyValueCollections fastFilterValues, FilterKeyValueCollections otherFilterValues) {
        List<Object> fieldNames;
        for (FilterKeyValueCollection filterKeyValueCollection : fastFilterValues.getFilterValueCollection()) {
            fieldNames = this.getFilerName(filterKeyValueCollection);
            List<Object> value = this.getFilerValue(filterKeyValueCollection);
            for (Object fieldName : fieldNames) {
                if (this.fastFilters.containsKey(fieldName.toString())) {
                    List<Object> fastFilter = this.fastFilters.get(fieldName.toString());
                    fastFilter.addAll(value);
                    this.fastFilters.put(fieldName.toString(), fastFilter);
                    continue;
                }
                this.fastFilters.put(fieldName.toString(), new ArrayList<Object>(value));
            }
        }
        for (FilterKeyValueCollection filterKeyValueCollection : otherFilterValues.getFilterValueCollection()) {
            fieldNames = this.getFilerName(filterKeyValueCollection);
            List<Object> ids = this.getFilerId(filterKeyValueCollection);
            List<Object> value = this.getFilerValue(filterKeyValueCollection);
            List<Object> compare = this.getCompare(filterKeyValueCollection);
            if (fieldNames.isEmpty()) continue;
            String fieldName = fieldNames.get(0).toString();
            ControlFilter controlFilter = this.filters.get(fieldName);
            List<ControlFilter> controlFilterList = this.filtersListMap.get(fieldName);
            if (controlFilter != null) {
                if (fieldName.endsWith("id")) {
                    controlFilter.getValue().addAll(ids);
                } else {
                    controlFilter.getValue().addAll(value);
                }
                this.filters.put(fieldName, controlFilter);
            } else {
                controlFilter = ControlFilters.createControlFilter(ids, value, compare, fieldName);
                this.filters.put(fieldName, controlFilter);
            }
            if (controlFilterList == null) {
                controlFilterList = new ArrayList<ControlFilter>(10);
            }
            controlFilterList.add(controlFilter);
            this.filtersListMap.put(fieldName, controlFilterList);
            this.currentControlFilter = controlFilter;
        }
    }

    private static ControlFilter createControlFilter(List<Object> ids, List<Object> value, List<Object> compare, String fieldName) {
        boolean isId;
        String[] split = fieldName.split("\\.");
        boolean bl = isId = split.length > 1 && "id".equals(split[split.length - 1]);
        ControlFilter controlFilter = new ControlFilter(fieldName, new ArrayList<Object>(isId ? (!ids.isEmpty() ? ids : value) : value));
        if (!compare.isEmpty()) {
            controlFilter.setCompareType(compare.get(0).toString());
        }
        return controlFilter;
    }

    @SdkInternal
    public ControlFilters(FilterKeyValueCollections fastFilterValues) {
        for (FilterKeyValueCollection filterKeyValueCollection : fastFilterValues.getFilterValueCollection()) {
            for (FilterKeyValue filterKeyValue : filterKeyValueCollection.getFilterKeyValues()) {
                this.fastFilters.put(filterKeyValue.getKey(), filterKeyValue.getValue());
            }
        }
    }

    public List<Object> getFastFilter(String fieldName) {
        return this.fastFilters.get(fieldName);
    }

    @Deprecated
    public List<Object> getFilter(String fieldName) {
        ControlFilter controlFilter = this.filters.get(fieldName);
        if (controlFilter != null) {
            return controlFilter.getValue();
        }
        return new ArrayList<Object>();
    }

    public String toString() {
        return "ControlFilters [fastFilters=" + this.fastFilters + ", filters=" + this.filters + ", searchText=" + this.searchText + "]";
    }
}

