/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.BuildBaseDataPropertyQFiltersResult;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.CompareTypeDto;
import kd.bos.entity.filter.F7FilterParam;
import kd.bos.entity.filter.LogicOperate;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IRefBillField;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.DimensionPermOrgResult;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.permission.api.ICorePermissionService;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FilterUtil {
    private FilterUtil() {
    }

    public static <T> List<T> getValidValues(List<Object> valueList) {
        ArrayList<Object> tmpValueList = new ArrayList<Object>();
        if (valueList != null) {
            for (Object value : valueList) {
                if (!StringUtils.isNotBlank((Object)value)) continue;
                tmpValueList.add(value);
            }
        }
        return tmpValueList;
    }

    public static List<CompareTypeDto> getCompareTypeDtos(List<CompareType> compareTypes) {
        ArrayList<CompareTypeDto> compareTypeDtos = new ArrayList<CompareTypeDto>(10);
        for (CompareType compareType : compareTypes) {
            CompareTypeDto compareTypeDto = new CompareTypeDto(compareType.getId(), compareType.getName(), compareType.isNeedInput(), compareType.getValue(), compareType.getGroupId(), compareType.getInputCtlType(), compareType.isFieldCompare(), compareType.isMulti(), compareType.isNumber(), compareType.isBetween());
            compareTypeDto.setVisible(compareType.isVisible());
            compareTypeDtos.add(compareTypeDto);
        }
        return compareTypeDtos;
    }

    public static QFilter combineFilter(QFilter toQFilter, QFilter fromQFilter) {
        return FilterUtil.combineFilter(toQFilter, fromQFilter, LogicOperate.AND);
    }

    public static QFilter combineFilter(QFilter toQFilter, QFilter fromQFilter, LogicOperate logicOperate) {
        QFilter qFilter = null;
        if (fromQFilter != null && toQFilter != null) {
            qFilter = logicOperate == LogicOperate.AND ? QFilter.and((QFilter)fromQFilter.copy(), (QFilter)toQFilter.copy()) : QFilter.or((QFilter)fromQFilter.copy(), (QFilter)toQFilter.copy());
        } else if (fromQFilter != null) {
            qFilter = fromQFilter.copy();
        } else if (toQFilter != null) {
            qFilter = toQFilter.copy();
        }
        return qFilter;
    }

    public static List<QFilter> buildBaseDataPropertyQFilters(IDataModel model, String baseEntityTypeId, IBasedataField basedataField, String appId, String permissionItem) {
        return FilterUtil.buildBaseDataPropertyQFilters(model, baseEntityTypeId, basedataField, appId, permissionItem, null);
    }

    public static List<QFilter> buildBaseDataPropertyQFilters(IDataModel model, String baseEntityTypeId, IBasedataField basedataField, String appId, String permissionItem, QFilter idQFilter) {
        try (EntityTraceSpan span = EntityTracer.create((String)"kd.bos.entity.filter.FilterUtil", (String)"buildBaseDataPropertyQFilters");){
            QFilter baseDataControlOrgQFilter;
            BuildBaseDataPropertyQFiltersResult buildBaseDataPropertyQFiltersResult = FilterUtil.buildBaseDataPropertyQFiltersWithoutControlOrgFilter(model, basedataField, appId, permissionItem);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(buildBaseDataPropertyQFiltersResult.getQFilters().size() + 1);
            qFilters.addAll(buildBaseDataPropertyQFiltersResult.getQFilters());
            if (span.isRealtime()) {
                span.addLocaleTag("baseDataPropertyQFilters", (Object)((Object)qFilters).toString());
                span.addLocaleTag("idQFilter", (Object)(idQFilter == null ? null : idQFilter.toString()));
            }
            if (buildBaseDataPropertyQFiltersResult.isNeedControlOrgFilter() && (baseDataControlOrgQFilter = basedataField.getBaseDataControlOrgQFilter(model, baseEntityTypeId, idQFilter)) != null) {
                qFilters.add(baseDataControlOrgQFilter);
                if (span.isRealtime()) {
                    span.addLocaleTag("baseDataControlOrgQFilter", (Object)baseDataControlOrgQFilter.toString());
                }
            }
            ArrayList<QFilter> arrayList = qFilters;
            return arrayList;
        }
    }

    public static BuildBaseDataPropertyQFiltersResult buildBaseDataPropertyQFiltersWithoutControlOrgFilter(IDataModel model, IBasedataField basedataField, String appId, String permissionItem) {
        boolean isNeedControlOrgFilter = false;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        try (EntityTraceSpan span = EntityTracer.create((String)"kd.bos.entity.filter.FilterUtil", (String)"buildBaseDataPropertyQFiltersWithoutControlOrgFilter");){
            QFilter groupQFilter;
            qFilters.addAll(basedataField.buildCoreFilterByString(model));
            if (span.isRealtime()) {
                span.addLocaleTag("basedataField.coreFilters", (Object)((Object)qFilters).toString());
            }
            String dimFldKey = model.getDataEntityType().getPermissionControlType().getDataDimensionField();
            boolean isControlFuction = model.getDataEntityType().getPermissionControlType().isControlFunction();
            boolean isUseDimField = isControlFuction && StringUtils.isNotBlank((CharSequence)dimFldKey) && !"null".equals(dimFldKey);
            PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            long userId = RequestContext.get().getCurrUserId();
            if (isUseDimField && dimFldKey.equals(basedataField.getName())) {
                DimensionPermOrgResult hasDimPermOrgResult = permissionService.getAllPermDimObj(Long.valueOf(userId), appId, model.getDataEntityType().getName(), permissionItem);
                if (!hasDimPermOrgResult.getMainDimension().hasAllOrgPerm()) {
                    List mainDimPermOrgsId = hasDimPermOrgResult.getMainDimension().getHasPermOrgs();
                    QFilter idFilter = new QFilter("id", "in", (Object)mainDimPermOrgsId);
                    qFilters.add(idFilter);
                    if (span.isRealtime()) {
                        span.addLocaleTag("DimPermOrg.dimPermissionFilter", (Object)idFilter.toString());
                    }
                }
            } else if (basedataField instanceof MainOrgProp) {
                QFilter permissionFilter = ((MainOrgProp)basedataField).getPermissionFilter(model.getDataEntityType().getName(), appId, permissionItem);
                if (permissionFilter != null) {
                    qFilters.add(permissionFilter);
                    if (span.isRealtime()) {
                        span.addLocaleTag("MainOrgProp.permissionFilter", (Object)permissionFilter.toString());
                    }
                }
            } else {
                isNeedControlOrgFilter = true;
            }
            if (basedataField instanceof AssistantProp && (groupQFilter = ((AssistantProp)basedataField).getGroupQFilter()) != null) {
                qFilters.add(groupQFilter);
            }
            if (span.isRealtime()) {
                span.addLocaleTag("qFilters", (Object)((Object)qFilters).toString());
            }
            BuildBaseDataPropertyQFiltersResult buildBaseDataPropertyQFiltersResult = new BuildBaseDataPropertyQFiltersResult(isNeedControlOrgFilter, qFilters);
            return buildBaseDataPropertyQFiltersResult;
        }
    }

    public static List<QFilter> buildRefBillPropertyQFilters(IDataModel model, String baseEntityTypeId, IRefBillField refBillField, String appId, String permissionItem) {
        QFilter groupQFilter;
        boolean isUseDimField;
        String billStatus;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        Boolean isShowDisabled = refBillField.isShowOnlyAudited();
        if (isShowDisabled.booleanValue() && StringUtils.isNotEmpty((CharSequence)(billStatus = refBillField.getBillStatus()))) {
            qFilters.add(new QFilter(billStatus, "=", (Object)"C"));
        }
        qFilters.addAll(refBillField.buildCoreFilterByString(model));
        String dimFldKey = model.getDataEntityType().getPermissionControlType().getDataDimensionField();
        boolean isControlFuction = model.getDataEntityType().getPermissionControlType().isControlFunction();
        boolean bl = isUseDimField = isControlFuction && StringUtils.isNotBlank((CharSequence)dimFldKey) && !"null".equals(dimFldKey);
        if (isUseDimField && dimFldKey.equals(refBillField.getName())) {
            long userId;
            ICorePermissionService permissionService = (ICorePermissionService)ServiceFactory.getService(ICorePermissionService.class);
            HasPermDimObjResult hasPermDimObjResult = permissionService.getHasPermDimObjs(userId = Long.parseLong(RequestContext.get().getUserId()), appId, model.getDataEntityType().getName(), permissionItem);
            if (hasPermDimObjResult != null && !hasPermDimObjResult.hasAllDimObjPerm()) {
                QFilter idFilter = new QFilter("id", "in", (Object)hasPermDimObjResult.getHasPermDimObjs());
                qFilters.add(idFilter);
            }
        } else if (refBillField instanceof MainOrgProp && !isUseDimField) {
            QFilter permissionFilter = ((MainOrgProp)((Object)refBillField)).getPermissionFilter(model.getDataEntityType().getName(), appId, permissionItem);
            if (permissionFilter != null) {
                qFilters.add(permissionFilter);
            }
        } else {
            QFilter baseDataControlOrgQFilter = refBillField.getBaseDataControlOrgQFilter(model, baseEntityTypeId);
            if (baseDataControlOrgQFilter != null) {
                qFilters.add(baseDataControlOrgQFilter);
            }
        }
        if (refBillField instanceof AssistantProp && (groupQFilter = ((AssistantProp)((Object)refBillField)).getGroupQFilter()) != null) {
            qFilters.add(groupQFilter);
        }
        return qFilters;
    }

    public static List<QFilter> buildDataPermissionFilter(F7FilterParam param) {
        if (param.getEntityType() == null) {
            if (StringUtils.isBlank((CharSequence)param.getEntityId())) {
                return new ArrayList<QFilter>();
            }
            MainEntityType type = EntityMetadataCache.getDataEntityType(param.getEntityId());
            param.setEntityType((BasedataEntityType)type);
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter approvedQFilter = PermissionFilterUtil.getApprovedFilter(param.getEntityType());
        if (param.isEnable() && approvedQFilter != null) {
            filters.add(approvedQFilter);
        }
        QFilter usedQFilter = PermissionFilterUtil.getUsedFilter(param.getEntityType());
        if (param.isShowUsed() && usedQFilter != null) {
            filters.add(usedQFilter);
        }
        return filters;
    }

    public static List<QFilter> buildDataPermFilter(long userId, String appId, String entityNumber) {
        ICorePermissionService permissionService = (ICorePermissionService)ServiceFactory.getService(ICorePermissionService.class);
        HashMap<String, Boolean> customParams = new HashMap<String, Boolean>();
        customParams.put("isLookUp", true);
        return Collections.singletonList(permissionService.getDataPermWithOrg(userId, appId, entityNumber, customParams));
    }

    public static List<QFilter> buildSpecialDataPermFilter(ITimeService timeService, IUserService userService, String appId, String entityNumber) {
        return Collections.singletonList(PermissionFilterUtil.getSpecialDataPermissionFilter(appId, entityNumber, "view", timeService, userService));
    }

    public static List<QFilter> buildDataPermissionFilter(String baseEntityId, boolean isShowUsed, boolean isShowApproved) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType(baseEntityId);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter approvedQFilter = PermissionFilterUtil.getApprovedFilter(mainEntityType);
        if (isShowApproved && approvedQFilter != null) {
            filters.add(approvedQFilter);
        }
        QFilter usedQFilter = PermissionFilterUtil.getUsedFilter(mainEntityType);
        if (isShowUsed && usedQFilter != null) {
            filters.add(usedQFilter);
        }
        return filters;
    }

    public static List<QFilter> buildBaseDataF7QFilters(IBasedataField basedataField, IDataModel model, String appId, String baseEntityTypeId, List<QFilter> userQFilters, String permissionItem, boolean isShowApproved) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (userQFilters != null) {
            filters.addAll(userQFilters);
        }
        filters.addAll(FilterUtil.buildBaseDataPropertyQFilters(model, baseEntityTypeId, basedataField, appId, permissionItem));
        filters.addAll(FilterUtil.buildDataPermissionFilter(baseEntityTypeId, basedataField.isShowUsed(), isShowApproved));
        return filters;
    }

    public static List<QFilter> buildRefBillF7QFilters(IRefBillField basedataField, IDataModel model, String appId, String baseEntityTypeId, List<QFilter> userQFilters, String permissionItem, boolean isShowApproved) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (userQFilters != null) {
            filters.addAll(userQFilters);
        }
        filters.addAll(FilterUtil.buildRefBillPropertyQFilters(model, baseEntityTypeId, basedataField, appId, permissionItem));
        filters.addAll(FilterUtil.buildDataPermissionFilter(baseEntityTypeId, basedataField.isShowOnlyAudited(), isShowApproved));
        return filters;
    }

    public static QFilter decorateZero(QFilter qFilter) {
        int currentDot = qFilter.getProperty().indexOf(".");
        while (currentDot != -1) {
            qFilter.or(new QFilter(qFilter.getProperty().substring(0, currentDot), "=", (Object)0));
            currentDot = qFilter.getProperty().indexOf(".", currentDot + 1);
        }
        return qFilter;
    }

    public static QFilter decorateNotZero(QFilter qFilter) {
        int currentDot = qFilter.getProperty().indexOf(".");
        while (currentDot != -1) {
            qFilter.and(new QFilter(qFilter.getProperty().substring(0, currentDot), "!=", (Object)0));
            currentDot = qFilter.getProperty().indexOf(".", currentDot + 1);
        }
        return qFilter;
    }
}

