/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.filter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.IFilterValueSetter;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.filter.TypeChange;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.service.KDDateFormatUtils;

public class ModelTypeFilterValueSetter
implements IFilterValueSetter {
    private static final String BOS_ENTITY_METADATA = "bos-entity-metadata";
    IDataModel model;

    public IDataModel getModel() {
        return this.model;
    }

    public void setModel(IDataModel model) {
        this.model = model;
    }

    public ModelTypeFilterValueSetter(IDataModel model) {
        this.model = model;
    }

    protected boolean isEntryProperty(IDataEntityProperty property) {
        IDataEntityType propParentType = property.getParent();
        return propParentType instanceof EntryType;
    }

    private Object getModelValue(IDataModel model, IDataEntityProperty property) {
        if (this.isEntryProperty(property)) {
            int rowIndex = model.getEntryCurrentRowIndex(property.getParent().getName());
            return model.getValue(property.getName(), rowIndex);
        }
        return model.getValue(property.getName());
    }

    private Object getBaseDataFieldValue(BasedataProp field, IDataModel model, String fieldName) {
        Object value = null;
        DynamicObject baseDataObject = (DynamicObject)this.getModelValue(model, (IDataEntityProperty)field);
        if (baseDataObject != null) {
            value = baseDataObject.get(fieldName);
        }
        return value;
    }

    @Override
    public List<Object> getFieldValue(SimpleFilterRow simpleFilterRow) {
        ArrayList<Object> value = new ArrayList<Object>();
        if (simpleFilterRow.getValue().size() > 0 && ((FilterValue)simpleFilterRow.getValue().get(0)).getValue().toString().indexOf("GetValue(") > -1) {
            this.initFieldValue(simpleFilterRow, value);
        } else {
            for (FilterValue filterValue : simpleFilterRow.getValue()) {
                value.add(filterValue.getValue());
            }
        }
        return value;
    }

    private void initFieldValue(SimpleFilterRow simpleFilterRow, List<Object> value) {
        Object fieldValue;
        String strKey = "";
        String defaultValue = "";
        strKey = ((FilterValue)simpleFilterRow.getValue().get(0)).getValue().toString().replace("GetValue(", "");
        if ((strKey = strKey.replace(")", "")).split(",").length >= 2) {
            defaultValue = strKey.split(",")[1];
        }
        if ((fieldValue = this.getFieldValue(strKey = strKey.split(",")[0], defaultValue)) != null) {
            if (fieldValue instanceof Date) {
                value.add(KDDateFormatUtils.getDateTimeFormat().format(fieldValue));
            } else if (fieldValue instanceof BigDecimal) {
                value.add(((BigDecimal)fieldValue).toPlainString());
            } else {
                value.add(fieldValue.toString());
            }
        }
    }

    @Override
    public List<Object> getBaseDataFieldIds(SimpleFilterRow simpleFilterRow) {
        ArrayList<Object> value = new ArrayList<Object>();
        if (simpleFilterRow.getValue().size() > 0 && ((FilterValue)simpleFilterRow.getValue().get(0)).getValue().toString().indexOf("GetValue(") > -1) {
            this.initFieldValue(simpleFilterRow, value);
        } else {
            for (FilterValue filterValue : simpleFilterRow.getBaseDataIds()) {
                value.add(filterValue.getValue());
            }
        }
        return value;
    }

    private Object getFieldValue(String strKey, String defaultValue) {
        BasedataProp field;
        Object value = null;
        IDataEntityProperty property = null;
        String[] strKeyProperty = strKey.split("\\.");
        String locationCodeMessage = ResManager.loadKDString((String)"%1$s\uff0c\u9519\u8bef\u4ee3\u7801\uff1a%2$s", (String)"ModelTypeFilterValueSetter_1", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]);
        if (strKeyProperty.length == 1) {
            property = this.model.getProperty(strKey);
            if (property == null) {
                String msg = String.format(locationCodeMessage, strKey, "FIELDNOTEXISTS000002");
                throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{this.model.getDataEntityType().getName(), msg});
            }
            value = this.getModelValue(this.model, property);
        } else if (strKeyProperty.length == 2) {
            field = (BasedataProp)this.model.getProperty(strKeyProperty[0]);
            if (field == null) {
                String msg = String.format(locationCodeMessage, strKeyProperty[0], "FIELDNOTEXISTS000002");
                throw new KDException(BosErrorCode.fieldNotExist, new Object[]{this.model.getDataEntityType().getName(), msg});
            }
            property = (IDataEntityProperty)field.getComplexType().getProperties().get((Object)strKeyProperty[1]);
            if (property == null) {
                String msg = String.format(locationCodeMessage, strKeyProperty[1], "FIELDNOTEXISTS000002");
                throw new KDException(BosErrorCode.fieldNotExist, new Object[]{field.getComplexType().getName(), msg});
            }
            value = this.getBaseDataFieldValue(field, this.model, strKeyProperty[1]);
        } else if (strKeyProperty.length == 3) {
            field = (BasedataProp)this.model.getProperty(strKeyProperty[0]);
            if (field == null) {
                String msg = String.format(locationCodeMessage, strKeyProperty[0], "FIELDNOTEXISTS000002");
                throw new KDException(BosErrorCode.fieldNotExist, new Object[]{this.model.getDataEntityType().getName(), msg});
            }
            property = (IDataEntityProperty)field.getComplexType().getProperties().get((Object)strKeyProperty[1]);
            if (property == null) {
                String msg = String.format(locationCodeMessage, strKeyProperty[1], "FIELDNOTEXISTS000002");
                throw new KDException(BosErrorCode.fieldNotExist, new Object[]{field.getComplexType().getName(), msg});
            }
            if (!(property instanceof BasedataProp)) {
                String msg = String.format(locationCodeMessage, property.getClass(), "FIELDNOTEXISTS000002");
                throw new KDException(BosErrorCode.canNotCast, new Object[]{BasedataProp.class, msg});
            }
            value = this.getBaseDataFieldValue(field, this.model, strKeyProperty[1]);
            if (value instanceof DynamicObject) {
                value = ((DynamicObject)value).get(strKeyProperty[2]);
            }
        } else {
            return null;
        }
        if (value instanceof DynamicObject) {
            value = ((DynamicObject)value).get("id");
        }
        if (value instanceof Boolean) {
            value = (Boolean)value != false ? Character.valueOf('1') : Character.valueOf('0');
        }
        if (value == null && StringUtils.isNotEmpty((CharSequence)defaultValue)) {
            Class type = property.getPropertyType();
            if (type == String.class) {
                value = defaultValue;
            } else if (type == Integer.TYPE) {
                value = TypeChange.stringToInt(defaultValue);
            } else if (type == Float.TYPE) {
                value = Float.valueOf(TypeChange.stringToFloat(defaultValue));
            } else if (type == Long.TYPE) {
                value = Float.valueOf(TypeChange.stringToLong(defaultValue));
            } else if (type == Boolean.TYPE) {
                value = TypeChange.stringToBoolean(defaultValue);
                value = ((Boolean)value).booleanValue() ? Character.valueOf('1') : Character.valueOf('0');
            } else if (type == Date.class) {
                value = TypeChange.stringToDate(defaultValue);
            }
        }
        int bdType = -9;
        if (property instanceof DynamicSimpleProperty) {
            bdType = ((DynamicSimpleProperty)property).getDbType();
        } else if (property instanceof DynamicComplexProperty) {
            bdType = ((DynamicComplexProperty)property).getComplexType().getPrimaryKey().getDbType();
        }
        if (bdType == -9 && value == null) {
            value = defaultValue;
        }
        return value;
    }
}

