/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.GetMainOrgIdsParameter;
import kd.bos.entity.filter.TypeChange;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.org.OrgViewSchemeProp;
import kd.bos.org.api.IOrgService;
import kd.bos.org.model.BizViewQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.ICorePermissionService;
import kd.bos.service.IBaseDataService;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class PermissionFilterUtil {
    private PermissionFilterUtil() {
    }

    private static Set<Long> getOrgRangeCondition(List<Long> authOrgs) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (Long org : authOrgs) {
            idSet.add(org);
        }
        return idSet;
    }

    public static QFilter getPermOrgFilter(BasedataProp bdProp, String entityTypeId) {
        return PermissionFilterUtil.getPermOrgFilter(bdProp, entityTypeId, "");
    }

    public static QFilter getPermOrgFilter(BasedataProp bdProp, String entityTypeId, String appId) {
        List<Long> mainOrgIds = PermissionFilterUtil.getMainOrgIds(bdProp, entityTypeId, appId);
        Long defaultOrg = PermissionFilterUtil.getDefaultMainOrgId(mainOrgIds);
        return new QFilter(bdProp.getName(), "=", (Object)defaultOrg);
    }

    public static QFilter getOrgFilter(BasedataProp basedataProp) {
        return PermissionFilterUtil.getOrgFilter(basedataProp, "");
    }

    public static QFilter getOrgFilter(BasedataProp basedataProp, String appId) {
        QFilter filter = null;
        boolean isMainOrg = EntityTypeUtil.isMainOrgProp((IDataEntityProperty)basedataProp);
        if (isMainOrg) {
            BillEntityType billEntityType = (BillEntityType)basedataProp.getParent();
            String entityId = billEntityType.getName();
            filter = PermissionFilterUtil.getMainOrgFilter(basedataProp, entityId, appId);
        }
        return filter;
    }

    public static QFilter getAllPermOrgFilter(BasedataProp bdProp, String entityTypeId) {
        return PermissionFilterUtil.getAllPermOrgFilter(bdProp, entityTypeId, "");
    }

    public static QFilter getAllPermOrgFilter(BasedataProp bdProp, String entityTypeId, String appId) {
        QFilter qFilter = PermissionFilterUtil.getMainOrgFilter(bdProp, entityTypeId, appId);
        DynamicObjectCollection dynamicObjectCollection = ORM.create().query(bdProp.getComplexType().getName(), bdProp.getComplexType().getPrimaryKey().getName(), new QFilter[]{qFilter});
        ArrayList<Object> permOrgs = new ArrayList<Object>();
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            Long orgId = (Long)dynamicObject.getPkValue();
            permOrgs.add(orgId.toString());
        }
        return new QFilter(bdProp.getName(), "in", TypeChange.getRealPkList((DynamicObjectType)bdProp.getComplexType(), permOrgs));
    }

    public static QFilter getMainOrgFilter(BasedataProp bdProp, String entityTypeId) {
        return PermissionFilterUtil.getMainOrgFilter(bdProp, entityTypeId, "");
    }

    public static QFilter getMainOrgFilter(BasedataProp bdProp, String entityTypeId, String appId) {
        return PermissionFilterUtil.getMainOrgFilter(bdProp, entityTypeId, appId, null, "", -1, "47150e89000000ac");
    }

    public static QFilter getMainOrgFilter(BasedataProp bdProp, String entityTypeId, String appId, QFilter qFilter, String orderBy, int top, String permissionItem) {
        return PermissionFilterUtil.getMainOrgFilter((IBasedataField)bdProp, entityTypeId, appId, qFilter, orderBy, top, permissionItem);
    }

    public static QFilter getMainOrgFilter(IBasedataField bdProp, String entityTypeId, String appId, QFilter qFilter, String orderBy, int top, String permissionItem) {
        List authOrgs;
        AppInfo app;
        String bizAppId = null;
        if (StringUtils.isNotBlank((CharSequence)appId) && (app = AppMetadataCache.getAppInfo(appId)) != null) {
            bizAppId = app.getId();
        }
        ICorePermissionService permissionService = (ICorePermissionService)ServiceFactory.getService(ICorePermissionService.class);
        boolean isBinding = permissionService.isBindingViewPerm(entityTypeId);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String orgFun = ((OrgProp)bdProp).getOrgFunc();
        QFilter orgFilter = null;
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        orgFilter = isBinding ? ((authOrgs = orgService.getAuthorizedBizOrgIds(Long.valueOf(userId), orgFun, entityTypeId, permissionItem, bizAppId, qFilter, orderBy, top)) != null && !authOrgs.isEmpty() ? new QFilter("id", "in", PermissionFilterUtil.getOrgRangeCondition(authOrgs)) : new QFilter("id", "=", (Object)-1)) : orgService.getBizOrgFilter(orgFun);
        return orgFilter;
    }

    public static List<Long> getMainOrgIds(BasedataProp bdProp, String entityTypeId) {
        return PermissionFilterUtil.getMainOrgIds(bdProp, entityTypeId, "");
    }

    public static List<Long> getMainOrgIds(BasedataProp bdProp, String entityTypeId, String appId) {
        return PermissionFilterUtil.getMainOrgIds(bdProp, entityTypeId, appId, null, "", -1, "47150e89000000ac");
    }

    public static List<Long> getMainOrgIds(BasedataProp bdProp, String entityTypeId, String appId, QFilter qFilter, String orderBy, int top, String permissionItem) {
        AppInfo app;
        String bizAppId = null;
        if (StringUtils.isNotBlank((CharSequence)appId) && (app = AppMetadataCache.getAppInfo(appId)) != null) {
            bizAppId = app.getId();
        }
        ICorePermissionService permissionService = (ICorePermissionService)ServiceFactory.getService(ICorePermissionService.class);
        boolean isBinding = permissionService.isBindingViewPerm(entityTypeId);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String orgFun = ((OrgProp)bdProp).getOrgFunc();
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        if (isBinding) {
            return orgService.getAuthorizedBizOrgIds(Long.valueOf(userId), orgFun, entityTypeId, permissionItem, bizAppId, qFilter, orderBy, top);
        }
        return orgService.getBizOrgIds(orgFun, qFilter, orderBy, top);
    }

    public static DynamicObjectCollection getMainOrgIds(BasedataProp bdProp, String entityTypeId, String appId, QFilter qFilter, String selectFields, String orderBy, int top) {
        return PermissionFilterUtil.getMainOrgIds(new GetMainOrgIdsParameter(bdProp, entityTypeId, appId, qFilter, selectFields, orderBy, top, "47150e89000000ac"));
    }

    public static DynamicObjectCollection getMainOrgIds(BasedataProp bdProp, String entityTypeId, String appId, QFilter qFilter, String selectFields, String orderBy, int top, String permissionItem) {
        return PermissionFilterUtil.getMainOrgIds(new GetMainOrgIdsParameter(bdProp, entityTypeId, appId, qFilter, selectFields, orderBy, top, permissionItem));
    }

    public static DynamicObjectCollection getMainOrgIds(GetMainOrgIdsParameter parameterObject) {
        return PermissionFilterUtil.getMainOrgIds0(parameterObject);
    }

    private static DynamicObjectCollection getMainOrgIds0(GetMainOrgIdsParameter parameterObject) {
        Long currentOrg;
        AppInfo app;
        String bizAppId = null;
        if (StringUtils.isNotBlank((CharSequence)parameterObject.getAppId()) && (app = AppMetadataCache.getAppInfo(parameterObject.getAppId())) != null) {
            bizAppId = app.getId();
        }
        ICorePermissionService permissionService = (ICorePermissionService)ServiceFactory.getService(ICorePermissionService.class);
        boolean isBinding = permissionService.isBindingViewPerm(parameterObject.getEntityTypeId());
        long userId = Long.parseLong(RequestContext.get().getUserId());
        OrgProp mainOrgProp = (OrgProp)parameterObject.getBdProp();
        OrgViewSchemeProp orgViewScheme = mainOrgProp.getOrgViewScheme();
        String orgViewSchemeNum = null;
        if (orgViewScheme != null) {
            orgViewSchemeNum = orgViewScheme.getNumber();
        }
        String orgFun = "";
        if (StringUtils.isEmpty((CharSequence)orgViewSchemeNum)) {
            orgFun = mainOrgProp.getOrgFunc();
            if (StringUtils.isNotEmpty((CharSequence)orgFun)) {
                BizViewQueryParam bizViewQueryParam = new BizViewQueryParam();
                bizViewQueryParam.setCustomFilter(new QFilter("treetype", "=", (Object)orgFun));
                bizViewQueryParam.setOnlyDefault(true);
                Map viewObjMap = ((IOrgService)ServiceFactory.getService(IOrgService.class)).getView(bizViewQueryParam);
                if (viewObjMap != null && !viewObjMap.isEmpty()) {
                    orgFun = ((DynamicObject)viewObjMap.entrySet().iterator().next().getValue()).getString("number");
                }
            }
        } else {
            orgFun = orgViewSchemeNum;
        }
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        if (isBinding) {
            currentOrg = RequestContext.get().getOrgId();
            if (parameterObject.getStart() == 0) {
                QFilter currentOrgFilter = new QFilter("id", "=", (Object)currentOrg);
                currentOrgFilter = currentOrgFilter.and(parameterObject.getqFilter());
                DynamicObjectCollection currentOrgCollection = orgService.getAuthorizedBizOrgs(Long.valueOf(userId), orgFun, parameterObject.getEntityTypeId(), parameterObject.getPermissionItem(), bizAppId, currentOrgFilter, parameterObject.getSelectFields(), parameterObject.getOrderBy(), parameterObject.getTop());
                DynamicObjectCollection allOrgCollection = orgService.getAuthorizedBizOrgs(Long.valueOf(userId), orgFun, parameterObject.getEntityTypeId(), parameterObject.getPermissionItem(), bizAppId, parameterObject.getqFilter(), parameterObject.getSelectFields(), parameterObject.getOrderBy(), parameterObject.getTop());
                return PermissionFilterUtil.mergeCollection(currentOrgCollection, allOrgCollection);
            }
            return orgService.getAuthorizedBizOrgs(Long.valueOf(userId), orgFun, parameterObject.getEntityTypeId(), parameterObject.getPermissionItem(), bizAppId, parameterObject.getqFilter(), parameterObject.getSelectFields(), parameterObject.getOrderBy(), parameterObject.getStart(), parameterObject.getTop());
        }
        if (parameterObject.getStart() == 0) {
            currentOrg = RequestContext.get().getOrgId();
            QFilter currentOrgFilter = new QFilter("id", "=", (Object)currentOrg);
            currentOrgFilter = currentOrgFilter.and(parameterObject.getqFilter());
            DynamicObjectCollection currentOrgCollection = orgService.getBizOrgs(orgFun, currentOrgFilter, parameterObject.getSelectFields(), parameterObject.getOrderBy(), parameterObject.getTop());
            DynamicObjectCollection allOrgCollection = orgService.getBizOrgs(orgFun, parameterObject.getqFilter(), parameterObject.getSelectFields(), parameterObject.getOrderBy(), parameterObject.getTop());
            return PermissionFilterUtil.mergeCollection(currentOrgCollection, allOrgCollection);
        }
        return orgService.getBizOrgs(orgFun, parameterObject.getqFilter(), parameterObject.getSelectFields(), parameterObject.getOrderBy(), parameterObject.getStart(), parameterObject.getTop());
    }

    private static DynamicObjectCollection mergeCollection(DynamicObjectCollection currentOrgCollection, DynamicObjectCollection allOrgCollection) {
        if (currentOrgCollection == null || currentOrgCollection.isEmpty() || allOrgCollection == null || allOrgCollection.isEmpty()) {
            return allOrgCollection;
        }
        Object currentOrgID = ((DynamicObject)currentOrgCollection.get(0)).get("id");
        boolean hasFound = false;
        for (DynamicObject org : allOrgCollection) {
            if (!currentOrgID.equals(org.get("id"))) continue;
            hasFound = true;
            break;
        }
        if (!hasFound) {
            allOrgCollection.addAll((Collection)currentOrgCollection);
        }
        return allOrgCollection;
    }

    public static QFilter buildPermOrgFilter(MainEntityType dataType, boolean isContainMainOrg, boolean isNoLimit, String formId) {
        return PermissionFilterUtil.buildPermOrgFilter(dataType, isContainMainOrg, isNoLimit, formId, "");
    }

    public static QFilter buildPermOrgFilter(MainEntityType dataType, boolean isContainMainOrg, boolean isNoLimit, String formId, String appId) {
        QFilter orgFilter = null;
        MainOrgProp mainOrgProp = PermissionFilterUtil.getMainOrgProp(dataType);
        if (mainOrgProp != null) {
            orgFilter = !isContainMainOrg || isNoLimit ? PermissionFilterUtil.getAllPermOrgFilter(mainOrgProp, formId, appId) : PermissionFilterUtil.getPermOrgFilter(mainOrgProp, formId, appId);
        }
        return orgFilter;
    }

    public static List<Long> getMainOrgIds(MainEntityType dataType, String entityTypeId) {
        return PermissionFilterUtil.getMainOrgIds(dataType, entityTypeId, "");
    }

    public static List<Long> getMainOrgIds(MainEntityType dataType, String entityTypeId, String appId) {
        return PermissionFilterUtil.getMainOrgIds(dataType, entityTypeId, appId, null, "", -1);
    }

    public static List<Long> getMainOrgIds(MainEntityType dataType, String entityTypeId, String appId, QFilter qFilter, String orderBy, int top) {
        MainOrgProp mainOrgProp = PermissionFilterUtil.getMainOrgProp(dataType);
        if (mainOrgProp != null) {
            return PermissionFilterUtil.getMainOrgIds((BasedataProp)mainOrgProp, entityTypeId, appId, qFilter, orderBy, top, "47150e89000000ac");
        }
        return new ArrayList<Long>();
    }

    public static MainOrgProp getMainOrgProp(MainEntityType dataType) {
        BillEntityType billEntityType;
        MainOrgProp mainOrgProp;
        if (dataType instanceof BillEntityType && (mainOrgProp = (billEntityType = (BillEntityType)dataType).getMainOrgProperty()) != null) {
            return mainOrgProp;
        }
        return null;
    }

    public static Long getDefaultMainOrgId(List<Long> mainOrgIds) {
        Long curOrgId = RequestContext.get().getOrgId();
        Long minOrgId = null;
        boolean curOrgHasPerm = false;
        if (!mainOrgIds.isEmpty()) {
            minOrgId = mainOrgIds.get(0);
            for (Long mainOrgId : mainOrgIds) {
                if (mainOrgId < minOrgId) {
                    minOrgId = mainOrgId;
                }
                if (!mainOrgId.equals(curOrgId)) continue;
                curOrgHasPerm = true;
            }
        }
        Long defaultOrg = curOrgHasPerm ? curOrgId : (minOrgId != null ? minOrgId : Long.valueOf(0L));
        return defaultOrg;
    }

    public static QFilter getApprovedFilter(EntityType type) {
        IDataEntityProperty billStatusProp;
        BasedataEntityType basedataEntityType;
        QFilter qFilter = null;
        if (type instanceof BasedataEntityType && StringUtils.isNotBlank((CharSequence)(basedataEntityType = (BasedataEntityType)type).getBillStatus()) && (billStatusProp = basedataEntityType.findProperty(basedataEntityType.getBillStatus())) != null && !billStatusProp.isDbIgnore()) {
            qFilter = new QFilter(basedataEntityType.getBillStatus(), "=", (Object)"C");
        }
        return qFilter;
    }

    public static QFilter getUsedFilter(EntityType type) {
        QFilter qFilter = null;
        IDataEntityProperty enableProp = type.findProperty("enable");
        if (enableProp instanceof BillStatusProp && StringUtils.isNotBlank((CharSequence)enableProp.getAlias())) {
            qFilter = new QFilter("enable", "=", (Object)"1");
        }
        return qFilter;
    }

    public static List<QFilter> getSpecialDataPermFilter(String appId, String entityNmber, String operateKey, ITimeService timeService, IUserService userService) {
        StringBuilder errorInfo = new StringBuilder();
        return PermissionFilterUtil.getSpecialDataPermFilter(appId, entityNmber, operateKey, timeService, userService, errorInfo);
    }

    public static List<QFilter> getSpecialDataPermFilter(String appId, String entityNmber, String operateKey, ITimeService timeService, IUserService userService, StringBuilder errorInfo) {
        QFilter qFilter = PermissionFilterUtil.getSpecialDataPermissionFilter(appId, entityNmber, operateKey, timeService, userService, errorInfo, null);
        ArrayList<QFilter> resultList = new ArrayList<QFilter>();
        if (qFilter != null) {
            resultList.add(qFilter);
        }
        return resultList;
    }

    @Deprecated
    public static QFilter getSpecialDataPermissionFilter(String appId, String entityNmber, String operateKey, ITimeService timeService, IUserService userService) {
        StringBuilder errorInfo = new StringBuilder();
        return PermissionFilterUtil.getSpecialDataPermissionFilter(appId, entityNmber, operateKey, timeService, userService, errorInfo, null);
    }

    public static QFilter getSpecialDataPermissionFilter(String appId, String entityNmber, String operateKey) {
        StringBuilder errorInfo = new StringBuilder();
        return PermissionFilterUtil.getSpecialDataPermissionFilter(appId, entityNmber, operateKey, errorInfo, null);
    }

    public static QFilter getSpecialDataPermissionFilter(String appId, String entityNmber, String operateKey, ITimeService timeService, IUserService userService, StringBuilder errorInfo) {
        return PermissionFilterUtil.getSpecialDataPermissionFilter(appId, entityNmber, operateKey, timeService, userService, errorInfo, null);
    }

    @Deprecated
    public static QFilter getSpecialDataPermissionFilter(String appId, String entityNmber, String operateKey, ITimeService timeService, IUserService userService, StringBuilder errorInfo, Long orgId) {
        AppInfo app;
        ICorePermissionService permissionService = (ICorePermissionService)ServiceFactory.getService(ICorePermissionService.class);
        String bizAppId = null;
        if (StringUtils.isNotBlank((CharSequence)appId) && (app = AppMetadataCache.getAppInfo(appId)) != null) {
            bizAppId = app.getId();
        }
        QFilter resultFilter = permissionService.getOperationRuleFilter(bizAppId, entityNmber, operateKey, orgId, errorInfo);
        return resultFilter;
    }

    private static QFilter getSpecialDataPermissionFilter(String appId, String entityNmber, String operateKey, StringBuilder errorInfo, Long orgId) {
        AppInfo app;
        ICorePermissionService permissionService = (ICorePermissionService)ServiceFactory.getService(ICorePermissionService.class);
        String bizAppId = null;
        if (StringUtils.isNotBlank((CharSequence)appId) && (app = AppMetadataCache.getAppInfo(appId)) != null) {
            bizAppId = app.getId();
        }
        return permissionService.getOperationRuleFilter(bizAppId, entityNmber, operateKey, orgId, errorInfo);
    }

    public static List<QFilter> getListPermissionFilters(MainEntityType mainEntityType, boolean isIsolationOrg, String appId, ITimeService timeService, IUserService userService) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        MainOrgProp mainOrgProp = PermissionFilterUtil.getMainOrgProp(mainEntityType);
        if (isIsolationOrg && mainOrgProp != null) {
            qFilters.add(PermissionFilterUtil.getAllPermOrgFilter(mainOrgProp, mainEntityType.getName(), appId));
        }
        ICorePermissionService permissionService = (ICorePermissionService)ServiceFactory.getService(ICorePermissionService.class);
        if (StringUtils.isNotBlank((CharSequence)appId) && AppMetadataCache.getAppInfo(appId) != null) {
            AppInfo app = AppMetadataCache.getAppInfo(appId);
            qFilters.add(permissionService.getDataPermission(userService.getCurrentUserId(), app.getId(), mainEntityType.getName()));
        } else {
            qFilters.add(permissionService.getDataPermission(userService.getCurrentUserId(), null, mainEntityType.getName()));
        }
        qFilters.add(PermissionFilterUtil.getSpecialDataPermissionFilter(appId, mainEntityType.getName(), "view", timeService, userService));
        return qFilters;
    }

    public static List<QFilter> getListPermissionFilters(MainEntityType mainEntityType, boolean isIsolationOrg, String appId, ITimeService timeService, IUserService userService, Long orgId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        String entityNum = mainEntityType.getName();
        IBaseDataService basedataServ = (IBaseDataService)ServiceFactory.getService(IBaseDataService.class);
        Boolean checkBaseDataCtrl = ((IBaseDataService)ServiceFactory.getService(IBaseDataService.class)).checkBaseDataCtrl(entityNum);
        if (Boolean.TRUE.equals(checkBaseDataCtrl)) {
            if (orgId == null || orgId == 0L) {
                orgId = RequestContext.get().getOrgId();
            }
            qFilters.add(basedataServ.getBaseDataFilter(entityNum, orgId));
        } else {
            MainOrgProp mainOrgProp = PermissionFilterUtil.getMainOrgProp(mainEntityType);
            if (isIsolationOrg && mainOrgProp != null) {
                qFilters.add(PermissionFilterUtil.getAllPermOrgFilter(mainOrgProp, mainEntityType.getName(), appId));
            }
        }
        ICorePermissionService permissionService = (ICorePermissionService)ServiceFactory.getService(ICorePermissionService.class);
        if (StringUtils.isNotBlank((CharSequence)appId) && AppMetadataCache.getAppInfo(appId) != null) {
            AppInfo app = AppMetadataCache.getAppInfo(appId);
            qFilters.add(permissionService.getDataPermission(userService.getCurrentUserId(), app.getId(), mainEntityType.getName()));
        } else {
            qFilters.add(permissionService.getDataPermission(userService.getCurrentUserId(), null, mainEntityType.getName()));
        }
        qFilters.add(PermissionFilterUtil.getSpecialDataPermissionFilter(appId, mainEntityType.getName(), "view", timeService, userService));
        return qFilters;
    }
}

