/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.flex;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;

public class FlexBDFilter {
    private static Log log = LogFactory.getLog(FlexBDFilter.class);
    private final QFilter originalFilter;
    private boolean isFlexFilter = false;
    private final List<Object> masterIdList = new ArrayList<Object>();
    private String matchFlexProperty;

    public static List<QFilter> convertFlexFilter(List<QFilter> qFilters, IDataEntityType entityType) {
        if (Boolean.getBoolean("flex.personal.enable")) {
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            for (QFilter qFilter : qFilters) {
                FlexBDFilter flexBDFilter = new FlexBDFilter(qFilter, entityType);
                if (flexBDFilter.isFlexFilter()) {
                    log.info("\u542f\u7528\u5f39\u6027\u57df\u4e2a\u6027\u5316\uff0c\u8f6c\u6362\u5f39\u6027\u57df\u8fc7\u6ee4\u6761\u4ef6" + flexBDFilter.getConvertQFilter().toString());
                    list.add(flexBDFilter.getConvertQFilter());
                    continue;
                }
                list.add(qFilter);
            }
            return list;
        }
        return qFilters;
    }

    protected FlexBDFilter(QFilter filter, IDataEntityType entityType) {
        this.originalFilter = filter;
        if (filter.getCP().equalsIgnoreCase("is null") || filter.getCP().equalsIgnoreCase("is not null")) {
            return;
        }
        this.parseFlexProperty("", filter.getProperty(), entityType);
    }

    public boolean isFlexFilter() {
        return this.isFlexFilter;
    }

    private void parseFlexProperty(String baseProperty, String property, IDataEntityType entityType) {
        String[] split = property.split("\\.");
        if (split.length <= 1) {
            return;
        }
        IDataEntityProperty first = (IDataEntityProperty)entityType.getProperties().get((Object)split[0]);
        if (first instanceof BasedataProp) {
            if (split.length != 3) {
                return;
            }
            String[] split1 = new String[2];
            int pos = first.getName().lastIndexOf("_");
            if (pos < 0) {
                return;
            }
            split1[0] = first.getName().substring(0, pos);
            split1[1] = first.getName().substring(pos + 1);
            this.matchFlexProperty = baseProperty + (StringUtils.isEmpty((CharSequence)baseProperty) ? "" : ".") + first + ".value";
            IDataEntityProperty flexProp = (IDataEntityProperty)entityType.getProperties().get((Object)split1[0]);
            if (flexProp instanceof FlexProp) {
                IDataEntityType baseDataType;
                IDataEntityProperty baseDataProp = (IDataEntityProperty)((BasedataProp)first).getComplexType().getProperties().get((Object)split[1]);
                if (baseDataProp instanceof BasedataProp && (baseDataType = ((BasedataProp)baseDataProp).getComplexType()) instanceof BasedataEntityType) {
                    if (StringUtils.isEmpty((CharSequence)((BasedataEntityType)baseDataType).getNameProperty())) {
                        return;
                    }
                    if (!split[2].equals(((BasedataEntityType)baseDataType).getNameProperty()) && !split[2].equals(baseDataType.getPrimaryKey().getName())) {
                        return;
                    }
                    String masteridPropName = ((BasedataEntityType)baseDataType).getMasteridPropName();
                    if (StringUtils.isNotBlank((CharSequence)masteridPropName)) {
                        List<Object> masterIds = null;
                        if (this.isNotCP(this.originalFilter.getCP())) {
                            QFilter baseDataFilter = new QFilter(split[2], this.getNotCP(this.originalFilter.getCP()), this.originalFilter.getValue());
                            masterIds = this.loadMasterId(((BasedataProp)baseDataProp).getComplexType().getName(), masteridPropName, new QFilter[]{baseDataFilter});
                            if (masterIds.isEmpty()) {
                                this.isFlexFilter = false;
                                return;
                            }
                            baseDataFilter = new QFilter(masteridPropName, "not in", masterIds);
                            masterIds = this.loadMasterId(((BasedataProp)baseDataProp).getComplexType().getName(), masteridPropName, new QFilter[]{baseDataFilter});
                        } else {
                            QFilter baseDataFilter = new QFilter(split[2], this.originalFilter.getCP(), this.originalFilter.getValue());
                            masterIds = this.loadMasterId(((BasedataProp)baseDataProp).getComplexType().getName(), masteridPropName, new QFilter[]{baseDataFilter});
                        }
                        this.masterIdList.addAll(masterIds);
                        this.isFlexFilter = true;
                    }
                }
            } else {
                log.info("\u4e0d\u7b26\u5408\u5f39\u6027\u57df\u6761\u4ef6.\u4e0d\u662fFlexProp" + (flexProp == null ? " null " : flexProp.toString()));
            }
        } else if (first instanceof EntryProp) {
            this.parseFlexProperty(baseProperty + (StringUtils.isEmpty((CharSequence)baseProperty) ? "" : ".") + split[0], property.substring(split[0].length() + 1), ((EntryProp)first).getItemType());
        }
    }

    private boolean isNotCP(String cp) {
        return cp.equals("not like") || cp.equals("not in") || cp.equals("!=") || cp.equals("<>") || cp.equals(">=") || cp.equals(">") || cp.equals("<=") || cp.equals("<");
    }

    private String getNotCP(String cp) {
        if (cp.equals("not like")) {
            return "like";
        }
        if (cp.equals("not in")) {
            return "in";
        }
        if (cp.equals("!=")) {
            return "=";
        }
        if (cp.equals("<>")) {
            return "=";
        }
        if (cp.equals(">=")) {
            return "<";
        }
        if (cp.equals(">")) {
            return "<=";
        }
        if (cp.equals("<=")) {
            return ">";
        }
        if (cp.equals("<")) {
            return ">=";
        }
        throw new RuntimeException("invalid cp" + cp);
    }

    protected List<Object> loadMasterId(String entityName, String masterIdProp, QFilter[] filters) {
        ArrayList<Object> idList = new ArrayList<Object>();
        String maxRowStr = System.getProperty("bos.billlist.maxRowCount", "100000");
        int maxrowcount = Integer.parseInt(maxRowStr);
        try (DataSet ds = ORM.create().queryDataSet("FlexBDFilter." + entityName, entityName, masterIdProp, filters, null, maxrowcount, (Distinctable)WithEntityEntryDistinctable.get());){
            ds.forEach(row -> idList.add(row.get(0)));
        }
        return idList;
    }

    public QFilter getConvertQFilter() {
        Object[] newValue = this.masterIdList.toArray(new Object[0]);
        QFilter qFilter = new QFilter(this.matchFlexProperty, "in", (Object)newValue);
        for (QFilter.QFilterNest nest : this.originalFilter.getNests(false)) {
            if ("or".equalsIgnoreCase(nest.getOp())) {
                qFilter.or(nest.getFilter());
                continue;
            }
            qFilter.and(nest.getFilter());
        }
        return qFilter;
    }
}

