/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.flex;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.flex.CreateFlexMetaArgs;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.flex.FlexType;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.datamanager.ReadWhere;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.RuntimeFlexMetaService;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.ExceptionUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FlexEntityMetaUtils {
    private static final String BOS_ENTITY_METADATA = "bos-entity-metadata";
    private static Log log = LogFactory.getLog(FlexEntityMetaUtils.class);
    private static String flex_log_out = "flex.log.out";
    private static boolean enableOutLog = false;
    private static String flex_cache_release = "flex.cache.release";
    private static boolean flexCacheRelease = false;
    private static String flex_list_batchload = "flex.list.batchload";
    private static boolean flexListBatchLoad = true;

    public static boolean isOutLog() {
        return enableOutLog;
    }

    public static boolean isFlexCacheRelease() {
        return flexCacheRelease;
    }

    public static boolean isFlexListBatchLoad() {
        return flexListBatchLoad;
    }

    public static void outLog(String className, String method, String info) {
        if (enableOutLog) {
            log.info(String.format("%s.%s.info: %s", className, method, info));
        }
    }

    public static void clearFlexEntityMeta() {
    }

    public static FlexType getFlexType(int id) {
        IDataEntityType type = OrmUtils.getDataEntityType(FlexType.class);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(type);
        Object[] pkArray = new Integer[]{id};
        Map cacheMap = cacheManager.get(pkArray);
        FlexType dataEntity = (FlexType)((Object)cacheMap.get(id));
        if (dataEntity != null) {
            return dataEntity;
        }
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)type);
        FlexType flexType = (FlexType)((Object)dataManager.read((Object)id));
        String sql = "select FNAME from T_BAS_FLEX_L where FID = ? and FLOCALEID = ?";
        Object[] parameters = new SqlParameter[]{new SqlParameter("FID", 4, (Object)id), new SqlParameter("FLOCALEID", 12, (Object)RequestContext.get().getLang().toString())};
        String name = (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])parameters, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                String name = "";
                if (rs.next()) {
                    name = rs.getString("FNAME");
                }
                return name;
            }
        });
        flexType.setName(name);
        FlexType[] flexes = new FlexType[]{flexType};
        cacheManager.put((Object[])flexes);
        return flexType;
    }

    public static List<FlexProperty> getFlexProperties(int flexTypeId) {
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter("FID", -5, (Object)flexTypeId));
        params.add(new SqlParameter("FSTATUS", 12, (Object)BillStatus.C.name()));
        params.add(new SqlParameter("FENABLE", 12, (Object)"0"));
        ReadWhere rw = new ReadWhere(" FID = ? AND FSTATUS = ? AND FENABLE <> ? ", params);
        IDataEntityType type = OrmUtils.getDataEntityType(FlexProperty.class);
        return FlexEntityMetaUtils.getFlexPropertiesByWhere(type, rw);
    }

    public static List<FlexProperty> getFlexProperty(List<Long> propertyIds) {
        IDataEntityType type = OrmUtils.getDataEntityType(FlexProperty.class);
        ArrayList<FlexProperty> list = new ArrayList<FlexProperty>();
        FlexEntityMetaUtils.outLog("FlexEntityMetaUtils", "getFlexProperty", String.format("flex getFlexProperty: id = %s", propertyIds.toString()));
        DataEntityCacheManager cm = new DataEntityCacheManager(type);
        Object[] ids = propertyIds.toArray(new Long[propertyIds.size()]);
        Map cacheMap = cm.get(ids);
        ArrayList<Object> notCacheIds = new ArrayList<Object>();
        for (Object id : ids) {
            Object entity = cacheMap.get(id);
            if (entity == null) {
                notCacheIds.add(id);
                continue;
            }
            FlexProperty f = (FlexProperty)entity;
            list.add(f);
            FlexEntityMetaUtils.outLog("FlexEntityMetaUtils", "getFlexProperty", String.format("cache:id=%s, name=%s, orgfunid=%d, orgfunnumber=%s", f.getId(), f.getName(), f.getOrgFunc(), f.getOrgFuncNumber()));
        }
        if (!notCacheIds.isEmpty()) {
            IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)type);
            Object[] objects = dataManager.read(notCacheIds);
            list.addAll(FlexEntityMetaUtils.convertFlexProperty(objects));
            cm.put((Object[])list.toArray(new FlexProperty[0]));
        }
        list.sort(new Comparator<FlexProperty>(){

            @Override
            public int compare(FlexProperty o1, FlexProperty o2) {
                return o1.getIndex() - o2.getIndex();
            }
        });
        return list;
    }

    public static FlexProperty getFlexProperty(String flexField) {
        IDataEntityType type = OrmUtils.getDataEntityType(FlexProperty.class);
        DataEntityCacheManager cm = new DataEntityCacheManager(type);
        Map cacheMap = cm.getByNumbers(new String[]{flexField});
        if (cacheMap.size() == 1) {
            return (FlexProperty)cacheMap.get(flexField);
        }
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter("FFLEXFIELD", 12, (Object)flexField));
        ReadWhere rw = new ReadWhere(" FFLEXFIELD = ? ", params);
        List<FlexProperty> list = FlexEntityMetaUtils.getFlexPropertiesByWhere(type, rw);
        if (list.size() == 1) {
            Object[] flexProperies = new FlexProperty[]{list.get(0)};
            cm.putByNumbers("FlexField", flexProperies);
            return list.get(0);
        }
        if (list.isEmpty()) {
            throw new KDException(BosErrorCode.nullError, new Object[]{String.format(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u5c5e\u6027\u7684\u5f39\u6027\u57df\u5b57\u6bb5%s\u4e0d\u5b58\u5728\uff01", (String)"FlexEntityMetaUtils_0", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), flexField)});
        }
        throw new KDException(BosErrorCode.bOS, new Object[]{String.format(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u5c5e\u6027\u7684\u5f39\u6027\u57df\u5b57\u6bb5%s\u6709\u591a\u4e2a\u503c\uff01", (String)"FlexEntityMetaUtils_1", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), flexField)});
    }

    public static DynamicProperty createProperty(String flexFieldKey, FlexProperty flexProperty) {
        String propertyName = flexProperty.getNumber();
        String valueType = flexProperty.getValueType();
        String fieldKey = flexProperty.getFlexField();
        String flexKey = String.format("$$%s__%s", flexFieldKey, fieldKey);
        IFieldHandle property = null;
        if ("1".equals(valueType)) {
            String valueSourceNumber = flexProperty.getValueSource();
            if (StringUtils.isBlank((CharSequence)valueSourceNumber)) {
                throw new KDException(BosErrorCode.bOS, new Object[]{String.format(ResManager.loadKDString((String)"\u5c5e\u6027%s\u672a\u5b9a\u4e49\u503c\u6765\u6e90\u3002", (String)"FlexEntityMetaUtils_2", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), propertyName)});
            }
            BasedataEntityType sourceType = (BasedataEntityType)EntityMetadataCache.getDataEntityType(valueSourceNumber);
            if (FlexEntityMetaUtils.isOutLog()) {
                log.info(String.format("RuntimeFlexMeta - createFieldEdit fieldKey:%s, propertyName:%s, orgfuncid:%d, number:%s", fieldKey, propertyName, flexProperty.getOrgFunc(), flexProperty.getOrgFuncNumber()));
            }
            if (flexProperty.getOrgFunc() != 0L) {
                property = new OrgProp();
                ((OrgProp)property).setOrgFunc(flexProperty.getOrgFuncNumber());
            } else {
                property = new BasedataProp();
            }
            property.setAlias(fieldKey);
            property.setDisplayName(flexProperty.getName());
            String numberPropKey = sourceType.getNumberProperty();
            ((BasedataProp)property).setNumberProp(numberPropKey);
            ((BasedataProp)property).setName(flexKey);
            ((BasedataProp)property).setBaseEntityId(sourceType.getName());
            FlexProperty.DisplayStyle displayStyle = flexProperty.getDisplayStyle();
            ((BasedataProp)property).setDisplayProp(displayStyle.getDisplayProperty().toString());
            ((BasedataProp)property).setComplexType((IDataEntityType)sourceType);
        } else if ("2".equals(valueType)) {
            property = new AssistantProp();
            property.setAlias(fieldKey);
            property.setDisplayName(flexProperty.getName());
            ((AssistantProp)property).setAsstTypeId(flexProperty.getAssistantType());
            ((BasedataProp)property).setName(flexKey);
            BasedataEntityType sourceType = (BasedataEntityType)EntityMetadataCache.getDataEntityType("bos_assistantdata_detail");
            ((BasedataProp)property).setBaseEntityId("bos_assistantdata_detail");
            ((BasedataProp)property).setComplexType((IDataEntityType)sourceType);
            FlexProperty.DisplayStyle displayStyle = flexProperty.getDisplayStyle();
            ((BasedataProp)property).setDisplayProp(displayStyle.getDisplayProperty().toString());
        } else if ("3".equals(valueType)) {
            property = new TextProp();
            property.setAlias(fieldKey);
            property.setDisplayName(flexProperty.getName());
            ((TextProp)property).setName(flexKey);
        } else {
            throw new KDException(BosErrorCode.bOSNotImplemented, new Object[]{ResManager.loadKDString((String)"\u672a\u5b9e\u73b0", (String)"FlexEntityMetaUtils_3", (String)BOS_ENTITY_METADATA, (Object[])new Object[0])});
        }
        return property;
    }

    private static List<FlexProperty> getFlexPropertiesByWhere(IDataEntityType type, ReadWhere rw) {
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)type);
        Object[] flexPropertyObject = dataManager.read(rw);
        List<FlexProperty> list = FlexEntityMetaUtils.convertFlexProperty(flexPropertyObject);
        list.sort(new Comparator<FlexProperty>(){

            @Override
            public int compare(FlexProperty o1, FlexProperty o2) {
                return o1.getIndex() - o2.getIndex();
            }
        });
        return list;
    }

    private static List<FlexProperty> convertFlexProperty(Object[] flexPropertyObject) {
        ArrayList<FlexProperty> list = new ArrayList<FlexProperty>(20);
        if (flexPropertyObject.length == 0) {
            return list;
        }
        StringBuilder ids = new StringBuilder();
        Map<Long, String> map = FlexEntityMetaUtils.getOrgBizFuncList();
        for (Object obj : flexPropertyObject) {
            ids.append(((FlexProperty)obj).getId()).append(',');
            Long orgFunc = ((FlexProperty)obj).getOrgFunc();
            if (FlexEntityMetaUtils.isOutLog()) {
                log.info(String.format("FlexEntityMetaUtils - convertFlexProperty id:%d, getFlexField:%s, orgfuncid:%d, funcnumber:%s", ((FlexProperty)obj).getId(), ((FlexProperty)obj).getFlexField(), ((FlexProperty)obj).getOrgFunc(), ((FlexProperty)obj).getOrgFuncNumber()));
            }
            if (orgFunc == null || orgFunc == 0L) continue;
            ((FlexProperty)obj).setOrgFuncNumber(map.get(orgFunc));
        }
        Map<Long, LocaleString> nameMap = FlexEntityMetaUtils.selectFlexPropertyName(ids);
        for (Object obj : flexPropertyObject) {
            FlexProperty fp = (FlexProperty)obj;
            LocaleString name = nameMap.get(fp.getId());
            if (name == null && StringUtils.isBlank((CharSequence)fp.getGLName())) {
                throw new KDException(BosErrorCode.variableNotValid, new Object[]{String.format(ResManager.loadKDString((String)"flex\u5c5e\u6027%1$s\u7684\u5f53\u524d\u8bed\u8a00%2$s\u5bf9\u5e94\u7684\u5c5e\u6027\u540d\u4e3a\u7a7a\u3002", (String)"FlexEntityMetaUtils_5", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), fp.getId(), RequestContext.get().getLang().toString())});
            }
            fp.setName(name);
            list.add(fp);
        }
        return list;
    }

    public static FlexEntityType getBasedataPropFlexEntityType(String formNumber, String flexFieldKey, int flexTypeId, List<Long> propertyIds) {
        CreateFlexMetaArgs args = new CreateFlexMetaArgs(formNumber, flexFieldKey, flexTypeId, propertyIds);
        return FlexEntityMetaUtils.getBasedataPropFlexEntityType(args);
    }

    public static FlexEntityType getBasedataPropFlexEntityType(CreateFlexMetaArgs args) {
        return FlexEntityMetaUtils.getFlexMeta(args);
    }

    private static FlexEntityType getFlexMeta(CreateFlexMetaArgs args) {
        Object ret = null;
        FlexEntityMeta flexEntityMeta = new FlexEntityMeta();
        flexEntityMeta.propertyIds = args.getPropertyIds();
        try {
            RuntimeFlexMetaService service = (RuntimeFlexMetaService)ServiceFactory.getService(RuntimeFlexMetaService.class);
            String className = service.getRuntimeFlexMetaClassName();
            Class<?> flexMeta = Class.forName(className);
            Method getDataEntityType = flexMeta.getMethod("getDataEntityType", new Class[0]);
            try {
                Object flexMetaInstance = flexMeta.getConstructor(CreateFlexMetaArgs.class).newInstance(args);
                ret = getDataEntityType.invoke(flexMetaInstance, new Object[0]);
                return (FlexEntityType)((Object)ret);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                String msg = e.getMessage();
                if (msg == null) {
                    msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                }
                throw new KDException((Throwable)e, BosErrorCode.cannotLoadBeanClass, new Object[]{msg});
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            throw new KDException((Throwable)e, BosErrorCode.cannotLoadBeanClass, new Object[]{e.getMessage()});
        }
    }

    static String getCacheKey(String formKey, String flexFieldKey) {
        return String.format("%s_flex_%s", formKey, flexFieldKey);
    }

    private static Map<Long, LocaleString> selectFlexPropertyName(StringBuilder ids) {
        if (ids.length() > 0) {
            String sql = String.format("select FENTRYID, FLOCALEID, FNAME from T_BAS_FLEX_PROPERTY_L where FENTRYID in (%s) ", ids.toString().substring(0, ids.length() - 1));
            return (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Map<Long, LocaleString>>(){

                public Map<Long, LocaleString> handle(ResultSet rs) throws SQLException {
                    HashMap<Long, LocaleString> nameMap = new HashMap<Long, LocaleString>();
                    while (rs.next()) {
                        Long flexPropId = rs.getLong(1);
                        LocaleString name = (LocaleString)nameMap.get(flexPropId);
                        if (name == null) {
                            name = new LocaleString();
                            nameMap.put(flexPropId, name);
                        }
                        name.setItem(rs.getString(2), (Object)rs.getString(3));
                    }
                    return nameMap;
                }
            });
        }
        return new HashMap<Long, LocaleString>();
    }

    private static Map<Long, String> getOrgBizFuncList() {
        QFilter f1 = new QFilter("isbasetype", "=", (Object)"1");
        QFilter f3 = new QFilter("fnumber", "not in", (Object)new String[]{"14", "07"});
        QFilter[] filters = new QFilter[]{f1, f3};
        String sql = "select fid, fnumber from t_ORG_BizList where FIsBaseType = '1'";
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Map<Long, String>>(){

            public Map<Long, String> handle(ResultSet rs) throws Exception {
                HashMap<Long, String> map = new HashMap<Long, String>(16);
                while (rs.next()) {
                    Long id = rs.getLong(1);
                    String number = rs.getString(2);
                    map.put(id, number);
                }
                return map;
            }
        });
    }

    static {
        enableOutLog = Boolean.parseBoolean(System.getProperty(flex_log_out));
        ConfigurationUtil.observeChange((String)flex_log_out, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                enableOutLog = Boolean.parseBoolean(System.getProperty(flex_log_out));
            }
        });
        flexCacheRelease = true;
        ConfigurationUtil.observeChange((String)flex_cache_release, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                flexCacheRelease = Boolean.parseBoolean(System.getProperty(flex_cache_release));
            }
        });
        flexListBatchLoad = Boolean.parseBoolean(System.getProperty(flex_list_batchload, "true"));
        ConfigurationUtil.observeChange((String)flex_list_batchload, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                flexListBatchLoad = Boolean.parseBoolean(System.getProperty(flex_list_batchload));
            }
        });
    }

    private static class FlexEntityMetaCollection {
        Map<String, List<FlexEntityMeta>> flexEntityMetaMap = new ConcurrentHashMap<String, List<FlexEntityMeta>>();

        private FlexEntityMetaCollection() {
        }

        void add(String formKey, String flexFieldKey, FlexEntityMeta flexEntityMeta) {
            String key = this.getCacheKey(formKey, flexFieldKey);
            List list = this.flexEntityMetaMap.computeIfAbsent(key, k -> new ArrayList());
            list.add(flexEntityMeta);
        }

        FlexEntityMeta get(String formKey, String flexFieldKey, List<Long> propertyIds) {
            String key = this.getCacheKey(formKey, flexFieldKey);
            List<FlexEntityMeta> flexEntityMetaList = this.flexEntityMetaMap.get(key);
            if (flexEntityMetaList == null) {
                return null;
            }
            for (FlexEntityMeta flexFormMeta : flexEntityMetaList) {
                if (!this.compareList(flexFormMeta.propertyIds, propertyIds)) continue;
                return flexFormMeta;
            }
            return null;
        }

        boolean compareList(List<Long> oldPropertyIds, List<Long> newPropertyIds) {
            if (oldPropertyIds == null && newPropertyIds == null) {
                return true;
            }
            if (oldPropertyIds != null && newPropertyIds == null || oldPropertyIds == null && newPropertyIds != null) {
                return false;
            }
            if (oldPropertyIds.size() != newPropertyIds.size()) {
                return false;
            }
            for (Long id : newPropertyIds) {
                if (oldPropertyIds.contains(id)) continue;
                return false;
            }
            return true;
        }

        String getCacheKey(String formKey, String flexFieldKey) {
            return String.format("%s_flex_%s", formKey, flexFieldKey);
        }

        void clear() {
            this.flexEntityMetaMap.clear();
        }
    }

    private static class FlexEntityMeta {
        List<Long> propertyIds;

        FlexEntityMeta() {
            new FlexEntityType();
        }
    }
}

