/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.format;

import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.format.DateFormatObject;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.TimeFormat;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DateFormat
extends TimeFormat {
    private DateFormatObject dateFormatObject;

    @Override
    <T> Format newFormat(T t) {
        DateFormatObject dfo = (DateFormatObject)t;
        SimpleDateFormat sdf = null;
        Locale locale = dfo.getLocale();
        sdf = locale != null ? (SimpleDateFormat)SimpleDateFormat.getTimeInstance(2, locale) : (SimpleDateFormat)SimpleDateFormat.getTimeInstance();
        if (locale != null && !sdf.getCalendar().getClass().isAssignableFrom(GregorianCalendar.class)) {
            GregorianCalendar calendar = (GregorianCalendar)new Calendar.Builder().setLocale(locale).setTimeZone(TimeZone.getDefault()).setCalendarType("gregory").setInstant(System.currentTimeMillis()).build();
            sdf.setCalendar(calendar);
        }
        try {
            sdf.applyPattern(dfo.getDateFormat());
        }
        catch (IllegalArgumentException e) {
            throw new KDException((Throwable)e, BosErrorCode.parse, new Object[]{String.format("Error:%s", e.getMessage())});
        }
        if (StringUtils.isNotEmpty((CharSequence)dfo.getTimeArea())) {
            sdf.setTimeZone(TimeZone.getTimeZone(dfo.getTimeArea()));
        }
        return sdf;
    }

    @Override
    <T extends Cloneable> void cloneFormatObject(T t) {
        DateFormatObject dfo = (DateFormatObject)t;
        try {
            this.dateFormatObject = (DateFormatObject)dfo.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("CloneFailedException", e.getMessage()), new Object[0]);
        }
    }

    @Override
    <T extends Cloneable> boolean equalsFormatObject(T t) {
        return t.equals(this.dateFormatObject);
    }

    @Override
    public Format getFormat(FormatObject formatObject) {
        if (formatObject == null) {
            return null;
        }
        DateFormatObject dfo = formatObject.getDateFormat();
        if (dfo == null) {
            return null;
        }
        return super.getFormat(dfo);
    }
}

