/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.formula;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.formula.ActiveRowHandle;
import kd.bos.entity.formula.ChildRowHandle;
import kd.bos.entity.formula.ParentRowHandle;
import kd.bos.entity.formula.UnKnownRowHandle;
import kd.bos.exception.KDException;

interface IRowHandler {
    public EntityType getActiveEntity();

    public void setActiveEntity(EntityType var1);

    public EntityType getTargetEntity();

    public void setTargetEntity(EntityType var1);

    public Object getTargetDataEntity(Object var1);

    default public int getTargetRowIndex(Object targetRow, int activeRowIndex) {
        return activeRowIndex;
    }

    default public boolean isChildRows() {
        return false;
    }

    public static int getEntityLevel(EntityType entityType) {
        int entityLevel = -1;
        if (entityType instanceof MainEntityType) {
            entityLevel = 0;
        } else if (entityType instanceof SubEntryType) {
            entityLevel = 2;
        } else if (entityType instanceof LinkEntryType) {
            LinkEntryType linkEntryType = (LinkEntryType)entityType;
            entityLevel = IRowHandler.getEntityLevel((EntityType)linkEntryType.getParent()) + 1;
        } else if (entityType instanceof EntryType) {
            entityLevel = 1;
        } else if (entityType == null) {
            entityLevel = -1;
        } else {
            throw new KDException(String.format(ResManager.loadKDString((String)"\u6682\u6ca1\u652f\u6301\u57fa\u4e8e\u5b9e\u4f53%s\u7684\u8fd0\u7b97", (String)"IRowHandler_0", (String)"bos-entity-metadata", (Object[])new Object[0]), entityType.getDisplayName().toString()));
        }
        return entityLevel;
    }

    public static IRowHandler create(IDataModel model, MainEntityType mainType, EntityType activeEntity, EntityType targetEntity) {
        int targetEntityLevel;
        UnKnownRowHandle rowHandle = new UnKnownRowHandle();
        int activeEntityLevel = IRowHandler.getEntityLevel(activeEntity);
        if (activeEntityLevel == (targetEntityLevel = IRowHandler.getEntityLevel(targetEntity))) {
            if (activeEntity != null && targetEntity != null && activeEntity.getName().equalsIgnoreCase(targetEntity.getName())) {
                rowHandle = new ActiveRowHandle();
            }
        } else if (activeEntityLevel > targetEntityLevel) {
            ParentRowHandle parentRowHandle = new ParentRowHandle();
            parentRowHandle.setActiveEntity(activeEntity);
            parentRowHandle.setTargetEntity(targetEntity);
            parentRowHandle.setModel(model);
            if (parentRowHandle.isParent(targetEntity, activeEntity)) {
                rowHandle = parentRowHandle;
            }
        } else {
            ChildRowHandle childRowHandle = new ChildRowHandle();
            childRowHandle.setActiveEntity(activeEntity);
            childRowHandle.setTargetEntity(targetEntity);
            childRowHandle.setModel(model);
            if (childRowHandle.searchChildEntitys(activeEntity, targetEntity)) {
                rowHandle = childRowHandle;
            }
        }
        rowHandle.setActiveEntity(activeEntity);
        rowHandle.setTargetEntity(targetEntity);
        return rowHandle;
    }
}

