/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.formula;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.formula.IMemberValueHandler;
import kd.bos.entity.formula.IRowHandler;
import kd.bos.exception.KDException;

abstract class MemberValueHandler
implements IMemberValueHandler {
    protected IDataModel model;
    protected IRowHandler rowHandler;
    protected DynamicProperty fieldProp;

    public MemberValueHandler(IDataModel model, IRowHandler rowHandler, DynamicProperty fieldProp) {
        this.model = model;
        this.fieldProp = fieldProp;
        this.rowHandler = rowHandler;
    }

    @Override
    public Object getValue(Object activeRow) {
        if (!this.rowHandler.isChildRows()) {
            Object targetRow = this.rowHandler.getTargetDataEntity(activeRow);
            return this.fieldProp.getValue(targetRow);
        }
        List targetRows = (List)this.rowHandler.getTargetDataEntity(activeRow);
        Object[] values = new Object[targetRows.size()];
        int i = 0;
        for (DynamicObject targetRow : targetRows) {
            Object value;
            values[i] = value = this.fieldProp.getValue((Object)targetRow);
            ++i;
        }
        return values;
    }

    @Override
    public void setValue(Object activeRow, int activeRowIndex, Object value) {
        if (this.rowHandler.isChildRows()) {
            String fieldCaption = this.fieldProp.getDisplayName() == null ? this.fieldProp.getName() : this.fieldProp.getDisplayName().toString();
            throw new KDException(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fee\u6539\u5b50\u5b9e\u4f53\u4e0a\u5b57\u6bb5%s\u7684\u503c", (String)"MemberValueHandler_0", (String)"bos-entity-metadata", (Object[])new Object[0]), fieldCaption));
        }
        Object targetRow = this.rowHandler.getTargetDataEntity(activeRow);
        if (this.model != null) {
            this.model.setValue((IDataEntityProperty)this.fieldProp, (DynamicObject)targetRow, value);
        } else {
            this.fieldProp.setValue(targetRow, value);
        }
    }
}

