/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.formula;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.formula.IMemberValueHandler;
import kd.bos.entity.formula.IRowHandler;
import kd.bos.entity.formula.OutValue;
import kd.bos.exception.KDException;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang.StringUtils;

@SdkPublic
public class RowDataModel {
    private MainEntityType mainEntityType;
    private IDataModel model;
    private String entityKey;
    private EntityType entityType;
    private Object activeRow = null;
    private int rowIndex = -1;
    private Map<EntityType, IRowHandler> dctRowHandles = new HashMap<EntityType, IRowHandler>();
    private Map<String, IMemberValueHandler> dctVarHandlers = new HashMap<String, IMemberValueHandler>();

    public RowDataModel(String entityKey, IDataModel model) {
        this.init(model, model.getDataEntityType(), entityKey);
    }

    public RowDataModel(String entityKey, MainEntityType mainEntityType) {
        this.init(null, mainEntityType, entityKey);
    }

    private void init(IDataModel model, MainEntityType mainEntityType, String entityKey) {
        this.model = model;
        this.mainEntityType = mainEntityType;
        this.entityKey = StringUtils.isNotBlank((String)entityKey) ? entityKey : mainEntityType.getName();
        this.entityType = mainEntityType.getAllEntities().get(entityKey);
        if (this.entityType == null) {
            KDException e = new KDException(String.format(ResManager.loadKDString((String)"\u5728\u5143\u6570\u636e\u6a21\u578b\u4e2d\uff0c\u627e\u4e0d\u5230\u4f20\u5165\u7684\u5b9e\u4f53(%s)\uff01", (String)"RowDataModel_0", (String)"bos-entity-metadata", (Object[])new Object[0]), entityKey));
            try (EntityTraceSpan span = EntityTracer.create((String)"RowDataModel", (String)"init");){
                span.addLocaleTag("entityKey", (Object)entityKey);
                span.addLocaleTag("mainEntityType", (Object)mainEntityType);
                span.throwException((Throwable)e);
            }
            throw e;
        }
    }

    public IDataModel getModel() {
        return this.model;
    }

    public MainEntityType getMainEntityType() {
        return this.mainEntityType;
    }

    public String getSource() {
        return this.entityKey;
    }

    public int getSourceLevel() {
        return IRowHandler.getEntityLevel(this.entityType);
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public Object getActiveRow() {
        return this.activeRow;
    }

    public void setRowContext(DynamicObject activeRow) {
        this.activeRow = activeRow;
    }

    public void setRowContext(Object activeRow, int rowIndex) {
        this.activeRow = activeRow;
        this.rowIndex = rowIndex;
    }

    public static DynamicProperty findProperty(MainEntityType mainType, String var) {
        List<DynamicProperty> properties = IMemberValueHandler.findPropertys(mainType, var, false);
        if (properties.isEmpty()) {
            return null;
        }
        return properties.get(0);
    }

    public static int compareEntityLevel(EntityType e1, EntityType e2) {
        int level1 = IRowHandler.getEntityLevel(e1);
        int level2 = IRowHandler.getEntityLevel(e2);
        return level1 - level2;
    }

    public Object get(String var, int rowIndex) {
        return this.model.getValue(var, rowIndex);
    }

    public Object getValue(String var) {
        IMemberValueHandler varHandler = this.createValueHander(var);
        Object value = varHandler.getValue(this.activeRow);
        return value;
    }

    public Boolean tryGetValue(String var, OutValue<Object> value) {
        IMemberValueHandler varHandler = this.dctVarHandlers.get(var);
        if (varHandler == null) {
            varHandler = IMemberValueHandler.create(this.model, this.mainEntityType, this.entityType, var, this.dctRowHandles);
        }
        if (varHandler == null) {
            return Boolean.FALSE;
        }
        this.dctVarHandlers.put(var, varHandler);
        Object varValue = varHandler.getValue(this.activeRow);
        value.set(varValue);
        return Boolean.TRUE;
    }

    public void setValue(String var, Object value) {
        IMemberValueHandler varHandler = this.createValueHander(var);
        varHandler.setValue(this.activeRow, this.rowIndex, value);
    }

    private IMemberValueHandler createValueHander(String var) {
        IMemberValueHandler varHandler = this.dctVarHandlers.get(var);
        if (varHandler != null) {
            return varHandler;
        }
        varHandler = IMemberValueHandler.create(this.model, this.mainEntityType, this.entityType, var, this.dctRowHandles);
        if (varHandler == null) {
            KDException e = new KDException(String.format(ResManager.loadKDString((String)"\u672a\u80fd\u627e\u5230\u5b57\u6bb5 %1$s\uff0c\u6216\u5728\u5f53\u524d\u5b9e\u4f53 %2$s \u7684\u4e0a\u4e0b\u7ea7\u4e2d\u4e0d\u80fd\u8bbf\u95ee\u5230\u3002", (String)"RowDataModel_1", (String)"bos-entity-metadata", (Object[])new Object[0]), var, this.entityType.getDisplayName().toString()));
            try (EntityTraceSpan span = EntityTracer.create((String)"RowDataModel", (String)"createValueHander");){
                span.addLocaleTag("var", (Object)var);
                span.addLocaleTag("entity", (Object)this.entityType.getName());
                span.addLocaleTag("mainEntityType", (Object)this.mainEntityType);
                span.throwException((Throwable)e);
            }
            throw e;
        }
        this.dctVarHandlers.put(var, varHandler);
        return varHandler;
    }
}

