/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.formula;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.OutValue;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class VarValueParser {
    private VarValueParser() {
    }

    public static Map<String, Object> getVarValues(BOSExpression expression, ExpressionContext expContext) {
        Object[] vars = expression.getVars().toArray(new String[0]);
        Arrays.sort(vars);
        HashMap<String, Object> varValues = new HashMap<String, Object>(vars.length);
        for (int i = 0; i < vars.length; ++i) {
            Object var = vars[i];
            varValues.put((String)var, VarValueParser.getVarValue((String)var, expContext));
        }
        return varValues;
    }

    public static Object getVarValue(String var, ExpressionContext expContext) {
        OutValue<Object> value = new OutValue<Object>();
        if (!expContext.tryGetValue(var, value).booleanValue()) {
            return null;
        }
        Object item = value.get();
        if (item instanceof String) {
            item = ((String)item).trim();
        } else if (item instanceof OrmLocaleValue) {
            item = ((OrmLocaleValue)item).getDefaultItem();
        }
        return item;
    }
}

